C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: C3RDVMOD   READ VELOCITY MODEL                                 *
C***********************************************************************

      subroutine c3rdvmod( verbos, debug, nvel, fmax, dtgrid, tmax,
     &                     dzgrid, zmax, strch, nzbar, nzseg, 
     &                     izsnz, zsdz, zsslo, ierr )

      implicit none

#include <f77/iounit.h>

c
c input parameters:
c
      integer   debug           ! debug printout flag
      real      dtgrid          ! delta time (ms)
      real      dzgrid          ! delta z for output
      real      fmax            ! maximum frequency (Hz)
      integer   nvel            ! number of velocities in the vel. file
      real      strch           ! stretch factor
      logical   verbos          ! verbose output flag
c
c modified (input and output) parameters:
c
      real      tmax            ! maximum time for migration (ms)
      real      zmax            ! maximum depth of migration
c
c output parameters:
c
      integer   ierr            ! error flag
      integer   izsnz(*)        ! number of z steps per z segment
      integer   nzbar           ! number of z's (irregular grid)
      integer   nzseg           ! number of z segments
      real      zsdz(*)         ! delta z per z segment
      real      zsslo(*)        ! slowness per z segment
c
c local variables
c
      real      dzmax           ! maximum delta z for current z segment
      integer   ivel            ! velocity card sequence number
      integer   jvel            ! velocity loop index
      integer   mz              ! number of z steps in current z segment
      real      tend            ! t at bottom of current z segment
      real      tlast           ! t at bottom of last z segment
      real      vel             ! velocity
      real      zend            ! z at bottom of current z segment
      real      zlast           ! z at bottom of last z segment
      real      zstep           ! thickness of current z segment

c-----------------------------------------------------------------------

  901 format( i10, f10.0, 10x, f10.0 )
  910 format( /' ', 'VELOCITIES REFLECTED           END DEPTH' )
  911 format(  ' ', i10, f10.1, 10x, f10.1 )
  912 format( /' ', 'VELOCITIES AND DEPTHS ARE STRETCHED BY', f6.3 )

c-----------------------------------------------------------------------

      if( debug .gt. 0 ) write( LUPRT, * ) 'Entered subroutine c3rdvmod'

      if( verbos ) write( LUPRT, 910 )

      nzbar = 1
      nzseg = 0
      tlast = 0.0
      zlast = 0.0
      do jvel = 1, nvel
         read( LUCARD, 901, iostat=ierr ) ivel, vel, zend
         if( ierr .ne. 0 ) then
            write( LER, * ) '*** ERROR: cannot read velocity file ***'
            ierr = 3001
            return
         endif

         vel  = vel  * strch
         zend = zend * strch

         if( zend .gt. zmax ) zend = zmax

         tend = tlast + 1000.0 * ( zend - zlast ) / ( 0.5 * vel )
         
         if( tend .gt. tmax ) then
            tend = tmax
            zend = zlast + 0.0005 * vel * ( tend - tlast )
         endif  
         
         if( verbos ) write( LUPRT, 911 ) ivel, vel, zend
         
cmat     Remove this check on sequence numbers
cmat     if( ivel .ne. jvel ) then
cmat        write( LER, * ) '*** ERROR: invalid velocity sequence ***'
cmat        ierr = 3002
cmat        return
cmat     endif

cmat     Remove this check on sequence number & use loop counter
cmat     if( ivel .gt. 1 .or. zend .gt. 0.0 ) then
         if( jvel .gt. 1 .or. zend .gt. 0.0 ) then
            nzseg = nzseg + 1

cmat        Here Ron has previously guaranteed that he has either a
cmat        dzgrid or a dtgrid. He uses dzgrid to determine zend, then
cmat        determines tend in terms of that depth -OR- he uses dtgrid
cmat        to determine time, then determines zend in terms of that time

            if( dzgrid .gt. 0.0 ) then
               zend = dzgrid * aint( zend / dzgrid + 1.0 )
               tend = tlast + 1000.0 * ( zend - zlast ) / ( 0.5 * vel )
            else
               tend = dtgrid * aint( tend / dtgrid + 1.0 )
               zend = zlast + 0.0005 * vel * ( tend - tlast )
            endif

            zstep = zend - zlast
            zlast = zend
            tlast = tend

            if( vel .le. 0.0 .or. zstep .le. 0.0 ) then
               write( LER, * ) '*** ERROR: invalid velocity card ***'
               ierr = 3003
               return
            endif

            dzmax = 0.25 * vel / fmax
            mz    = ifix( zstep / dzmax )
            if( mz*dzmax .lt. zstep ) mz = mz + 1
            nzbar = nzbar + mz
            izsnz(nzseg) = mz
            zsdz(nzseg)  = zstep / float( mz )
            zsslo(nzseg) = 2.0 / vel
         endif

         if( tend .ge. tmax .or. zend .ge. zmax ) go to 110

      end do

  110 continue
      tmax = tend
      zmax = zend

      if( verbos .and. strch .ne. 1.0 ) write( LUPRT, 912 ) strch

      ierr = 0

      return
      end
