C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C NAME: C3WRREC   CMMVZ3D WRITE USP RECORD                             *
C***********************************************************************

      subroutine c3wrrec( verbos, debug, luout, jky, nkx, nzbar, trace,
     &                    header, dr, di, ierr )

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c input parameters:

      logical   verbos             ! verbose printout flag
      integer   debug              ! debug printout flag
      integer   luout              ! logical unit of output file
      integer   jky                ! current ky (record) index
      integer   nkx                ! number of kx's
      integer   nzbar              ! number of z's (irregular grid)
      real      header(ITRWRD,nkx) ! trace header array
      real      dr(nkx,nzbar)      ! real components of image
      real      di(nkx,nzbar)      ! imaginary components of image

c scratch parameters:

      real      trace(*)           ! trace (with header)

c output parameters:

      integer   ierr               ! completion code

c local variables:

      integer   jkx                ! kx loop index
      integer   nbytes             ! number bytes to write
C
C-----------------------------------------------------------------------
C
  991 format( /' ', '***** Tape write error - record', I5, ' trace', I5,
     &              ' *****' /)
C
C-----------------------------------------------------------------------
C
      if( debug .gt. 0 ) write( LUPRT, * ) 'Entered subroutine c3wrrec'
         
      nbytes = ( 2*nzbar + ITRWRD ) * ISZBYT
      do jkx = 1, nkx
         call vmov( header(1,jkx), 1, trace, 1, ITRWRD )
         call vmov( dr(jkx,1), nkx, trace(ITHWP1  ), 2, nzbar )
         call vmov( di(jkx,1), nkx, trace(ITHWP1+1), 2, nzbar )

         call wrtape( luout, trace, nbytes )
         if( nbytes .eq. 0 ) then
            write( LER, 991 ) jky, jkx
            ierr = -1
            return
         endif

      enddo
C
      ierr = 0
      return
      end
