C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C*********************************************************************
C NAME: CUBEVZ  CUBEVZ HEADER FILE              REV 3.1     OCT 92   *
C*********************************************************************
C
C  PURPOSE:
C     DEFINES SYMBOLIC CONSTANTS FOR CUBEVZ.
C
C  HISTORY:
C       JUN 92          REV 3.0         R.D. COLEMAN, CETech
C       OCT 92          REV 3.1         R.D. COLEMAN, CETech
C               Updated version number.
C       MAY 93          REV 3.2         Mary Ann Thornton   
C               Updated version number.
C
C---------------------------------------------------------------------
C
      INTEGER LUCRD, LULST, LUPRT, LUTMP, LUTRM, LPRT, MAXNK, MAXNT,
     &        MAXNW, MAXNX, MAXNP, MAXNZT, MAXSEG, NTAB
      REAL    TABMAX, PI, DEG2RAD
C
      PARAMETER (LUTRM   =     0)
C                                   Logical unit number terminal
      PARAMETER (LUCRD   =    25)
C                                   Logical unit number of card file
      PARAMETER (LULST   =    26)
C                                   Logical unit number of list file
      PARAMETER (LUPRT   =    27)
C                                   Logical unit number of print file
      PARAMETER (LPRT    =    27)
C                                   Logical unit number of print file
      PARAMETER (LUTMP   =    28)
C                                   Logical unit number of scratch file
      PARAMETER (MAXNK   =  2048)
C                                   Maximum number of K's
      PARAMETER (MAXNT   =  4096)
C                                   Maximum number of time samples
      PARAMETER (MAXNW   =  2048)
C                                   Maximum number of omegas
      PARAMETER (MAXNX   =  2048)
C                                   Maximum number of X's
      PARAMETER (MAXNP   =   201)
C                                   Maximum number of angles
      PARAMETER (MAXNZT  =  4096)
C                                   Maximum number of Z's (total)
      PARAMETER (MAXSEG  =  2048)
C                                   Maximum number of Z segments
      PARAMETER (NTAB    = 25001)
C                                   Number of entries in CXFTAB
      PARAMETER (PI      = 3.141592653589793 )
C                                   PI = 3.14...
      PARAMETER (TABMAX  = 2.5  )
C                                   Maximum argument into CXFTAB
      PARAMETER (DEG2RAD = PI / 180.0 )
C                                   Degrees to radian conversion
C
C  STRING CONSTANTS
C
      CHARACTER PPNAME*6, VERSION*4, TITLE*66
      PARAMETER( PPNAME = 'CUBEVZ', VERSION = ' 3.2' )
      PARAMETER( TITLE =                                               '
     &                    V(Z) MIGRATION CUBE                          '
     & )
C
