C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       Subroutine Interpolate(slowness, x, z, dxi, dzi, dx, dz,
     1 xorigin, zorigin, nx, nz, nt, current, next, ix,rx, 
     1 iz, rz, Slow0, slowx, slowz)
       implicit none
       Integer  current, next, i, nt, nx, nz 
       Integer ix(nt), iz(nt)
       Real Slowness(nx,3)
       Real x(nt), z(nt)
       Real Slow0(nt)
       Real Slowx(nt)
       Real Slowz(nt)
       Real rx(nt), rz(nt)
       Real xorigin, zorigin, dxi, dzi, dx, dz
       Do i = 1,Nt
       ix(i)=int((x(i)-xorigin)*dxi)+1
       rx(i)=amod(x(i)-xorigin,dx)*dxi
       iz(i)=int((z(i)-zorigin)/dz)+1
       rz(i)=amod(z(i)-zorigin,dz)*dzi

                                        
       if (ix(i) .gt. nx-1 ) rx(i) = 1.
       if (ix(i) .lt. 1    ) rx(i) = 0.
c      if (iz(i) .gt. 1    ) rz(i) = 1.
       if (iz(i) .gt. nz-1 ) rz(i) = 1.
       if (iz(i) .lt. 1    ) rz(i) = 0.
                                    
       ix(i) = min(max(ix(i) , 1),nx-1)
       iz(i) = min(max(iz(i) , 1),nz-1)
       enddo
                                  
C Now that we know the ray locations in the velocity grid, use bilinear
C  interpolation to get the slowness and linear interpolation to get
C  Grad(slowness):
C  Use forall here if you are on the cm5:
                                         
       Do i  = 1,Nt
c We return values for the current depth even for dead rays:
       slow0(i) = (1.-rx(i))*(1.-rz(i))*slowness(ix(i)   ,Next   )+ 
     1                rx(i) *(1.-rz(i))*slowness(ix(i)+1 ,Next   )+
     1            (1.-rx(i))*    rz(i) *slowness(ix(i)   ,Current)+ 
     1                rx(i) *    rz(i) *slowness(ix(i)+1 ,Current) 
c Notice that we assume Next is above Current. This must be changed for the 
C down going rays of the time 2 depth calculation. 

c      ! gradient of slowness:

         slowx(i)= ((1.-rz(i))*(slowness(ix(i)+1, Next   ) -
     1                          slowness(ix(i)  , Next   ))+
     1                  rz(i) *(slowness(ix(i)+1, Current) -
     1                          slowness(ix(i)  , Current)))*dxi
         slowz(i)= ((1.-rx(i))*(slowness(ix(i)  , Current) - 
     1                          slowness(ix(i)  , Next   ))+ 
     1                  rx(i) *(slowness(Ix(i)+1, Current) - 
     1                          slowness(Ix(i)+1, Next   )))*dzi
       Enddo
       Return
       End
