C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C a second order Runga-Kutta version
      Subroutine ray2d( xorigin, zorigin,
     1   x0,  z0,       
     1  tx0,  tz0,
     1   dx,  dz,  Nt,               
     1   nx,  nz,  V ,
C   ---------------Arrays provided for storage inside of ray2ddown-----
     1       Slow,
C             slowness at one level
     1       Slowness, 
C              Slowness at current, and next level
     1       Slow0,    
C              Slowness interpolated to ray locations
     1       Slowx,    
C              Slowness gradient interpolated to ray locations
     1       Slowz,    
     1       dSds,       
C              Derivative of slowness in the direction of the rays
     1       tau,      
C              Travel time along the rays
     1       tx,       
C              Cosine of ray direction in the x direction times the slowness
     1       tz,       
C              Cosine of the ray direction in the Z direction * slowness
     1       X ,       
C              X-location of the rays
     1       z ,       
C              z-location of the rays
     1       ix, iz,             
C              Location of the rays within ther grid (grid index of rays)
     1       rx, rz, Current, Next, Nsteps, rray, nrays, nray, inray,
C              Location of the ray within a grid block
C Number of steps for each velocity level.
     1       saveray, icolor, segname, lray, tzprev, raypath,verbos)
C        allocate arrays for the current, and next ray locations,
C
C        directions, finite differences, and slownesses.                   
C
         Implicit None
#include <f77/iounit.h>
         Integer nrays, nray, LL
         Real  dtz, dtx, tzave, dtzerr, a, tzp
         Real dxi, dzi,  ddz, t2
         Real rray(4,nrays, nray)
         Real Xorigin, zorigin, dx, dz
         Integer L, i,  nt, nx, nz, nsteps
         Integer inray(NT)
         Integer icolor(50)
         Character*20 segname(50)
         Logical saveray(Nt), verbos, raypath
         Integer lray(Nt)
         Real x0(Nt), z0(Nt), tx0(Nt), tz0(Nt), tzprev(Nt) 
C Initial positions and direction for rays
          Real V(nz,nx)    
C Velocity at grid locations
         Real Slow(nx)    
C slowness at grid locations in current layer
         Real Slowness(nx,2) 
C slowness at grid locations in 2 layers
         Real Slow0(Nt)    
C slowness at ray locations
         Real Slowx(Nt)    
C x component of Grad(slowness) at ray locations
         Real Slowz(Nt)    
C z component of Grad(slowness) at ray locations
         Real dSds (Nt)      
C Derivative of Slowness with respect to arc length
                                                                                
         Real tau(Nt,2)      
C Travel time along rays
         Real tx(Nt,2)       
C tangent direction x                         !
         Real tz(Nt,2)       
C tangent direction z                         !
         Real X (Nt,2)       
C x location of rays                          !
         Real z (Nt,2)       
C z location of rays                          !
         Integer Maxpicks
         Parameter (Maxpicks = 4400)
         Real NextX(Maxpicks), NextZ(Maxpicks)
         Real txl, tzl,ddx, zz, part 
         Integer Current, Next, ideepest     
C Set up integers to point to the Current and Next values in the computation.
C  We avoid a copy operation by using these indicies to impliment a data circle with 2 positions.
         Integer zlayer
C counter for depth layers
         Integer ix(nt) ,iz(nt)             
C ray cell locations
         Real    rx(nt), rz(nt)
C location of a ray within a cell.
C       
C Differential Equations used:
C  See Aki & Richards "Quantitative Seismology" vol 1 page 92
C    
C     dt/ds = Grad(Slowness)/S    where t  = ray direction & s = arclength
C     ds    = dz/tz               where tz = z-component of the ray parameter
C     dx/ds = tx
C
C Finite difference equations:
C     dtx   = gradx(slowness)*dz/(Slowness*tz)  
C     dtz   = gradz(slowness)*dz/(Slowness*tz) 
C     tz    = tz + dtz
C     tx    = tx + dtx
C     x     = x  + tx*dz/tz
C     z     = z  + dz
C     tau   = tau+ S*dz/tz
C
C Program Design:
C 1. Initialize positions and ray parameters.
C     Set all rays to dead.
C 2. Initialize Previous and Next Slowness arrays.
C 3. Compute slowness and grad(slowness) at ray positions
C 4. Compute trial dp and dr
C 5. Compute Slowness(r+dr/2)& Grad(slowness(r+dr/2))
C 6. Compute R-K guess at dp & dr
C 7. Update r(current), p(current) for live rays & 
C      partial increment for new rays.
C 8. z = z+dz 
C 9. If old zlevel then repeat 3
C10. If done exit 
C    else rotate memory cycle and read in new slowness values
C   to set up a new zlevel and repeat 3.

c      Logical Done
C--------Initialize-arrays-------------------------------------------------
C
C      Open (12,file='Trace_coordinates', status='old')
C      Read (12,*) (X(i), Y(i), tx(i), ty(i), tz(i), i=1,Nt)
C
C       Initialize ray positions and directions:
c      Open(25,file='ray.path')
       If (Nt .gt. Maxpicks) then
         Write(*,*) 'Error!  Too many picks for predefined arrays.'
         Write(*,*) 'Change maxpicks value in the ray2d pgm.'
         Write(*,*) 'Maxpicks =',Maxpicks
         stop
       endif
c      write(*,*) 'On entry to ray2d.f Nt=',Nt
c      Write(*,*) 'nx,nz=',nx,nz
c      Write(*,*) 'dx,dz=',dx,dz
c      Write(*,*) 'Nsteps =',Nsteps
c      Write(*,*) 'velocity ='
c      Write (*,*) (v(j,nx),j=1,nz)
c testing the interface-------
c      j = 0
c     Do i = 1,Nt
c       j = j+1 
c       call testit(x0(j), j,'x0  ')
c     enddo
c     Do i = 1,Nt
c       j = j+1
c       call testit(z0(j), j,'z0  ')
c     enddo
c     Do i = 1,Nt
c       j = j+1
c       call testit(tx0(j), j,'tx0 ')
c     enddo
c     Do i = 1,Nt
c       j = j+1
c       call testit(tz0(j), j,'tz0 ')
c     enddo
       ! Do some inverses for efficiency considerations:
       ! Most compilers probably recognize these optimizations but ...
       dxi    = 1./dx
       dzi    = 1./dz

       Current  = 1
       Next     = 2
       zz = 0.
       Do 10 i = 1,Nt
         X(i,1) = X0(i)
         Z(i,1) = z0(i)
        zz      = max(zz, z0(i))
        tzprev(i)= tz0(i)
       Tau(i,1)= 0.
10     Continue
       do i = 1,nt
         inray(i)= 0
       Enddo
       ideepest = (zz-zorigin)/dz +1.
       zz = (ideepest -1)*dz
        write(*,*) 'Deepest layer is ',ideepest
C --------- Read a first velocity layer (velocity for depth zz) -------
       Call Read_slowness(ideepest  , nz, nx, V, Slowness(1,Current))

C  Initialize the ray parameters-------------------------------
       Do i = 1,Nt
         tx(i,1)=  tx0(i)
         tz(i,1)=  tz0(i)

       Enddo
c--------save the initial position of the rays:
       If (raypath) then
       Do L = 1,Nt
       If (saveray(L)) then
           LL = inray(L) + 1
           inray(L) = LL
           rray(1,lray(L),LL) =  X0(L)
           rray(2,lray(L),LL) =  z0(L)
c          rray(1,lray(L),LL) =  X0(L)/dx +1
c          rray(2,lray(L),LL) =  z0(L)/dz +1
           rray(3,lray(L),LL) = tx0(L)
           rray(4,lray(L),LL) = tz0(L)
            
       Endif
       Enddo
C--------Set up to display the rays using Gocad++---------------

       Open (14,file='Krraytd.debug',status='unknown')
       Open (15,file='real.rayparms',status='unknown')
                                                      
       Write(15, *) 'NUMBER_OF_RAY_POINT_PARAMETERS 0'
       Write(15, *) 'NUMBER_OF_RAY_BOUNDARY_POINT_PARAMETERS 0'
       Write(15, *) 'RAY_FILE_NAME real.rayset'
       endif
                                               
C
C
C
                                                                                           
       Do zlayer = ideepest-1, 1, -1 
c      ! Read in a layer of the slowness array:
         Call Read_slowness(zlayer, nz, nx,  V, Slowness(1,Next))
c      ! interpolate slowness and slowness gradients:
c      ! fix the following for better boundary properties djv
c      ! Maybe we can use an estimator like t(nx)=2t(nx-1)-t(nx-2) at the
c      ! boundary.
                  
            
CEach vertical slice of the velocity model is broken into NSTEPS vertical steps.
C  We compute increments in the direction and position at NSTEPS steps for each 
C  depth of the velocity level.  
C  We do all NSTEPS in place to save storage.  That is we use :(:,Next) to hold the 
C  intermediate calculations. 
                                 
       ddz  = -dz/Nsteps
       Do L=1,Nt
          tz(L,Next) = tz(L,Current)
          tx(L,Next) = tx(L,Current)
          x (L,Next) = X (L,Current)
          z (L,Next) = z (L,Current)
          Tau(L,Next)= Tau(L,Current)
       enddo

       do i = 1, Nsteps

       call Interpolate(slowness, x(1,Next), z(1,Next), dxi, dzi,
     1 dx, dz, xorigin, zorigin, nx, nz, nt, current, 
     1 next, ix,rx, iz, rz, Slow0, slowx, slowz)


C Now we have the derivative of the slowness and are ready to do
C  a Runga-Kutta step:

       Do L=1,Nt
C Update ray directions using a semi-implicit formula:
C and use Newton's iteration to solve the nonlinear equation:

          a      = ddz*Slowz(L)/Slow0(L)
          dtz    = a/tz(L,Next)
          tzp    = tz(L,Next) + dtz*.5
          dtzerr = tzp*(a - dtz*tzp)/(tzp**2+a*.5)
          dtz    = dtz + dtzerr
          tzp    = tz(L,Next) + dtz*.5
          dtzerr = tzp*(a - dtz*tzp)/(tzp**2+a*.5)
          dtz    = dtz + dtzerr
          tzp    = tz(L,Next) + dtz*.5
          dtzerr = tzp*(a - dtz*tzp)/(tzp**2+a*.5)
          dtz    = dtz + dtzerr

c         dtz   = (ddz*Slowz(L)/Slow0(L) - .5*dtz*dtz)/tz(L,Next)
c         dtz   = (ddz*Slowz(L)/Slow0(L) - .5*dtz*dtz)/tz(L,Next)
c         dtz   = (ddz*Slowz(L)/Slow0(L) - .5*dtz*dtz)/tz(L,Next)
c         dtx   = ddz*Slowx(L)/(Slow0(L)*(tz(L,Next) + .5*dtz))
          tzL   = tz(L,Next) + dtz
          txL   = tx(L,Next) + dtx
c         part  = max(0.,min(1., abs((z0(L) -zz - ddz)/ddz)))
          part  = max(0.,min(1.,    -(z0(L) -zz - ddz)/ddz))
C     x     = x  + tx*dz/tz
          ddx   = txL*ddz/tzL

C Compute a guess at the midpoint location. ( 2nd order Runga-Kutta)

          NextX(L)= x(L,Next) + part*ddx*.5
          NextZ(L)= z(L,Next) + part*ddz*.5
       Enddo

C Compute slowness and gradients at the midpoint:

       call Interpolate(slowness, NextX, NextZ, dxi, dzi,
     1 dx, dz, xorigin, zorigin, nx, nz, nt, current,
     1 next, ix,rx, iz, rz, Slow0, slowx, slowz)

                                       
       Do L=1,Nt
C Only compute for upward going rays.  Once they go down they stay down.
       If(tz(L,Next). lt. 0. .and. 
     1     z0(L) .gt. zz +ddz         ) then 
C Recompute the changes using the best guess at local conditions:
c (and Newton's iteration)

C Finite difference equations:
C     dtx   = gradx(slowness)*dz/(Slowness*tz)  
C     dtz   = gradz(slowness)*dz/(Slowness*tz) 
C     tz    = tz + dtz
C     tx    = tx + dtx
C     x     = x  + tx*dz/tz
C     z     = z  + dz
C     tau   = tau+ S*dz/tz
C
c         dtz   = ddz*Slowz(L)/(Slow0(L)*tz(L,Next))
c         dtz   = (ddz*Slowz(L)/Slow0(L) - .5*dtz*dtz)/tz(L,Next)
c         dtz   = (ddz*Slowz(L)/Slow0(L) - .5*dtz*dtz)/tz(L,Next)

          a      = ddz*Slowz(L)/Slow0(L)
          dtz    = a/tz(L,Next)
          tzp    = tz(L,Next) + dtz*.5
          dtzerr = tzp*(a - dtz*tzp)/(tzp**2+a*.5)
          dtz    = dtz + dtzerr
          tzp    = tz(L,Next) + dtz*.5
          dtzerr = tzp*(a - dtz*tzp)/(tzp**2+a*.5)
          dtz    = dtz + dtzerr
          tzp    = tz(L,Next) + dtz*.5
          dtzerr = tzp*(a - dtz*tzp)/(tzp**2+a*.5)
          dtz    = dtz + dtzerr

          if (abs(dtzerr).gt. .001) then
          if(verbos) then
            write(LERR,*) 'dtz convergence failed for ray # ',L
            write(LERR,*) 'tz(L)=',Tz(L,Next), ' dtz=',dtz
            write(LERR,*) 'slowz=',slowz(l),' Slow=',slow0(l)
            write(LERR,*) 'ddz=',ddz
            write(LERR,*) 'dtz=',dtz, ' dtzerr=',dtzerr
          endif
          endif
          dtx   = ddz*Slowx(L)/(Slow0(L)*(tz(L,Next) + .5*dtz))
          part  = max(0.,min(1., -((z0(L) -zz - ddz)/ddz)))
c         part  = max(0.,min(1., abs((z0(L) -zz - ddz)/ddz)))
c         part = 1.
          tz(L,Next)   = tz(L,Next) + dtz*part
          tx(L,Next)   = tx(L,Next) + dtx*part

C Force  the magnitude of the ray direction vector to be one:

           t2 = 1./sqrt(tx(L,Next)**2 + tz(L,Next)**2)
           tx(L,Next) = tx(L,Next)* t2 
           tz(L,Next) = tz(L,Next)* t2

C Update travel time and ray positions
          tzave         = .5*(tz(L,Next)+tzprev(L))
          tzprev(L)     = tz(L,Next)
          if(tzave .ne. 0.) then
          Tau(L,Next)   = Tau(L,Next) +
     1                    part*abs(Slow0(L)*ddz/tzave)
            x(L,Next)   =   x(L,Next)+
     1                    part*     tx(L,Next)*ddz/tzave
            z(L,Next)   =   z(L,Next)+    part*ddz  
         endif
         endif
       enddo

         zz = zz + ddz
       Enddo
C ----Check that we have truely propagated the rays through the
C ----z layer..................................................
       Do L=1,Nt
       If (zlayer -1.ne. z(L, Next)/dz .and.
     1       tz(L,Next). lt. 0.      .and. 
     1       z0(L) .gt. zz    ) then
          Write(*,*) 'Error in zlayer', zlayer, z(L,Next)
     1  ,z(L,Next)/dz, L, tz(L,Next), Tau(L,Next), z0(L) 
       endif
       Enddo
       If (raypath) then
       Do L = 1,Nt
       If (saveray(L).and. z0(L) .gt. zz.and.
     1        tz(L,next).lt.0.) then
           LL = inray(L) + 1
           inray(L) = LL
           rray(1,lray(L),LL) =  X(L,NEXT)
           rray(2,lray(L),LL) =  z(L,NEXT)
c          rray(1,lray(L),LL) =  X(L,NEXT)/dx +1
c          rray(2,lray(L),LL) =  z(L,NEXT)/dz +1
           rray(3,lray(L),LL) = tx(L,NEXT)
           rray(4,lray(L),LL) = tz(L,NEXT)
            
       Endif
       Enddo
       endif
C Rotate the memory loop to get ready for the next step higher:
       Current  = Next
       Next     = Next + 1
       If (Next .gt. 2 ) Next = 1
                                 
c       Write(*,*) 'zlayer=', zlayer, tau(Nt/2,Current)
c       write(*,*) ' z=',z(Nt/2,Current), x(Nt/2,Current) , z0(Nt/2) 
        write(14,*) ' Current, next=', Current, Next
        write(14,*) 'zlayer=',zlayer
        write(14,*) 'ix(nx/2)=',ix(nx/2),' X(nx/2)=',X(nx/2,Current)
        write(14,*) 'rx(nx/2)=',rx(nx/2)
c        if (done) exit                               
       enddo
            
            
      if(raypath) then
      Write(15,*) 'END'
      Write(15,*) 'END'
      endif
C      Return the final position & travel time of the rays:
      Write(*,*) 'done with ray2d'

c      write(*,*) 'x(i,current)=',(x(i,current),i=1,nt)
c      write(*,*) 'tau(i,current)=',(tau(i,current),i=1,nt)
c      write(*,*) 'tz(i,current)=',(tz(i,current),i=1,nt)
      Do i = 1,Nt
       X0(i)  = X(i,Current)
       z0(i)  = tau(i,Current)
       tz0(i) = tz(i,Current)
       tx0(i) = tx(i,Current)
c      If(tz(i,Current). ge. 0.) then 
c        x0(i)  = 0.0
c        z0(i)  = 0.0
c      endif
      enddo

c-----write rays to ray file---------------------
c     one = 1.0
c     do L = 1,Nt
c     if (saveray(L)) then
c       I = lray(L)
c       write(25,20) I, segname(I), icolor(i), inray(L)
c0    Format('Segment = ',I5,' Name ',A20,2X,'color = ',
c    1        I5,' picks =',I6)
c     Do j = 1,inray(L)
c     write(25,'(F12.6,4F13.6)') one, (rray(k,I,j),k=1,4) 
c     enddo
c     endif
c     Enddo
c     write(*,*) x0(1),' = x0(1)'
      Return
                       
                       
      end
      Subroutine Read_slowness(zlevel, nz, nx,  V, Slow)
c Read in a "z" layer at a time.
c 

      implicit none

      integer zlevel, nz, nx
      Integer i, j
      Real Slow(nx)
      Real V(nz,nx)
      j = zlevel
      If (j .lt. 1 ) j = 1
      If (j .gt. nz) j = nz
      do  i = 1, nx
          Slow(i) = 1./V(j, i)
      Enddo 
      Return
      End
      Subroutine testit(x0,j,s)
      character s*4
        If(x0 .ne. j) then
           write (*,*)  s,'failed test at', j, x0
           stop
        Endif
        Return
        End
