/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/* flag is the item being searched.
   default_value is the default value for the option.
   argc and argv are from the main program. */


char *get_arg(flag,default_value,argc,argv)
char *flag,*default_value,**argv;
int *argc;
{
  char answer[1024];
  int i, j = 0, flag_found =0;
  
				/* loop thru the arguments looking 
				   for the right flag */
  for (i=1; i<*argc; i++) {
    if( !strncmp(flag,argv[i],strlen(flag))) {
      if ( strlen(argv[i]) == strlen(flag) ) {
	strcpy( answer,argv[i+1]);
	flag_found=2;
      } else {
	strcpy(answer,argv[i]+strlen(flag));
	flag_found=1;
      }
      break;
    }
  }

  if (flag_found!=0) {
    (*argc)-=flag_found;
    for ( j=i; j<*argc; j++)
      argv[j] = argv[j+flag_found];
    argv[*argc] = '\0';
  } else {
    strcpy( answer,default_value);
  }
  
  return( answer );
}


int is_arg(flag, argc, argv)
char *flag, **argv;
int *argc;
{
  int i, j = 0, flag_found =0, answer;
  
  /* loop thru the arguments looking for the right flag */
  
  for (i=1; i<*argc; i++) {
    if( !strncmp( flag, argv[i], strlen(flag)) ) {
      flag_found = 1;
	  
				/* we have found the flag */
      if ( strlen(argv[i]) == strlen(flag) )
	answer =1;
      else
	answer =0;
      break;
    }
  }
  
  /* if we found the flag then decrease the number of args
     and take one element out of the argv list		*/
  
  if (flag_found!=0) {
    (*argc)-=flag_found;
    for ( j=i; j<*argc; j++)
      argv[j] = argv[j+flag_found];
    argv[*argc] = '\0';
  } else {
    answer =0;
  }
  
  return( answer );
}


#ifdef TEST
#include <stdio.h>

main(argc,argv)
int argc;
char **argv;
{
  int verbose=0,record;
  char filename[1024];

  strcpy(filename,get_arg("-N","",&argc,argv));

  record=atoi(get_arg("-record","1",&argc,argv));

  verbose=is_arg("-V",&argc,argv);;

  if (argc>1) {
    fprintf(stderr,"Usage: %s [-N filename] [-record record] [-V verbose].\n",argv[0]);
    exit(1);
  }

  printf("Verbose=%d \n",verbose);
  printf("Filename=%s \n",filename);
  printf("Record=%d \n",record);

  printf("argc left %d\n",argc);
}
#endif
