C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C*****************************************************************************
C
C   cefft: subroutine to do 1-D complex to complex Fourier transform.  
C   Based on Les Hattons coding of the routine "fork" from FGDP.
C
C   cefft( x, n1, sign ): n1 complex to n1 complex
C
C   arguments:
C
C      x	input output complex array
C      n1	number of complex elements in array; must be a power of two
C      sign	sign of sqrt(-1); +1 is forward transform, -1 inverse transform
C
C      scaling by (1/n1) is done on forward transform (sign=1)
C
C*****************************************************************************
C
      subroutine cefft( x, n1, sign ) 
C
      implicit none
C 
      integer           i         !loop counter 
      integer           sign      !direction flag for fft. 
      integer           istep     !loop increment. 
      integer           j         !loop counter 
      integer           l         !work variable 
      integer           n1        !number of samples in rarray. 
      integer           m         !work variable 
C 
      doubleprecision   factlt    !1./n1 
      doubleprecision   pi 	  !mathematical constant
C
      complex*16        carg      !work variable. 
      complex*16        ctemp     !work variable
      complex*16        cw        !work variables. 
      complex           x(n1)     !data array. 
C 
      parameter (pi = 3.14159265358979323846) 
C
      if (sign .eq. 1)  then 
C 
C        forward transform, scale the time series. 
C 
         factlt = 1./n1 
C 
         do 5 i = 1, n1 
            x(i) = x(i)*factlt 
    5    continue 
C
       endif 
C 
C     initialize the pointers. 
C 
      j    = 1 
C 
C     do the bit-reverse addressing. 
C     ============================== 
      do 10 i = 1, n1                                 !do 
         if (i .lt. j)  then                          ! 
C                                                     ! 
C             swap.                                   ! 
C                                                     ! 
              ctemp  = x(j)                           ! 
              x(j) = x(i)                             ! 
              x(i) = ctemp                            ! 
C                                                     !
         endif                                        ! 
C                                                     ! 
         m = n1/2                                     ! 
C                                                     ! 
    7    continue                                     !  @do forever 
              if (j .le. m)  go to 8                  !  @..exitdo 
              j = j - m                               !  @ 
              m    = m/2                              !  @ 
              if (m .lt. 1)  go to 8                  !  @..exitdo 
              go to 7                                 !  @ 
    8    continue                                     !  @enddo 
C                                                     ! 
         j = j + m                                    ! 
C                                                     ! 
   10 continue                                        !enddo 
C 
C     now do the transform. 
C     ===================== 
      l       = 1 
C 
   20 continue                                        !do forever 
         istep = 2*l                                  ! 
         do 40 i = 1, l                               !   @do 
              carg = (0.,1.) * (pi*sign*(i-1)) / l    !   @ 
              cw   = exp( carg )                      !   @ 
              do 30 j = i, n1, istep                  !   @   @do 
                   ctemp        = cw   * x(j+l)       !   @   @ 
                   x(j+l)       = x(j) - ctemp        !   @   @ 
                   x(j  )       = x(j) + ctemp        !   @   @ 
   30         continue                                !   @   @enddo 
C                                                     !   @ 
   40    continue                                     !   @enddo 
C                                                     ! 
         l = istep                                    ! 
         if ( l .ge. n1 )  go to 50                   !..exitdo 
         go to 20                                     ! 
   50 continue                                        !enddo 
C
      return
      end 
