C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
CABCD 123456  version s3
C***********************************************************************
C                  PLANE WAVE MIGRATION BEFORE STACK
C***********************************************************************
C    Author:   N. D. Whitmore, Jr.
C
C    Revised:  Mary Ann Thornton   9/10/91
C              Moved code to sun for maintenance/distribution
C              Changes are to include 4 header files and add calls to
C               saver and savew for retrieving or storing lineheader and
C               trace header values.  One include file is to date stamp
C               the printout at run time with the last revised date.
C              Subroutine czero was unused and removed.               
C    Revised:  Mary Ann Thornton   3/25/92  version 2.1
C              Call openpr with ppname for compatibility with OS 6.1
C              Made ierr equal zero before calling genvel subroutine
C    Revised:  Mary Ann Thornton   8/11/92  version 2.2
C              Changed first lines of velocity model               
C    Revised:  Mary Ann Thornton   8/18/92  version 3.0
C              converted code to run on 32 bit machine             
C    Revised:  Mary Ann Thornton   2/02/93  version 3.1
C              Replace CCONT routine with FXCONT routine which allows
C              4096 traces in one horizontal segment
C              4 work arrays were defined in routine XDCIM6
C    Revised:  Mary Ann Thornton   4/23/93  version 3.2
C              Correct xdcim6 to call galloc only the first time through
C              Changed line headr size to SZLNHD, included logical unit
C              for the HP, removed nastat (msk) and Istatstep (iextrp) from
C             the input cards and made them hidden command line arguments.
C              Changed number of angles allowed to 150 from 100, also jbmax
C    Revised:  Mary Ann Thornton   4/28/93  version 3.3
C              change routines fgcfft and ggcfft to receive arrays with
C              dimension of *, not 1.  Change cnst to receive cnst array
C              dimensioned to 11.  change number of angles input to 200.
C              change jbmax to 200, also.
C    Revised:  M.A. Thornton       04/29/93  Version 3.4
C              Moved the dummy array definition and the pointers to the
C              main, passing the pointers to the appropriate subroutines,
C              allocating the space in xdcim6 routine.
C    Revised:  M.A. Thornton       05/29/93  Version 3.5
C              Correct an error in a call to vmov in subroutine xfsmp
C              (not enough parameters in the call/subr. never called)
C    Revised:  M.A. Thornton       10/01/93  Version 4.0
C              Corrected the size of the 4 dynamically allocated arrays
C              (size based on aperture which changed from one call to
C              the next - chose largest ever allowed to use in calculation)
C              Corrected the size of an array ixp.                     
C              Changed size of maxnt from 3839 to maxna*maxnv+1
C              Moved some subroutines into separate files so the compile
C              could finish without running out of memory.
C              Removed unused subroutines xfsmp and flint and openzz
C              Added auditing.
C    Revised:  N.D. Whitmore, Jr.  11/08/93  Version 4.1
C              Add a value for the zero-depth point  (See stimag.F)
C    Revised:  Mary Ann Thornton   01/07/94  Version 4.2
C              Include Dx1000 and Dz1000 in the line header         
C              Include command line args in the line header         
C***********************************************************************
C
C PARAMETER AND DIMENSION STATEMENTS COMMON BLOCKS AND DATA STATEMENTS

      PARAMETER (THETA=89.,IMG=0,EPSLN=.3)

C * * * BEGIN MEMORY SPACE ALLOCATION * * * * * *

C * * * PWMBS COMMON (BEGIN) * * *

C     DEPTH COMMON ---------------------------------------------------
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=100,IZSEGM=20)

      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)

      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C     DEPTH COMMON ---------------------------------------------------


C     WIDTH COMMON -(ixmax must be a power of 2) ---------------------
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=200,IXSEGM=5,IXMAX=4096)

      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT

      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C     WIDTH COMMON ---------------------------------------------------


C     TIME COMMON ------------------------------------------------------
      INTEGER ISI,NSAMP,ITPAD,NDFT,ITBEG
      REAL DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES

      COMMON /TIME/ ISI,NSAMP,ITPAD,NDFT,ITBEG,
     &              DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES,TDFT,T0
C     TIME COMMON ------------------------------------------------------


C     FREQ COMMON ------------------------------------------------
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)

      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI

      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ------------------------------------------------


C     LUNITS ---LOGICAL UNITS
C     LUNITS -----------------------------------------------------
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99

      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS -----------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS------------------
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)

      INTEGER IHEAD(1500)
ccms  INTEGER*2 THEAD(3000),ITRH(128)
CCRAY
      INTEGER THEAD(3000)
      INTEGER*2 ITRH(LNTRHD)
ccms  REAL TRACE(NSMAX+64),DATA(NSMAX)
CCRAY
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)

      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
ccms  EQUIVALENCE (TRACE(65),DATA(1))
CCRAY
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ------------------------------------------------


C     MISCL COMMON ---------------------------------------------------
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY

      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C     MISCL COMMON ---------------------------------------------------


      INTEGER INDREC(IXMAX*IXSEGM)

C * * * PWMBS COMMON (END) * * * *

c * * DATA ARRAYS NOT IN COMMON * *


C     WORK SPACE
      Parameter (NWORK=6064)
      REAL WORK1(nwork),WORK2(nwork),WORK3(nwork)
      COMPLEX CWORK1(nwork/2),CWORK2(nwork/2),CWORK3(nwork/2)
CCRAY  mixed radix fft tables -- (do not use for other space)
      integer ifftab(nwork)
      real    rfftab(3*nwork/2)

c     number of velocities per depth segment
      integer numvel(izsegm)

c     reciprocical of velocities per depth segment
      parameter (maxnv=63,maxna=65)
      real slop(maxnv,izsegm)

c     velocity array
      real velist(300,maxnv)

      EQUIVALENCE(WORK1(1),CWORK1(1)),(WORK2(1),CWORK2(1))
      EQUIVALENCE(WORK3(1),CWORK3(1))

C     MINIMUM AND MAXIMUM VELOCITIES
      REAL VMIN(IZSEGM),VMAX(IZSEGM)

C     DOWNWARD CONTINUATION ARRAYS
      COMPLEX CRFL(IXMAX),CINC(IXMAX)

C     2-d cmplex transpose array
      COMPLEX CIMAGE(IXMAX*IWMAX)

C     RESAMPLING ARRAYS
      INTEGER IXRSMP(IXMAX*4)
      REAL XRSMP(IXMAX*4)

C     Green's tables
      REAL    GWRK1( 3*maxnv*(maxna+1) ),
     &        GWRK2( 2*maxna-1 ),
     &        GWRK3( maxnv*(maxna+1) ),
     &        GWRK4( maxnv*(maxna+1) ),
     &        GWRK5( maxna*maxna ), WORK(4*IXMAX)
      integer ivv (izmax*maxnv),  ivp2(izmax+1),
     &        ivv2(izmax*maxnv),
     &        ixp (izmax*maxnv+1),
     &        ixp2(izmax*maxnv+1),
     &        map(maxnv)
      real    gxr1(ixmax+1, maxna), gxr2(ixmax+1,maxna),
     &        sxr1(ixmax+1, maxna), sxr2(ixmax+1,maxna),
     &        gxi1(ixmax+1, maxna), gxi2(ixmax+1,maxna),
     &        sxi1(ixmax+1, maxna), sxi2(ixmax+1,maxna)
      real rimage(ixmax*izmax*izsegm)     
cmat
      real  wpr(1),wnr(1),wni(1),wpi(1)
      pointer (ppwpr,wpr),(ppwnr,wnr),(ppwni,wni),(ppwpi,wpi)

CVXZ1 MEMORY MAP ARRAYS FOR INC AND REFLECTED FIELDS
      complex ciwork(ixmax,iwmax),crwork(ixmax,iwmax)

C * * * END MEMORY SPACE ALLOCATION * * * * * * *


C * * * * * * * * * * EXECUTION BEGINS  * * * * * * * * * * * * * * * *


C   $ $ $ $ $ $     INITIALIZATION PHASE      $ $ $ $ $ $
C

C $ $ $ $ $ $ $ $   PARAMETERIZATION PHASE     $ $ $ $ $ $


C    OPEN INPUT TAPE
C     READ INPUT CARDS
C      COMPUTE JOB CONSTANT PARAMETERS AND LOOP CONTROL
C       OPEN OUTPUT TAPE

cv6
      CALL PWJOBP ( BMWTHI, BMWTHR, IDIPZ, PRCNT ,iextrp ,imute,ixtap,
     &              LUV, DXTAP , DZTAP )

C    TAPES OPEN,  CARDS READ, LOOP CONTROL DETERMINED



C   $ $ $ $ $ $ $      EXECUTION PHASE         $ $ $ $ $ $
C


C    COMPUTE VELOCITY INDEX MATRIX and velocity tables

       WRITE(LUPRT,*) 'GENERATING VELOCITY INDEX MATRIX'
       ierr = 0
       CALL GENVEL(IERR,VMIN,VMAX,SLOP,NUMVEL,velist,
     &             indrec,DXTAP,DZTAP,maxna,MAXNV,LUV)
       IF(IERR.NE.0) THEN
        WRITE(LUPRT,*) 'ERROR IN GENERATING VELOCITY INDICIES'
        CALL CCEXIT(100)
       ENDIF

C     ALLOCATE DISK WORK FILES


         WRITE(LUPRT,*) 'ALLOCATING DIRECT ACCESS DISK FILES'
C         OPEN LUHDR
          nsmp=ITRWRD
          OPEN(UNIT=LUHDR,FORM='UNFORMATTED',
     1        STATUS='SCRATCH',ACCESS='DIRECT',RECL=NSMP*ISZBYT)

C         OPEN LUDAT
          NSMP=IWMAX*2
          OPEN(UNIT=LUDAT,FORM='UNFORMATTED',
     1        STATUS='SCRATCH',ACCESS='DIRECT',RECL=NSMP*ISZBYT)

C         OPEN LURFL
          NSMP=IXMAX*2
          OPEN(UNIT=LURFL,FORM='UNFORMATTED',
     1        STATUS='SCRATCH',ACCESS='DIRECT',RECL=NSMP*ISZBYT)

C         OPEN LUINC
          NSMP=IXMAX*2
          OPEN(UNIT=LUINC,FORM='UNFORMATTED',
     1        STATUS='SCRATCH',ACCESS='DIRECT',RECL=NSMP*ISZBYT)


      WRITE(LUPRT,*) 'SKIPPING LEAD IN TRACES'
C * * * * * * * SKIP OVER  IXBLK*IXSKP  INPUT TRACES  * * * * * * * * *
C *
      ISKIP=IXBLK*IXSKP
      WRITE(LUPRT,*) 'IXBLK,IXSKP,ISKIP=',IXBLK,IXSKP,ISKIP
      IF(ISKIP.GT.0) CALL SKIPT(LU14,ISKIP)
C *
C * * * * * * * *  TRACE SKIPPING COMPLETED   * * * * * * * * * * *
C
C * * * * * * * * * * *  PROCESS DATA * * * * * * * * * * * * * * *

C     LOOP 10: OVER BLOCKS (RECORDS)

      DO 10 JBLK=1,JXBLK

#ifdef CRAYSYSTEM
       cptime1 = second()
#endif

C      COMPUTE BLOCK DEPENDENT PARAMETERS/VECTORS
       write(luprt,*) '                        '
       WRITE(LUPRT,*)'BLOCK(RECORD)=',JBLK
cv8d   WRITE(LUPRT,*)'              '
       CALL PWBLKP(JBLK)
       WRITE(LUPRT,*) 'BLOCK PARAMETERS BUILT'
       NWBYT=NW*8

C      READ TRACE, WRITE HEADERS TO DISK, DFT DATA AND EITHER:
C      WRITE (OMEGA) DATA TO DISK
C      TRANSPOSE (OMEGA) DATA

       NBYTES=0
       IFLG=1
CCRAY   compute the starting frequency offset (times 2) for fft
       nf0 =f0*2. + itbeg

       DO 21 JNTR=1,JXNTR
CCRAY    clear data and read trace
        call vclr(data,1,(ndft+itbeg))
        CALL RTAPE(LU14,TRACE,NBYTES)
        if(nbytes.le.0) then
         write(luprt,*) 'tape i/o error on input'
         call ccexit(100)
        endif

cvs1    mute starting samples
        if(imute.gt.0) then
         do 22 jmute = 1,imute
   22    data(jmute) = 0.0
        endif

C       GET STATICS FROM FIRST/LAST TRACE TO COMPUTE RAY PARAMETER
        CALL SAVER(ITRH, 'StaCor', I125, TRCHED)
        IF(JNTR.EQ.1) STAT1=I125/1000.
        IF(JNTR.EQ.JXNTR) STAT2=I125/1000.
cmat    IF(JNTR.EQ.1) STAT1=ITRH(125)/1000.
cmat    IF(JNTR.EQ.JXNTR) STAT2=ITRH(125)/1000.

C
C       fft input trace

cvs2     if(JNTR.eq.1) then
cvs2     write(ler,*) 'itbeg,t0,tdft,f0,ndft,nw,iflg='
cvs2 &   ,               itbeg,t0,tdft,f0,ndft,nw,iflg
cvs2     endif
         call rfftmr(data(itbeg),1,ndft,iflg,ifftab,rfftab)
         call vmov(data(nf0),1,cwork1,1,nw*2)

        IF(JNTR.EQ.JXNTR/2) THEN
         WRITE(LUPRT,*) 'AFTER DFT',JNTR
        ENDIF

C        WRITE TRACE HEADER TO DISK
ccms     CALL DAWRTE(JNTR,ITRH,LUHDR,256)
CCRAY
         CALL DAWRTE(JNTR,ITRH,LUHDR,ITRWRD*4)

       IF(IXSEG.GT.1 .OR. IWSEG.GT.1) THEN
C        WRITE TRANSFORMED TRACE DATA TO DISK
         CALL DAWRTE(JNTR,CWORK1,LUDAT,NWBYT)
       ENDIF

       IF(IXSEG.EQ.1 .AND. IWSEG.EQ.1) THEN
        JXW=-JXNTR+JNTR
        DO 121 JW=1,NW
        JXW=JXW+JXNTR
 121    CIMAGE(JXW) =CWORK1(JW)
       ENDIF

  21   CONTINUE

C      PRINT RAY PARAMETER COMPUTED FROM TRACE HEADERS
       PRAY1=(STAT2-STAT1)/(DX*(JXNTR-1))
       WRITE(LUPRT,*)
     & 'RAY PARAMETER (COMPUTED FROM TRACE HEADERS)=',PRAY1

C      RDFT'S DONE- IF ON THE PERKIN-ELMER RELEASE THE STAR PARTITION
C                   IF ON CMS CLOSE LUHDR,LUDAT

C      LOOP 20: HORIZONTAL SEGMENTS

       DO 20 IXS=1,IXSEG

       WRITE(LUPRT,*) 'BEGIN HORIZONTAL SEGMENT',IXS
       NXLN=IXLN(IXS)
       NX=IXLN0(IXS)
       NX4=NX*4
       NX8=NX*8
       NXLN1=IXLN1(IXS)
       JXST=IXST(IXS)-1

C       LOOP 31: OMEGA SEGMENTS
        DO 31 IWS=1,IWSEG
        WRITE(LUPRT,*) 'BEGIN OMEGA SEGMENT',IWS
        JW1=IWBEG(IWS)
        JW2=IWEND(IWS)
C       IF NECESSARY READ REFLECTED (OMEGA) DATA AND TRANSPOSE --
        IF(IXSEG.GT.1 .OR. IWSEG.GT.1) THEN
         DO 41 JX=1,NXLN
          KXBIAS=JX+JXST
          CALL DAREAD(KXBIAS,CWORK1,LUDAT,NWBYT)
          JXW=-NXLN+JX
          DO 141 JW=JW1,JW2
          JXW=JXW+NXLN
  141     CIMAGE(JXW)=CWORK1(JW)
   41    CONTINUE
        ENDIF

C        LOOP 42: OVER OMEGA
C        COMPUTE INCIDENT FIELD AND DELAY REFLECTED FIELD
C        AND WRITE TO DISK
         IFLAG=0
         SCLINC=1./SQRT( (FMAX-FMIN)/DF )

         DO 42 JW=JW1,JW2

C                                       -I*OMEGA*PRAY*X
C        INCIDENT FIELD(X)  = SCLINC * E

         IF(PRAY.GE.0.0) THEN
          CWORK1(1)=CMPLX(SCLINC,0.0)
         ELSE
          ARG2=-OMEGA(JW)*PRAY*DX0*(1-NX)
          CWORK1(1)=SCLINC*CMPLX(COS(ARG2),SIN(ARG2))
         ENDIF

         ARG=-OMEGA(JW)*PRAY*DX0
         CWORK3(1)=CMPLX(COS(ARG),SIN(ARG))

          DO 142 JX=2,NX
  142     CWORK1(JX)=CWORK1(JX-1)*CWORK3(1)

CVXZ1    CALL DAWRTE(JW,CWORK1,LUINC,NX8) (memory map to ciwork)
         call vmov(cwork1,1,ciwork(1,jw),1,nx*2)

C        REFLECTED FIELD
         KX1=1+(JW-JW1)*NXLN
         CALL CRSMP(CIMAGE(KX1),DX ,NXLN,
     &               CWORK2(1),DX0,NX,
     &   IXRSMP,XRSMP,IFLAG)
         IFLAG=1
          SCLRFL=FILT(JW)/SCLINC
c****     SCLRFL=FILT(JW)/SCALF
          DO 342 JX=1,NX
          CWORK3(JX)=SCLRFL*CWORK1(JX)*CWORK2(JX)
  342     CONTINUE
CVXZ1    CALL DAWRTE(JW,CWORK3,LURFL,NX8) (memory map to crwork)
         call vmov(cwork3,1,crwork(1,jw),1,nx*2)

   42    CONTINUE

   31   CONTINUE

C
C      COMPUTE RIMAGE
C
CVXZ1  added ciwork,crwork (for memory mapping)
       CALL STIMAG (JBLK, IXS, IMG, PRCNT, EPSLN,
     &      INDREC, CINC, CRFL, BMWTHI, BMWTHR, IDIPZ, VMIN,VMAX,
     &      iextrp , ixtap , ciwork, crwork ,
     &      numvel , slop  , maxna, maxnv, gwrk1,gwrk2,gwrk3,gwrk4,
     &      gwrk5,work,ivv2,ivv,ixp,ivp2,ixp2,map,gxr1,gxr2,sxr1,
     &      sxr2, rimage, gxi1, gxi2, sxi1, sxi2, 
     &      ppwpr,ppwnr,ppwni,ppwpi )

C
   20  CONTINUE
#ifdef CRAYSYSTEM
       cptime2 = second()
       cptim12 = cptime2 - cptime1
       write(luprt,*) 'completed processing record #',jblk
       WRITE(LUPRT,*) 'CP TIME =',CPTIM12
cv8d   write(ler,*)     'completed processing record #',jblk
cv8d   WRITE(    0,*) 'CP TIME =',CPTIM12
#endif

C      SKIP JXSKIP TRACES:
       IF(JXSKIP.GT.0) THEN
CCRAY    CALL SKIPT(LU14,JXSKIP)
cf8d
        if(jblk.lt.jxblk) then
        CALL SKIPT(LU14,jxskip)
        endif
       ENDIF


   10 CONTINUE


C * * * * * * * * DATA PROCESSING COMPLETED * * * * * * * * * * * *



C   $ $ $ $ $ $       CLOSING PHASE          $ $ $ $ $ $ $


C    CLOSE DISKS
      CALL DACLOS(LUMTX)
      CALL DACLOS(LUHDR)
      CALL DACLOS(LUDAT)
      CALL DACLOS(LURFL)
      CALL DACLOS(LUINC)

C    CLOSE TAPES
      CALL LBCLOS(LU14)
      CALL LBCLOS(LU24)

C   PROGRAM COMPLETE
       write(luprt,*) '                        '
       write(luprt,*) 'FXPWMIG - program complete'
       write(luprt,*) '                        '
cv8d   write(ler,*)     'program complete'

      STOP
      END

C * * PWMBS BLOCK ( START ) * * * * * * * * * * * * * * * * * * * * *

      BLOCK DATA pwbloc
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

C * * BEGIN PWMBS COMMON  * * *

C     DEPTH COMMON ---------------------------------------------------
C
C J D IZMAX=MAXIMUM NUMBER OF OUTPUT SAMPLES (PARAMETER)
C J D IZSEGM=MAXIMUM NUMBER OF VERTICAL SEGMENTS (PARAMETER)

C J R IZSEG=NUMBER OF VERTICAL SEGMENTS (DEFAULT=1)
C J C IZB(IZS)=BEGINING INDEX OF SEGMENT IZS
C J C JZROW(IZS)=NUMBER OF ROWS IN SEGMENT IZS
C J C IZLN=NUMBER OF DEPTHS EXTRAPOLATED
C J C IZXTR=NUMBER OF Z ROWS TO APPEND BELOW DIGITIZED MODEL
C J C JZLN=NUMBER OF DEPTH SAMPLES OUTPUT
C J C ZBEG(IZS)=STARTING DEPTH OF SEGMENT IZS
C J C ZEND(IZS)=ENDING DEPTH OF SEGMENT IZS
C J C DZ(IZS)=DEPTH SPACING OF SEGMENT IZS
C J I DZOUT=OUTPUT DEPTH SPACING
C J I ZMAX=MAXIMUM DEPTH (=JZLN*DZOUT)
C J R ZDEP=DEPTH OF DIGITIZED MODEL
C J C ZTABLE(IZMAX)=DEPTH TABLE OF ACTUAL DEPTHS USED IN CONTINUATION


C     WIDTH COMMON ---------------------------------------------------
C
C J D JBMAX=MAXIMUM NUMBER OF BLOCKS (PARAMETER)
C J D IXSEGM=MAXIMUM NUMBER OF HORIZONTAL SEGMENTS/BLOCK (PARAMETER)
C J D IXMAX=MAXIMUM X WIDTH (IN DX0 OR DX UNITS) (PARAMETER)

C J I IXSEG=NUMBER OF HORIZONTAL SEGMENTS/BLOCK
C J R NTR=NUMBER OF TRACES PER RECORD ON INPUT TAPE
C J R NREC=NUMBER OF RECORDS ON INPUT TAPE
C J C IXLEN=WIDTH OF INDEX DATASET (AFTER HOIZONTAL PADDING)
C J I IXBLK=NUMBER OF BLOCKS TO SKIP (DEFAULT=0)
C J I IXSKP=NUMBER OF TRACES/BLOCK TO SKIP (DEFAULT=NTR)
C J I JXBLK=NUMBER OF BLOCKS TO PROCESS
C           (DEFAULT=NREC-((IXBLK*IXSKP/NTR)
C J I JXNTR=NUMBER OF TRACES PER BLOCK TO PROCESS (DEFAULT=NTR)
C J I JXSKIP=NUMBER OF TRACES PER BLOCK TO SKIP (DEFAULT=0)
C J C IXLN(IXS)=NUMBER OF TRACES/SEGMENT TO PROCESS
C J C IXLN0(IXS)=NUMBER OF X'S/SEGMENT TO PROCESS AFTER RESAMPLING
C J C IXLN1(IXS)=NUMBER OF OUTPUT TRACES/SEGMENT
C J C IXBIAS(IXS)=(STARTING INDEX PER SEGMENT)-1
C     (IXBIAS(1)=0,IXBIAS(N)=IXBIAS(N-1)+IXLN1(N-1), N=2,IXSEG)
C J C IXST(IXS)=STARTING TRACE LOCATION (PER SEGMENT)
C J C IXST0(IXS)=STARTING MATRIX INDEX (PER SEGMENT) = IXST(IXS)/XPAND
C J I XOVPC=PER CENT OVERLAP PER SEGMENT
C J I DX=TRACE SPACING (DEFAULT=GROUP INTERVAL)
C J I XPAND=HORIZONTAL EXPANSION (OR COMPRESSION) FACTOR (DEFAULT=1.0)
C J C DX0=HORIZONTAL SPACING TO BE USED IN MIGRATION (DX0=DX*XPAND)
C J I XBEGIN=LOCATION OF FIRST TRACE RELATIVE TO THE GEOLOGIC MODEL
C            (IF XBEGIN<0, THEN THE DEPTH INDEX MATRIX IS EXTENDED
C            HOIZONTALLY BY -XBEGIN )
C J R XWTH =WIDTH OF DIGITIZED MODEL
C J D XSHOT=LOCATION OF SOURCE (RELATIVE TO A BLOCK) -- THIS IS VALID
C           ONLY WITH COMMON SHOT MIGRATION (OTHERWISE,XSHOT=0.0)
C J D XSHFT=LATERAL SHIFT OF DIGITIZED MODEL PER BLOCK-- THIS IS VALID
C           ONLY WITH COMMON SHOT MIGRATION (OTHERWISE,XSHFT=0.0)


C     TIME COMMON ------------------------------------------------------
C
C J R ISI=INTEGER SAMPLE RATE IN MS ON INPUT TAPE
C J R NSAMP=NUMBER OF TIME SAMPLES ON INPUT TAPE
C B C ITPAD=ZERO SAMPLES TO PAD ON IXS SEG. OF JBLK BLOCK
C B C NDFT=NSAMP+IPAD0=NUMBER OF SAMPLES TO DFT
C J C ITBEG=BEGINNING TIME SAMPLE TO MIGRATE (ITBEG=TBEG/DTMS+1)
C J C DTMS=SAMPLE RATE IN MS ( DEFAULT=FLOAT(ISI) OR INPUT)
C J C DT=DTMS/1000.
C J I TBEG=BEGINING TIME TO MIGRATE (MS) (DEFAULT=0)
C J I TEND=ENDING TIME TO MIGRATE (MS) (DEFAULT=END OF DATA)
C J I TPAD0=EXTRA TIME TO PAD (MS) (DEFAULT=0)
C               (=TPAD0/DTMS+ABS(PRAY)*WIDTH(JBLK)*1000.)
C B C TIMEMS=TEND-TBEG+ITPAD*DTMS
C B C TIMES=TIMEMS/1000.
C B C TDFT=NDFT=REAL NUMBER OF SAMPLES TO DFT
C J D T0=REAL STARTING SAMPLE TO DFT=0.0


C     FREQ COMMON ------------------------------------------------
C
C J C IWSEGM=MAXIMUM NUMBER OF FREQUENCY SEGMENTS (PARAMETER)
C J C IWMAX=MAXIMUM NUMBER OF FREQUENCIES (PARAMETER)

C J C IWSEG=NUMBER OF FREQUENCY SEGMENTS TO TRANSPOSE AT A TIME
C B C IWBEG(IWS)=STARTING INDEX FOR THE IWS FREQUENCY SEGMENT
C B C IWEND(IWS)=ENDING   INDEX FOR THE IWS FREQUENCY SEGMENT
C B C IWMIN=STARTING OMEGA INDEX TO PROCESS (IWMIN=1)
C B C NW=ENDING OMEGA INDEX TO PROCESS=NUMBER OF FREQUENCIES
C        (NW=(FMAX-FMIN)*TIMES)
C B C FILT( )=TRAPEZOIDAL FREQUENCY FILTER
C B C F0=REAL MININUM FREQUENCY INDEX TO DFT(=FMIN*TIMES+1.)
C J I FMIN=MINIMUM FREQUENCY TO MIGRATE
C         =POINT ONE   IN (F1,F2,F3,F4) TRAPEZOIDAL FILTER
C J I F2  =POINT TWO   IN (F1,F2,F3,F4) TRAPEZOIDAL FILTER
C J I F3  =POINT THREE IN (F1,F2,F3,F4) TRAPEZOIDAL FILTER
C J I FMAX=POINT FOUR  IN (F1,F2,F3,F4) TRAPEZOIDAL FILTER
C         =MAXIMUM FREQUENCY TO MIGRATE
C B C DF = CHANGE IN FREQUENCY=1/TIMES
C B C SCALF=FOURIER TRANSFORM SCALING FACTOR =DT*DF
C J C OMMIN=2*PI*FMIN =MINIMUM ANGULAR FREQUENCY TO MIGRATE
C J C OMMAX=2*PI*FMAX =MAXIMUM ANGULAR FREQUENCY TO MIGRATE
C B C DOMEGA=2*PI/TIMES =CHANGE IN ANGULAR FREQUENCY
C B C OMEGA(JWL)=ANGULAR FREQUENCY FOR INDEX JWL
C B C OMEGA(JWL)=OMMIN+(JWL-1)*DOMEGA
C J D PI=3.14159....


C     LUNITS ---LOGICAL UNITS
C J D LUSTR (=  1): ST100
C J D LUMXC (= 62): DIGITIZED MODEL
C J D LUSYS (=  3): TEMP LU TO CHECK FOR SYSTEM VOLUME WITH CHKSYS
C J D LU4   (=  4): NOT USED
C J D LUIPT (= 64): PARAMETER INPUT
C J D LUPRT (= 66): PRIMARY PRINTER OUTPUT
C J D LU7   (=  7): NOT USED
C J D LU8   (=  8): NOT USED
C J D LU9   (=  9): NOT USED
C J D LUAPX (= 10): FPS APX (MAY NOT BE USED)
C J D LUAPR (= 11): FPS APR (MAY NOT BE USED)
C J D LUAPS (= 12): FPS APRS (MAY NOT BE USED)
C J D LUAPC (= 13): FPS APC (MAY NOT BE USED)
C J D LU14  (= 14): REFLECTED FIELD TAPE INPUT (TIME)
C J D LU15  (= 15): INCIDENT FIELD TAPE INPUT (TIME- NOT USED)
C J D LU16  (= 16): NOT USED
C J D LU17  (= 17): NOT USED
C J D LU18  (= 18): NOT USED
C J D LU19  (= 19): NOT USED
C J D LU20  (= 20): NOT USED
C J D LU21  (= 21): NOT USED
C J D LU24  (= 24): DEPTH SECTION OUTPUT (DEPTH)
C J D LU25  (= 25): DOWNWARD CONTINUED INCIDENT FIELD (TIME- NOT USED)
C J D LU26  (= 26): DOWNWARD CONTINUED REFLECTED FIELD (TIME- NOT USED)
C J D LU35  (= 35): NOT USED
C J D LUMTX (= 45): VELOCITY INDEX
C J D LUHDR (= 55): TRACE HEADER
C J D LUDAT (= 65): TRACE DATA (AFTER DFT)
C J D LUINC (= 75): INCIDENT FIELD
C J D LURFL (= 85): REFLECTED FIELD
C J D LUDEP (= 95): DEPTH SECTION (NOT PRESENTLY USED)
C J D LU98  (= 98): DEPTH SECTION (NOT PRESENTLY USED)
C J D LU99  (= 99): DEPTH SECTION (NOT PRESENTLY USED)


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS

C J D NSMAX=MAXIMUM NUMBER OF TIME SAMPLES (PARAMETER)

C J D IHEAD(1500) = LINE HEADER (FULL WORDS)
CCRAY
C J D THEAD(3000) = LINE HEADER (FULL WORDS)
ccms
C J D THEAD(3000) = LINE HEADER (HALF WORDS)
C J D ITRH(128) = TRACE HEADER PORTION OF TRACE
C J D TRACE(NSMAX+64)= HEADER + DATA
C J D DATA(NSMAX) = DATA PORTION OF TRACE


C     MISCL COMMON ---------------------------------------------------
C     (THIS COMMON BLOCK CONTAINS THE REMAINDER OF THE PARAMETERS AND
C     ARRAYS WHICH ARE NOT CATEGORIZED BY THE COMMON BLOCKS ABOVE)
C
C J D ISYS=SYSTEM TYPE (1=CMS, 0=PERKIN-ELMER, 2=CCRAY) SET IN BLOCK DATA
C J D IFMT=INTERNAL FORMAT = 3
C J R ITPFMT=INPUT TAPE FORMAT (AT THIS TIME, THIS MUST BE 3)
C
C     MODEL AND LINE NUMBER
C J I MTXNAM( )=NAME OF DIGITIZED MODEL
C J R LINNUM( )=LINE NUMBER
C
C     IMAGING CONTROL PARAMETERS
C J I MSK=EXTRAPOLATION APERTURE DECREMENT (USE EVERY 'MSK' POINT)
C J I NA=NUMBER OF POINTS/(HALF APERTURE) IN MIGRATION KERNEL
C         (DEFAULT=15, SHOULD BE GREATER THAN 10, <66)
C J D NAPMIN=MINIMUM NO OF POINTS IN APERTURE
C J D NAPMAX=MAXIMUM NO OF POINTS IN APERTURE
C
C     VELOCITY PARAMETERS
C J I NV =NUMBER OF VELOCITIES
C J I VELRFL( )=REFLECTED FIELD VELOCITIES
C J I VELINC( )=INCIDENT FIELD VELOCITIES (DEFAULT VELINC=VELRFL)
C J C SLORFL( )=REFLECTED FIELD SLOWNESS (SLORFL=1./VELRFL)
C J C SLOINC( )=INCIDENT FIELD SLOWNESS (SLOINC=1./VELINC)
C J I VELREF=REFERENCE VELOCITY
C
C     ANGLE PARAMETERS
C J I ANGL(JBMAX)=BEAM ANGLE (FOR A BLOCK)
C B C PRAY=RAY PARAMETER FOR A BLOCK


C     INDREC ARRAY TO HOLD ROW OF GENERATED MATRIX
C



C * * * PWMBS COMMON (BEGIN) * * *

C     DEPTH COMMON ---------------------------------------------------
      INTEGER IZMAX,IZSEGM
      PARAMETER (IZMAX=100,IZSEGM=20)

      INTEGER IZSEG,IZB(IZSEGM),JZROW(IZSEGM),IZLN,IZXTR,JZLN
      REAL ZBEG(IZSEGM),ZEND(IZSEGM),DZ(IZSEGM),DZOUT
      REAL ZMAX,ZDEP,ZTABLE(IZMAX*IZSEGM)

      COMMON /DEPTH/ IZSEG,IZB,JZROW,IZLN,IZXTR,JZLN,
     &               ZBEG,ZEND,DZ,DZOUT,ZMAX,ZDEP,ZTABLE
C     DEPTH COMMON ---------------------------------------------------


C     WIDTH COMMON ---------------------------------------------------
      INTEGER JBMAX,IXSEGM,IXMAX
      PARAMETER (JBMAX=200,IXSEGM=5,IXMAX=4096)

      INTEGER IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,JXBLK,JXNTR,JXSKIP
      INTEGER IXLN(IXSEGM),IXLN0(IXSEGM),IXLN1(IXSEGM)
      INTEGER IXBIAS(IXSEGM),IXST(IXSEGM),IXST0(IXSEGM)
      REAL XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT

      COMMON /WIDTH/ IXSEG,NTR,NREC,IXLEN,IXBLK,IXSKP,
     &               JXBLK,JXNTR,JXSKIP,
     &               IXLN,IXLN0,IXLN1,IXBIAS,IXST,IXST0,
     &               XOVPC,DX,XPAND,DX0,XBEGIN,XWTH,XSHOT,XSHFT
C     WIDTH COMMON ---------------------------------------------------


C     TIME COMMON ------------------------------------------------------
      INTEGER ISI,NSAMP,ITPAD,NDFT,ITBEG
      REAL DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES

      COMMON /TIME/ ISI,NSAMP,ITPAD,NDFT,ITBEG,
     &              DTMS,DT,TBEG,TEND,TPAD0,TIMEMS,TIMES,TDFT,T0
C     TIME COMMON ------------------------------------------------------


C     FREQ COMMON ------------------------------------------------
      INTEGER IWSEGM,IWMAX
      PARAMETER (IWSEGM=5,IWMAX=600)

      INTEGER IWSEG,IWBEG(IWSEGM),IWEND(IWSEGM),IWMIN,NW
      REAL FILT(IWMAX),F0,FMIN,F2,F3,FMAX,DF,SCALF
      REAL OMMIN,OMMAX,DOMEGA,OMEGA(IWMAX),PI

      COMMON /FREQ/  IWSEG,IWBEG,IWEND,IWMIN,NW,
     &               FILT,F0,FMIN,F2,F3,FMAX,DF,SCALF,
     &               OMMIN,OMMAX,DOMEGA,OMEGA,PI
C     FREQ COMMON ------------------------------------------------


C     LUNITS ---LOGICAL UNITS
C     LUNITS -----------------------------------------------------
      INTEGER         LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7
      INTEGER         LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14
      INTEGER         LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21
      INTEGER         LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX
      INTEGER         LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99

      COMMON /LUNITS/ LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
C     DEFINED IN PWBLOC (BLOCK DATA) AS:
C                        1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
C                        8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
C                       15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
C                       22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
C                       55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99
C     LUNITS -----------------------------------------------------


C     TAPE COMMON -- TAPE DATA AND HEADER ARRAYS------------------
      INTEGER NSMAX
      PARAMETER (NSMAX=7500)

      INTEGER IHEAD(1500)
ccms  INTEGER*2 THEAD(3000),ITRH(128)
CCRAY
      INTEGER THEAD(3000)
      INTEGER*2 ITRH(LNTRHD)
ccms  REAL TRACE(NSMAX+64),DATA(NSMAX)
CCRAY
      REAL TRACE(NSMAX+ITRWRD),DATA(NSMAX)

      EQUIVALENCE (ITRH(1),TRACE(1)),(IHEAD(1),THEAD(1))
ccms  EQUIVALENCE (TRACE(65),DATA(1))
CCRAY
      EQUIVALENCE (TRACE(ITHWP1),DATA(1))

      COMMON /TAPE/  IHEAD,TRACE
C     TAPE COMMON ------------------------------------------------


C     MISCL COMMON ---------------------------------------------------
      INTEGER ISYS,IFMT,ITPFMT,MTXNAM(2),LINNUM(2)
      INTEGER MSK,NA,NAPMIN,NAPMAX,NV,NATOP,NABOT
      REAL VELRFL(50),VELINC(50),SLORFL(50),SLOINC(50),VELREF
      REAL ANGL(JBMAX),PRAY

      COMMON /MISCL/ ISYS,IFMT,ITPFMT,
     &               MTXNAM,LINNUM,
     &               MSK,NA,NAPMIN,NAPMAX,NATOP,NABOT,
     &               NV,VELRFL,VELINC,SLORFL,SLOINC,VELREF,
     &               ANGL,PRAY
C     MISCL COMMON ---------------------------------------------------



C * * * PWMBS COMMON (END) * * * *


C    ASSIGN DEFAULTS NOT GIVEN BY PARAMETER STATEMENTS

C    PI:
                 DATA PI/3.14159265/


C    LOGICAL UNITS (COMMON: LUNITS)
                 DATA LUSTR, LUMXC, LUSYS, LU4  , LUIPT, LUPRT, LU7  ,
     &                LU8  , LU9  , LUAPX, LUAPR, LUAPS, LUAPC, LU14 ,
     &                LU15 , LU16 , LU17 , LU18 , LU19 , LU20 , LU21 ,
     &                LU22 , LU23 , LU24 , LU25 , LU26 , LU35 , LUMTX,
     &                LUHDR, LUDAT, LUINC, LURFL, LUDEP, LU98 , LU99
     &               /   1 ,   62 ,    3 ,    4 ,   64 ,   66 ,    7 ,
     &                   8 ,    9 ,   10 ,   11 ,   12 ,   13 ,   14 ,
     &                  15 ,   16 ,   17 ,   18 ,   19 ,   20 ,   21 ,
     &                  22 ,   23 ,   24 ,   25 ,   26 ,   35 ,   45 ,
     &                  55 ,   65 ,   75 ,   85 ,   95 ,   98 ,   99 /

C    APERTURE CONTROL:
                 DATA NAPMIN,NAPMAX/1,65/

C    SYSTEM CONTROL (CMS=1,PE=0,CCRAY=2)
ccms             DATA ISYS/1/
CCRAY
                 DATA ISYS/2/

C    INTERNAL DATA FORMAT:
                 DATA IFMT/3/


C     THAT'S ALL
      END

C * * PWMBS BLOCK ( END   ) * * * * * * * * * * * * * * * * * * * * *
