C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c    NAME: fxscmdln
c PURPOSE: get command line arguments
c***********************************************************************
c
      subroutine fxscmdln(LER, verbos, ntape, otape, vtape, gtape, ctape
     &              , base, dawov, dx, dz, f1, f2, f3, f4, switch
     &              , zmax, izmul, idt, increc, irec1, irec2, ismp1
     &              , ismp2, nabs, nap, nkx, nxpad, nspad, nxwin, nxout
     &              , nsym, tmute, vmute, nap_use, xlam )
c
      implicit none
c
c input parameters:
c
      integer   LER             ! logical unit number, error file
c
c output parameters:
c
      real      base            ! controls sharpness of absorp bdry
      character ctape*(*)       ! name of coefficient table file
      real      dawov           ! delta awov
      integer   debug           ! debug output flag
      real      dx              ! delta x
      real      dz              ! delta z
      real      f1              ! low  cutoff frequency (Hz) for filter
      real      f2              ! low  corner frequency (Hz) for filter
      real      f3              ! high corner frequency (Hz) for filter
      real      f4              ! high cutoff frequency (Hz) for filter
      character gtape*(*)       ! name of geometry file
      integer   idt             ! Sampling interval used
      integer   increc          ! increment between input records
      integer   irec1           ! first input record to use
      integer   irec2           ! last  input record to use
      integer   ismp1           ! first input sample of trace to use
      integer   ismp2           ! last  input sample of trace to use
      integer   izmul           ! multiplier for gridding in z dimension
      integer   nabs            ! number of absorbing zones
      integer   nap             ! number of apertures
      integer   nap_use         ! number of apertures to use
      integer   nkx             ! number of kx's
      integer   nspad           ! number pad sample
      integer   nsym            ! switch for symmetric window
      character ntape*(*)       ! name of input file
      integer   nxwin           ! max number of x's to be used
      integer   nxout           ! number of x's to be used in output
      integer   nxpad           ! number of zero traces padded in x
      character otape*(*)       ! name of output file
      real      switch          ! parameter for fft table building
      real      tmute           ! muting time offset
      logical   verbos          ! verbose output flag
      real      vmute           ! muting velocity
      character vtape*(*)       ! name of velocity data file (input)
      real      xlam            ! number of wavelengths, half aperture
      real      zmax            ! maximum depth
c
c functions:
c
      integer   argis           ! is argument present function
c
c***********************************************************************
c
c===  read parameters from command line
c
      call argi4( '-BR'   , irec1 ,      1,      1 )
      call argi4( '-ER'   , irec2 ,     -1,     -1 )
      call argi4( '-IR'   , increc,      1,      1 )
      call argi4( '-BS'   , ismp1 ,      1,      1 )
      call argi4( '-ES'   , ismp2 ,     -1,     -1 )
      call argi4( '-PS'   , nspad ,      0,      0 )
      call argi4( '-DT'   , idt   ,     -1,     -1 )
      call argi4( '-NAP'  , nap_use,    18,     18 )
      call argr4( '-fc'   , f2    ,    0.0,    0.0 )
      call argr4( '-f'    , f1    ,    0.0,    0.0 )
      call argr4( '-FC'   , f3    ,    0.0,    0.0 )
      call argr4( '-F'    , f4    ,    0.0,    0.0 )
      call argr4( '-DX'   , dx    ,    0.0,    0.0 )
      call argr4( '-DZ'   , dz    ,    0.0,    0.0 )
      call argr4( '-DAWOV', dawov , 1.6e-5, 1.6e-5 )
      call argr4( '-SW'   , switch,   0.95,   0.95 )
      call argi4( '-NKX'  , nkx   ,   1024,   1024 )
      call argi4( '-NXPAD', nxpad ,      0,      0 )
      call argi4( '-NXWIN', nxwin ,      0,      0 )
      call argi4( '-NXOUT', nxout ,      0,      0 )
      call argi4( '-NSYM' , nsym  ,      0,      0 )
      call argi4( '-NABS' , nabs  ,     10,     10 )
      call argr4( '-BASE' , base  ,   0.99,   0.99 )
      call argr4( '-ZMAX' , zmax  ,    0.0,    0.0 )
      call argi4( '-ZMUL' , izmul ,     1 ,     1  )
      call argi4( '-D'    , debug ,     1 ,     0  )
      call argstr('-N'    , ntape , ' '   , ' '    )
      call argstr('-O'    , otape , ' '   , ' '    )
      call argstr('-VEL'  , vtape , ' '   , ' '    )
      call argstr('-GEOM' , gtape ,  'fxgeo.dat', 'fxgeo.dat')
      call argstr('-CTAB' , ctape , ' '   , ' '    )
      call argr4( '-TMUTE', tmute ,    0.0,    0.0 )
      call argr4( '-VMUTE', vmute ,    0.0,    0.0 )
      call argi4( '-MAXAP', nap   ,    0,      0 )
      call argr4( '-LAMBDA', xlam ,    0.0,    0.0 )
c
      verbos = ( argis( '-V' ) .gt. 0 ) .or. ( debug .gt. 0 )
c
c===  sanity checking that is immediately possible
c
      if( vtape .eq. ' ' ) then
         write( LER, * )
     &           ' ***** ERROR: velocity file be specified *****'
         stop 1
      endif
c
      if( gtape .eq. ' '  ) then
         write( LER, * )
     &           ' ***** ERROR: geometry file be specified *****'
         stop 1
      endif
c===
      if( nap_use .le. 0 ) then
         write( LER, * ) ' ***** ERROR: nap must be positive *****'
         stop 1
      endif
c===
      if( dawov .le. 0.0 ) then
         write( LER, * ) ' ***** ERROR: davow must be positive *****'
         stop 1
      endif
c===
      if( (switch .le. 0.0 ) .or. ( switch .gt. 1.0) ) then
         write( LER, * )
     &        ' ***** ERROR: switch must be between 0.0 and 1.0 *****'
         stop 1
      endif
c===
      if( ( base .le. 0.0 ) .or. ( base .gt. 1.0) ) then
         write( LER, * ) 
     &        ' ***** ERROR: base must be between 0.0 and 1.0 *****'
         stop 1
      endif
c===
      if( nspad .lt. 0 ) then
         write( LER, * ) ' ***** ERROR: nspad must not be negative ****'
         stop 1
      endif
c===
c***********************************************************************
      return
      end
c***********************************************************************
