C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c    NAME: fxshelp
c PURPOSE: print out help message
c***********************************************************************
c
      subroutine fxshelp(LER)
c
      implicit none
c
c input parameters:
c
      integer   LER             ! logical unit number, error file

c***********************************************************************
9000  format(/
     &'***************************************************************'/
     & ' FXSMIG performs a pre-stack shot migration.'//
     &'      execute fxsmig by typing fxsmig and the list of program'/
     &'      parameters.  Note that each parameter is proceeded by -a '/
     &'      where "a" is a character(s) corresponding to some '/
     &'      parameter.'/
     &'   Users enter the following parameters, or use default values:'/
     &'***************************************************************'/
     &   ' ', 'FXSMIG COMMAND LINE ARGUMENTS:',
     &        /' ', '  -N[ntape]    - INPUT  DATASET NAME             ',
     &              ' default = stdin',
     &        /' ', '  -O[otape]    - OUTPUT DATASET NAME             ',
     &              ' default = stdout',
     &        /' ', '  -VEL[vtape]  - VELOCITY DATASET NAME           ',
     &              ' none',
     &        /' ', '  -GEOM[gtape] - GEOMETRY DATASET NAME           ',
     &              ' default = fxgeo.dat',
     &        /' ', '  -CTAB[ctape]  - COEFFICIENT TABLE FILE         ',
     &              ' none')
9001  format(
     &         ' ', '  -BR[irec1]   - BEGINNING RECORD                ',
     &              ' default = 1',
     &        /' ', '  -ER[irec2]   - ENDING RECORD                   ',
     &              ' default = NumRec from header',
     &        /' ', '  -IR[increc]  - RECORD INCREMENT                ',
     &              ' default = 1',
     &        /' ', '  -BS[ismp1]   - BEGINNING SAMPLE                ',
     &              ' default = 1',
     &        /' ', '  -ES[ismp2]   - ENDING SAMPLE                   ',
     &              ' default = NumSmp from header',
     &        /' ', '  -PS[nspad]   - PAD SAMPLE                      ',
     &              ' default = 0',
     &        /' ', '  -NXPAD[nxpad]- ZERO TRACES PADDED IN X         ',
     &              ' default = 0')
9002  format(
     &         ' ', '  -NXWIN[nxwin]- WINDOW ABOUT SHOT IN X W/O PAD  ',
     &              ' default = ntrace + 1',
     &        /' ', '  -NXOUT[nxout]- WINDOW ABOUT SHOT IN X, OUTPUT  ',
     &              ' default = nxwin',
     &        /' ', '  -NSYM[nsym]  - SYMMETRIC WINDOW ABOUT SHOT?    ',
     &              ' default = 0 (no) (1=yes)',
     &        /' ', '  -DT[idt]     - DELTA TIME - idt<=32? msec:usec ',
     &              ' default = SmpInt from header',
     &        /' ', '  -f[f1]       - LOW CUTOFF FREQUENCY IN HZ      ',
     &              ' default = 0',
     &        /' ', '  -fc[f2]      - LOW CORNER FREQUENCY IN HZ      ',
     &              ' default = f1',
     &        /' ', '  -FC[f3]      - HI  CORNER FREQUENCY IN HZ      ',
     &              ' default = f4',
     &        /' ', '  -F[f4]       - HI  CUTOFF FREQUENCY IN HZ      ',
     &              ' default = nyquist - dw')
9003  format(
     &         ' ', '  -DX[dx]      - DELTA X                         ',
     &              ' default = use veloc header',
     &        /' ', '  -DZ[dz]      - DELTA Z                         ',
     &              ' default = use veloc header',
     &        /' ', '  -ZMAX[zmax]  - MAXIMUM DEPTH (Z)               ',
     &              ' default = model max Z',
     &        /' ', '  -ZMUL[zmul]  - MULTIPLE FOR DZ GRID            ',
     &              ' default = 1 (model delta Z)'
     &        /' ', '  -NAP[nap]    - NUMBER OF APERTURES TO USE      ',
     &              ' default = 18',
     &        /' ', '  -TMUTE[tmute]- MUTING TIME OFFSET              ',
     &              ' default = 0.0',
     &        /' ', '  -VMUTE[vmute]- MUTING VELOCITY                 ',
     &              ' default = 0.0',
     &        /' ', '  -MAXAP[nap_max]- NUMBER OF APERTURES IN TABLE  ',
     &              ' default = nap',
     &        /' ', '  -LAMBDA[xlam]- MIN NO. OF WAVELENGTHS 1/2 AP   ',
     &              ' default = 0.0',
     &        /' ', '  -V           - VERBOSE PRINTOUT' )
9004  format(
     &'***************************************************************'/
     &' usage:  fxsmig -N[ntape]  -O[otape] -VEL[vtape] -GEOM[gtape] '
     &               ,'-CTAB[ctape]'/
     &'                -BR[irec1] -ER[irec2] -IR[increc]'/
     &'                -BS[ismp1] -ES[ismp2] -PS[nspad]'/
     &'                -NXPAD[nxpad] -NXWIN[nxwin] -NXOUT[nxout] '
     &               ,'-NSYM[nsym]'/
     &'                -DT[idt] -f[f1] -fc[f2] -FC[f3] -F[f4]'/
     &'                -DX[dx] -DZ[dz] -ZMAX[zmax] -ZMUL[zmul]'/
     &'                -NAP[nap]  -TMUTE[tmute] -VMUTE[vmute] '/
     &'                -MAXAP[nap_max] - LAMBDA[xlam]   -V'//
     &'***************************************************************')
9005  format(
     &        /' ', 'The following parameters should only be used by  ',
     &        /' ', 'an experienced user.  Override the defaults for  ',
     &        /' ', 'these parameters at your own risk!'/
     &        /' ', '  -DAWOV[dawov]- DELTA OMEGA OVER V FOR TABLE    ',
     &              ' default = 1.6e-5',
     &        /' ', '  -SW[switch]  - COS(90-DIP)                     ',
     &              ' default = 0.95',
     &        /' ', '  -NKX[nkx]    - NKX FOR OPERATOR DESIGN         ',
     &              ' default = 1024',
     &        /' ', '  -NABS[nabs]  - LENGTH OF ABSORBING BOUNDARY    ',
     &              ' default = 10',
     &        /' ', '  -BASE[base]  - BASE FOR ABSORBING BOUNDARY     ',
     &              ' default = 0.99'/
     &'***************************************************************')
c***********************************************************************
      write( LER, 9000 )
      write( LER, 9001 )
      write( LER, 9002 )
      write( LER, 9003 )
      write( LER, 9004 )
c     write( LER, 9005 )
c***********************************************************************
      return
      end
c***********************************************************************
