C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
      subroutine fxsmove( LER, dzmul, izmul, nshift, nsym, nxc, ntrc
     &    , nxldata, nxrdata, soptnm
     &    , nxout, nxpad, nxv, nzmul, nsta
     &    , vmodel, zsta, ierr, itrc1, itrc2, jz, jzmax, jzmin, nxl, nxr
     &    , nxlout, nxrout, nxuse, nxluse, nxruse, vshot, zshot )
c
      implicit none
c
c input parameters:
c
      integer   LER             ! logical unit number, error file
      real      dzmul           ! delta z * izmul for multigriding
      integer   izmul           ! multiplier for gridding in z dimension
      integer   nshift          ! offset number between station numbers
                                ! and velocity model
      integer   nsta            ! total number of stations in data
      integer   nsym            ! switch for symmetric window
      integer   ntrc            ! number of traces per record in input
      integer   nxc             ! max number of x_s on each side of shot
      integer   nxldata         ! # of traces to left of shot in data
      integer   nxrdata         ! # of traces to right of shot in data
      integer   nxout           ! number of x_s to be used in output
      integer   nxpad           ! # of 0-traces padded in x, each side
      integer   nxv             ! number of x_s in velocity file
      integer   nzmul           ! number of z's for multigriding
      integer   soptnm          ! station number of shot station
      real      vmodel(nxv,*)  ! velocity input data
      real      zsta(nsta)       ! depth at recording stations
c
c output parameters:
c
      integer   idx             ! index check for padding
      integer   ierr            ! error flag
      integer   itrc1           ! first trace to read in input dataset
      integer   itrc2           ! last  trace to read in input dataset
      integer   jz(-nxc:nxc)    ! centered depth index
      integer   jzmax           ! maximum depth index for a shot
      integer   jzmin           ! minimum depth index for a shot
      integer   nxl             ! number of x_s to left of shot
      integer   nxr             ! number of x_s to right of shot
      integer   nxlout          ! # of traces to output on left of shot
      integer   nxrout          ! # of traces to output on right of shot
      integer   nxluse          ! # of traces to use on left of shot
      integer   nxruse          ! # of traces to use on right of shot
      integer   nxuse           ! number of input data traces used
      real      vshot(-nxc:nxc,nzmul)! centered velocity model
      real      zshot(-nxc:nxc) ! centered depths
c
c local variables:
c
      integer   ix              ! x index
      integer   iz              ! depth index for vmodel
c
c***********************************************************************
c
      ierr = 0
c
      nxluse = min0( nxldata, nxc - nxpad )
      nxruse = min0( nxrdata, nxc - nxpad )
      nxlout = min0( nxout/2 , nxluse )
      nxrout = min0( nxout/2 , nxruse )
c
      itrc1 = ntrc/2 - nxluse + 1
      itrc2 = ntrc/2 + nxruse + 1
      nxuse = itrc2 - itrc1 + 1    ! ( = nxluse + nxruse + 1 )
c
c===  get nxl, nxr: symmetric window?
c
      if( nsym .le. 0 ) then
           nxl = nxluse + nxpad
           nxr = nxruse + nxpad
      else
           nxl = nxc
           nxr = nxc
      endif
c
c===  multigrid velocity model, center about shot
c     pad to left and right of nsta
c
      do iz = 1, nzmul
         do ix = -nxl, nxr
            idx = max0( 1, min0( nsta, soptnm - nshift + ix ) )
            vshot(ix,iz) = vmodel(idx, (iz-1)*izmul +1)
         enddo
      enddo
c
c===  center depths about the shot, get jz, the integer depth index
c     pad to left and right of nsta
c     get minimum and maximum jz index for this shot
c
      jzmin = nzmul
      jzmax = 0
      do ix = -nxl, nxr
         idx = max0( 1, min0( nsta, soptnm - nshift + ix ) )
         zshot(ix) = zsta(idx)
         jz(ix) = nint ( zshot(ix) / dzmul )
         jzmin = min0( jzmin, jz(ix) )
         jzmax = max0( jzmax, jz(ix) )
      enddo
c
      if(jzmin .eq. 0) then
         write( LER, * )' ***** DATA ERROR: jzmin can not be 0  ***** '
         ierr = 1
         return
      endif
c
c***********************************************************************
      return
      end
c***********************************************************************

