C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c    NAME: fxsmute
c PURPOSE: fxsmute zeros the input data up to a time equal to:
c
c     trav = sqrt( (x-xs)^2 + (z-zs)^2 ) / vmute + tmute
c
c     where xs and zs are the coordinates of the source and
c     vmute and tmute are input parameters
c
c     note the data has not been transposed yet
c
c***********************************************************************
c
      subroutine fxsmute( nxc, nxluse, nxruse, zshot, mt, dx, dt, vmute
     &                 , tmute, data )
c
      implicit none
c
c input parameters:
c
      real      dt              ! delta t
      real      dx              ! delta x
      integer   mt              ! row dimension of input data (mt = nt+3)
      integer   nxc             ! max number of x's on each side of shot
      integer   nxluse          ! # of traces to use on left of shot
      integer   nxruse          ! # of traces to use on right of shot
      real      tmute           ! muting time offset
      real      vmute           ! muting velocity
      real      zshot(-nxc:nxc) ! centered depths
c
c     modified parameters:
c
      real      data(mt,-nxluse:nxruse) ! input traces
c
c local variables:
c
      real      dist            ! cartesian distance from the shot
      integer   imute           ! sample index to mute to
      integer   ix              ! trace, station index
      real      ttrav           ! time to zero sample
      real      zs              ! depth of the shot
c
c***********************************************************************
      zs    =  zshot(0)
      do ix = -nxluse, nxruse
         dist = sqrt( (dx*ix)**2 + (zshot(ix)-zs)**2 )
         ttrav = abs( dist / vmute ) + tmute
         imute = nint( ttrav / dt )
         if( imute .ne. 0 ) call vclr( data(1,ix) , 1 , imute )
      enddo
c***********************************************************************
      return
      end
c***********************************************************************

