C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c sort the recind's from input order (gitab2) into output order (gitab2)
c using gitab1 as work space
c Mary Ann Thornton           Version 2.0          Date: October 10, 1995
c**********************************************************************c
      subroutine sortab(gitab1,maxtra,gitab2,gicnt,maxgi,
     &                  gi1,gi2,ginc,nrecout,ntrtot)

      integer gi1,gi2,ginc
      integer gitab1(maxtra,2), gitab2(maxtra), gicnt(maxgi)

c     gitab1: 
c          1st dimension holds map of recind's on the input dataset
c          2nd dimension holds trace number (sequential no's, 1->maxtra)
c     gitab2: 
c          On input gitab2 holds map or recinds' of input dataset
c          Move these into 1st dimension of gitab1 and attach a trace no. to it
c          Then use gitab2 to hold the recinds in sorted order
c     gicnt:  The number of traces (live & dead) found for the selected gis
c     ntrtot: maximum number of live traces per record which is determined
c              as the recind's are sorted
c              output records are padded with zero traces if less than 
c              ntrtot gi's are found

      do 500 j=1,maxtra
         gitab1(j,1) = gitab2(j)
         gitab1(j,2) = j
  500 continue
c     knt is a subscript on traces (increments ea. time a desired gi is found)
c     knt_gi is a subscript for gicnt where totals are accumulated for ea. gi
c     num_gi is the number of gis found for a particular RecInd
      knt = 0
      knt_gi = 0
      num_gi = 0
      do 1001 i=gi1,gi2,ginc
         knt_gi = knt_gi + 1
         do 1000 j=1,maxtra
            if(gitab1(j,1).eq.i)then
               num_gi = num_gi + 1
               knt = knt + 1
               gitab2(knt) = gitab1(j,2)
            endif
 1000    continue
         knt_gi = knt_gi + 1
         gicnt(knt_gi) = num_gi
         num_gi = 0
 1001 continue
      ntrtot = 0
      do 1500 i=1,nrecout
         if(gicnt(i).gt.ntrtot)ntrtot = gicnt(i)
 1500 continue
      return
      end
