C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SUBS                                                 *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      SUBS  (NTR,NSAMP,ARRAY1,ARRAY2,ARRAY3)                          *
C  ARGUMENTS:                                                          *
C      NTR     INTEGER  ??IOU*              -                          *
C      NSAMP   INTEGER  ??IOU*              -                          *
C      ARRAY1  REAL     ??IOU*  (NSAMP,NTR) -                          *
C      ARRAY2  REAL     ??IOU*  (NSAMP,NTR) -                          *
C      ARRAY3  REAL     ??IOU*  (NSAMP,NTR) -                          *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/11/10  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/11/10  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VMOV   -                                                        *
C      HILBER -                                                        *
C      VMMA   -                                                        *
C      VSQRT  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
c  dummy subroutine - does precisely nothing
 
c  but it is an example of rearranging a vector in main
c  into a matrix
 
      subroutine subs (ntr, nsamp, vel, outvel, 
     1                 resid, nrec, irec,
     1                 rec, trac, samp, npts, no_seg, 
     1                 rec2, trac2, samp2, npt2, noseg2, 
     1                 ngamma, dgamma, 
     1                 dz, pow, jwinln, vmin, vmax, agrad,
     1                 ks, ke, dk, iord)
 
      parameter (defalt = -999.)
      real      vel(nsamp, ntr)
      real      outvel(nsamp, ntr)
      real      resid(nsamp, ntr)
      real      rec(*), trac(*), samp(*)
      integer   npts(no_seg)
      real      rec2(*), trac2(*), samp2(*)
      integer   npt2(noseg2)
      real      dgamma, dz
      real      ks,ke,dk,igoodk,iks
      real      time, tmp1, tmp2
      pointer   (ptime, time(nsamp,1))
      pointer   (ptime2, time2(nsamp,1))
      pointer   (prms, rms(nsamp,1))
      pointer   (prmsnew, rmsnew(nsamp,1))
      pointer   (prgslwn, rgslwn(nsamp,1))
      pointer   (prms2vel, rms2vel(nsamp,1))
      pointer   (pgrd2vel, grd2vel(nsamp,1))
      pointer   (pslow, slow(nsamp,1))
      pointer   (pz1, z1(1))
      pointer   (pz2, z2(1))
      pointer   (ptmp1, tmp1(1))
      pointer   (ptmp2, tmp2(1))
      pointer   (ptop, top(ntr,1))
      pointer   (pbot, bot(ntr,1))
      pointer   (ptopsm, topsm(ntr,1))
      pointer   (pbotsm, botsm(ntr,1))
      pointer   (pv0, v0(ntr,1))
      pointer   (pvavg, vavg(ntr,1))
      pointer   (pvmed, vmed(ntr,1))
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
c---------------

c compute average slowness grid from velocity field
      call galloc (ptime2, ntr*nsamp*SZSMPD, errcd, abort)
      call galloc (ptime, ntr*nsamp*SZSMPD, errcd, abort)
      call galloc (pslow, ntr*nsamp*SZSMPD, errcd, abort)
      call galloc (prms, ntr*nsamp*SZSMPD, errcd, abort)
      call galloc (prmsnew, ntr*nsamp*SZSMPD, errcd, abort)
      call galloc (prgslwn, ntr*nsamp*SZSMPD, errcd, abort)
      call galloc (prms2vel, ntr*nsamp*SZSMPD, errcd, abort)
      call galloc (pgrd2vel, ntr*nsamp*SZSMPD, errcd, abort)
      timax=0
      dv2tmx=0.
      dv2tmn=10000000000.
      do itr = 1, ntr
         t = 0
         v2t = 0
         do isamp = 1, nsamp
            dt = dz/vel(isamp,itr)
            dv2t = (vel(isamp,itr)**pow)*2*dt
            t = t + 2*dt
            v2t = v2t + dv2t
            rms(isamp,itr)=v2t/t
            time(isamp,itr)=t
            if(t.gt.timax)timax=t
            if(dv2t.gt.dv2tmx)dv2tmx=dv2t
            if(dv2t.lt.dv2tmn)dv2tmn=dv2t
         enddo
      enddo
      nsampt=(timax/dt+1.5)

c interpolate the gammas
      do itr=1,ntr
         do isamp=1,nsamp
            resid(isamp,itr)=defalt
         enddo
         resid(1,itr)=ngamma/2+1
         resid(nsamp,itr)=ngamma/2+1
      enddo

c read picks and put into arrays
      call galloc (ptop, ntr*no_seg*SZSMPD, errcd, abort)
      call galloc (pbot, ntr*no_seg*SZSMPD, errcd, abort)
      call galloc (ptopsm, ntr*no_seg*SZSMPD, errcd, abort)
      call galloc (pbotsm, ntr*no_seg*SZSMPD, errcd, abort)
      call galloc (pv0, ntr*no_seg*SZSMPD, errcd, abort)
      call galloc (pvavg, ntr*no_seg*SZSMPD, errcd, abort)
      call galloc (pvmed, ntr*no_seg*SZSMPD, errcd, abort)
      do iseg=1,no_seg
         do itr=1,ntr
            bot(itr,iseg)=defalt
            top(itr,iseg)=defalt
            botsm(itr,iseg)=defalt
            topsm(itr,iseg)=defalt
            v0(itr,iseg)=defalt
            vavg(itr,iseg)=defalt
         enddo
      enddo
      inpick=0
      do iseg=1,no_seg

         do ipnt=1,npts(iseg)
            inpick=inpick+1
            inpck2=0
            do i2=1,iseg-1
               inpck2=inpck2+npt2(i2)
            enddo
            do j2=1,npt2(iseg)
               inpck2=inpck2+1
               if(nint(trac(inpick)).eq.nint(trac2(inpck2)))then

                   isamp=nint(samp(inpick))
                   if(isamp.lt.1.or.isamp.gt.nsamp)isamp=nsamp
                   jgam=nint(samp2(inpck2))
                   if(jgam.lt.1.or.jgam.gt.ngamma)jgam=ngamma/2+1
                   itrace=nint(trac(inpick))
                   if(itrace.ge.1.and.itrace.le.ntr)then
                      resid(isamp,itrace)=jgam
                      bot(itrace,iseg)=isamp
                   endif

               endif
            enddo
         enddo

      enddo

c find the top of each layer
      do iseg=1,no_seg
         do itr=1,ntr
            if(bot(itr,iseg).ne.defalt)then
               ibot=bot(itr,iseg)
               top(itr,iseg)=1
               do isamp=ibot-1,1,-1
                  if(resid(isamp,itr).ne.defalt)then
                     top(itr,iseg)=isamp
                     goto 1
                  endif
               enddo
 1             continue
            endif
         enddo
      enddo

      do itr=1,ntr
         call intrp ( resid(1,itr), nsamp, defalt )
      enddo

      do itr=1,ntr
         do isamp=1,nsamp
            if(resid(isamp,itr).eq.defalt)resid(isamp,itr)=ngamma/2+1
         enddo
      enddo

c compute new rms velocities based on picked gamma
      do itr = 1, ntr
         do isamp = 1, nsamp
            gam=resid(isamp,itr)
            gamma=1.+(gam-ngamma/2-1)*dgamma
            rmsnew(isamp,itr)=rms(isamp,itr)/(gamma**pow)
         enddo
      enddo

c compute array of new depths based on old
      call galloc (pz1, nsamp*SZSMPD, errcd, abort)
      call galloc (pz2, nsamp*SZSMPD, errcd, abort)
      call galloc (ptmp1, nsamp*SZSMPD, errcd, abort)
      call galloc (ptmp2, 4*nsamp*SZSMPD, errcd, abort)
      do isamp = 1, nsamp
         z2(isamp) = isamp*dz
      enddo

c create interval slownesses
      init=1
      do itr = 1, ntr
         slow(1,itr)=1.0/(rmsnew(1,itr)**(1./pow))
         z1(1)=.5*time(1,itr)/slow(1,itr)
         do isamp = 2, nsamp
c make big window to smooth rms velocities
            sum=0.
            icnt=0
            do iwin = 1, jwinln
               if(isamp-iwin.ge.1)then
                  dt=time(isamp,itr)-time(isamp-iwin,itr)
                  test=(rmsnew(isamp,itr)*time(isamp,itr)-
     &                  rmsnew(isamp-iwin,itr)*time(isamp-iwin,itr))/dt
                  if(test.gt.0)then
                     test=test**(1.0/pow)
                  endif
                  if(test.lt.vmin)then
                     sum=sum+vmin
                     icnt=icnt+1
                  else if(test.gt.vmax)then
                     sum=sum+vmax
                     icnt=icnt+1
                  else
                     sum=sum+test
                     icnt=icnt+1
                  endif
               endif
            enddo
            dt=time(isamp,itr)-time(isamp-1,itr)
            slow(isamp,itr)=1.0/(sum/icnt)
            z1(isamp)=z1(isamp-1)+.5*dt/slow(isamp,itr)
         enddo

c interpolate interval slowness to regular spacing
         call cuint (z1(1),slow(1,itr),nsamp,
     &               z2(1),rgslwn(1,itr),nsamp,
     &               tmp1(1),tmp2(1),init)
      enddo

c convert slowness to interval velocities and save in resid and vel.
      timax2=0.
      do itr = 1, ntr
         t=0
         do isamp = 1, nsamp
            dt=dz*rgslwn(isamp,itr)
            t=t+2.*dt
            if(t.gt.timax2)timax2=t
            time2(isamp,itr)=t

            rms2vel(isamp,itr)=1.0/rgslwn(isamp,itr)
            grd2vel(isamp,itr)=defalt
         enddo
      enddo

c compute new depths for tops and bottoms
      do iseg=1,no_seg
         do itr=1,ntr
            if(bot(itr,iseg).ne.defalt)then
               ibot=bot(itr,iseg)
               bottm=time(ibot,itr)
               do isamp=1,nsamp
                  if(isamp.ge.1.and.isamp.le.nsamp)then
                     if(bottm.lt.time2(isamp,itr))goto 10
                     ibot=isamp
                  endif
               enddo
   10          continue
               bot(itr,iseg)=ibot

               itop=top(itr,iseg)
               toptm=time(itop,itr)
               do isamp=1,nsamp
                  if(isamp.ge.1.and.isamp.le.nsamp)then
                     if(toptm.lt.time2(isamp,itr))goto 20
                     itop=isamp
                  endif
               enddo
   20          continue
               top(itr,iseg)=itop
            endif
         enddo
      enddo


c compute average velocity in layer.
      do iseg=1,no_seg
         itrs=0
         itre=0
         do itr=1,ntr
            ibot=bot(itr,iseg)
            itop=top(itr,iseg)
            vavg(itr,iseg)=0.
            icnt=0
            if(bot(itr,iseg).ne.defalt)then
               do isamp=itop,ibot
                  if(isamp.ge.1.and.isamp.le.nsamp)then
                     vavg(itr,iseg)=vavg(itr,iseg)+rms2vel(isamp,itr)
                     icnt=icnt+1
                     itre=itr
                     if(itrs.eq.0)itrs=itr
                  endif
               enddo
            endif
            if(icnt.gt.0)then
               vavg(itr,iseg)=vavg(itr,iseg)/icnt
            else
               vavg(itr,iseg)=defalt
            endif
         enddo

c compute v0s with all k's and keep the one with the smallest
c standard deviation.
         stdev=999999999999999.
         igoodk=0.
         do iks=ks,ke,dk
            vsum=0
            icnt=0
            do itr=itrs,itre
               if(bot(itr,iseg).ne.defalt)then
                  isamp=bot(itr,iseg)+.5
                  x=iks*(exp(iks*time2(isamp,itr)*.5)-1.)
                  if(x.eq.0.)then
                     v0(itr,iseg)=vavg(itr,iseg)
                  else
                     v0(itr,iseg)=(isamp*dz)/x
                  endif
                  vsum=vsum+v0(itr,iseg)
                  icnt=icnt+1
               endif
            enddo
            if(icnt.ne.0)then
               vsum=vsum/icnt
               test=0
               itcnt=0
               do itr=itrs,itre
                  if(bot(itr,iseg).ne.defalt)then
                     if((v0(itr,iseg).gt.vmin).and.
     &                  (v0(itr,iseg).lt.vmax))then
                           test=test+
     &                        (v0(itr,iseg)-vsum)*(v0(itr,iseg)-vsum)
                        itcnt=itcnt+1
                     endif
                  endif
               enddo
               if(itcnt.ne.0)then
                  test=test/itcnt
                  if(test.lt.stdev)then
                     igoodk=iks
                     stdev=test
                  endif
               endif
            endif
         enddo

c compute the array of the best v0's
         do itr=itrs,itre
            if(bot(itr,iseg).ne.defalt)then
               isamp=bot(itr,iseg)+.5
               x=igoodk*(exp(igoodk*time2(isamp,itr)*.5)-1.)
               if(x.eq.0.)then
                  v0(itr,iseg)=vavg(itr,iseg)
               else
                  v0(itr,iseg)=(isamp*dz)/x
               endif
            endif
         enddo

c fit a line to the best gradient.
         n=itre-itrs+1

         call vmov(v0(itrs,iseg),1,vmed(itrs,iseg),1,n)
         call intrp (vmed(itrs,iseg),n,defalt)
         if(iord.gt.0)
     &      call fspline(vmed(itrs,iseg),n,iord)

c        call intrp (vavg(itrs,iseg),n,defalt)
c        if(iord.gt.0)
c    &      call fspline(vavg(itrs,iseg),n,iord)

         avg1=0
         icnt=0
         do itr=itrs,itre
            if(vavg(itr,iseg).ne.defalt)then
               avg1=avg1+vavg(itr,iseg)
               icnt=icnt+1
            endif
         enddo
         if(icnt.ne.0)then
            avg1=avg1/icnt
         else
            avg1=1.
         endif

         call vmov(top(1,iseg),1,topsm(1,iseg),1,ntr)
         call intrp (topsm(itrs,iseg),n,defalt)
         if(iord.gt.0)
     &      call fspline(topsm(itrs,iseg),n,iord)

         call vmov(bot(1,iseg),1,botsm(1,iseg),1,ntr)
         call intrp (botsm(itrs,iseg),n,defalt)
         if(iord.gt.0)
     &      call fspline(botsm(itrs,iseg),n,iord)

c compute the new interval velocities
         avg2=0
         icnt=0
         do itr=itrs,itre
            ibot=botsm(itr,iseg)
            itop=topsm(itr,iseg)
            v=vmed(itr,iseg)
            grad=igoodk
            if(bot(itr,iseg).ne.defalt)then
               do isamp=itop,ibot
                  if(isamp.ge.1.and.isamp.le.nsamp)then
                     grd2vel(isamp,itr)=v+grad*dz*(isamp-1)
                     avg2=avg2+grd2vel(isamp,itr)
                     icnt=icnt+1
                  endif
               enddo
            endif
         enddo

         if(icnt.ne.0)then
            avg2=avg2/icnt
         else
            avg2=1.
         endif

         do itr=itrs,itre
            ibot=botsm(itr,iseg)
            itop=topsm(itr,iseg)
               do isamp=itop,ibot
                  if(isamp.ge.1.and.isamp.le.nsamp)then
                     grd2vel(isamp,itr)=avg1*
     &                  grd2vel(isamp,itr)/avg2
                     if(grd2vel(isamp,itr).lt.vmin)
     &                  grd2vel(isamp,itr)=defalt
                     if(grd2vel(isamp,itr).gt.vmax)
     &                  grd2vel(isamp,itr)=defalt
                  endif
               enddo
         enddo
      enddo

c weigh the dix and the gradient inversion
      b=1-agrad
      do itr = 1, ntr
         call intrp(grd2vel(1,itr),nsamp,defalt)
         maxbot=1
         do iseg=1,no_seg
           maxbot=max(maxbot,ifix(topsm(itr,iseg)))
         enddo
         maxbot=min(maxbot,nsamp)
         do isamp=1,maxbot
            if(grd2vel(isamp,itr).eq.defalt)
     &         grd2vel(isamp,itr)=rms2vel(isamp,itr)
            outvel(isamp,itr)=agrad*grd2vel(isamp,itr)+
     &         b*rms2vel(isamp,itr)
         enddo
         do isamp=maxbot+1,nsamp
            outvel(isamp,itr)=vel(isamp,itr)
         enddo
      enddo

      return
      end

      subroutine lsqrtr(y,n,defalt)
      dimension y(n)
      real*8 sumx,sumy,sumxy,sumxx,del,slope,yint
      sumx=0
      sumy=0
      sumxy=0
      sumxx=0
      icnt=0
      do i=1,n
         if(y(i).ne.defalt)then
            sumx=sumx+((i-1))
            sumy=sumy+y(i)
            sumxy=sumxy+((i-1)*y(i))
            sumxx=sumxx+((i-1)*(i-1))
            icnt=icnt+1
         endif
      enddo
      del=(icnt*sumxx)-(sumx*sumx)
      if (del .ne. 0.) then
         slope = ((icnt*sumxy) - (sumy*sumx)) / del
         yint  = ((sumy*sumxx) - (sumxy*sumx)) / del
         do i=1,n
            y(i)=yint+((i-1)*slope)
         enddo
      endif
      return
      end
c      subroutine fspline(array,npts,order)
c      integer order
c      real array(npts)
c      parameter (point=2)
c      real curve (point, npts)
c      pointer (pcurve, curve)
c#include <f77/iounit.h>
c#include <f77/lhdrsz.h>
c      call galloc (pcurve, 2*npts*SZSMPD, errcd, abort)
c      do i=1,npts
c         curve(1,i)=i
c         curve(2,i)=array(i)
c      enddo
c      call bspline(curve, npnts, order)
c      do i=1,npts
c         array(i)=curve(2,i)
c      enddo
c      call gfree (pcurve)
c      return
c      end
