C***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  Routine:  hdrext.F                                                  *
C  Purpose:  hdrext will create a plane of data containing a user spec-*
C            ified keyword from each trace of each record coming in.   *
C            The plane will be converted to floating point numbers     *
C            and written on a seismic tape.                            *
c                                                                      *
C  Author:   Mary Ann Thornton    V: 1.0                     10/21/94  *
C***********************************************************************
C***********************************************************************
c**********************************************************************c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
      integer   lhed (SZLNHD)
      integer*2 itr  (SZLNHD)
      real      head (SZLNHD)

      integer   nsamp, nsi, ntrc, nrec, iform, obytes
      integer   luin , luout, lbytes, nbytes, lbyout
      integer   irs,ire,ns,ne
c------
      real      plane(SZLNHD)
      character ntap * 100, otap * 100, name*6, version*4
      character keyword*6
      logical   verbos, hlp, query
      integer   argis
c-----
      equivalence (itr(1), lhed(1), head(1))

      data lbytes /0/, nbytes/0/, name/'HDREXT'/, version /' 1.0'/ 
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query.or.hlp )then
            call help()
            stop
      endif
c-----
#include <f77/mbsopen.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,keyword,verbos)
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'HDREXT: no header read from unit ',luin
         write(LOT,*)'JOB TERMINATED'
         stop
      endif
c------
c-----
c     specify which traceheader word we want to extract
c     key will contain the index of the value of the keyword
c     len_key is the length of the keyword

      call savelu(keyword,ifmt,key,len_key,TRACEHEADER)

c----------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
c------
      call hlhprt (itr, lbytes, name, 6, LERR)
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c-----
c     records out = 1; traces out = no. records in;
c     samples out = no. traces in;
      nrecc = 1
      ntrcc = nrec
      nsampc = ntrc
      call savew(itr, 'NumRec', nrecc,  LINHED)
      call savew(itr, 'NumTrc', ntrcc,  LINHED)
      call savew(itr, 'NumSmp', nsampc, LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsampc * SZSMPD
 
c----------------------
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )
 
c-----
      if(verbos) then
         call verbal(nsamp, nsi, ntrc, nrec, iform,
     &               irs,ire,ns,ne,
     &               ntap,otap,keyword,nrecc,ntrcc,nsampc)
      endif
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
c--------------------------------------------------
c--------------------------------------------------
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c-----
c--------------------------------------------------
c--------------------------------------------------
c--------------------------------------------------
      irec = 0
      call recskp(1,irs-1,luin,ntrc,itr)
      do 1000 jj = irs, ire
         irec = irec + 1
         call trcskp(jj,1,ns-1,luin,ntrc,itr)
         la = 1
         do 1001 nn = ns,ne
            nbytes = 0
            call rtape(luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)' rec= ',jj,'  trace= ',nn
               go to 999
            endif
            plane(la) = float(itr(key))
            la = la +1
 1001    continue
         call vmov(plane,1,lhed(ITHWP1),1,nsampc)
         call savew(itr, 'RecNum',    1,  TRACEHEADER)
         call savew(itr, 'TrcNum', irec,  TRACEHEADER)
         call wrtape(luout, itr, obytes)
         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
 1000 continue
 
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of hdrext, processed',nrec,' record(s)',
     :             ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)'hdrext reads a USP dataset and extracts the '
        write(LER,*)'user-specified keyword value from the trace '
        write(LER,*)'header, and outputs a plane of the keyword '
        write(LER,*)'values'
#ifdef CRAYSYSTEM
        write(LER,*)'See manual pages by typing: tman hdrext '
#else
        write(LER,*)'See manual pages by typing: man hdrext ',
     &              'or:   mman hdrext'
#endif
        write(LER,*)'See pattern file by typing:   catpat hdrext'
        write(LER,*)'Build an executable script by typing: ',
     &              '     catpat hdrext > hdrext.job'
        write(LER,*)'Execute hdrext by typing hdrext and the ',
     &              'program parameters.'
        write(LER,*)'Note that each parameter is proceeded by -a ',
     &              'where "a" is a character(s) corresponding ',
     &              'to some parameter.'
        write(LER,*)'Users enter the following parameters, or use ',
     &              'the default values.'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   : input dataset'    
        write(LER,*)'-O[otap]   : output dataset'  
        write(LER,*)'-ns[ns]    : start trace number       (default=1)'    
        write(LER,*)'-ne[ne]    : end trace number       (default=all)'
        write(LER,*)'-rs[irs]   : start record number      (default=1)'
        write(LER,*)'-re[ire]   : end record number      (default=all)'
        write(LER,*)'-key[word] : the keyword to extract  (No default)'
        write(LER,*)'-V         : for verbose printout'
        write(LER,*)' '
        write(LER,*)'usage:  '
        write(LER,*)'hdrext -N[ntap] -O[otap]'
        write(LER,*)'        -ns[ns] -ne[ne] -rs[irs] -re[ire]'
        write(LER,*)'        -key[word] [-V] '
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,keyword,verbos)
c-----
c     get command arguments
c
c     ntap    - C*100     input file name velocity
c     otap    - C*100     output file name
c     ns      - int       starting trace index
c     ne      - int       ending trace index
c     irs     - int       starting record index
c     ire     - int       ending record index
c     keyword - C*6       keyword to be extracted
c     verbos  - L         verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), keyword*(*)
      integer     ns, ne, irs, ire
      logical     verbos
      integer     argis
 
c-------
       call argstr('-N', ntap, ' ', ' ')
       call argstr('-O', otap, ' ', ' ')
       call argi4 ('-ns', ns ,1   ,   1)
       call argi4 ('-ne', ne ,0   ,   0)
       call argi4 ('-rs', irs,1   ,   1)
       call argi4 ('-re', ire,0   ,   0)
       call argstr('-key',keyword ,'      ','      ')
       verbos =   (argis('-V') .gt. 0)
c-------

      return
      end
 
C***********************************************************************
C***********************************************************************
C***********************************************************************
C***********************************************************************

      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     &               irs,ire,ns,ne,
     &               ntap,otap,keyword,nrecc,ntrcc,nsampc)
c-----
c     nsamp - I*4     number input samples in trace
c     nsampc - I*4     number output samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     input traces per record
c     ntrcc - I*4     output traces per record
c     nrec  - I*4     input number of records per line
c     nrecc - I*4     output number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c     ns    - Int     starting record
c     ne    - Int     ending record
c     irs   - Int     starting trace
c     ire   - Int     ending trace
c     keyword- C*6    keyword to extract
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec,ns,ne,irs,ire
      integer     nsampc, ntrcc, nrecc
      character   ntap*100, otap*100, keyword*6
 
      write(LERR,*)' '
      write(LERR,*)' line header values after default check '
      write(LERR,*)' # of samples/trace input    =  ', nsamp
      write(LERR,*)' sample interval             =  ', nsi
      write(LERR,*)' traces per record input     =  ', ntrc
      write(LERR,*)' records per line input      =  ', nrec
      write(LERR,*)' format of data              =  ', iform
      write(LERR,*)' input dataset               =  ', ntap
      write(LERR,*)' output dataset              =  ', otap
      write(LERR,*)' starting record             =  ', irs
      write(LERR,*)' ending record               =  ', ire
      write(LERR,*)' starting trace              =  ', ns
      write(LERR,*)' ending trace                =  ', ne
      write(LERR,*)' keyword to extract          =  ', keyword
      write(LERR,*)' '
      write(LERR,*)' # of samples/trace output   =  ', nsampc
      write(LERR,*)' traces per record output    =  ', ntrcc
      write(LERR,*)' records on output           =  ', nrecc
 
      return
      end
 
