C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c...|....1....|....2....|....3....|....4....|....5....|....6....|....7..
c*********************************************************************
c
c    Subrouine histlim  
c   
c      This subroutine determins the amplitude values that bracket a 
c      the central "scal" fraction of samples of a data volume. The
c      input array is assumed to be a histogram of the data volume.
c      First, calulate the number of samples to reject at the top and
c      bottom of the amplitude range. Then starting at the bottom and
c      top of the histogram, accumulate samples until the number of
c      samples to be rejected has been reached. Use these positions 
c      to determin the mapping limits to pass back to main.
c      
c      An alternate approach might be to locate the peak position in 
c      the histogram and march away from this peak position (in both 
c      directions simultaneously) accumulating the number of samples 
c      in each histogram bucket as you go. Upon accumulating the
c      desired % of the samples, the locations within the histogram 
c      is translated into mapping limits to pass back to main.
c
c*********************************************************************
 
      subroutine histlim (hstogrm, hstnm, scal, vmin, vmax,
     1                    nsamp, ntrcout, nrecout)
 
      integer     hstnm, nsamp, ntrcout, nrecout
      real        vmin, vmax, scal
      real        hstogrm(hstnm)

      integer     samps, count, mapmin, mapmax
c      integer     hstmax
      real        ampmin, ampmax
 
c-----
c
c    Calculate the number of samples reject on each end of the range
c
      samps = int( float(nsamp*ntrcout*nrecout) * (1.0-scal)/2. )
      if (samps .lt.0) samps = 0
c
c-----

c-----
c
c    detrmine the histogram location of the lower mapping limit
c
      count = 0
      do 1000, i = 0, hstnm
        if (count .lt. samps) then
          count = count + int(hstogrm(i))
          mapmin = i
        endif
 1000 continue

c
c-----

c-----
c
c    detrmine the histogram location of the upper mapping limit
c
      count = 0
      do 1001, i = hstnm,0,-1
        if (count .lt. samps) then
          count = count + int(hstogrm(i))
          mapmax = i
        endif
 1001 continue

c
c-----

c-----
c
c    Alternate method of using the central -scal fraction of samples
c
c    find the max value on the histogram
c
c        do i = 1,hstnm
c           if (histogrm(i) .gt. hstmax) hstmax = i
c        enddo
c
c        samps  = int(nsamp*ntrcout*nrecout*scal)
c        mapmin = hstmax
c        mapmax = hstmax
c        count  = hstogrm(hstmax)
c
c        do while (count .lt. samps)
c
c            mapmin = mapmin - 1
c            mapmax = mapmax + 1
c
c            if (mapmin .ge. 1) then
c               count = count + int(hstogrm(mapmin))
c            endif
c
c            if (mapmax .le. hstnm) then
c               count = count + int(hstogrm(mapmax))
c            endif
c
c        enddo
c
c-----

c-----
c
c    Translate mapmin and mapmax into amplitude values on the
c    input dataset
c
      ampmin = vmin + (mapmin * (vmax-vmin) / (hstnm-1))
      ampmax = vmin + (mapmax * (vmax-vmin) / (hstnm-1))

      vmin = ampmin
      vmax = ampmax

c-----
c    ALL DONE
c-----
 
      return
      end
