C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*********************************************************************
c
c    Subrouine lineco  
c   
c      given amplitude limits of input and output volumes, determin
c      the scalar and bias coefficients that will linearly map the
c      input amplitude range and the desired output amplitude range.
c
c*********************************************************************
 
      subroutine lineco (a_min,a_max,b_min,b_max,scalar,bias,lbias)
 
      real        a_min, a_max, b_min, b_max, scalar, bias
      logical     lbias
 
c-----
c
c    Calculate line parameters scale and bias
c
      if (lbias) then

         scalar = (b_max - b_min) / (a_max - a_min)
         bias   = b_max - scalar*a_max
 
      else
 
         bias = 0.
         if (abs(a_min) .ge. abs(a_max)) then
            scalar = b_min/a_min
         else
            scalar = b_max/a_max
         endif
 
      endif

c
c-----
 
      return
      end
