C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C----------------------------------------------------------------------
C   PROGRAM IANGLE
C
C
c-----------------------------------------------------------------------
c
#include  <save_defs.h>
#include  <localsys.h>
#include  <f77/iounit.h>
#include  <f77/lhdrsz.h>
#include  <f77/sisdef.h>
c-----------------------------------------------------------------------
c
c
      real    * 4 u1,u2,uout
      pointer (u1adr,u1(1:3001,1))
      pointer (u2adr,u2(1:3001,1))
      pointer (uoutadr,uout(1:3001,1))
c
      integer * 4 istatic1( 3001 ), istatic2( 3001 )
      integer * 4 itr ( 6128 ), iheadr(128 , 3001  )
c
      character   ntap1*120, ntap2*120, otap*120, name*5
c
#include  <f77/pid.h>
c
      logical verbos, query
      integer argis
c
      DATA pi / 3.141592 /
      DATA name /'IANGLE' /
      data iabort / 0 /
C-----------------------------------------------------------------------
#include <f77/open.h>
C
C      get online help
C
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
            call help()
            stop
      end if
C
      call gcmdln (ntap1, ntap2, otap, ns, ne, irs, ire, ampmin,verbos)
c
c     get logical unit numbers for input and output
c
      call getln (luin1,  ntap1, 'r', 0 )
      call getln (luin2,  ntap2, 'r', 0 )
      call getln (luout, otap, 'w', 1 )
c-----------------------------------------------------------------------
C
C      read lineheader and save key values
C
      lbytes1 = 0
      call rtape4 ( luin1, itr, lbyte1, lbytes1 )
      if (lbytes1 .eq. 0) then
            write(LOT, *)'DATUM: no header read from unit ', luin1
            write(LOT, *)'FATAL'
            stop
      endif
#include <f77/saveh.h>
      call saver(itr, 'NumSmp', nsamp1, LINHED)
      call saver(itr, 'SmpInt', nsi1  , LINHED)
      call saver(itr, 'NumTrc', ntrc1 , LINHED)
      call saver(itr, 'NumRec', nrec1 , LINHED)
      call saver(itr, 'Format', iform1, LINHED)

      lbytes2 = 0
      call rtape4 ( luin2, itr, lbyte2, lbytes2 )
      if (lbytes2 .eq. 0) then
            write(LOT, *)'DATUM: no header read from unit ', luin2
            write(LOT, *)'FATAL'
            stop
      endif
      call saver(itr, 'NumSmp', nsamp2, LINHED)
      call saver(itr, 'SmpInt', nsi2  , LINHED)
      call saver(itr, 'NumTrc', ntrc2 , LINHED)
      call saver(itr, 'NumRec', nrec2 , LINHED)
      call saver(itr, 'Format', iform2, LINHED)
c
C-----------------------------------------------------------------------
c     build pointers to selected trace headers
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TRACEHEADER)
      call savelu('DePtEl',ifmt_DePtEl,l_DePtEl,ln_DePtEl,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
C-----------------------------------------------------------------------
C
C      verify command line parameters
C
       call cmdchk ( ns, ne, irs, ire, ntrc2, nrec2 )
C-----------------------------------------------------------------------
C
C      modify lineheader to agree with command line arguments
C
      nrecc = ire -irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      ntrace = ne - ns + 1
      call savew(itr, 'NumTrc', ntrace,   LINHED)
      call savhlh(itr, lbyte2, lbyout )
      CALL WRTAPE ( LUOUT, ITR, lbyout                      )
c-----------------------------------------------------------------------
c     set general parameters
c
      if (nsi2 .le. 32) then
         dt = real (nsi2) /1000.
      else
         dt = real (nsi2) /1000000.
      endif
c
      tmax = dt * float( nsamp2 - 1 )
      scale = 1.0 / dt
c
c
C-----------------------------------------------------------------------
C
C      verbose listing of parameters
C
      if (verbos) then
        call verbal
     :   (nsamp,nsi,ntrc,nrec,iform,ntap1,ntap2,otap, ampmin)
      end if
c-----------------------------------------------------------------------
c
c      get array space
 
      ispace = 3001*ntrace*SZSMPD
      call galloc(u1adr,ispace,ierr,iabort)
      if (ierr .ne. 0) then
        write(ler,10) ispace
        stop
      endif
        write(lerr,*) 'Mem Alloc. on u1adr', ispace
 
      ispace = 3001*ntrace*SZSMPD
      call galloc(u2adr,ispace,ierr,iabort)
      if (ierr .ne. 0) then
        write(ler,10) ispace
        stop
      endif
        write(lerr,*) 'Mem Alloc. on u2adr', ispace
 
      ispace = 3001*ntrace*SZSMPD
      call galloc(uoutadr,ispace,ierr,iabort)
      if (ierr .ne. 0) then
        write(ler,10) ispace
        stop
      endif
        write(lerr,*) 'Mem Alloc. on uoutadr', ispace

   10 format(' DATUM: memory allocation failed: attempted to get ',
     1     i7,' bytes ',/,' FATAL')

C-----------------------------------------------------------------------
C       skip unwanted records
C
      call skprec(1, irs-1, luin1, ntrc2, itr, lbytes1, nsamp2, iform2 )
      call skprec(1, irs-1, luin2, ntrc2, itr, lbytes2, nsamp2, iform2 )
C-----------------------------------------------------------------------
C
C-----Loop over Records
C
      do 450 irec = irs, ire
        write (lerr,*) ' PROCESSING RECORD' ,IREC
        write (ler,*)  ' PROCESSING RECORD' ,IREC
C
C       Initialize Output Array udt.
C
          do 160 jxii = 1,ntrace
            do 158 ii = 1, nsamp2
                  uout(ii,jxii) = 0.0
158            continue
160       continue
          distmin = +999999999.0
C
C       Read Record into 2D array and get trace header info
C
        do 460 jx = ns,ne
C
C         READ A TRACE.
C
          nbytes1 = 0
          CALL RTAPE ( LUIN1, ITR, nbytes1 )
          if (nbytes1 .le. 0 ) then
             write(LER,*) 'read EOF on record',jxii
             write(LER,*) 'terminating job'
             go to 9999
          end if
          call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  istatic1(jx), TRACEHEADER)
c
         if (istatic1(jx)  .ne. 30000 ) then
            call vmov(itr(ITHWP1),1,u1(1,jx),1,nsamp1)
            call checka ( nsamp1, u1(1,jx) )
         endif


          nbytes2 = 0
          CALL RTAPE ( LUIN2, ITR, nbytes2 )
          if (nbytes2 .le. 0 ) then
             write(LER,*) 'read EOF on record',jxii
             write(LER,*) 'terminating job'
             go to 9999
          end if

          call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  istatic2(jx), TRACEHEADER)
          
          call vmov( itr, 1, iheadr(1,jx), 1, SZTRHD )
c
         if (istatic2(jx)  .ne. 30000 ) then
            call vmov(itr(ITHWP1),1,u2(1,jx),1,nsamp2)
            call checka ( nsamp1, u2(1,jx) )
         endif

460   continue
c
      do 470 jx = ns,ne
          
          do 350 jt = 1,nsamp2
            if( abs( u1(jt,jx) ) .ge. abs( ampmin ) ) then
              uout(jt,jx) = (abs((u2(jt,jx) / u1(jt,jx)))) ** 0.25 
            else
              uout(jt,jx) = 0.0
            endif

            if( abs( uout(jt,jx) ) .le. 1.0 ) then
               uout(jt,jx) = (180./pi) * acos (uout(jt,jx))
            else
                uout(jt,jx)=90.0
            endif
         
350       continue
470   continue
C-----------------------------------------------------------------------
C
C
C       APPEND TRACE HEADERS AND WRITE OUT AN EXTRAPOLATED RECORD
C
        DO 540 JXI = 1,NTRACE
           call vmov( iheadr(1,jxi), 1, itr, 1, SZTRHD )
           call vmov( uout(1,jxi), 1, itr(ITHWP1), 1, nsamp2 )
           call wrtape( luout, ITR, nbytes2 )
540     CONTINUE
C
450   CONTINUE
9999  continue
      CALL LBCLOS(LUIN1)
      CALL LBCLOS(LUIN2)
      CALL LBCLOS(LUOUT)
      STOP
      END
C***********************************************************************
c
      SUBROUTINE CHECKA ( NX  , X )
      REAL    * 4 X ( * ), XMAX, XMIN
      INTEGER * 4 NX
      DATA  XMAX  ,   XMIN / 1.0e+15, 1.0e-15/
C                                                                   C
      DO 10 I = 1, NX
        IF (ABS ( X (I) ) .LT. XMIN       ) THEN
            X ( I ) = 0.0
        ENDIF
        IF (ABS ( X (I) ) .GT. XMAX       ) THEN
            X ( I ) = 0.0
        ENDIF
10      continue
      RETURN
      END
c-----------------------------------------------------------------------
      subroutine help
#include <f77/iounit.h>
 
      write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'iangle - calculate incident angles from avomig output'
      write(LER,*)
      write(LER,*)
     :'execute iangle by typing iangle followed by command line',
     :' parameters.'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)
        write(LER,*)
     :' -N1 [ntap1]        (none) : Amplitude gathers'
        write(LER,*)
     :' -N2 [ntap2]        (none) : {Amplitude* cos(angle)}**4} gathers'
        write(LER,*)
     :' -O [otap]          (none) : output data file name'
       write(LER,*)
     :' -ns[ns]            (first : start trace number'
       write(LER,*)
     :' -ne[ne]            (last) : end trace number'
       write(LER,*)
     :' -rs[irs]           (first : start record number'
       write(LER,*)
     :' -re[ire]           (last) : end record number'
       write(LER,*)
     :' -ampmin[ampmin]    (none) : min. amplitude for analysis'
       write(LER,*)
     :' -V                      : -V to get additional printout.'
       write(LER,*)
     :' -?                      : enter -? to get online help.'
        write(LER,*)
        write(LER,*)
     :'usage:   iangle -N1[ntap1] -N2[ntap1] -O[otap]  '
        write(LER,*)
     :'-ns[ns] -ne[ne] -rs[irs] -re[ire] -ampmin[ampmin] -V -?'
        write(LER,*)
     :'***************************************************************'
      return
 
      end
 
C***********************************************************************
      subroutine gcmdln 
     :      (ntap1, ntap2, otap, ns, ne, irs, ire, ampmin,verbos)
c-----
#include <f77/iounit.h>
      character ntap1*(*), ntap2*(*), otap*(*)
      integer *4 ns, ne, irs, ire
      logical verbos
      integer argis
 
            call argstr( '-N1', ntap1, ' ', ' ' )
            call argstr( '-N2', ntap2, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argr4('-ampmin', ampmin, 1E-20, 1E-20)
            verbos = ( argis( '-V' ) .gt. 0 )
c
      return
      end
C***********************************************************************
c
        subroutine verbal
     :   (nsamp,nsi,ntrc,nrec,iform,ntap1,ntap2,otap, ampmin)
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, iform
      character ntap1*(*), ntap2*(*), otap*(*)
      logical shot, post, down
 
            write(LERR ,*)' '
            write(LERR ,*)' line header values after default check '
            write(LERR, *) ' # of samples/trace =  ', nsamp
            write(LERR ,*) ' sample interval    =  ', nsi
            write(LERR ,*) ' traces per record  =  ', ntrc
            write(LERR, *) ' records per line   =  ', nrec
            write(LERR ,*) ' format of data     =  ', iform
            write(LERR ,*) ' input amplitude    =  ', ntap1
            write(LERR ,*) ' input amp*cos      =  ', ntap2
            write(LERR ,*) ' output data set    =  ', otap
            write(LERR ,*)' '
            write(LERR ,*)' Program Run Parameters '
            write(LERR, *) ' Analysis Min Am    =  ', ampmin
            write(LERR ,*)' '
 
      return
      end
