C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln (card,tend,tpad0,tbeg,dtms,tmute,f1,f2,f3,f4,
     1           zmax,dztap,zfrst,z2nd,dx,itrbeg,itrend,nx,emerg,dipmax,
     2           xbegin,nabot,dzout,dtmig,nrinc,ismoo,istrid,
     3           dtsec,imute,itbeg,lucrd,isi,ntr,nrec,nsamp,
     4           nzbig,napmx,natop,strch,dztemp,input)

c    read in migration parameters via Whitmore card deck or command line
c    arguments

#include <f77/iounit.h>

      real       tend,tpad0,tbeg,dtms,tmute,fmin,fmax,dzout,dtmig
      real       zmax,dztap,zfrst,z2nd,dx,dipmax,xbegin,emerg
      real       strch,dztemp,dtsec,f1,f2,f3,f4
      integer    nx,nabot,nrinc,ismoo,istrid,isi,ntr,nrec,nsamp,natop
      integer    itrbeg,itrend,imute,itbeg,lucrd,nzbig,napmx
      character  card*(*), input*(*)
      character  word*4, word5*5, word9*9
      logical    cmd

c----------------
c  is input
c  from card file
      if (input .ne. ' ') then
         open (unit=lucrd, file=input, status='OLD', iostat=jerr)
         if (jerr .ne. 0) then
            write (LERR, *) '  ERROR OPENING EXTERNAL CARD FILE'
            stop 50
         endif
c----------------
c  or from job
c  stream
      else
         jerr = icopen('-kmcm.crd', lucrd)
         write(LERR,*)'icopen:  jerr=  ',jerr
         if (jerr .ne. 0) then
            cmd = .false.
         else
c----------------
c  or from cmd line
            cmd = .true.
         endif
      endif

      IF (cmd) THEN

        call argr4 ('-ts', tbeg  , 0.0, 0.0)
        call argr4 ('-te', tend  , 0.0, 0.0)
        call argr4 ('-tp', tpad0 , 0.0, 0.0)
        call argr4 ('-tm', tmute ,16.0,16.0)

        call argr4 ('-dti', dtms , 0.0, 0.0)
        call argr4 ('-dtm', dtmig, 2.0, 2.0)
        call argr4 ('-f1', fmin  , 1.0, 0.0)
        call argr4 ('-f2', f2    , 0.0, 0.0)
        call argr4 ('-f3', f3    , 0.0, 0.0)
        call argr4 ('-f4', fmax  , 0.0, 0.0)
       
        call argr4 ('-zx', zmax  , 0.0, 0.0)
        call argr4 ('-z1', zfrst , 0.0, 0.0)
        call argr4 ('-z2', z2nd  , 0.0, 0.0)
        call argr4 ('-dzt', dztap, 0.0, 0.0)
        call argr4 ('-dzo', dzout, 0.0, 0.0)

        call argr4 ('-dx', dx    , 0.0, 0.0)
        call argi4 ('-ns', itrbeg, 1  , 1  )
        call argi4 ('-nx', nx    , 0  , 0  )

        call argr4 ('-em', emerg , 45.0, 45.0)
        call argr4 ('-dm', dipmax, 90.0, 90.0)
        call argr4 ('-xb', xbegin, 0.0 , 0.0 )

        call argi4 ('-ap', nabot , 100, 100)
        call argi4 ('-ni', nrinc ,   1,   1)
        call argi4 ('-sm', ismoo ,   3,   3)
        call argi4 ('-sd', istrid,   1,   1)

      ELSE

         read (lucrd, '(A80)') card
         read (lucrd, '(A4, 6X, 5F10.0)') word, tend, tpad0, tbeg, dtms,
     &                                   tmute

         if (word .ne. 'TIME') then
            write (LERR, *)'"TIME" CARD MISORDERED',word,' CARD ENTERED'
            call ccexit (100)
         endif
         read (lucrd, '(A80)') card
         read (lucrd, '(A9, 1X, 4F10.0)') word9, fmin, f2, f3, fmax

         if (word9 .ne. 'FREQUENCY') then
            write (LERR, *) '"FREQUENCY" CARD MISORDERED', word9,
     &                      ' CARD ENTERED'
            call ccexit (100)
         endif
         read (lucrd, '(A80)') card
         read (lucrd,'(A5,5X,4F10.0)') word5,zmax,dztap,zfrst,z2nd

         if (word5 .ne. 'DEPTH') then
            write (LERR, *) '"DEPTH" CARD MISORDERED', word5,
     &                      ' CARD ENTERED'
            call ccexit (100)
         endif
          read (lucrd, '(A80)') card
          read (lucrd, '(A5, 5X, F10.0, 2I10)') word5, dx, itrbeg, nx
         if (word5 .ne. 'WIDTH') then
            write (LERR, *) '"WIDTH" CARD MISORDERED', word5,
     &                      ' CARD ENTERED'
            call ccexit (100)
         endif
         read (lucrd, '(A80)') card
         read (lucrd, '(A5, 15X, 3F10.0)') word5,emerg,dipmax,xbegin

         if (word5 .ne. 'MODEL') then
            write (LERR, *) '"MODEL" CARD MISORDERED', word5,
     &                      ' CARD ENTERED'
            call ccexit (100)
      endif
         read (lucrd, '(A80)') card
         read (lucrd, '(A5, 5X, I10, 2F10.0, 3I10)') word5,nabot,dzout,
     &                                       dtmig, nrinc,ismoo,istrid

         if (word5 .ne. 'IMAGE') then
            write (LERR, *) '"IMAGE" CARD MISORDERED', word5,
     &                      ' CARD ENTERED'
            call ccexit (100)
         endif

      ENDIF

      if (itrbeg .le.    0) itrbeg = 1
      if(nx.le.0) nx = ntr*nrec - itrbeg + 1
      if (nx.gt. ntr*nrec-itrbeg +1) nx=ntr*nrec - itrbeg + 1
      itrend = itrbeg + nx -1

      if (dipmax .le. 0.0) dipmax = 90.0
      if (emerg  .le. 0.0) emerg  = 45.0

c     prevent minimum frequency from being zero

      if (fmin .eq. 0) fmin = 1.0
      f1 = fmin
      f4 = fmax

      if (dtms  .le. 0.0 ) dtms  = float( isi )
      if (tmute .lt. 0.0 ) tmute = 0.0
      if (tmute .gt. tend) tmute = tend
      if (tend  .le. 0.0 ) tend  = nsamp * dtms
      if (tpad0 .le. 0.0 ) tpad0 = 0.0
      dtsec = dtms  / 1000.0
      imute = tmute / dtms
      itbeg = tbeg  / dtms + 1

      natop = 1
      if (nabot  .le. 0    ) nabot  = 100
      if (natop  .gt. nx   ) natop  = nx
      if (nabot  .gt. napmx) nabot  = nx
      if (natop  .gt. napmx) natop  = napmx
      if (nabot  .gt. napmx) nabot  = napmx
      if (nabot  .lt. natop) nabot  = natop
      if (dtmig  .le. 0.0  ) dtmig  = 2.0
      if (nrinc  .le. 1    ) nrinc  = 1
      if (ismoo  .le. 0    ) ismoo  = 3
      if (istrid .le. 0    ) istrid = 1
      if (dzout  .le. 0.0  ) dzout  = dztap

      nztemp = zmax / dzout
      if (nztemp .gt. nzbig-4) then
         dzout = zmax / (nzbig + 5)
         write (lutrm, *) 'dzgrid too small,reset to = ', dzout
      endif

      dztemp = dzout
      dzout  = dzout * strch


      write (LERR, *) ' '
      write (LERR, *) ' '
      write(LERR,*)
     :'TIME       ENDTIMEMS   PADTIME BEGTIMEMS      DTMS     TMUTE'
      write (LERR, '(10X, 5F10.0)') tend, tpad0, tbeg, dtms,
     &                                 tmute
      write(LERR,*)
     :'FREQUENCY  MINFREQHZ  F2FREQHZ  F3FREQHZ MAXFREQHZ'
      write (LERR, '(10X, 4F10.0)')  fmin, f2, f3, fmax
      write(LERR,*)
     :'DEPTH      MAX DEPTH   DELTA Z 1ST DEPTH'
      write (LERR,'(10X,4F10.2)') zmax,dztap,zfrst,z2nd
      write(LERR,*)
     :'WIDTH         DELTAX  BEGTRACE  # TRACES'
      write (LERR, '(10X, F10.2, 2I10)') dx, itrbeg, nx
      write(LERR,*)
     :'MODE                 EMERG ANG    DIPMAX'
      write (LERR, '(20X, 3F10.0)') emerg,dipmax,xbegin
      write(LERR,*)
     :'IMAGE     MIG 1/2 AP     DZMIG             NRAYINC   ISMOOTH   IS
     :TRIDE'
      write (LERR, '(10X, I10, 2F10.2, 3I10)') nabot, dzout,
     &                                    dtmig, nrinc, ismoo, istrid
      write (LERR, *) ' '
      write (LERR, *) ' '



      return
      end
