C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       KMCM                                                 *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE: 2D Kirchhoff Depth Migration                               *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   N. D. Whitmore, Jr.                ORIGIN DATE: 89/03/13  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 89/03/13  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      a bunch                                                         *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/09/10  *
C       Moved code to sun for maintenance/distribution
C  REVISED BY:  DAN WHITMORE                  REVISION DATE: 92/12/06  *
C       Changed fxznode to fxznod3 to check endpoints of rays          *
C       Moved to Cray on January 6, 1992                               *
C  REVISED BY:  Mary Ann Thornton   V 2.2     REVISION DATE: 92/03/25  *
C       Call openpr with ppname to be compatible with OS 6.1           *
C  REVISED BY:  N. D. Whitmore, Jr. V 2.3     REVISION DATE: 92/08/04  *
C       Change phase from 45 to -45; change zsrc to zsrc*dzgrid*3.0
C       This is so reflections will show up at the proper depth
C  REVISED BY:  Mary Ann Thornton,  V 2.4     REVISION DATE: 92/08/12  *
C       Added a check to see if both the velocity tape and the command
C       line contain 0 for dx and dz and write a message if so.
C  ATTENTION:
C       A message has been placed in this code after the mbsdate stamp
C       to advise users of the change in phase and tell them kmcm.old
C       is in existance if they are in the middle of a project.  This
C       message should be removed at some future date.
C  REVISED BY:  Mary Ann Thornton    V3.0    REVISION DATE:  92/08/25
C       The above change (V 2.4) was added to kmcmusp.F and then kmcmusp.F
C       is being written here in kmcm directory  so we will have one 
C       code that is identical for kmcmusp and kmcm.  At some future 
C       date, one of the codes should be dropped when users are 
C       ready for a change.  This code does not print a version 
C       number in the printout like the other codes do.
C*******************   END OF DOCUMENTATION PACKAGE   ******************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

      parameter (nxmax = 4001, nzmax = 1600, nzbig = 1600, nxbig = 4001)
      parameter (ntmax = 4011, nrmax = 361)
      parameter (napmx = 2121)
c     parameter (lucrd = 25, luprt = 26, lulst = 27, nlhdr = 1500)
      parameter (lucrd = 25, lulst = 27, nlhdr = 1500)

c     MEMORY ALLOCATION FOR CCUINT (CUBIC INTERPOLATOR)
c     DIMENSIONS:
c     TABL1, TABL2 MUST BE MAX0(NXMAX, NZMAX, NTMAX) LONG

c     real    tabl1(ntmax), tabl2(ntmax), zz(ntmax*4)
      real    tabl1(4*ntmax), tabl2(4*ntmax), zz(4*ntmax)
      integer iz(4*ntmax)


c     MEMORY ALLOCATION FOR TIMRFL and RKRAY

c     SPATIAL ARRAYS:

c     real    v   (nzmax*nxmax)
      real    v
      pointer (vaddr,       v(1))


c     COMPUTED WAVEFRONT SLOWNESS:

      real    theta(nrmax)
c     real    theta
c     pointer (thaddr,  theta(1))


c     COMPUTED WAVEFRONT RAY POSITIONS:

c     real    xray(nrmax*ntmax)
c     real    zray(nrmax*ntmax)
      integer mray(ntmax)
      real    xray, zray
      pointer (xraddr,   xray(1))
      pointer (zraddr,   zray(1))


c     RESAMPLING ARRAYS

      parameter (nwork = 4*ntmax)
      real    xwork(nwork),zwork(nwork)
      real    tscale(ntmax)
      integer nzst(napmx)

c     real    coswgt(napmx*nzbig)
      real    coswgt
      pointer (csaddr, coswgt(1))



c     HEADER ARRAYS:

c     integer lhead(nlhdr), trhead(128), trhdrs(128,nxbig)
c     real    trace(ntmax+128), trdata(ntmax)
c     equivalence (trace(1), trhead(1)), (trace(129), trdata(1))

      integer   lhead(nlhdr)
      integer*2 trhead(128), trhdrs(128,nxbig), itr(SZLNHD)
      real      trdata(ntmax)
      equivalence (itr(1), trhead(1)), (itr(129), trdata(1))

c     OUTPUT DATA ARRAYS
c     integer itmrfl(napmx*nzbig)
c     integer itmrfl
c     equivalence (xray(1),itmrfl(1))
c     real data2d(nzbig*napmx*2),depth(nzbig*nxbig)
      real time(ntmax)
c     integer itmrfl
      real    depth
      real    data2d
c     pointer (itaddr, itmrfl(1))
      pointer (dpaddr,  depth(1))
      pointer (d2addr, data2d(1))

c     LOGICALS:

      logical       heap

#include <f77/pid.h>

c     MISC:

      integer       pipe

c     CHARACTER ARRAYS:

      character*1   parr(66)
      character*128 ntap, otap, input, ntpv
      character     card*80, name*7
      character*4 pname

      data pname / 'KMCM' /
      data parr / ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
     1            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'K', 'I',
     2            'R', 'C', 'H', 'H', 'O', 'F', 'F', ' ', 'M', 'I',
     3            'G', 'R', 'A', 'T', 'I', 'O', 'N', ' ', 'A', 'F',
     4            'T', 'E', 'R', ' ', 'S', 'T', 'A', 'C', 'K', ' ',
     5            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
     6            ' ', ' ', ' ', ' ', ' ', ' '/
      data name/'KMCMUSP'/
      data pipe/3/
c
c-----------------------------------------------------------------------
c

c     PROCESS COMMAND LINE ARGUMENTS
      lutrm = 0
      call aopen (ntpv, ntap, otap, input, dxgrid, dzgrid,
     &            strch, icos)

c     OPEN PRINT FILE

#include  <f77/open.h>


c     OPEN INPUT DATASET (OR PIPE)

      call getln (luinp, ntap, 'r', 0)

c     PROCESS INPUT LINE HEADER

      jeof = 0
      call rtape (luinp, lhead, jeof)
      if (jeof .eq. 0) then
         write (LERR, *) 'ERROR READING INPUT LINEHEADER'
         stop
      endif

      call saver(lhead, 'NumTrc', ntr   , LINHED)
      call saver(lhead, 'NumRec', nrec  , LINHED)
      call saver(lhead, 'SmpInt', isi   , LINHED)
      call saver(lhead, 'NumSmp', nsamp , LINHED)
      call saver(lhead, 'Format', itpfmt, LINHED)


      if (itpfmt .ne. 3) then
         write (LERR, *) 'INPUT TAPE FORMAT NE 3 - JOB TERMINATED'
         stop 100
      endif

c     PROCESS HISTORICAL LINE HEADER

      nlin = 1
      len  = 7
      call gamoco (parr, nlin, LERR)
      call hlhprt (lhead, jeof, name, len, LERR)

      write (LERR, *) ' '
      write (LERR, *) 'Input dataset characteristics:'
      write (LERR, *) '#tr/rec      = ', ntr
      write (LERR, *) '#rec         = ', nrec
      write (LERR, *) '#sample rate = ', isi
      write (LERR, *) '#samples     = ', nsamp

c***********************************************************************
c     PROCESS INPUT PARAMETER CARDS OR COMMAND LINE ARGS
c***********************************************************************

      call cmdln (card,tend,tpad0,tbeg,dtms,tmute,f1,f2,f3,f4,
     1           zmax,dztap,zfrst,z2nd,dx,itrbeg,itrend,nx,emerg,dipmax,
     2           xbegin,nabot,dzout,dtmig,nrinc,ismoo,istrid,
     3           dtsec,imute,itbeg,lucrd,isi,ntr,nrec,nsamp,
     4           nzbig,napmx,natop,strch,dztemp,input)


CMAT  phase = 45.
      phase = -45.
      expon =  0.5
      mrsmp =  1


c     SET SOME RAY TRACING PARAMETERS

      nzout  = (ifix( zmax / dztemp ) + 3) / 4 * 4
      nztap  = zmax / dztap + 0.00001
      nzfrst = zfrst / dztemp + 1
      nz2nd  = z2nd / dztemp + 1
      if(nzfrst.le.1) nzfrst = 1
      if(nzfrst.gt.nzout) nzfrst = 1
      if(nz2nd.le.1) nz2nd  = nzout
      if(nz2nd.lt.nzfrst) nz2nd  = nzout
      nrrec  = nx
      xbeg   = (itrbeg - 1) * dx
      dxout  = dx
      xinc   = dx
      nap    = max0( natop, nabot )
      nap0   = 0
      apfeet = nap * dxout
      angle  = emerg + 1.0


      if (angle .gt. 90.0) angle = 90.0

      anginc = 0.5
      nang   = angle / anginc
      nxap   = nap * 2 + 1
      nray   = 2 * nang + 1
      write(LERR,*)'nxap,nray= ',nxap,nray,natop,nabot


c     COMPUTE TEMPORAL PARAMETERS

      tmax   = (tend + tpad0) / 2000.0
      ntsmp  = (tend + tpad0 - tbeg) / dtms
      ntskip = 4
      dt     = dtmig / 1000.0
      dtray  = dt * ntskip
      itref  = 0.256 / dtray
      dtref  = float( itref ) * dtray
      ntinc  = 1
      nt     =  tmax / dt + 1
      ntime  = ntsmp * dtms / dtmig
      if(nt.gt.ntmax) then
         write(LERR,*) 'maximum time is greater than allowed'
         stop 100
      endif

c***********************************************************************
c     OPEN OUTPUT TAPE AND WRITE HEADER TO TAPE
c***********************************************************************

      numrec = 1
      iztap = dztap
      idx   = dx
      idz   = dzout
      call savew(lhead, 'NumTrc',nx, LINHED)
      call savew(lhead, 'NumRec',numrec, LINHED)
      call savew(lhead, 'NumSmp',nztap, LINHED)
      call savew(lhead, 'SmpInt', idz , LINHED)
      call savew(lhead, 'TmMsSl', idx , LINHED)
      call savew(lhead, 'TmSlIn', idz , LINHED)

      call getln (luout, otap, 'w', 1)

      call savhlh (lhead,  jeof, jeofo)
      call wrtape (luout, lhead, jeofo)

c-----------------------------------------------------------
c  now know enough to compute
c  max dimenSions for arrays
      nzmax1 = max0( nzout,nztap) + 2
c     nxmax1 =  2 * nx
      if (nx .lt. nzmax1-2) then
          nxmax1 = nzmax1
      else
          nxmax1 = 1.1 * nx
      endif
      write(LERR,*)'nt, ntsmp, ntime= ',nt, ntsmp, ntime
      ntmax1 = max0(    nt, ntsmp, ntime)
      napmx1 = nxap
      nzbig1 = nzmax1
      nrmax1 = nray
      nxray1 = max0( napmx1, nrmax1)

c     nzmax1 = nzmax
c     nxmax1 = nxmax
c     ntmax1 = ntmax
c     napmx1 = napmx
c     nzbig1 = nzbig
c     nrmax1 = nrmax
c     nxray1 = nrmax


      write(LERR,*) ' New nzmax= ',nzmax1,' New nxmax= ',nxmax1,
     1              ' New ntmax= ',ntmax1,' New napmx= ',napmx1,
     2              ' New nzbig= ',nzbig1,' New nrmax= ',nrmax1,
     3              ' New nxray= ',nxray1

c-----------------------------------------------------------
c  allocate array space based on above max array sizes needed
      heap = .true.

      call galloc (vaddr,  nxmax1*nzmax1*SZSMPD,   ierror, abort)
      if (ierror .ne. 0) heap = .false.
      call galloc (zraddr, nrmax1*ntmax1*SZSMPD,   ierror, abort)
      if (ierror .ne. 0) heap = .false.
      call galloc (csaddr, nzmax1*napmx1*SZSMPD,   ierror, abort)
      if (ierror .ne. 0) heap = .false.
      call galloc (xraddr, nxray1*ntmax1*SZSMPD,   ierror, abort)
      if (ierror .ne. 0) heap = .false.
      call galloc (dpaddr, nzmax1*nxmax1*SZSMPD,   ierror, abort)
      if (ierror .ne. 0) heap = .false.
      call galloc (d2addr, 2*nzmax1*nxmax1*SZSMPD, ierror, abort)
      if (ierror .ne. 0) heap = .false.

c     call galloc (itaddr, nzbig1*napmx1*SZSMPD,   ierror, abort)
c     if (ierror .ne. 0) heap = .false.

      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*)   nxmax1*nzmax1 * SZSMPD,' bytes'
         write(LERR,*)   nrmax1*ntmax1 * SZSMPD,' bytes'
         write(LERR,*)   nzmax1*napmx1 * SZSMPD,' bytes'
         write(LERR,*)   nxray1*ntmax1 * SZSMPD,' bytes'
         write(LERR,*)   nzmax1*nxmax1 * SZSMPD,' bytes'
         write(LERR,*) 2*nzmax1*nxmax1 * SZSMPD,' bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)    nxmax1*nzmax1 * SZSMPD,' bytes'
         write(LERR,*)    nrmax1*ntmax1 * SZSMPD,' bytes'
         write(LERR,*)    nzmax1*napmx1 * SZSMPD,' bytes'
         write(LERR,*)    nxray1*ntmax1 * SZSMPD,' bytes'
         write(LERR,*)    nzmax1*nxmax1 * SZSMPD,' bytes'
         write(LERR,*)  2*nzmax1*nxmax1 * SZSMPD,' bytes'
         write(LERR,*)' '
         write(LERR,*)'For a total of ',
     1   (nxmax1*nzmax1+nrmax1*ntmax1+nzmax1*napmx1+ nxray1*ntmax1
     2   +nzmax1*nxmax1+2*nzmax1*nxmax1)*SZSMPD,
     3   '  bytes'
         write(LERR,*)' '
      endif

c***********************************************************************
c     READ VELOCITY TAPE
c***********************************************************************

c     OPEN VELOCITY TAPE

      if (ntpv .ne. ' ') then
         call lbopen (luvel, ntpv, 'r')      ! LUVEL IS AN INPUT DATASET
      else
          write(LERR,*)'kmcmusp assumed to be running inside IKP'
          call sisfdfit (luvel, pipe)
         if (luvel .le. 0) then
            write (LERR, *) 'ERROR NO INPUT VELOCITY DATASET'
            stop 100
         endif
      endif

      write (LERR, 37) ntpv
   37 format ('  INPUT VELOCITY DATASET = '/ a128)
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'Some internal parameters...'
c     read and expand velocities into V

      call getvel(LERR, luvel, lhead,   itr, trhead, trdata, dxout,
     &             nap0, v, nzmax1, nxmax1, nzgrid, nxgrid, nzout, nx,
     &             dzgrid, dxgrid, strch, xbegin)
      

c     Compute angle dependent mute

      call anmute (v, nzmax1, nxmax1, nzgrid, nxgrid, nzout,
     &             dzout, dzgrid, dxout, angle, xwork, nzst, nap,velmax,
     &             nzfrst,nz2nd)

      if (velmax .eq. 0.) then
         write(LERR,*)'FATAL ERROR...'
         write(LERR,*)'Maximum velocity in velocity file= ',velmax
         write(LERR,*)'indicating a null velocity file.  Re-do'
         write(LERR,*)'the velocity generation steps'
         stop
      endif
      temp   =  1000.0 * dzout / velmax
      if ( dtmig .ge. temp) then
         write(LERR,*)'Migration sample interval changed from ',dtmig
         dtmig = temp
         write(LERR,*)'...to ',dtmig
      endif
      dtmig = 2.0

c***********************************************************************
c     BEGIN TRACE PROCESSING
c***********************************************************************

c     SKIP OVER  IXBLK*IXSKP  INPUT TRACES

      iskip = itrbeg - 1
      iskpbyt = nsamp * SZSMPD + SZTRHD
      if (iskip .gt. 0) call skipt (luinp, iskip, iskpbyt)

c     BUILD INTREPOLATION TABLES


      Do 300 j = 1, ntmax*4
         tabl1(j) = float( j - 1 ) * dtms
  300 continue

      do 301 j = 1, ntmax*4
         tabl2(j) = float( j - 1 ) * dtmig
  301 continue

c     BUILD COSINE WEIGHTS

      angl = 0.0
      call cosamp1 (coswgt, nzout, nap, dzout, dxout, angl)


c     CLEAR OUTPUT DEPTH RECORD

      call vclr (depth, 1, nzmax1*nxmax1)

c     IMAGE SEISMIC RECORD

      icinit = 1
      nxbias = -ntsmp + 1

      write(LERR,*)'dzgrid= ',dzgrid,' dzout= ',dzout,' nxap= ',nxap,
     1' strch= ',strch,' nap= ',nap
      write(LERR,*)' '
      write(LERR,*)' '

      do 6100 jx = 1, nx

c        COMPUTE MIGRATION INDICES

         nxbias = nxbias + ntsmp
         iin1   = jx - nap
         iin2   = jx + nap
         irn1   = 1

         if (jx-nap .le. 0) then
            iin1 = 1
            irn1 = nap - jx + 2
         endif

         if (jx+nap .gt. nx) then
            iin2 = nx
         endif

         iib    = (iin1 - 1) * nzout
         irb    = (irn1 - 1) * nzout
         nrbias = iib - irb
         nabias = irn1 - iin1

c        GET REFLECTED TRAVELTIMES

c       write(LERR,*)'JX= ',jx,' nxbias,iin1,iin2,iib,irb,nrbias,nabias=
c    1 ', nxbias,iin1,iin2,iib,irb,nrbias,nabias,ntsmp,ntime

        if(nrinc.gt.nx.and.jx.gt.1) go to 6099
         call gettim (jx, LERR, nrmax1, ntmax1, nxmax1, nzmax1,
     &                nang, nrinc, nt, ntinc, ntskip, nxray1,
     &                nxap,  nxgrid, nzout, nzgrid,
     &                dxout, dxgrid, dzout, dzgrid, dt, dtref,
     &                ismoo, angle, apfeet, dipmax, strch, tmax,
     &                xbeg, xinc, v,
     &                theta, xray, zray, data2d,        napmx1,nzbig1,
     &                istrid,mray)

 6099   continue

         call rdtrac (luinp, LERR, nx, ntsmp, itbeg, imute,
     &          itr, trhead, trdata, tscale, time, trhdrs,jx)

         if (mod( jx, istrid ) .ne. 0 ) go to 6100

         call vclr (xwork, 1, ntsmp)
         call fftflt (time, zwork, ntsmp, nsampo, mrsmp, dtsec,
     &                f1, f2, f3, f4, phase, expon, icinit, LERR)
         call fcuint (tabl1, zwork, ntsmp, tabl2, xwork, ntime,
     &                iz, zz, icinit)
         icinit = 0

c        COMPUTE DIFFRACTION STACK

         nzend = nzout
         nzend = nz2nd

         if (icos .eq. 0) then
            call fdstk1 (iib, iin1, iin2, nabias, nrbias, nzend,
     &               nzout, nzst, xray  , xwork, coswgt, depth, ntime)
c    &               nzout, nzst,itmrfl, xwork, coswgt, depth, ntime)
         else
            call fdstk0 (iib, iin1, iin2, nabias, nrbias, nzend,
     &                   nzout, nzst, xray  , xwork, depth, ntime)
c    &                   nzout, nzst,itmrfl, xwork, depth)
         endif

 6100 continue

c     WRITE IMAGED SEISMIC RECORD TO OUTPUT DATASET

      jr = 1

      call wrrec2 (luout, luinp, nx, nzout, nztap, dzout, dztap,
     &             jr, istrid, strch, depth, trhdrs,
     &               itr, trhead, trdata,
     &                   iz, xwork, tabl1, tabl2, zz)

c * * * * * * * * DATA PROCESSING COMPLETED * * * * * * * * * * * *

      call lbclos (luinp)
      call lbclos (luout)

      write (LERR, *) ' JOB COMPLETE'
999   continue
      stop
      end
