C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FFTFLT                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      FFTFLT  (DATA,DATAO,MDATI,MDATO,MRSMP,DTSEC,F1,F2,F3,F4,PHASE,  *
C               EXPON,IFINIT,LPRT)                                     *
C  ARGUMENTS:                                                          *
C      DATA    REAL     ??IOU*  (*) -                                  *
C      DATAO   REAL     ??IOU*  (*) -                                  *
C      MDATI   INTEGER  ??IOU*      -                                  *
C      MDATO   INTEGER  ??IOU*      -                                  *
C      MRSMP   INTEGER  ??IOU*      -                                  *
C      DTSEC   REAL     ??IOU*      -                                  *
C      F1      REAL     ??IOU*      -                                  *
C      F2      REAL     ??IOU*      -                                  *
C      F3      REAL     ??IOU*      -                                  *
C      F4      REAL     ??IOU*      -                                  *
C      PHASE   REAL     ??IOU*      -                                  *
C      EXPON   REAL     ??IOU*      -                                  *
C      IFINIT  INTEGER  ??IOU*      -                                  *
C      LPRT    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/09/04  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/09/04  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      CTRPFL -                                                        *
C      VCLR   -                                                        *
C      RFFT   -                                                        *
C      CVMUL  -                                                        *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL -                                                  *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine fftflt (data, datao, mdati, mdato, mrsmp, dtsec,
     &                   f1, f2, f3, f4, phase, expon, ifinit, lprt)
 
c     D. Whitmore
 
c     data   = input data
c     datao  = output data
c     mdati  = length of input data
c     mdato  = length of output data = mdati*mrsmp
c     mrsmp  = resampling rate (must be a power of 2)
c     dtsec  = delta t in seconds of input
c     f1-f4  = frequency filtering points
c     phase  = phase angle in degrees
c     expon  = frequency exponent
c     ifinit = initialization flag ( = 1 to inititalize)
 
      integer mdati, mdato, mrsmp, ifinit, lprt
      real    f1, f2, f3, f4, dtsec, phase, expon
      real    data(*), datao(*)
 
 
      complex filt(8192)
      integer m1, lfilt, m4
      real    df, scalf
c
      save    filt, m1, lfilt, m4, scalf, df
 
c-----------------------------------------------------------------------
 
c     INITIALIZE FILTER
 
      if (ifinit .eq. 1 ) then
 
c        compute power of 2 length
 
	 m1 = 16
 110     continue
         if (m1 .le. mdati) then
            m1 = m1 + m1
            go to 110
         endif
 
c        compute df = incremental frequency
 
         df = 1.0 / (dtsec * m1)
 
c        compute scalf = 1 / (2 * m1)
 
         scalf = 1.0 / (2.0 * float( m1 ))
         lfilt = m1 / 2
 
c        define expanded samples
 
         m4    = m1 * mrsmp
         mdato = mdati * mrsmp
 
c        compute frequency filter:
 
         call ctrpfl (filt, lfilt, f1, f2, f3, f4, df, scalf, expon,
     &                phase, lprt)
 
      end if
 
c     execute forward fft
 
      call vclr (data(1+mdati), 1, m1-mdati)
      call rfft (data, m1, 1)
 
c     multiply by filt
 
      call cvmul (data, 2, filt, 2, datao, 2, lfilt, 1)
 
c     execute inverse fft
 
      if (mrsmp .gt. 1) call vclr (datao(1+m1), 1, (mrsmp-1)*m1)
      call rfft (datao, m4, -1)
 
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       CTRPFL                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      CTRPFL  (FILT,LFILT,F1,F2,F3,F4,DF,SCALF,EXPON,PHASE,LPRT)      *
C  ARGUMENTS:                                                          *
C      FILT    COMPLEX  ??IOU*  (*) -                                  *
C      LFILT   INTEGER  ??IOU*      -                                  *
C      F1      REAL     ??IOU*      -                                  *
C      F2      REAL     ??IOU*      -                                  *
C      F3      REAL     ??IOU*      -                                  *
C      F4      REAL     ??IOU*      -                                  *
C      DF      REAL     ??IOU*      -                                  *
C      SCALF   REAL     ??IOU*      -                                  *
C      EXPON   REAL     ??IOU*      -                                  *
C      PHASE   REAL     ??IOU*      -                                  *
C      LPRT    INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 93/09/04  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 93/09/04  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      VCLR -                                                          *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SIN     GENERIC -                                               *
C      COS     GENERIC -                                               *
C      FLOAT   REAL    -                                               *
C      CMPLX   COMPLEX -                                               *
C  FILES:                                                              *
C      LPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      1000  ( 2) -                                                    *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      statement out of order :      REAL FREF, DFOVFR, THETA, RA      *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine ctrpfl (filt, lfilt, f1, f2, f3, f4, df, scalf, expon,
     &                   phase, lprt)
 
C     THIS ROUTINE COMPUTES A TRAPEZOIDAL FREQUENCY SCALING VECTOR
 
c     D. Whitmore
 
      complex filt(*), scale
      real f1, f2, f3, f4, df, scalf, expon, phase, pi
      integer lfilt, lprt
 
      data pi / 3.141592653589793 /
 
C     FILT, LFILT   = FILTER AND LENGTH OF FILTER
C     F1, F2, F3, F4  = TRAPEZOIDAL FILTER POINTS
C     DF           = FREQUENCY SPACING
C     SCALF        = SCALAR MULTIPLIER
C     EXPON        = FREQUENCY EXPONENT
C     PHASE        = PHASE ROTATION IN DEGREES
 
      real fref, dfovfr, theta, ramp
      data fref/30./
      integer j1, j2, j3, j4, j
 
C-----------------------------------------------------------------------
 
C     SET REF FREQUENCY TO 30 HZ
 
c     fref   = 30
      dfovfr = df / fref
 
C     BUILD PHASE SCALING
 
      theta = phase * pi / 180.0
      scale = scalf * cmplx( cos(theta), sin(theta) )
 
c     BUILD F1, F2, F3, F4 FILTER
 
      if (f4.lt.f3 .or. f3.lt.f2 .or. f2.lt.f1 .or. f1.lt.0.0) then
         write (lprt, *) 'FILTER ERROR: F1,F2,F3,F4 = ', f1, f2, f3, f4
         stop 1000
      endif
 
      j1 = f1 / df + 1
      j2 = f2 / df + 1
      j3 = f3 / df + 1
      j4 = f4 / df + 1
 
      if (j4 .gt. lfilt) then
         write (lprt, *) 'FILTER ERROR'
         write (lprt, *) 'F4 FREQUENCY GREATER THAN MAX FREQUENCY'
         stop 1000
      endif
 
      call vclr( filt, 1, 2*lfilt )
 
      if (j2 .gt. j1) then
         do 20 j = j1, j2-1
            ramp    = float(j-j1) / float(j2-j1)
            filt(j) = scale * ((float(j-1) * dfovfr) ** expon * ramp)
   20    continue
      endif
 
      do 30 j = j2, j3-1
         filt(j) = scale * (float(j-1) * dfovfr) ** expon
   30 continue
 
      if (j4 .gt. j3) then
         do 40 j = j3, j4-1
            ramp    = float(j4-j) / float(j4-j3)
            filt(j) = scale * ((float(j-1) * dfovfr) ** expon * ramp)
   40    continue
      endif
 
      return
      end
