C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine timget(ix1,iz1,nz,nt,nx,itime,nap,slow,dz,dt,dx,
     &                  dipmax,angle,ntskip)
      integer itime(nz,-nap:nap)
      parameter (nang_max = 361,nrmax = 2000)
      real slow(nz,nx)
      real xray(nang_max),zray(nang_max),theta(nang_max)
      real wcos(nang_max),wsin(nang_max),vdt(nang_max)
      real xsav(nang_max,nrmax)
      real zsav(nang_max,nrmax)
      real thetsav(nang_max,nrmax)
      integer izarr(nang_max),ixarr(nang_max)

      data pi / 3.141592653589793 /
      radian = pi / 180.0

c     compute initial conditions of rayfans
      if(ntskip.le.0) ntskip = 1
      zsrc   = iz1*dz
      xsrc   = (ix1-1)*dx
      xmax   = (nx - 1) * dx
      apfeet = nap * dx
      if (xsrc .gt. xmax) xsrc = xmax
      tmax   = nt*dt
      anginc = 0.5
      nang   = angle / anginc
      nray   = 2 * nang + 1
      angmax = dipmax * radian
      xbias = xsrc - apfeet
      dang   = abs( angle ) / nang
      angray = -abs( angle ) - dang
      do jray = 1, nray
         angray       = angray + dang
         zray(jray) = zsrc
         xray(jray) = xsrc
         theta(jray)  =  angray * radian
      enddo

c     initialize itime matrix          
      do jx = -nap,nap
       do jz = 1, nz
        itime(jz,jx) = nt 
       enddo
      enddo   

      ifirst = 1
      ntlast = (nt-1)/ntskip + 1
      dtray  = dt*ntskip
      jt1    = 1
      call vmov(theta,1,thetsav(1,jt1),1,nray)
      call vmov(zray,1,zsav(1,jt1),1,nray)
      call vmov(xray,1,xsav(1,jt1),1,nray)
      do jt1 = 2,ntlast

                 if(ntskip.gt.1) then
            itheta = 0
            do jt2=1,ntskip-1
       call rkraya ( nz,nx,nray,dz,dx,dt,slow,theta,
     & zray,xray,wcos,wsin,vdt,ifirst ,ix1,izarr,ixarr,itheta) 
       ifirst = 0
            enddo
                 endif
       itheta = 0
       call rkraya ( nz,nx,nray,dz,dx,dt,slow,theta,
     & zray,xray,wcos,wsin,vdt,ifirst ,ix1,izarr,ixarr,itheta) 

       call vmov(theta,1,thetsav(1,jt1),1,nray)
       call vmov(zray,1,zsav(1,jt1),1,nray)
       call vmov(xray,1,xsav(1,jt1),1,nray)

      enddo
c     end time step loop

c     interpolate ray endpoints and grid traveltimes
        call grdno1 (xsav,zsav,thetsav,angmax,nray,ntskip,ntlast,
     &               dx, dz, itime, nz, xsrc , nap ,nang_max,nrmax)

      return
      end

      subroutine grdno1 (xsav, zsav,thetsav,angmax,nray,ntskip,ntlast,  
     &               dx, dz, itime, nz, xsrc , nap ,nang_max,nrmax)
c
      real xsav(nang_max,nrmax) 
      real zsav(nang_max,nrmax)
      real thetsav(nang_max,nrmax)
      integer itime(nz,-nap:nap)
c
c------------------------------------------------------------------
c
      zover  = 1.0 / dz
      xover  = 1.0 / dx
      xbias1 = -(nap-1)*dx
      xbias2 = +(nap-1)*dx
      zbig   = nz*dz

c     grid rays

      do 10 jt1 = ntlast,2,-1
      jt = 1+(jt1-1)*ntskip
       do 20 j = 1, nray-1
       x1a = xsav(j  ,jt1  ) - xsrc
       x1b = xsav(j  ,jt1-1) - xsrc
       x2a = xsav(j+1,jt1  ) - xsrc
       x2b = xsav(j+1,jt1-1) - xsrc
       z1a = zsav(j  ,jt1  ) 
       z1b = zsav(j  ,jt1-1) 
       z2a = zsav(j+1,jt1  ) 
       z2b = zsav(j+1,jt1-1) 
       nxrat = abs(x1a -x2a)*xover
       nzrat = abs(z1a -z2a)*zover
       nrat  = max0(nxrat,nzrat) + 1
cdan   nrat = 1
       if(abs(thetsav(j  ,jt1  )).gt.angmax) go to 20
       if(abs(thetsav(j+1,jt1  )).gt.angmax) go to 20
       if(nrat.gt.40) goto 20
       step   = 1.0 / float( nrat+1 )
       stepz  = zover * step
       stepx  = xover * step
        do 30 jts = 0,ntskip-1
        alphaz = zover
        alphax = xover
        betaz  = 0.0
        betax  = 0.0
        beta  = float(jts)/float(ntskip)
        alpha = 1. - beta
        xnod1 = alpha*x1a + beta*x1b
        xnod2 = alpha*x2a + beta*x2b
        znod1 = alpha*z1a + beta*z1b
        znod2 = alpha*z2a + beta*z2b
         do 40 i = 0, nrat
          jz = ifix( alphaz * znod1 + betaz * znod2  )
          jx = ifix( alphax * xnod1 + betax * xnod2  )
          if(jz.le.nz .and. jz.ge.1 .and. iabs(jx).lt.nap) then          
          itime(jz,jx) = jt-jts
          endif
   41     alphaz = alphaz - stepz
          alphax = alphax - stepx
          betaz  = betaz  + stepz
          betax  = betax  + stepx
   40    continue
   30   continue
   20  continue
   10 continue
      return
      end
      subroutine rkraya ( nz,nx,nray,dz,dx,dt,slow,theta,zray,xray,
     &  wcos, wsin, vdt , ifirst ,ix1, izarr, ixarr ,itheta)

      real     slow(nz,nx)   
      real     theta(*) , zray(*) , xray(*) 
      real     wcos (*) , wsin(*) , vdt(*) 
      integer izarr(*) , ixarr(*)

c     initialize cos and sin
      if(ifirst.eq.1) then
       do j=1,nray
        wcos(j) = cos(theta(j))
        wsin(j) = sin(theta(j))
       enddo
      endif

c     FIXED DT RAYTRACING IN HETEROGENEOUS MEDIA -- RUNGE-KUTTA
c      ray tracing for a single time step                               

       dzover = 1./dz
       dxover = 1./dx
       dzdt   = dz/dt
       dxdt   = dx/dt


c      find temp node indices
       do j=1,nray
       jxx = ifix(xray(j)*dxover + 1.5)
       jzz = ifix(zray(j)*dzover + 1.5)
       if(jxx.lt.3) jxx=3
       if(jxx.gt.nx-2) jxx=nx-2
       if(jzz.lt.2) jzz=2
       if(jzz.gt.nz-2) jzz=nz-2
       vdt(j)   = dt/slow(jzz,jxx)
       ixarr(j) = jxx
       izarr(j) = jzz
       enddo

c      if itheta ne 0, only update node locations
       if(itheta.ne.0) go to 300
       
c      if itheta eq 0, update theta         
       do 200 j=1,nray
       jxx = ixarr(j) 
       jzz = izarr(j) 
c      compute thetmp
       thetmp    = theta(j)
     &           + wcos(j)/(slow(jzz,jxx)**2 *dxdt) *
     &   .5*( slow(jzz,jxx+1) -slow(jzz,jxx-1) )
     &           - wsin(j)/(slow(jzz,jxx)**2 *dzdt) *
     &   .5*( slow(jzz+1,jxx) -slow(jzz-1,jxx) )
c      update node indices
       wcos(j)   = cos(thetmp)
       wsin(j)   = sin(thetmp)
       jzz =
     & ifix( (zray(j) + wcos(j)*vdt(j))*dzover + 1.5)
       jxx =
     & ifix( (xray(j) + wsin(j)*vdt(j))*dxover + 1.5)
       if(jxx.lt.3) jxx=3
       if(jxx.gt.nx-2) jxx=nx-2
       if(jzz.lt.2) jzz=2
       if(jzz.gt.nz-2) jzz=nz-2
c      compute update theta
       theta(j) = .5*
     &          ( theta(j) + thetmp
     &           + wcos(j)/(slow(jzz,jxx)**2 *dxdt) *
     &   .5*( slow(jzz,jxx+1) -slow(jzz,jxx-1) )
     &           - wsin(j)/(slow(jzz,jxx)**2 *dzdt) *
     &   .5*( slow(jzz+1,jxx) -slow(jzz-1,jxx) ) )
c      compute ray locations 
       wcos(j) = cos(theta(j))
       wsin(j) = sin(theta(j))
  200  continue

  300  continue
       do j=1,nray
       xray(j) = xray(j) + wsin(j)*vdt(j)
       zray(j) = zray(j) + wcos(j)*vdt(j)
       enddo

      return
      end
