C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs some arcane geophysical process
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/localsize.h>
c-----
 
      parameter (NYMAX=4000)
      integer     luin , luout
      character*1 blank(80)
 
c------
c  dynamic memory allocation for big arrays, eg whole records
      real x, y

c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      character   inpick * 100, outpick * 100, name*7, version*4
      logical     verbos, hlp, query
      integer     argis
 
      DATA BLANK/80*' '/

      data name/'LIDI2XY'/, version /' 1.0'/ 
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
      if ( hlp ) then
           call help()
           stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/mbsopen.h>
 
      call gcmdln(inpick,outpick,verbos,
     1            ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4,
     1            dy,dx,ili1,idi1)

c     set up transformation
c-----
         if (ix4 .eq. 0) ix4 = ix1 + ix3 - ix2
         if (iy4 .eq. 0) iy4 = iy1 + iy3 - iy2
         if (dy .ne. 0. .and. dx .ne. 0.) then
            call xfmi (ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4,dy,dx,
     &                 nx,ny,isign,lerr,ier)
            if (ier .ne. 0) then
               WRITE (lerr, 2250)
 2250 FORMAT(/, 1X, '** M2250 ** ERROR DETECTED BY SUBROUTINE XFMI'  ,
     *          2X, 'THE GRID CORNER COORDINATES INPUT '             ,
     *         50X, 'DO NOT DESCRIBE A PARALLELOGRAM.',             /)  
               stop
            endif
         end if
         XT1        = DX / 2.
         YT1        = DY / 2.
         XT2        = DX / 2.
         YT2        = NY*DY - DY / 2.
         XT3        = NX*DX - DX / 2.
         YT3        = NY*DY - DY / 2.
         XT4        = NX*DX - DX / 2.
         YT4        = DY / 2.
         CALL XFMINV(X1,Y1,XT1,YT1,X1,Y1,XT1,YT1,IWARN)
         CALL XFMINV(X2,Y2,XT2,YT2,X2,Y2,XT2,YT2,IWARN)
         CALL XFMINV(X3,Y3,XT3,YT3,X3,Y3,XT3,YT3,IWARN)
         CALL XFMINV(X4,Y4,XT4,YT4,X4,Y4,XT4,YT4,IWARN)
         JX1        = NINT (X1)
         JY1        = NINT (Y1)
         JX2        = NINT (X2)
         JY2        = NINT (Y2)
         JX3        = NINT (X3)
         JY3        = NINT (Y3)
         JX4        = NINT (X4)
         JY4        = NINT (Y4)
         WRITE (lerr, 115) IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,
     &                     JX1,JY1,JX2,JY2,JX3,JY3,JX4,JY4
         WRITE (lerr, 116) NY, NX
  115    FORMAT (//, 30X, 'OUTPUT HEADER SORT-CORNER COORDINATES' ,
     &         /, 23X, '  X FOR CORNER 1. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 1. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  X FOR CORNER 2. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 2. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  X FOR CORNER 3. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 3. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  X FOR CORNER 4. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 4. . . . . . . . .',1X,I9  ,
     &        //, 30X, 'BIN-CENTER COORDINATES'                   ,
     &         /, 23X, '  X FOR CORNER 1. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 1. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  X FOR CORNER 2. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 2. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  X FOR CORNER 3. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 3. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  X FOR CORNER 4. . . . . . . . .',1X,I9  ,
     &         /, 23X, '  Y FOR CORNER 4. . . . . . . . .',1X,I9  )
  116    FORMAT (
     &         /, 23X, 'NUMBER OF LINE INDEXES IN GRID. .',1X,I9  ,
     &         /, 23X, 'NUMBER OF DEPTH INDEXES IN GRID .',1X,I9  ,//)

c     get logical output for tape
c-----
      call getln(luout, outpick, 'w', 1)
 
      if (ny .gt. NYMAX) then
         write (lerr, *) ' error - number of li(s) exceeds ', NYMAX
         stop
      endif
      minli=ili1
      maxli=ny+ili1-1
      mindi=idi1
      maxdi=nx+idi1-1
      if(verbos)then
         write (lerr, *) ' minimum li = ', minli
         write (lerr, *) ' minimum di = ', mindi
         write (lerr, *) ' maximum li = ', maxli
         write (lerr, *) ' maximum di = ', maxdi
      endif

c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings inpick & outpick (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if inpick & outpick are blank strings, i.e. inpick = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c-----
c  compute size of input buffer
      if(inpick.eq.' ')then
         write(LERR,*)' must specify li, di, z file.'
         stop
      endif
      luin=19
      open(unit=luin,file=inpick,status='old',iostat=ierr)
      if(ierr.ne.0)then
         write(LERR,*)' end of file or error opening ', inpick
         stop
      endif
      luout=20
      open(unit=luout,file=outpick,status='unknown',iostat=ierr)
      if(ierr.ne.0)then
         write(LERR,*)' end of file or error opening ', outpick
         stop
      endif
      itot=0
      icount=0
      zmin=50000.
      zmax=-50000.
  100 continue
         itot=itot+1
         read(luin,*,end=110,err=100)iy,ix,iz
         if(minli.le.iy.and.iy.le.maxli.and.
     1      mindi.le.ix.and.ix.le.maxdi)then
            icount=icount+1
            if(iz.lt.zmin)zmin=iz
            if(iz.gt.zmax)zmax=iz
         endif
         goto 100
  110 continue
      rewind(luin)
      if(verbos)then
         write(LERR,*) ' total lines read ', itot
         write(LERR,*) ' total coordinates read ', icount
      endif

 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
           call verbal(inpick,outpick,ns,ne,irs,ire,verbos,
     1                 ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4,
     1                 dy,dx,ili1,idi1,ny,nx)
      end if

      write(LERR,*) ' number of lis is ', ny
      write(LERR,*) ' number of dis is ', nx
 
      i=0
      j=0
  200 continue
         read(luin,*,end=210,err=200)iy,ix,iz
         i=i+1
         if(minli.le.iy.and.iy.le.maxli.and.
     1      mindi.le.ix.and.ix.le.maxdi)then
            j=j+1
            ix=ix-idi1+1
            iy=iy-ili1+1
            index=((ix-1)*ny)+iy
            xt=(ix*dx)-(dx*.5)
            yt=(iy*dy)-(dy*.5)
            call xfminv(x,y,xt,yt,x,y,xt,yt,iwarn)
            jx=nint(x)
            jy=nint(y)
            write(luout,*)jx,jy,iz
         endif
         goto 200
  210 continue

c-----
c     close data files
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      close ( luin )
      close ( luout )
 
            write(LERR,*)'end of lidi2xy, processed',itot,' record(s)',
     :               ' with ',icount, ' coordinates'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
      print *,' lidi2xy converts lidiz triplets to xyz triplets'
      print *,' '
      print *,' -P1[inpick] input file'
      print *,' -P2[outpick]  output file'
      print *,' -i1x[ix1]   grid-corner coordinate'
      print *,' -i1y[iy1]   grid-corner coordinate'
      print *,' -i2x[ix1]   grid-corner coordinate'
      print *,' -i2y[iy1]   grid-corner coordinate'
      print *,' -i3x[ix1]   grid-corner coordinate'
      print *,' -i3y[iy1]   grid-corner coordinate'
      print *,' -i4x[ix1]   grid-corner coordinate'
      print *,' -i4y[iy1]   grid-corner coordinate'
      print *,' -dy[dy]     bin spacing in y '
      print *,' -dx[dx]     bin spacing in x '
      print *,' -ili[ili1]  starting li bias '
      print *,' -idi[idi1]  starting di bias '
      print *,' [-V]        verbose flag '
      print *,' '
      print *,'usage'
      print *,' '
      print *,'lidi2xy -P1[inpick] -P2[outpick] -dy[dy] -dx[dx]'
      print *,'     -i1x[ix1] -i1y[ix1] -i2x[ix1] -i2y[ix1]'
      print *,'     -i3x[ix1] -i3y[ix1] -i4x[ix1] -i4y[i4y]'
      print *,'     -ili[ili1] -idi[idi1] [-V]'

      return
      end
 
C***********************************************************************
 
      subroutine gcmdln(inpick,outpick,verbos,
     1                  ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4,
     1                  dy,dx,ili1,idi1)
 

 
c-----
c     verbose output of processing parameters
c
c     character*100 inpick   - input file
c     character*100 outpick   - output file
c     logical       verbos - verbose flag
c     integer       ix1    - grid corner coordinates
c     integer       iy1    - grid corner coordinates
c     integer       ix2    - grid corner coordinates
c     integer       iy2    - grid corner coordinates
c     integer       ix3    - grid corner coordinates
c     integer       iy3    - grid corner coordinates
c     integer       ix4    - grid corner coordinates
c     integer       iy4    - grid corner coordinates
c     real          dy     - bin spacing in y
c     real          dx     - bin spacing in x
c     integer       ili1   - starting li bias
c     integer       idi1   - starting di bias
c-----
#include <f77/iounit.h>
 
      character*(*) inpick
      character*(*) outpick
      logical       verbos
      real          dy
      real          dx
      integer       ix1
      integer       iy1
      integer       ix2
      integer       iy2
      integer       ix3
      integer       iy3
      integer       ix4
      integer       iy4
      integer       ili1
      integer       idi1
      integer       argis
 
c-------
c     import values from the command line using keys, e.g. -P1
c     to which are immediately attached the users values.
 
c     For example program lidi2xy might be invoked in the following way:
 
c     lidi2xy  -P1inpick -P2outpick
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into lidi2xy and associated with the variable
c     "inpick"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
      call argstr( '-P1', inpick, ' ', ' ' )
      call argstr( '-P2', outpick, ' ', ' ' )
      call argi4 ( '-i1x', ix1, 0, 0 )
      call argi4 ( '-i1y', iy1, 0, 0 )
      call argi4 ( '-i2x', ix2, 0, 0 )
      call argi4 ( '-i2y', iy2, 0, 0 )
      call argi4 ( '-i3x', ix3, 0, 0 )
      call argi4 ( '-i3y', iy3, 0, 0 )
      call argi4 ( '-i4x', ix4, 0, 0 )
      call argi4 ( '-i4y', iy4, 0, 0 )
      call argr4 ( '-dy', dy, 1., 1. )
      call argr4 ( '-dx', dx, 1., 1. )
      call argi4 ( '-ili', ili1 ,   1  ,  1    )
      call argi4 ( '-idi', idi1 ,   1  ,  1    )
      verbos =   (argis('-V') .gt. 0)

c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
 
      subroutine verbal(inpick,outpick,ns,ne,irs,ire,verbos,
     1                  ix1,iy1,ix2,iy2,ix3,iy3,ix4,iy4,
     1                  dy,dx,ili1,idi1,ny,nx)
 

c-----
c     verbose output of processing parameters
c
c     character*100 inpick   - input file
c     character*100 outpick   - output file
c     logical       verbos - verbose flag
c     real          dy     - bin spacing in y
c     real          dx     - bin spacing in x
c     integer       ix1    - grid corner coordinates
c     integer       iy1    - grid corner coordinates
c     integer       ix2    - grid corner coordinates
c     integer       iy2    - grid corner coordinates
c     integer       ix3    - grid corner coordinates
c     integer       iy3    - grid corner coordinates
c     integer       ix4    - grid corner coordinates
c     integer       iy4    - grid corner coordinates
c     integer       ny     - number of line indices
c     integer       nx     - number of depth indices
c     integer       ili1   - starting li bias
c     integer       idi1   - starting di bias
c-----
#include <f77/iounit.h>
 
      character*(*) inpick
      character*(*) outpick
      logical       verbos
      real          dy
      real          dx
      integer       ix1
      integer       iy1
      integer       ix2
      integer       iy2
      integer       ix3
      integer       iy3
      integer       ix4
      integer       iy4
      integer       ili1
      integer       idi1

      write(lerr,*)' input file                 ', inpick
      write(lerr,*)' output file                ', outpick
      write(lerr,*)' verbose flag               ', verbos
      write(lerr,*)' grid corner 1 x-coordinate ', ix1
      write(lerr,*)' grid corner 1 y-coordinate ', iy1
      write(lerr,*)' grid corner 2 x-coordinate ', ix2
      write(lerr,*)' grid corner 2 y-coordinate ', iy2
      write(lerr,*)' grid corner 3 x-coordinate ', ix3
      write(lerr,*)' grid corner 3 y-coordinate ', iy3
      write(lerr,*)' grid corner 4 x-coordinate ', ix4
      write(lerr,*)' grid corner 4 y-coordinate ', iy4
      write(lerr,*)' number of line indices     ', ny
      write(lerr,*)' number of depth indices    ', nx
      write(lerr,*)' starting li bias           ', ili1
      write(lerr,*)' starting di bias           ', idi1
      write(lerr,*)' inline spacing             ', dx
      write(lerr,*)' crossline spacing          ', dy


      return
      end
