C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mainsub(niter,decrease,weight,lerr,ler,file_data,
     1                   cmdforward,cmdbackward,file_prior,subdir,
     2                   olddir,verbose)

      implicit none

c-----------------------------------------------------------------------
c---->Type declarations for arguments
      character*256 file_data,file_prior,subdir,olddir
      character*256 cmdforward,cmdbackward
      integer       lerr,ler
      real          decrease,weight
      integer       niter
      logical       verbose

c---->Type declarations for local variables
      logical       restart
      integer       unitrestart
      character     current_pwd
      character*256 file_guess_old,file_guess,file_grad
      character*256 file_restart,file_fmdata,file_fmdata_old,file_error
      logical       initial
      integer       lmin,pid,ppid,lds_pid,lde_pid
      character*20  pid6
      character*256 name
      character*20  int_to_str
      character*256 file_temp,file_temp2
      integer       lnst
      character*256 directory,string
      integer       lengstring
      parameter     (lengstring=256)
      integer       ld_directory,ld_subdir,ld_olddir,ld_pwd
      logical       specialcase
c-----------------------------------------------------------------------


      initial = .false.
      current_pwd = '.'


c---->Defines if minimization restart from a previous one or not
c-----------------------------------------------------------------------
      if (olddir.eq.' ') then
       restart = .false.
      else
       restart = .true.
      endif
      if (restart.and.(olddir.eq.subdir)) then
       specialcase = .true.
      else
       specialcase=.false.
      endif
 

c---->Convert the process id in a character format
c-----------------------------------------------------------------------
      call getpps(pid,ppid)
      pid6  = int_to_str(pid,lds_pid,lde_pid)


c---->Create the directory where results will be written
c-----------------------------------------------------------------------
      ld_pwd = lnst(current_pwd)
      if (subdir.eq.' ') then
       directory = current_pwd(1:ld_pwd)//'/result.'
     1             //pid6(lds_pid:lde_pid)
      else
       ld_subdir = lnst(subdir)
       directory = current_pwd(1:ld_pwd)//'/'//subdir(1:ld_subdir)
      endif
      ld_directory = lnst(directory)
      if (.not.specialcase) then
       string = 'mkdir '//directory(1:ld_directory)
       call callsys(string,lengstring,lerr,verbose)
      endif


c---->Copy result files of the previous minimization in the new 
c---->result directory
c-----------------------------------------------------------------------
      if (restart.and.(.not.specialcase)) then
       ld_olddir = lnst(olddir)
       string = 'cp '//current_pwd(1:ld_pwd)//'/'
     1          //olddir(1:ld_olddir)//'/* '
     2          //directory(1:ld_directory)
       call callsys(string,lengstring,lerr,verbose)
      endif


c---->Defines the file names of the program outputs
c-----------------------------------------------------------------------
      file_temp = directory(1:ld_directory)//'/temp'
      file_temp2 = directory(1:ld_directory)//'/temp2'
      file_grad = directory(1:ld_directory)//'/grad'
      file_error = directory(1:ld_directory)//'/error'
      file_fmdata = directory(1:ld_directory)//'/data.calc'
      file_fmdata_old = directory(1:ld_directory)//'/data.calc.old'
      file_guess = directory(1:ld_directory)//'/solution'
      file_guess_old = directory(1:ld_directory)//'/solution.old'
      file_restart = directory(1:ld_directory)//'/restartfile'
      unitrestart = 96
      open(unitrestart,file=file_restart,form='formatted')
      name = directory(1:ld_directory)
     1       //'/MINIMIZER.'//pid6(lds_pid:lde_pid)
      lmin = 95
      open(lmin,file=name,form='formatted')


c---->Write informations in the lerr unit file
c-----------------------------------------------------------------------
      call putcmdlin(lmin)
      call putcmdlin(lerr)


c---->Call the conjugate gradient algorithm
c-----------------------------------------------------------------------
      call minimizer(restart,niter,decrease,weight,lerr,file_data,
     1               file_guess,file_guess_old,file_grad,file_fmdata,
     2               file_fmdata_old,file_error,file_temp,cmdforward,
     3               cmdbackward,verbose,lmin,unitrestart,file_prior,
     4               file_temp2)


c---->Remove the useless files file_grad and file_error	
c-----------------------------------------------------------------------
      call remove(file_grad,verbose,lerr)
      call remove(file_error,verbose,lerr)
      call remove(file_temp,verbose,lerr)
      call remove(file_temp2,verbose,lerr)


c---->Close files
c-----------------------------------------------------------------------
      close(unitrestart)
      close(lmin)



      return
      end
