C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine backward(file_in,file_out,cmdstring,lerr,
     1                    nodelist,current_pwd,verbose)

      implicit none

c-----------------------------------------------------------------------
c     Declaration for arguments
      integer       lerr
      character*256 file_in,file_out
      character*256 cmdstring,nodelist,current_pwd
      logical       verbose

c     Declaration for local variables
      character*512 string
      integer       lengstring
      parameter     (lengstring=512)
      integer       lnst
      integer       ld_string,ld_in,ld_out,ld_cmdstring
      integer       ld_nodelist,ld_current_pwd
c-----------------------------------------------------------------------



c-----------------------------------------------------------------------
c     Define the length of the different file name used
c-----------------------------------------------------------------------
      ld_out = lnst(file_out)
      ld_in = lnst(file_in)
      ld_cmdstring = lnst(cmdstring)
      ld_current_pwd = lnst(current_pwd)
      ld_nodelist = lnst(nodelist)


c-----------------------------------------------------------------------
c     Define the command line
c-----------------------------------------------------------------------
      if (nodelist.eq.'-same 1') then
       string = 'radgamma '//cmdstring(1:ld_cmdstring)
     1          //' -N'//file_in(1:ld_in)//' -O'//file_out(1:ld_out)
       call callsys(string,lengstring,lerr,verbose)

      else
       string = cmdstring(1:ld_cmdstring)//' -N'//file_in(1:ld_in)
     1          //' -O'//file_out(1:ld_out)
       string = 'spawn2 -cmd "cd '
     1          //current_pwd(1:ld_current_pwd)
     2          //' && radgamma {totalnodes}'
     3          //' {nodenumber}	'//string
       ld_string=lnst(string)
       string = string(1:ld_string)//'" '//nodelist(1:ld_nodelist)


c-----------------------------------------------------------------------
c      Call system
c-----------------------------------------------------------------------
       call callsys(string,lengstring,lerr,verbose)


c-----------------------------------------------------------------------
c      Merge result
c-----------------------------------------------------------------------
       string = 'mrgrad -N'//file_out(1:ld_out)
     1          //' -O'//file_out(1:ld_out)
       call callsys(string,lengstring,lerr,verbose)

       string = '/bin/rm -f '//file_out(1:ld_out)//'__*'
       call callsys(string,lengstring,lerr,verbose)
      endif



      return
      end
