C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine info(unit,iter,j,j1,j2,ps,alpha,per,per1)
c-----------------------------------------------------------------------
c     Write informations in file MINIMIZER.id or LSQRRAD.id
c-----------------------------------------------------------------------

      implicit none

c-----------------------------------------------------------------------
c     Declaration for arguments
      integer unit,iter
      real*8  j,j1,j2,ps,per,alpha,per1
c-----------------------------------------------------------------------

      write(unit,*)
      if (iter.lt.10) then
      write(unit,'(a,I2)')    '  MINIMIZER   ITER=       ',iter
      else if (iter.lt.100) then
      write(unit,'(a,I3)')    '  MINIMIZER   ITER=       ',iter
      else
      write(unit,'(a,I4)')    '  MINIMIZER   ITER=       ',iter
      endif
      if (nint((j/per)*10.).lt.100) then
      write(unit,'(a,F3.1)')  '  MINIMIZER   %J=          ',real(j/per)
      elseif (nint((j/per)*10.).lt.1000) then
      write(unit,'(a,F4.1)')  '  MINIMIZER   %J=          ',real(j/per)
      else 
      write(unit,'(a,F5.1)')  '  MINIMIZER   %J=          ',real(j/per)
      endif
      if (nint((j1/per1)*10.).lt.100) then
      write(unit,'(a,F3.1)')  '  MINIMIZER   %J1=         ',
     1                        real(j1/per1)
      elseif (nint((j1/per1)*10.).lt.1000) then
      write(unit,'(a,F4.1)')  '  MINIMIZER   %J1=         ',
     1                        real(j1/per1)
      else 
      write(unit,'(a,F5.1)')  '  MINIMIZER   %J1=         ',
     1                        real(j1/per1)
      endif
      write(unit,'(a,E11.4)') '  MINIMIZER   J=          ',real(j)
      write(unit,'(a,E11.4)') '  MINIMIZER   J1=         ',real(j1)
      write(unit,'(a,E11.4)') '  MINIMIZER   J2=         ',real(j2)
c---->for the last iteration the norm of the gradient is not calculated
c---->because the gradient is not calculated so ps is set to -1. in the
c---->call line to info
      if (alpha.ne.1.) then 
      write(unit,'(a,E11.4)') '  MINIMIZER   STEP=       ',real(-alpha)
      endif
      if (ps.ne.-1.) then 
      write(unit,'(a,E11.4)') '  MINIMIZER   GRAD NORM=  ',real(ps)
      endif



      return
      end
