C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
      subroutine help
c***********************************************************************
c
c     PRINT HELP MESSAGES AND QUIT
c
c***********************************************************************
      write(6,'(a)')'************************************************'//
     &     '************************'
      write(6,'(a)')'mkusp can create a usp file of several different'//
     &     ' types.'
      write(6,'(a)')'      (-RAN is the default)'
      write(6,'(a)')' '
      write(6,'(a)')'Execute mkusp by typing mkusp and the list of pa'//
     &     'rameters.'
      write(6,'(a)')'Users enter the following parameters, or use def'//
     &     'ault values:'
      write(6,'(a)')' '
      write(6,'(a)')'************************************************'//
     &     '************************'
      write(6,'(a)')'   PARAM           DESCRIPTION                  '//
     &     '             DEFAULT'
      write(6,'(a)')'************************************************'//
     &     '************************'
      write(6,'(a)')' Parameters used in all cases:'
      write(6,'(a)')' '
      write(6,'(a)')' -O[otap]          output data file name        '//
     &     '             stdout'
      write(6,'(a)')' -nrec[nrec]       number of records            '//
     &     '             none'
      write(6,'(a)')' -ntrc[ntrc]       number of traces             '//
     &     '             none'
      write(6,'(a)')' -ntrc[nsmp]       number of samples            '//
     &     '             none'
      write(6,'(a)')' -V                include on command line if ve'//
     &     'rbose'
      write(6,'(a)')'                   printout is desired'
      write(6,'(a)')' '
      write(6,'(a)')' If -COS (cosine signal) is specified:'
      write(6,'(a)')' '
      write(6,'(a)')' -t[time]          time per trace (sec)         '//
     &     '             1.0'
      write(6,'(a)')' '
      write(6,'(a)')' If -INT (integer pattern) is specified:'
      write(6,'(a)')' '
      write(6,'(a)')' -t[time]          time per trace (sec)         '//
     &     '             1.0'
      write(6,'(a)')' -off[off]         offset                       '//
     &     '             0'
      write(6,'(a)')' -rad[rad]         radix                        '//
     &     '             512'
      write(6,'(a)')' '
      write(6,'(a)')' If -SIG ( shifted signal generator) is specified:'
      write(6,'(a)')' '
      write(6,'(a)')' -F[ffile]         frequency file name          '//
     &     '             none'
      write(6,'(a)')' -nsi[nsi]         sample interval in millisec. '//
     &     '             1'
      write(6,'(a)')' -nxshft[nxshft]   sample shift in x direction  '//
     &     '             2'
      write(6,'(a)')' -nyshft[nxshft]   sample shift in y direction  '//
     &     '             3'
      write(6,'(a)')' -C                if included complex samples a'//
     &     're produced'
      write(6,'(a)')'                   full number of samples is thu'//
     &     's = 2 * nsmp'
      write(6,'(a)')' '
      write(6,'(a)')' If -RAN (random numbers) is specified: (DEFAULT)'
      write(6,'(a)')' '
      write(6,'(a)')' -t[time]          time per trace (sec)         '//
     &     '             1.0'
      write(6,'(a)')' -lbnd[lbnd]       random sample lower bound    '//
     &     '             0.0'
      write(6,'(a)')' -ubnd[ubnd]       random sample upper bound    '//
     &     '             1.0'
      write(6,'(a)')' -seed[iseed]      random sample generator seed '//
     &     '             987654321'
      write(6,'(a)')' '
      write(6,'(a)')'************************************************'//
     &     '************************'
      write(6,'(a)')'  USAGE: mkusp -O[otap]'
      write(6,'(a)')'               -nrec[nrec] -ntrc[ntrc] -nsmp[nsmp]'
      write(6,'(a)')'               <-COS -t[time]>'
      write(6,'(a)')'               <-INT -t[time] -off[off] -rad[rad]>'
      write(6,'(a)')'               <-SIG -F[ffile] -nsi[nsi] -nxshft'//
     &     '[nxshft] -nyshft[nyshft] -C>'
      write(6,'(a)')'               <-RAN -t[time] -lbnd[lbnd] -ubnd['//
     &     'ubnd] -seed[iseed]>'
      write(6,'(a)')'                -V'
      write(6,'(a)')'************************************************'//
     &     '************************'
      write(6,'(a)')' CASE SPECIFIC NOTES:'
      write(6,'(a)')' '
      write(6,'(a)')'If -COS is specified mkusp creates a usp file sp'//
     &     'ecified by:'
      write(6,'(a)')'    val(it,ix) = cos( w*t )'
      write(6,'(a)')'    where w = 2*pi*ix,  and t = dt * (it-itbias),'
      write(6,'(a)')'    and itbias is the shift from record to record'
      write(6,'(a)')' '
      write(6,'(a)')'If -INT is specified, mkusp creates a usp file s'//
     &     'pecified by:'
      write(6,'(a)')'    val(it,ix,iy)= off + mod(it,rad) + rad * mod'//
     &     '(ix,rad)'
      write(6,'(a)')'                                  + rad**2 * mod'//
     &     '(iy,rad)'
      write(6,'(a)')' '
      write(6,'(a)')'If -SIG is specified, mkusp creates a usp file s'//
     &     'pecified by:'
      write(6,'(a)')'    val(it,ix,iy) = signal( index ) , where inde'//
     &     'x ='
      write(6,'(a)')'      mod( (ix-1)*nxshft +(iy-1)*nyshft + (it-1)'//
     &     ' , nsmp)'
      write(6,'(a)')'    and the signal amplitudes are generated from'//
     &     ' the'
      write(6,'(a)')'    frequency file specified by ffile.'
      write(6,'(a)')'    This file must contain:'
      write(6,'(a)')'       nfreq'
      write(6,'(a)')'       frequency   amplitude  phase ( nfreq entr'//
     &     'ies )'
      write(6,'(a)')' '
      write(6,'(a)')'If -RAN is specified, mkusp creates a usp file i'//
     &     'n which'
      write(6,'(a)')'   the samples are filled with random numbers un'//
     &     'iformly'
      write(6,'(a)')'   distributed from parameters lbnd to ubnd, see'//
     &     'ded with iseed.'
      write(6,'(a)')' '
      write(6,'(a)')'************************************************'//
     &     '************************'
c***********************************************************************
      stop
      end
c***********************************************************************
