C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
      subroutine siggen( nw, nt, dt, amp, freq, phase, x )
c***********************************************************************
c     GENERATE SIGNAL
c***********************************************************************
      integer nt                ! element count for x
      integer nw                ! number of frequencies
      real    dt                ! delta t
      real    amp  (nw)         ! amp(i)   = amplitude of the i-th component
      real    freq (nw)         ! freq(i)  = frequency of the i-th component
      real    phase(nw)         ! phase(i) = phase of the i-th component
      real    x    (0:nt-1)     ! output signal

c     local variables

      real     a                ! amplitude
      integer  jt               ! time (sample) index
      integer  jw               ! frequency index
      real     pi               ! pi
      real     phi              ! phase angle (radians)
      real     t                ! time
      real     w                ! angular frequency

c***********************************************************************

      if( nt .le. 0  .or. nw .le. 0 ) return

c     clear x

      do jt = 0, nt-1
         x(jt) = 0.0
      enddo

c     add frequency components

      pi = acos( -1.0 )
      do jw = 1, nw
         a   = amp(jw)
         w   = 2.0 * pi * freq(jw)
         phi = phase(jw) * pi / 180.0
         do jt = 0, nt-1
            t = dt * float( jt )
            x(jt) = x(jt) + a * cos( w * t + phi )
         enddo
      enddo

c***********************************************************************
      return
      end
c***********************************************************************
