C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c this subroutine warps a gamma spectra created after migration with     
c a velocity field to reflect the picks.

      subroutine subs (ntr, nsamp, vel1, vel2, 
     1                 resid, semb, nrec, jrec,
     1                 rec, trac, samp, npts, no_seg, 
     1                 rec2, trac2, samp2, npt2, noseg2, 
     1                 ngamma, dgamma, 
     1                 dz, pow, iopt, slowmn, dslow)
 
      parameter (defalt = -999.)
      real      vel1(nsamp, nrec)
      real      vel2(nsamp, nrec)
      real      resid(nsamp, nrec)
      real      semb(nsamp, ngamma)
      real      rec(*), trac(*), samp(*)
      integer   npts(no_seg)
      real      rec2(*), trac2(*), samp2(*)
      integer   npt2(noseg2)
      real      dgamma, dz
      real      contig1, contig2, slow1, slow2, tmp1, tmp2
      pointer   (ptmp1, tmp1(1))
      pointer   (ptmp2, tmp2(1))
      pointer   (pcontig1, contig1(1))
      pointer   (pcontig2, contig2(1))
      pointer   (pslow1, slow1(1))
      pointer   (pslow2, slow2(1))
      logical   ftf
      data      ftf/.true./
      data      init/1/
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c pass through first time logic
      if(ftf)then

c allocate some arrays
         ftf=.false.
         call galloc (pslow1,ngamma*SZSMPD,jerr,iabort)
         call galloc (pslow2,ngamma*SZSMPD,jerr,iabort)
         call galloc (pcontig1,ngamma*SZSMPD,jerr,iabort)
         call galloc (pcontig2,ngamma*SZSMPD,jerr,iabort)
         call galloc (ptmp1,4*ngamma*SZSMPD,jerr,iabort)
         call galloc (ptmp2,ngamma*SZSMPD,jerr,iabort)

c compute original rms velocity
         timax=0
         dv2tmx=0.
         dv2tmn=10000000000.
         do irec=1,nrec
            t=0
            v2t=0
            do isamp=1,nsamp
               dt=dz/vel1(isamp,irec)
               dv2t=(vel1(isamp,irec)**pow)*dt
               t=t+dt
               v2t=v2t+dv2t
               vel1(isamp,irec)=(v2t/t)**(1./pow)
               if(t.gt.timax)timax=t
               if(dv2t.gt.dv2tmx)dv2tmx=dv2t
               if(dv2t.lt.dv2tmn)dv2tmn=dv2t
            enddo
         enddo
         nsampt=(timax/dt+1.5)

c compute updated rms velocity
         if(iopt.eq.1)then
            timax=0
            dv2tmx=0.
            dv2tmn=10000000000.
            do irec=1,nrec
               t=0
               v2t=0
               do isamp=1,nsamp
                  dt=dz/vel2(isamp,irec)
                  dv2t=(vel2(isamp,irec)**pow)*dt
                  t=t+dt
                  v2t=v2t+dv2t
                  vel2(isamp,irec)=(v2t/t)**(1./pow)
                  if(t.gt.timax)timax=t
                  if(dv2t.gt.dv2tmx)dv2tmx=dv2t
                  if(dv2t.lt.dv2tmn)dv2tmn=dv2t
               enddo
            enddo
            nsampt=max(nsampt,ifix(timax/dt+1.5))
         endif

c initialize the gamma array
         do irec=1,nrec
            do isamp=1,nsamp
               resid(isamp,irec)=defalt
            enddo
            resid(1,irec)=ngamma/2+1
            resid(nsamp,irec)=ngamma/2+1
         enddo

c read picks and put into arrays
         inpick=0
         do iseg=1,no_seg

            do ipnt=1,npts(iseg)
               inpick=inpick+1
               inpck2=0
               do i2=1,iseg-1
                  inpck2=inpck2+npt2(i2)
               enddo
               do j2=1,npt2(iseg)
                  inpck2=inpck2+1
                  if(nint(trac(inpick)).eq.nint(trac2(inpck2)))then

                     isamp=nint(samp(inpick))
                     if(isamp.lt.1.or.isamp.gt.nsamp)isamp=nsamp
                     jgam=nint(samp2(inpck2))
                     if(jgam.lt.1.or.jgam.gt.ngamma)jgam=ngamma/2+1
                     itrace=nint(trac(inpick))
                     if(itrace.ge.1.and.itrace.le.nrec)then
                        resid(isamp,itrace)=jgam
                        samp2(inpck2)=ngamma/2+1
                     endif

                  endif
               enddo
            enddo
         enddo

c interpolate the gamma field
         do irec=1,nrec
            call intrp ( resid(1,irec),nsamp,defalt )
         enddo
         do irec=1,nrec
            do isamp=1,nsamp
               if(resid(isamp,irec).eq.defalt)then
                  resid(isamp,irec)=ngamma/2+1
               endif
            enddo
         enddo
      endif

c morf from one gamma to corrected gamma 
      if(iopt.eq.1)then
c compute input slowness
         do isamp=1,nsamp
            dslow1=dgamma/vel1(isamp,jrec)
            gam=1
            gamma=1.+(gam-ngamma/2-1)*dgamma
            slow1(1)=gamma/vel1(isamp,jrec)
            do igam = 2, ngamma
               slow1(igam)=slow1(igam-1)+dslow1
            enddo

c compute output slowness
            velnew=vel2(isamp,jrec)
            dslow2=dgamma/velnew
            gam=1
            gamma=1.+(gam-ngamma/2-1)*dgamma
            slow2(1)=gamma/velnew
            do igam = 2, ngamma
               slow2(igam)=slow2(igam-1)+dslow2
            enddo

c put semblances in contiguous buffer      
            do igam=1,ngamma
               contig1(igam)=semb(isamp,igam)
            enddo

c reinterpolate the data
            call ccuint(slow1(1),contig1(1),ngamma, 
     &                  slow2(1),contig2(1),ngamma, 
     &                  tmp1,tmp2,init)

c put the contiguous data back into output array
            do igam=1,ngamma
               semb(isamp,igam)=contig2(igam)
            enddo
         enddo

c morf from focusing panel to slowness scans
      else if(iopt.eq.2)then
c compute input slowness
         do isamp=1,nsamp
            dslow1=dgamma/vel1(isamp,jrec)
            gam=1
            gamma=1.+(gam-ngamma/2-1)*dgamma
            slow1(1)=gamma/vel1(isamp,jrec)
            do igam = 2, ngamma
               slow1(igam)=slow1(igam-1)+dslow1
            enddo

            do igam=1,ngamma
               slow=(igam-1)*dslow+slowmn
               isave=1
               diff=abs(slow1(1)-slow)
               do jgam=2,ngamma
                  if(abs(slow1(jgam)-slow).lt.diff)then
                     diff=abs(slow1(jgam)-slow)
                     isave=jgam
                  endif
               enddo
               slow2(igam)=semb(isamp,isave)
            enddo
            do igam = 2, ngamma
               semb(isamp,igam)=slow2(igam)
            enddo
         enddo
      endif
 
      return
      end
