C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       MXCVEL                                               *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  TO CREATE AN SIS TYPE VELOCITY TAPE FROM MXCFILE & VEL'S  *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 89/03/09  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 89/03/17  *
C  FILES:                                                              *
C      LCRD  ( INPUT  SEQUENTIAL ) -                                   *
C      LPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C      LTRM  ( OUTPUT SEQUENTIAL ) -                                   *
C      LMXC  ( INPUT  SEQUENTIAL ) -                                   *
C      0     ( standard in for c routines  )                           *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 5) - no errors                                       *
C      =50   =  ( 5) - error on input cards                            *
C      =75   =  ( 5) - tapeio error                                    *
C      =100  =  ( 5) - user error                                      *
C      =200  =  ( 5) - error opening printout                          *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  THIS ROUTINE READS A FINDIF  STRUCTURED       *
C       - DIGITIZED MODEL, A PARAMETER FILE, AND GENERATES AN SIS TYPE *
C       - VELOCITY TAPE                                                *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/03/17  *
C       - ADD VERTICAL AND HORIZONTAL GRADIENTS TO REGIONS             *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/05/23  *
C       - remove the 1500 extra points at bottom of velocity matrix    *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/01/30  *
C       - multiply dx & dz by 1000 to preserve decimal places          *
C       - read MSTS flag, for example zmatrx makes 4 indices for a model
C       -   with 3 closed contours, and velocities will be off by one  *
C       -   index on the MSTS created mxc files                        *
C       - constrain velocities between vmin and vmax                   *
C       - make sure no zero velocities lie along the bottom of matrix  *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/02/08  *
C       - make a special check after each card is read to determine if *
C       - v2 and v3 are zero and v1 not zero.  If this is true force   *
C       - the no gradient situation without checking other card values *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/06/29  *
C       - Add a VMAX parameter to use for clipping data rather than    *
C       - using a velocity read in with the x,z points. Then check for *
c       - zero or negative values on low end.  This means the data will*
C       - need to be scanned for VMAX/VMIN to put in lineheader before *
C       - the traces are written to tape as is done now(VLARGE,VSMALL) *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/06/29  *
C       - increase no.points/contour to 200 and no. contours to 100    *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/07/16  *
C       - increase no.traces to 2500                                   *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/07/16  *
C       - increase no.traces to 8000                                   *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/08/14  *
C       - corrected error in write statements                          *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/09/21  *
C       - added a write statement to lu = 0 on normal completion       *
C  REVISED BY:  N. D. WHITMORE, Jr.           REVISION DATE: 90/09/21  *
C       - created vtmod.f from mxcvel.f - change is if an input tape   *
C       - is given, the output tape will be a modified version of the  *
C       - input; new contours can be added and the old backdrop used   *
C       - when the velocity is zero                                    *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/11/09  *
C       - take Dan's vtmod.f and change no. points/contour to 3000 and *
C       - call it mxcvel and not vtmod                                 *
C       -  (see arrays savk, tabx, taby and the 102 loop in zmatrx)    *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 90/11/14  *
C       - change number of contours to 200  (see MAXCONT = 200)        *
C       - added a variable MAXPNTS = 3000                              *
C       - added checks for user exceeding no. contours and no. points  *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/02/25  *
C       - put dxgrid into line header positions 'GrpInt' and DptInt'   *
C       - and add code to check for english or metric units and add to *
C       - header in location 'UnitFl'                                  *
C  REVISED BY:  N. D. Whitmore, Jr.           REVISION DATE: 91/03/14  *
C       - Changed maximum number of traces to 8000                     *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/06/20  *
C       - Changed maximum MAXPNTS to 8000                              *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/08/02  *
C       - Change for system maintenance on Sun - include 4 files,      *
C       - check for byte counts, check for 'move', add saver,savew     *
C  REVISED BY:  David W. Nelson               REVISION DATE: 92/01/13  *
C       - Add units flag -U with f=feet and m=meters                   *
C  REVISED BY:  MARY ANN THORNTON  V: 2.3     REVISION DATE: 92/03/25  *
C       - Call openpr with full program name for OS 6.1                *
C  REVISED BY:  MARY ANN THORNTON  V: 2.4     REVISION DATE: 92/06/23  *
C       - Add more error checking for opening input cards              *
C  REVISED BY:  MARY ANN THORNTON  V: 2.5     REVISION DATE: 93/03/23  *
C       - Allow more horizons                                          *
C  REVISED BY:  MARY ANN THORNTON  V: 2.7     REVISION DATE: 93/05/25  *
C       - Add logical unit for HP,                                     *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
      PARAMETER (NXMAX=8000,NZMAX=2001,MAXNV=500)
      PARAMETER (LCRD=25,LPRT=26,LLIST=27,LUMXC=62,LHEAD=6000)
      DIMENSION V(NZMAX,NXMAX)
C     HEADER ARRAYS:
      DIMENSION IHEAD(LHEAD)
      INTEGER*2 IRX(LNTRHD)
      DIMENSION   RXX(NZMAX+ITRWRD),DATA(NZMAX)
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))
C     CHARACTER ARRAYS:
      CHARACTER*1   CARD(80),PARR(66),BLANK(80)
      CHARACTER*1   units
      CHARACTER*6   PPNAME
      CHARACTER*4   VERSION
      CHARACTER*128 NTAP, OTAP, INPUT, MODEL
      CHARACTER*4   WORD4, GI

C     ZMATRX ARRAYS:
      INTEGER    CON(NXMAX)   ,INDREC(NXMAX)
      DIMENSION  FH(502,NXMAX)
      DIMENSION  VEL(MAXNV)
      DIMENSION  A(MAXNV), B(MAXNV), C(MAXNV), D(MAXNV)
      DIMENSION X1(MAXNV),X2(MAXNV),X3(MAXNV)
      DIMENSION Z1(MAXNV),Z2(MAXNV),Z3(MAXNV)
      DIMENSION V1(MAXNV),V2(MAXNV),V3(MAXNV),VMULT(MAXNV)

C     OUTPUT DATA ARRAY
      DATA VERSION/' 2.7'/
      DATA PPNAME/'MXCVEL'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ','C','R',
     2          'E','A','T','E',' ','A',' ','V','E','L',
     3          'O','C','I','T','Y',' ','T','A','P','E',
     4          ' ','F','R','O','M',' ','M','X','C',' ',
     5          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     6          ' ',' ',' ',' ',' ',' '/
      DATA BLANK/80*' '/
C
      LTRM = LER
      CALL cmdlin(NTAP,OTAP,INPUT,MODEL,MSTS,IPIPO,IPIPI,LTRM,units)
      IF(IPIPI.EQ.0) THEN
C        LU1 IS A INPUT DATASET
         CALL LBOPEN(LU1,NTAP,'R')
      ELSE
C        WE KNOW LU1 IS NOT SPECIFIED
         LU1=1
      ENDIF
      IF(IPIPO.EQ.0) THEN
C        LU2 IS A OUTPUT DATASET
         CALL LBOPEN(LU2,OTAP,'W')
      ELSE
C        WE KNOW LU2 IS A PIPE
         LU2=1
      ENDIF

C     OPEN MODEL FILE(MXC) AND/OR CARD FILE
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include<mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(LPRT,37)NTAP
   37 FORMAT(' INPUT DATASET = '/,A128)
      WRITE(LPRT,38)OTAP
   38 FORMAT(' OUTPUT DATASET = '/,A128)
      IF(MODEL.NE.' ')THEN
         OPEN(UNIT=LUMXC,FILE=MODEL,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(LPRT,*)'  ERROR OPENING MODEL CARDS'
            STOP 50
         ENDIF
      ELSE
         WRITE(LPRT,*)' MODEL CARDS MUST BE SUPPLIED'
         STOP 100
      ENDIF
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(LPRT,*)'  ERROR OPENING EXTERNAL CARD FILE'
            STOP 50
         ENDIF
      ELSE
         N=ICOPEN('-mxcvel.crd',LCRD)
         IF(N.EQ.0)THEN
           WRITE(LPRT,39)
   39      FORMAT('  ERROR OPENING INLINE CARD FILE')
           STOP 50
         ENDIF
      ENDIF

C     READ INPUT CARDS
      READ(LCRD,5)CARD
    5 FORMAT(80A1)
      READ(LCRD,155)STARTX,NXGRID,DXGRID,STARTZ,NZGRID,DZGRID,VMAX
  155 FORMAT(F10.0,I10,2F10.0,I10,F10.0,F10.0)
      WRITE(LPRT,10)
   10 FORMAT (//, 27X, 'PROGRAM PARAMETERS',//)
      WRITE(LPRT,11)STARTX,NXGRID,DXGRID,STARTZ,NZGRID,DZGRID
   11 FORMAT(
     *' X-LOCATION TO BEGIN VELOCITY MATRIX    ', 10X,'=',F10.0,/
     *' NO. OF TRACES IN THE VELOCITY MATRIX   ', 10X,'=',I10  ,/
     *' DELTA-X, VELOCITY GRID SPACING         ', 10X,'=',F10.0,/
     *' Z-LOCATION TO BEGIN VELOCITY MATRIX    ', 10X,'=',F10.0,/
     *' NO. GRID POINTS IN THE Z-DIRECTION     ', 10X,'=',I10  ,/
     *' DELTA-Z VELOCITY GRID SPACING          ', 10X,'=',F10.0)
      IF(VMAX.GT.0.0) WRITE(LPRT,77)VMAX
      IF(VMAX.LE.0.0) WRITE(LPRT,*)' DATA WILL NOT BE CLIPPED'
   77 FORMAT(' DATA WILL BE CLIPPED TO                ', 10X,'=',F10.0)
      IF(MSTS.EQ.0) WRITE(LPRT,12)
      IF(MSTS.EQ.1) WRITE(LPRT,13)
   12 FORMAT(' MXC FILE NOT CREATED FROM MSTS ')
   13 FORMAT(' MXC FILE CREATED FROM MSTS')
      IF(units.EQ.'f' .or. units.eq.'F') WRITE(LPRT,14)
      IF(units.EQ.'m' .or. units.eq.'M') WRITE(LPRT,15)
   14 FORMAT(' UNITS ARE IN FEET ')
   15 FORMAT(' UNITS ARE IN METERS ')
C     CHECK ALL PARAMETERS
      IF(DXGRID .LE. 0.) THEN
       WRITE(LPRT,*) 'ERROR:  DXGRID CANNOT BE .LE. 0.0'
       STOP 100
      ENDIF
      IF(DZGRID .LE. 0.) THEN
       WRITE(LPRT,*) 'ERROR:  DZGRID CANNOT BE .LE. 0.0'
       STOP 100
      ENDIF
      IF(NXGRID  .LE. 0) THEN
       WRITE(LPRT,*) 'ERROR:  NO. TRACES CANNOT BE .LE. 0'
       STOP 100
      ENDIF
      ZEND = NZGRID * DZGRID

C     VELOCITY CARD AND NUMBER OF VELOCITIES
      READ(LCRD,'(A4,I3)') WORD4,NV
      IF(WORD4.NE.'VELO') THEN
         WRITE(LPRT,*) '"VELOCITIES" CARD NOT FOUND'
         STOP 100
      ENDIF

      WRITE(LPRT,*) '                              '
      WRITE(LPRT,*) '   NUMBER   VELOCITY          '
      WRITE(LPRT,*) '                              '
   29 FORMAT(I7,9F7.0)
      XMAX = NXGRID
      ZMAX = NZGRID
      ICASE=4
      DO 40 J=1,NV
         READ(LCRD,29)IV,X1(J),Z1(J),V1(J),
     1                   X2(J),Z2(J),V2(J),
     2                   X3(J),Z3(J),V3(J)
         IF(IV.NE.J) THEN
            WRITE(LPRT,*) 'VELOCITIES NOT IN ORDER'
            STOP 100
         ENDIF
C        CASE 1 - SPECIAL CHECK FOR 2 ZERO VELOCITIES (FORCE CASE=1)
         IF(V1(J).NE.0.0 .AND. V2(J).EQ.0.0 .AND. V3(J).EQ.0.0) THEN
            X1(J) = 0.0
            X2(J) = XMAX
            X3(J) = XMAX
            Z1(J) = 0.0
            Z2(J) = 0.0
            Z3(J) = ZMAX
            V2(J) = V1(J)
            V3(J) = V1(J)
            WRITE(LPRT,*)' REGION ',J,' NO GRADIENTS'
            ICASE = 1
            GO TO 30
         ENDIF
C        CASE 1
         IF(X1(J).EQ.0.0 .AND. X2(J).EQ.0.0 .AND. X3(J).EQ.0.0 .AND.
     1      Z1(J).EQ.0.0 .AND. Z2(J).EQ.0.0 .AND. Z3(J).EQ.0.0 )THEN
            X2(J) = XMAX
            X3(J) = XMAX
            Z3(J) = ZMAX
            V2(J) = V1(J)
            V3(J) = V1(J)
            WRITE(LPRT,*)' REGION ',J,' NO GRADIENTS'
            ICASE = 1
            GO TO 30
         ENDIF
C        CASE 2
         IF((X1(J).EQ.0.0 .AND. X2(J).EQ.0.0 .AND. X3(J).EQ.0.0) .AND.
     1      (Z1(J).NE.0.0  .OR. Z2(J).NE.0.0  .OR. Z3(J).NE.0.0))THEN
             X1(J) = 0.0
             X2(J) = 0.0
             X3(J) = XMAX
             V3(J) = V1(J)
             Z3(J) = Z1(J)
             WRITE(LPRT,*)' REGION ',J,' VERTICAL GRADIENTS'
             ICASE=2
             GO TO 30
         ENDIF
C        CASE 3
         IF((Z1(J).EQ.0.0 .AND. Z2(J).EQ.0.0 .AND. Z3(J).EQ.0.0) .AND.
     1      (X1(J).NE.0.0  .OR. X2(J).NE.0.0  .OR. X3(J).NE.0.0)) THEN
            Z1(J) = 0.0
            Z2(J) = 0.0
            Z3(J) = ZMAX
            V3(J) = V1(J)
            X3(J) = X1(J)
            WRITE(LPRT,*)' REGION ',J,' HORIZONTAL GRADIENTS'
            ICASE=3
            GO TO 30
         ENDIF
C        CASE 4
         IF(ICASE.EQ.4)THEN
            WRITE(LPRT,*)' REGION ',J,' HORZ & VERT GRADIENTS'
         ENDIF
   30    CONTINUE
         WRITE(LPRT,41)IV,X1(J),Z1(J),V1(J),X2(J),Z2(J),V2(J),
     1   X3(J),Z3(J),V3(J)
   40 CONTINUE
   41 FORMAT(I8,9F8.0)
C***********************************************************************
C     EVALUATE THE DETERMINANT
C***********************************************************************
      DO 50 J=1,NV
         D(J) = X1(J) * (Z2(J)-Z3(J)) -
     1          X2(J) * (Z1(J)-Z3(J)) +
     2          X3(J) * (Z1(J)-Z2(J))
         IF(D(J).EQ.0.0)THEN
            WRITE(LPRT,*)' BAD POINTS CHOSEN FOR REGION',J
            WRITE(LPRT,*)' ******PROGRAM TERMINATED******'
            STOP 100
         ENDIF
         A(J) = (V1(J) * (Z2(J)-Z3(J)) -
     1           V2(J) * (Z1(J)-Z3(J)) +
     2           V3(J) * (Z1(J)-Z2(J)) ) / D(J)

         B(J) = (X1(J) * (V2(J)-V3(J)) -
     1           X2(J) * (V1(J)-V3(J)) +
     2           X3(J) * (V1(J)-V2(J)) ) / D(J)

         C(J) = (X1(J) * (Z2(J)*V3(J) - Z3(J)*V2(J)) -
     1           X2(J) * (Z1(J)*V3(J) - Z3(J)*V1(J)) +
     2           X3(J) * (Z1(J)*V2(J) - Z2(J)*V1(J)) )/ D(J)
         IF(V1(J).LE.0. .AND. V2(J).LE.0. .AND. V3(J).LE.0.) THEN
         VMULT(J)=1.0
         ELSE
         VMULT(J)=0.0
         ENDIF
   50 CONTINUE
      DO 60 J=1,NV
         WRITE(LPRT,55)J,A(J),B(J),C(J)
   60 CONTINUE
   55 FORMAT(I10,3F20.8)

C     READ INPUT VELOCITY TAPE IF IT EXISTS
      IF(IPIPI.EQ.0) THEN
        IEOF=0
        CALL RTAPE(LU1,IHEAD,IEOF)
        IF(IEOF.EQ.0) THEN
           WRITE(LPRT,*) 'ERROR ON INPUT TAPE'
           WRITE(ler,*) 'ERROR ON INPUT TAPE'
           STOP 100
        ENDIF
        CALL SAVER(IHEAD,'NumTrc',NXIN,LINHED)
        CALL SAVER(IHEAD,'NumSmp',NZIN,LINHED)

        DO 200 JX=1,NXIN
          CALL RTAPE(LU1,RXX,IEOF)
          IF(IEOF.EQ.0) THEN
             WRITE(LPRT,*) 'ERROR ON INPUT TAPE,TRACE ', JX
             WRITE(ler,*) 'ERROR ON INPUT TAPE,TRACE ', JX
             STOP 100
          ENDIF
          DO 201 JZ=1,NZIN
            V(JZ,JX) = DATA(JZ)
  201     CONTINUE
  200   CONTINUE

        IF(NXIN.LT.NXGRID) THEN
          DO 202 JX=NXIN+1,NXGRID
             DO 203 JZ=1,NZIN
               V(JZ,JX) = V(JZ,NXIN)
  203        CONTINUE
  202     CONTINUE
        ENDIF

        IF(NZIN.LT.NZGRID) THEN
           DO 204 JX=1,NXGRID
             DO 205 JZ=NZIN+1,NZGRID
               V(JZ,JX) = V(NZIN,JZ)
  205        CONTINUE
  204      CONTINUE
        ENDIF

      ENDIF

C***********************************************************************
C     BUILD VELOCITY MATRIX
C***********************************************************************
      CALL ZMATRX(LUMXC,LPRT,DXGRID,DZGRID,STARTX,NXGRID,STARTZ,ZEND,FH
     1,CON,INDREC,V,VEL,NZMAX,NXMAX,A,B,C,D,MSTS,VMULT)

C***********************************************************************
C      CHECK VELOCITIES FOR GT VMAX AND LE ZERO AND FIND MAXIMUM VELOCITY
C      FOR WRITING INTO THE LINE HEADER
C***********************************************************************
       VLARGE = 0.0
       VSMALL = 1000000000.
       DO 100 JX=1,NXGRID
          DO 75 JZ=1,NZGRID
             IF(V(JZ,JX) .LE. 0.0)THEN
                WRITE(LPRT,85) JZ, JX
                STOP 100
             ENDIF
             IF(VMAX.GT.0.0) THEN
                IF(V(JZ,JX) .GT. VMAX) V(JZ,JX) = VMAX
             ENDIF
             IF(V(JZ,JX) .LT. VSMALL) VSMALL = V(JZ,JX)
             IF(V(JZ,JX) .GT. VLARGE) VLARGE = V(JZ,JX)
   75     CONTINUE
  100 CONTINUE
   85 FORMAT(' JOB TERMINATED - ZERO OR NEGATIVE VELOCITY FOUND ',
     &      'AT DEPTH ',I6,' ON TRACE ',I6)
C***********************************************************************
C     TRACE PROCESSING BEGINS
C***********************************************************************
      idx = dxgrid
      write(gi,23)idx
   23 format(I4)
      IDXX = DXGRID*1000.
      IDZZ = DZGRID*1000.
      IVMIN = VSMALL
      IVMAX = VLARGE
C     PROCESS OUTPUT LINE HEADER
      CALL VMOV(BLANK,1,IHEAD,1,10)
      CALL VCLR(IHEAD(11),1,1490)
      CALL VMOV(BLANK,1,IHEAD(18),1,2)
      CALL VMOV(BLANK,1,IHEAD(21),1,2)
      CALL SAVEW(IHEAD, 'NumTrc', NXGRID, LINHED)
      CALL SAVEW(IHEAD, 'NumRec', 1,      LINHED)
      CALL SAVEW(IHEAD, 'SmpInt', 2,      LINHED)
      CALL SAVEW(IHEAD, 'NumSmp', NZGRID, LINHED)
      CALL SAVEW(IHEAD, 'Format', 3,      LINHED)
      CALL SAVEW(IHEAD, 'Dx1000', IDXX, LINHED)
      CALL SAVEW(IHEAD, 'Dz1000', IDZZ, LINHED)
      CALL SAVEW(IHEAD, 'MinVel', IVMIN, LINHED)
      CALL SAVEW(IHEAD, 'MaxVel', IVMAX, LINHED)
      IHEAD(324) = 2*SZSMPD
c     code goes here to try to determine metric units from english
c     iunits = 0 = feet; iunits = 1 = meters;
      if (units.eq.' ') then
        iunits = 0
        if(vsmall .lt. 4000 .and. vlarge .lt. 7000) iunits = 1
      elseif (units.eq.'f' .or. units.eq.'F') then
        iunits=0
      elseif (units.eq.'m' .or. units.eq.'M') then 
        iunits=1
      else
        iunits=0
      endif
      CALL SAVEW(IHEAD, 'DptInt', IDX, LINHED)
      CALL SAVEW(IHEAD, 'UnitFl', iunits, LINHED)
      CALL SAVEW(IHEAD, 'GrpInt', GI, LINHED)
      JEOF = 324*SZSMPD
      LEN=6
      CALL HLHPRT(IHEAD,JEOF,PPNAME,LEN,LPRT)
      CALL WRTAPE(LU2,IHEAD,JEOF)
      IF(JEOF.EQ.0)THEN
         WRITE(LPRT,*)' ERROR WRITING LINEHEADER'
         STOP  75
      ENDIF
      KBYTES = NZGRID*SZSMPD
      JBYTES = KBYTES + SZTRHD
      CALL VCLR(IRX,1,ITRWRD)
C***********************************************************************
C      RECORD LOOP 100:
C***********************************************************************
       CALL SAVEW(IRX,'RecNum',1,TRCHED)
       DO 300 JX=1,NXGRID
          IRX(107) = JX
          DO 175 JZ=1,NZGRID
             DATA(JZ) = V(JZ,JX)
  175     CONTINUE
          CALL WRTAPE(LU2,RXX,JBYTES)
          IF(JBYTES.EQ.0) THEN
             WRITE(LPRT,*) 'ERROR IN OUTPUT TRACE=',JX
             STOP 75
          ENDIF
  300 CONTINUE
      CALL LBCLOS(LU2)
      WRITE(LPRT,*) ' JOB COMPLETE'
      WRITE(ler,*)  'normal exit'
      STOP
      END


      SUBROUTINE cmdlin(NTAP,OTAP,INPUT,MODEL,MSTS,IPIPO,IPIPI,LTRM,
     &                 units)
      INTEGER ARGIS
      LOGICAL HELP
      CHARACTER*128  NTAP,OTAP,INPUT,MODEL
      CHARACTER*1    units
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS -- MODIFY VEL TAPE '
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap]  .. INPUT DATASET NAME'
         WRITE(LTRM,*)'-O[otap]  .. OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-C[input] .. EXTERNAL CARD FILE'
         WRITE(LTRM,*)'-M[model] .. MODEL CARDS (MXC FILE)'
         WRITE(LTRM,*)'-F[msts]  .. 0 = Not MSTS FORMAT'
         WRITE(LTRM,*)'             1 = MSTS FORMAT'
         WRITE(LTRM,*)'-U[units] .. f or F = FEET'
         WRITE(LTRM,*)'             m or M = METERS'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'mxcvel -N[] -O[] -M[] -F[] -U[]'
         WRITE(LTRM,*)' Or, if there is not input tape to modify: '
         WRITE(LTRM,*)'mxcvel -O[] -M[] -F[] -U[]'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP,' ',' ')
      CALL ARGSTR('-O',OTAP,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      CALL ARGSTR('-M',MODEL,' ',' ')
      CALL ARGI4 ('-F',MSTS , 0, 0)
      CALL ARGSTR('-U',units,' ',' ')
C     SET FLAG IF THERE IS NO INPUT
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
