C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C NAME: mkvel - Routine to read a list of velocities and an 
C               Index matrix of the velocities V(z,x)
C***********************************************************************
C  Purpose: mkndx accepts an array (one whole record) of a velocity
C           index field, reads a list of velocities and the corresponding
C           index, then creates a real array of the velocities
C  Language:  Fortran 77
C
C  History:   Mary Ann Thornton     Version 1.0     August 1993
C
C  Parameters:
C    vlist  Input real array to hold the list of velocities
C    velist Input character array containing velocity list filename
C    vel    Input real array to contain the velocity field
C    ind    Input integer*2 array containing the velocity indices
C    nx     Input integer scalar - number of traces in x-direction
C    nz     Input integer scalar - number of samples in z-direction
C    jj     Input integer scalar - record number
C    ierr   Input integer scalar - an error flag
C***********************************************************************
      subroutine mkvel(vlist,velist,vel,ind,nx,nz,jj,ierr)
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
      real vlist(*)
      real vel(nz,nx)
      integer nx, nz, jj
      integer*2 ind(nz,nx)
      character velist*100, card*80
c-------------------------------------------
c     read vlist
c-------------------------------------------
      jerr = 0
      if(velist.ne.' ')then
        open(unit=LUCARD,file=velist,status='old',iostat=jerr)
        if(jerr.ne.0)then
          write(LERR,*)' Error opening list of velocities'
          ierr =  50
          return
        endif
      endif
      read(LUCARD,125,err=200)iv
      read(LUCARD,128,err=200)card
      do 10 i=1,iv
         read(LUCARD,126,end=25)j,vlist(i)
         ii = i
   10 continue
   25 continue
      if(ii.lt.iv)then
         write(LERR,*)' Expected ',iv,' velocities, read ',ii
         write(LER, *)' Expected ',iv,' velocities, read ',ii
      endif
      do 100 ix = 1,nx
         do 50 iz = 1,nz
            vel(iz,ix) = vlist(ind(iz,ix))
   50    continue
  100 continue
cc    do 110 iz = 1,nz,25
cc          write(LERR,127)(vel(iz,iii),iii=1,nx,12)
cc110 continue
  125 format(10x,i10)
  126 format(i10,f10.0)
  127 format(12f6.0)
  128 format(80a1)
      return
  200 continue
      write(LERR,*)' Error reading list of velocities'
      ierr = 100
      return
      end
