C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c     ndx2vel.F Read Velocity Index Field V(z,x)-Create Velocity V(z,x)
c     Mary Ann Thornton                     Version 1.0  August 10, 1993
c     Revised to remove 'call flush'        Version 1.1  Sept.  03, 1993
c***********************************************************************
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     lhed(SZLNHD)
      integer*2   itr(SZLNHD),ind(1)
      real        head(SZLNHD),vel(1)
      real        vlist(SZLNHD)
      integer     itrhdr(1)
      pointer     (pind,ind),(phdr,itrhdr),(pvel,vel)
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
      character   ntap * 100, otap * 100, name*7, version*4
      character   velist * 100
      logical     verbos, hlp, query
      integer     argis
      equivalence (itr(1), lhed(1), head(1))
      data name/'NDX2VEL'/, version /' 1.1'/ 
c---------------------------------------------------
      query = (argis ('-?').gt.0)
      hlp = (argis ('-h').gt.0)
      if (query)then
            call help()
            stop
      endif
      if ( hlp ) then
           call help()
           stop
      endif
c---------------------------------------------------
c     open printout files
#include <f77/mbsopen.h>
c---------------------------------------------------
c     get command line arguments 
      call cmdln(ntap,otap,velist,ns,ne,irs,ire,dx,dz,verbos)
c---------------------------------------------------
c     open the input,output files, read lineheader, get values,
c     write line header
c---------------------------------------------------
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      call rtape(luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'ndx2vel: no line header read from unit ',luin
         write(LOT,*)'Job Terminated'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'Dx1000', indx, LINHED)
      call saver(itr, 'Dz1000', indz, LINHED)
      call saver(itr, 'MinVel', ivmin, LINHED)
      call saver(itr, 'MaxVel', ivmax, LINHED)
      call hlhprt(itr, lbytes, name, 7, LERR)
      vmin = 0.0
      vmax = 0.0
      if(ivmin.gt.0)vmin = ivmin
      if(ivmax.gt.0)vmax = ivmax
      if(dx.le.0.0)then
         if(indx.gt.0)dx = indx/1000.
      endif
      if(dz.le.0.0)then
         if(indz.gt.0)dz = indz/1000.
      endif
      write(LERR,*)' Minimum Velocity in input field is ',vmin
      write(LERR,*)' Maximum Velocity in input field is ',vmax
c---------------------------------------------------
c     ensure that command line values are compatible with data set
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
      nx = ne - ns + 1
      nz = nsamp
      nvmov = nsamp/2
c---------------------------------------------------
c     allocate space needed
      isiz1 = ntrc * nsamp * SZSMPD
      isiz2 = nz * nx * SZHFWD
      isiz3 = ntrc * ITRWRD * SZSMPD
      ier = 0
      iabort = 0 
      call galloc (pvel, isiz1, ier, iabort)
      if(ier.ne.0 .or. iabort.ne.0)go to 55
      call galloc (pind, isiz2, ier, iabort)
      if(ier.ne.0 .or. iabort.ne.0)go to 55
      call galloc (phdr, isiz3, ier, iabort)
      if(ier.ne.0 .or. iabort.ne.0)then
        go to 55
      else
        go to 56
      endif
   55 continue
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) isiz3,'  bytes trace headers'
         write(LERR,*) isiz1,'  bytes for input data'
         write(LERR,*) isiz2,'  bytes for output data'
         write(LERR,*)' '
         go to 999
   56 continue
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) isiz3,'  bytes for trace headers'
         write(LERR,*) isiz1,'  bytes for input data'
         write(LERR,*) isiz2,'  bytes for output data'
         write(LERR,*)' '
c---------------------------------------------------
      nrecc = ire - irs + 1
      iformo= 3
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumSmp', nz, LINHED)
      call savew(itr, 'NumTrc', nx, LINHED)
      if(dx.gt.0.0)indx = dx * 1000.
      if(dz.gt.0.0)indz = dz * 1000.
      call savew(itr, 'Format', iformo, LINHED)
      call savew(itr, 'Dx1000', indx, LINHED)
      call savew(itr, 'Dz1000', indz, LINHED)
      nbytes = SZTRHD + nz * SZSMPD
c---------------------------------------------------
c     put command line into the output line header
      call savhlh(itr,lbytes,lbyout)
      call wrtape (luout,itr,lbyout)
      if(verbos)then
        call verbal(ntap,otap,velist,nsamp,nsi,ntrc,nrec,iform,
     &              nrecc,ns,ne,irs,ire,dx,dz,nx,nz,iformo,verbos)
      endif
c--------------------------------------------------
c     skip unwanted records
      call recskp(1,irs-1,luin,ntrc,itr)
c-----------------------------------------------------------------
c-----------------------------------------------------------------
c     process desired trace records
c-----------------------------------------------------------------
c-----------------------------------------------------------------
      do 1000 jj = irs, ire
c        skip to start trace
         call trcskp(jj,1,ns-1,luin,ntrc,itr)
         ic = 0
         do 1001  kk = ns, ne
            ibytes = 0
            call rtape(luin, itr, ibytes)
            if(ibytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               write(LER,*)'End of file on input:'
               write(LER,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            ic = ic + 1
            istrc = (ic-1) * nsamp
            ishdr = (ic-1) * ITRWRD
            call vmov (lhed(ITHWP1),1,ind(istrc+1),1,nvmov)
            call vmov (itr,1,itrhdr(ishdr+1),1,ITRWRD)
1001     continue
         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c---------------------
c        Manipulate the data here 
c---------------------
         ierr = 0
         call mkvel(vlist,velist,vel,ind,nx,nz,jj,ierr)
         if(ierr.ne.0)then
           write(LER,*)'Error reading velocity list'
           write(LER,*)'Job Terminated'
           go to 999
         endif
c---------------------
c        write the output 
c---------------------
         do 1002 kk = 1, nx
            istrc = (kk-1) * nz
            ishdr = (kk-1) * ITRWRD
            call vmov(vel(istrc+1),1,head(ITHWP1),1,nz)
            call vmov (itrhdr(1),1,lhed,1,ITRWRD)
            itr(106) = jj
            itr(107) = kk
            call wrtape(luout, itr, nbytes)
 1002    continue
 1000 continue
c-----------------------------------------------------------------
c-----------------------------------------------------------------
      write(LERR,*)' End of ndx2vel -- Normal Completion '
c--------------------------------------------------
  999 continue
      call lbclos(luin)
      call lbclos(luout)
      end
C***********************************************************************
C     help - Routine to print 'how-to' information to screen
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
      write(LER,*) ' '
      write(LER,*)'ndx2vel reads a velocity INDEX field V(z,x)',
     :'and outputs a Velocity field V(z,x) '
      write(LER,*)' Command Line Arguments: '
      write(LER,*)'-N[ntap]   - input velocity field'
      write(LER,*)'-O[otap]   - output velocity index field'
      write(LER,*)'-C[vlist]  - list of velocities'
      write(LER,*)'-ns[ns]    - starting trace'
      write(LER,*)'-ne[ne]    - ending trace'
      write(LER,*)'-rs[irs]   - starting record'
      write(LER,*)'-re[ire]   - ending record'
      write(LER,*)'-dx[dx]    - trace spacing (default=LH value)'
      write(LER,*)'-dz[dz]    - depth sample spacing (default=LH value)'
      write(LER,*)'-V         - Verbose printout'
      write(LER,*)
     :'usage: ndx2vel -N[ntap] -O[otap] -C[vlist] -ns[] -ne[]'
      write(LER,*)'               -rs[] -re[ire] -dx[dx] -dz[dz] -V'
      return
      end
C***********************************************************************
C     cmdln - Routine to get command line arguments
C***********************************************************************
      subroutine cmdln(ntap,otap,velist,ns,ne,irs,ire,dx,dz,verbos)
c     ntap  - input tape
c     otap  - output tape
c     ns    - starting trace index
c     ne    - ending trace index
c     irs   - starting record index
c     ire   - ending record index
c     dx    - delta-x (for output line header)
c     dz    - delta-z (for output line header)
c     verbos- verbose output
c-----
      character   ntap*(*), otap*(*), velist*(*)
      integer     ns, ne, irs, ire
      real        dx, dz
      logical     verbos
      integer     argis
c-------
       call argstr( '-C', velist, ' ', ' ' )
       call argstr( '-N', ntap, ' ', ' ' )
       call argstr( '-O', otap, ' ', ' ' )
       call argi4 ( '-ns', ns , 0  ,0    )
       call argi4 ( '-ne', ne , 0  ,0    )
       call argi4 ( '-rs', irs, 0  ,0    )
       call argi4 ( '-re', ire, 0  ,0    )
       call argr4 ( '-dx', dx , 0.0,0.0  )
       call argr4 ( '-dz', dz , 0.0,0.0  )
       verbos =   (argis('-V') .gt. 0)
      return
      end
C***********************************************************************
C     verbal - Routine to print parameters on printout
C***********************************************************************
      subroutine verbal(ntap,otap,velist,nsamp,nsi,ntrc,nrec,iform,
     &                  nrecc,ns,ne,irs,ire,dx,dz,nz,nx,iformo,verbos)
  
#include <f77/iounit.h>
      integer   nsamp, nsi, ntrc, nrec
      character ntap*100, otap*100, velist*100
c-------
      write(LERR,*)' '
      write(LERR,*)' Line header values after default check '
      write(LERR,*)' Name of Velocity list =  ',velist
      write(LERR,*)' Input data set name   =  ',ntap
      write(LERR,*)' Format of input data  =  ',iform
      write(LERR,*)' Samples per trace     =  ',nsamp
      write(LERR,*)' Sample interval       =  ',nsi
      write(LERR,*)' Traces per record     =  ',ntrc
      write(LERR,*)' Records per line      =  ',nrec
      write(LERR,*)' Input starting trace  =  ',ns
      write(LERR,*)' Input ending trace    =  ',ne
      write(LERR,*)' Input starting record =  ',irs
      write(LERR,*)' Input ending record   =  ',ire
      write(LERR,*)' Input Trace spacing   =  ',dx
      write(LERR,*)' Input Sample spacing  =  ',dz
      write(LERR,*)' Output data set name  =  ',otap
      write(LERR,*)' Format of output data =  ',iformo
      write(LERR,*)' Samples per trace out =  ',nz
      write(LERR,*)' Traces per record out =  ',nx
      write(LERR,*)' Number records out    =  ',nrecc
c-----
      return
      end
