C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       NORM - NORMALIZE A SECTION                           *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 88/03/16  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/03/16  *
C
C  GENERAL DESCRIPTION:  READ A SEISMIC SECTION, MAKE AN 'AVERAGE'     *
C       - TRACE, THEN SCALE WHOLE SECTION WITH IT                      *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 88/05/13  *
C       - AVERAGE OVER A WINDOW IN THE AVERAGE TRACE BEFORE APPLYING IT*
C       - ADD HLHPRT                                                   *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/01/11  *
C       - changed default from 2 to 10                                 *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 92/08/18  *
C       - Make the code run on 32 bit machine and distribute           *
C  REVISED BY:  MARY ANN THORNTON  V: 1.l     REVISION DATE: 93/07/08  *
C       - Increase line header buffer size; add include file for HP    *
C       - so ltrm logical unit will not be 0 on the HP                 *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
      PARAMETER (MXSAM=2048,MXTRA=4096,LHEAD=SZLNHD)
      PARAMETER (LPRT=26, LCRD=25, LLIST=27, MXTOT=MXSAM*MXTRA)
C
      DIMENSION IHEAD(LHEAD)
      DIMENSION RXX(MXSAM+ITRWRD),DATA(MXSAM)
      DIMENSION A(MXTOT),S(MXSAM),SN(MXSAM)
C
      INTEGER IRX(LNTRHD),THDR(LNTRHD,MXTRA)
C
      LOGICAL VERBOS
      CHARACTER*1   PARR(66)
      CHARACTER*4  PPNAME
      CHARACTER*4  VERSION
      CHARACTER*128 NTAP, OTAP
C
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))
C
      DATA PPNAME/'NORM'/
      DATA VERSION/' 1.1'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ','N','O','R','M','A','L','I','Z','E',' ','A',' ','S',
     3'E','C','T','I','O','N',' ',' ',' ',' ',' ',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/
C
C     (LTRM) TERMINAL=0 , EXCEPT WHEN USING PIPES, THEN TERMINAL=2
C
      LTRM = LER
      CALL cmdlin(NTAP,OTAP,NS,IPIPI,IPIPO,LTRM,VERBOS)
      IF(IPIPI.EQ.0) THEN
C        LUIN IS AN INPUT DATASET
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE
C        WE KNOW LUIN IS A PIPE
         LUIN=0
         LTRM=2
      ENDIF
      IF(IPIPO.EQ.0) THEN
C        LUOUT IS AN OUTPUT DATASET
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
C        WE KNOW LUOUT IS A PIPE
         LUOUT = 1
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     OPEN PRINTOUT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(LPRT,38)NTAP,OTAP
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ THE LINE HEADER AND PICK PARAMETERS NEEDED TO READ TRACES*
C     LTR   = NUMBER OF TRACES PER RECORD
C     NREC  = NUMBER OF RECORDS PER JOB
C     ISI   = SAMPLE RATE INTERVAL (I.E. 4 INDICATES 4 MILLISECONDS)
C     KSAMP = NUMBER OF DATA SAMPLES PER TRACE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      JEOF = 0
      CALL RTAPE(LUIN,IHEAD,JEOF)
      IF(JEOF.EQ.0)GO TO 1000
      call saver(ihead,'NumTrc',ltr,LINHED)
      call saver(ihead,'NumRec',nrec,LINHED)
      call saver(ihead,'NumSmp',ksamp,LINHED)
      call saver(ihead,'SmpInt',isi,LINHED)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   IF NO PARAMETERS ENTERED ON COMMAND LINE, NS = 10                 *
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      IF(NS.LE.0)NS = 10
      IF(NS.GT.KSAMP)NS = 10
      N2 = NS/2
      SCALE = 1.0/NS
      if(verbos)WRITE(LPRT,7)NS
    7 FORMAT(2X,'WINDOW SIZE = ',I5)
      IF(KSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)' MAXIMUM NO. SAMPLES ALLOWED IS ',MXSAM
         CALL LBCLOS(LUIN)
         CALL LBCLOS(LUOUT)
         STOP 100
      ENDIF
      IF(LTR.GT.MXTRA)THEN
         WRITE(LPRT,*)' MAXIMUM NO. TRACES ALLOWED IS ',MXTRA
         CALL LBCLOS(LUIN)
         CALL LBCLOS(LUOUT)
         STOP 100
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  HLH WILL PRINT LINEHEADER AND UPDATE THE HISTORICAL PORTION       *
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      LEN=4
      CALL HLHPRT(IHEAD,JEOF,PPNAME,LEN,LPRT)
      CALL WRTAPE(LUOUT,IHEAD,JEOF)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C START PROCESSING DATASET                                            C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     LOAD DATA INTO ARRAY A AND BUILD AVERAGE TRACE FOR SECTION
      call savelu('StaCor',ifmt,istat,length,TRCHED)
      DO 700 MR=1,NREC
         call vclr(s,1,mxsam)
         call vclr(sn,1,mxsam)
         IF(VERBOS)WRITE(LPRT,*) '  PROCESSING RECORD ',MR
         LA =1
         DO 200 L=1,LTR
            JEOF=0
            CALL RTAPE(LUIN,RXX,JEOF)
            IF(JEOF.EQ.0)GO TO 1500
            IF(IRX(istat).EQ.30000)THEN
               call vclr(data,1,ksamp)
            ENDIF
            call vmov(irx,1,thdr(1,L),1,ITRWRD)
            call vmov(data,1,A(LA),1,KSAMP)
            LA=LA+KSAMP
            DO 100 K=1,KSAMP
               S(K) = ABS(DATA(K)) + S(K)
  100       CONTINUE
  200    CONTINUE
C        NOW WE HAVE A WHOLE RECORD IN A  AND AN AVERAGE TRACE IN S
C        NORMALIZE THE TRACE AND CHECK FOR S(K) .LE. 10% OF B
         B = 0.0
         DO 300 K=1,KSAMP
            B = S(K) + B
  300    CONTINUE
         B = B * (1./KSAMP)
         X = .1 * B
         DO 400 K=1,KSAMP
            IF(S(K).LE.X)S(K) = X
  400    CONTINUE
C        AVERAGE THE SAMPLES OVER A WINDOW
C        N2=1/2 WINDOW SIZE, THE OUTPUT SAMPLE AT N WILL BE A SUM OF THE
C        N2*2 SAMPLES SURROUNDING THAT CURRENT N
C        SN IS THE NEW AVERAGED, WINDOW-SUMMED TRACE
         DO 420 N=1,N2
            SN(N) = S(N)
  420    CONTINUE
         DO 440 N=KSAMP-N2+1,KSAMP
            SN(N) = S(N)
  440    CONTINUE
         DO 475 N=N2+1,KSAMP-N2
            SUM = 0.0
            DO 450 M=-N2,N2
               SUM = SUM + S(M+N)
  450       CONTINUE
            SN(N) = SCALE * SUM
  475    CONTINUE
         LA = 0
         T = 1./LTR
         DO 600 L=1,LTR
            DO 500 K=1,KSAMP
               DATA(K) = A(K+LA)/SN(K) * T
  500       CONTINUE
            LA = LA + KSAMP
            call vmov(thdr(1,L),1,irx,1,ITRWRD)
            CALL WRTAPE(LUOUT,RXX,JEOF)
            IF(JEOF.EQ.0)GO TO 1500
  600    CONTINUE
  700 CONTINUE
      WRITE(LPRT,*) ' JOB COMPLETE'
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(6,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(6,1510)MR,L
 1510 FORMAT(2X,'TAPEIO ERROR PROCESSING OUTPUT RECORD',I5,' TRACE',I5)
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LUIN)
      CALL LBCLOS(LUOUT)
      STOP
      END
      SUBROUTINE CMDLIN(NTAP,OTAP,NS,IPIPI,IPIPO,LTRM,VERBOS)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP, OTAP
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      VERBOS=.FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS--NORMALIZE A SECTION'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap]   . INPUT DATASET NAME'
         WRITE(LTRM,*)'-O[otap]   . OUTPUT DATASET NAME'
       WRITE(LTRM,*)'-I[window] . WINDOW SIZE IN SAMPLES FOR SMOOTHING'
         WRITE(LTRM,*)'           . default = 10'
         WRITE(LTRM,*)'-V         . VERBOSE PRINTOUT'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'norm -N[] -O[] -I[]'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP ,' ',' ')
      CALL ARGSTR('-O',OTAP ,' ',' ')
      CALL ARGI4 ('-I',NS  ,'10','10')
      VERBOS =   (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END
