C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       PANLT2Z                                              *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  TO CONVERT AN INPUT PANEL FROM TIME TO DEPTH              *
C  AUTHOR:   DAN WHITMORE                       ORIGIN DATE: 93/04/02  *
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      parameter (nxmax=2000,nzmax=10000,len_trace =itrwrd+nzmax)
      parameter (lcrd=25,lprt=26,llist=27,lumxc=62,lhead=6536)
      parameter (iord=1)

#ifdef HPUXSYSTEM
c     unit 7 should be pre-connected to stderr on HP systems
      parameter (LER=7)
#else
      parameter (LER=0)
#endif


C     DATA ARRAYS:
      integer     ihead(lhead)
      integer*2   irx(lntrhd)
      real        rxx(len_trace),data1(nzmax),data2(nzmax)
      equivalence (rxx(1),irx(1)),(rxx(ithwp1),data1(1))
      dimension trace(len_trace),rtrd(nzmax)
      integer*2 itrh(lntrhd)
      equivalence (trace(1),itrh(1)),(trace(ithwp1),rtrd(1))

C     character arrays:
      character*1  parr(66)
      character*4  version
      character*7  ppname
      character*128 ntap, otap, input, nvt1

c     pointers for velocity tapes
      real vel(1)
      pointer (pvel,vel)

      DATA VERSION/'1.0'/
      DATA PPNAME/'PANLT2Z'/
      DATA PARR/'C','O','N','V','E','R','T',' ',
     1          'D','E','P','T','H',' ','P','A','N','E',
     2          'L',' ','T','O',' ','T','I','M','E',' ',
     3' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     5          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' '/


c     open printout file                         
      call openpr(llist,lprt,ppname,jerr)
      if(jerr.ne.0)stop 200
      nlin=1
      call gamoco(parr,nlin,lprt)
      ltrm = ler
      call cmdlin(ntap,otap,input,nvt1,ipipi,ipipo,ltrm,
     &nskip,np)

      write(lprt,38)ntap,otap
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      write(lprt,39)nvt1
   39 FORMAT('VELOCITY VTAP = ',/,A128)


C
C     OPEN DATA FILES
C

      if(ipipi.eq.0) then
C        LU1 IS A INPUT DATASET
         call lbopen(lu1,ntap,'r')
      else
C        WE KNOW LU1 IS A PIPE
         lu1=0
         ltrm=2
      endif
      if(ipipo.eq.0) then
C        LU2 IS A OUTPUT DATASET
         call lbopen(lu2,otap,'w')
      else
C        WE KNOW LU2 IS A PIPE
         lu2=1
      endif

c     open and read in velocity datasets
      call lbopen(lvt1,nvt1,'r')
      jeof = 0
      call rtape(lvt1,ihead,jeof)
        if(jeof.le.0) then
           call lbclos(lu1)
           call lbclos(lu2)
           write(0,*)'error in reading input line header'
           stop 73
        endif

c     Bring in Input Line Header Values
      call saver(ihead, 'NumSmp', nzd, linhed)
      call saver(ihead, 'NumTrc', nx1, linhed)
      call saver(ihead, 'Dx1000', idx_1000, linhed)
      call saver(ihead, 'Dz1000', idz_1000, linhed)
      dx = float(idx_1000)/1000.
      dz = float(idz_1000)/1000.

c     check velocity dataset trace spacing
      nx_vels  = nx1

      jerr = 0
      isize_veloc = nzd*nx_vels     
      call galloc( pvel, isize_veloc*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(0,*)'galloc error: ', jerr
         stop
      endif

c        READ VELOCITIES FROM THE VELOCITY DATASET
         jxcol = -nzd + 1 
         do jtrc=1,nx_vels
            jeof=0
            call rtape(lvt1,trace,jeof)
              if(jeof.le.0) then
                 call lbclos(lu1)
                 call lbclos(lu2)
                 call lbclos(lvt1)
                 write(0,*)'error in reading velocity tape'
                 write(0,*)'trace=',jtrc
                 stop 74
              endif
 
c           load vel
              jxcol = jxcol + nzd
              call vmov(rtrd,1,vel(jxcol),1,nzd) 
         enddo

C     PROCESS INPUT LINE HEADER
      jeof = 0
      call rtape(lu1,ihead,jeof)
       if(jeof.eq.0) then
        WRITE(LPRT,*) 'ERROR IN READING INPUT LINE HEADER'
        CALL CCEXIT(100)
        stop
       endif

      len=7
      call hlhprt(ihead,jeof,ppname,len,lprt)
      call saver( ihead, 'NumSmp', ntd,  LINHED )
      call saver( ihead, 'SmpInt', ms,  LINHED )
      call saver( ihead, 'NumRec', nrecd,   LINHED )
      call saver( ihead, 'NumTrc', ntrd,    LINHED )
      dt=ms/1000.
      if(np.eq.0 .and .ntrd.gt.1) np = ntrd
      nxd = nrecd*ntrd/np
      
C     PROCESS OUTPUT LINE HEADER
      idz=nint(dz)
      call savew( ihead, 'SmpInt', idz,  LINHED )
      call savew(ihead, 'Dx1000', idx_1000, LINHED)
      call savew(ihead, 'Dz1000', idz_1000, LINHED)
      call savew( ihead, 'NumSmp', nzd,  LINHED )
      call wrtape(lu2,ihead,jeof)
      jbytes = nzd*szsmpd + sztrhd


C     TRACE PROCESSING BEGINS

C      RECORD LOOP 100:
       do 100 jx = 1,nxd
        jxloc = jx
        if(jxloc.gt.nx_vels/nskip) jxloc = nx_vels/nskip

c       compute bias into velocity arrays
        jxz =(jxloc-1)*nskip*nzd + 1

C       PANEL LOOP 200:
        init = 1
        do 200 jp=1,np
           jeofd=0
           call rtape(lu1,rxx,jeofd)
           if(jeof.eq.0) then
              write(lprt,*) 'error in input, record,trace=',
     &                       nxd,np
              call ccexit(100)
              stop
           endif
        
c          TIME TO DEPTH CONVERSION:
           call trat2z(data1,data2,nzd,ntd,vel(jxz),
     &                 dz,dt,iord,init)
           init = 0
           call vmov(data2,1,data1,1,nzd)

c          WRITE OUTPUT DATASET
           call wrtape(lu2,rxx,jbytes)

           if(jeof.eq.0) then
              WRITE(LPRT,*) 'ERROR IN OUTPUT, RECORD,TRACE=',
     &                       nxd,np
              call ccexit(100)
              stop
           endif

C      END PANEL LOOP 200:
  200  continue

C     END RECORD LOOP 100:
  100 continue

      write(lprt,*) ' panlt2z complete'
      ICODE = 0
      call lbclos(lu1)
      call lbclos(lu2)
      call lbclos(lvt1)
      call ccexit(icode)
      stop
      end
c
      subroutine cmdlin(ntap,otap,input,ntv1,ipipi,ipipo,ltrm,
     &nskip,np)
      integer argis
      logical help
      character*128  ntap,otap,input,ntv1
C     SET DEFAULTS TO NO PIPES
      ipipi=0
      ipipo=0
      help  = (argis( '-h' ).gt.0) .or. (argis( '-?').gt.0)
      if(help)then
         WRITE(LTRM,*)' MBS PANEL TIME TO DEPTH CORRECTION '
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[]       .. Input dataset name'
         WRITE(LTRM,*)'-O[]       .. Output dataset name'
         WRITE(LTRM,*)'-VT[]      .. Vel Tape Used in Migration'
         WRITE(LTRM,*)'-I[]       .. panel spacing of sort(skipped I)'
         WRITE(LTRM,*)'-np[]      .. # of traces per panel'
         WRITE(LTRM,*)'-dt[]      .. dt  (MS) of output (default=8)'
         WRITE(LTRM,*)'-t[]       .. tmax(MS) of output (default=5000)'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)
     &   'panlt2z -N[] -O[] -VT[] -I[] -np[] -dt[] -t[]'
         stop
      endif
      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ')
      call argstr('-VT',ntv1,' ',' ')
      call argi4  ('-I'  , nskip , 0, 0)
      call argi4  ('-np'  , np , 0, 0)
      if(nskip.le.0) write(0,*) 'skipping inc must > 0'
      if(nskip.le.0) stop 999
C     MAKE THE NTAP A PIPE
      if(ntap.eq.' ' ) ipipi=1
C     MAKE THE OTAP A PIPE
      if(otap.eq.' ' ) ipipo=1
      return
      end
