C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine traz2t(data1,data2,nzd,ntd,vel,dz,dt,iord,init)
      
c     Compute layered plane wave residual depth moveout
c     by Dan Whitmore
 
c     data1  = trace data (input)
c     data2  = trace data (output)
c     nzd    = number of z sample in data
c     ntd    = number of t sample in data
c     vel    = velocity trace
c     dz     = depth spacing
c     dt     = time  spacing
c     iord   = interpolation order, 0=linear otherwise cubic
c     init   = initialize interpolation tables if init = 1   

      parameter (ntmax=10000)

      real      data1(*) , data2(*) 
      real        vel(*)           
 
      logical first

      real ttab1(ntmax) , ttab2(ntmax)
      real    wrk (4*ntmax)
      integer iwrk(ntmax)

      save ttab2 , first, jt

      data first / .true. /


c     build evenly spaced output depth table

      if (first) then
       first = .false.
       do jt = 1,ntmax
       ttab2(jt) = float(jt-1)*dt
       enddo
      endif
         
c     build time interpolation table
      if(init.eq.1) then

       ttab1(1)=0.
        do jz=1,nzd-1
         ttab1(jz+1) = ttab1(jz)+2.*dz/vel(jz)
        enddo
       ntout   = ttab1(nzd)/dt + 1.01
      
      endif

c      if time "small", then clear data2 and return
       if(ntout.lt.5 .or. jt.lt.5) then
        call vclr(data2,1,ntd)
        return
       endif

C      Resample data1 into data (using ttab1 and ttab2)
c      could use ccuint as well
       if(iord.eq.0) then
       call fliint(ttab1,data1,nzd,ttab2,data2,ntout,iwrk,wrk,init)
       else
       call ccuint(ttab1,data1,nzd,ttab2,data2,ntout,iwrk,wrk,init)
       endif

c      clear any unspecified samples
                               
       if(ntout.lt.ntd) call vclr(data2(ntout+1),1,ntd-ntout)

       return
       end
