C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C****************************************************************
C  ROUTINE:       PIESTKT                                             *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  PERFORM 2D-FFT, DISK OR PIE FILTER, WEIGHT EACH RECORD,   *
C          - INVERSE 2-D-FFT AND POWER STACK, THEN GSCL & OPT. GMIX    *
C          - 1024 TRACE LIMIT; 2048 SAMPLE LIMIT (SISTAPE IN AND OUT)  *
C          - ITYPE                                                     *
C          - = 0=DO NOT FILTER                                         *
C          - = 1=APPLY A PIE FILTER        (PPIE)                      *
C          - IGMIX      (PERFORM 2-TRACE GMIX)                         *
C          - = 0=DO NOT USE PGSMX PROCESS                              *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 87/09/30  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/11/29  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      cmdlin           - GET COMMAND LINE ARGUMENTS                    *
C      LBOPEN          - OPEN TAPE                                     *
C      OPENPR          - OPEN PRINT FILE                               *
C      GAMOCO          - PRINT TORCH AND OVAL                          *
C      ICOPEN  INTEGER - OPEN CARD FILE                                *
C      RTAPE           - READ TAPE                                     *
C      VMOV            - MOVE CHARACTER STRING                         *
C      RVTAP          - READ A VELOCITY TAPE AND RETURN MATRIX        *
C      PWROF2          - GET NEXT POWER OF 2                           *
C      HLHPRT          - PRINT & UPDATE HISTORICAL LINEHEADER          *
C      WRTAPE          - WRITE TAPE                                    *
C      WEDGEI          - CALCULATE WEDGE FILTER PARAMETERS             *
C      CCUINT          - CUBIC SPLINE INTERPOLATOR                     *
C      XPIES           - DO THE FILTER                                 *
C      FGSMX           - DO A GMIX                                     *
C      LBCLOS          - CLOSE TAPE                                    *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      ASIN    GENERIC -                                               *
C      FLOAT   REAL -                                                  *
C      ABS     GENERIC -                                               *
C      ATAN    GENERIC -                                               *
C      SIN     GENERIC -                                               *
C  FILES:                                                              *
C      GIASC  ( INPUT  INTERNAL   ) - INTERNAL READ ON TRACE SPACING   *
C      LCRD   ( INPUT  SEQUENTIAL ) - INPUT CARD FILE                  *
C      LPRT   ( OUTPUT SEQUENTIAL ) - PRINT FILE                       *
C      LLIST  ( OUTPUT SEQUENTIAL ) - PARENT PID LIST                  *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      200      ( 1) - PRINT FILE ERRORS
C      50       ( 5) - CARD FILE ERRORS                                *
C      75       ( 5) - TAPEIO ERRORS                                   *
C      100      ( 3) - OTHER ERRORS                                    *
C      =BLANK=  ( 5) - NO ERRORS                                       *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  THIS ROUTINE READS AN SIS TAPE INTO 2-D ARRAY *
C       - 2-D FFT APPLIED, DISK OR PIE FILTER APPLIED, INVERSE 2-D FFT *
C       - APPLIED, THEN RECORD IS WEIGHTED AND POWER-STACKED INTO A    *
C       - 2-D ARRAY. AT END OF JOB THE RECORD IS GSCL'D AND GMIX'D(OPT)*
C       - THEN OUTPUT TO SIS TAPE                                      *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 88/01/27  *
C            - ADDED GAMOCO AND COF TAPEIO                             *
C            - CHANGED VMOV AND VCLR BACK TO MOVE FOR TESTING          *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 88/02/10  *
C            - ADD FIXED FORMATS TO THE READ STATEMENTS AS REQUESTED   *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 88/04/25  *
C            - CHANGE COPEN TO ICOPEN, GET DX FROM LINEHEADER IF READ  *
C            - IN AS ZERO, CALL HLHPRT                                 *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 88/11/29  *
C            - CHANGE INPUT PARAMETERS TO BE FREQUENCIES, NOT WAVELENGT*
C            - SHRINK/STRETCH BEFORE APPLYING THE WEDGE FILTER - REMOVE*
C            - THE DISK FILTER (SEE PDSK FOR DISK FILTER ONLY)         *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 88/12/01  *
C            - CHECK THE TRACE HEADER FOR THE ANGLE, THEN USE THE CARD *
C            - WHICH CORRESPONDS TO THIS ANGLE FOR THE PROPER WEIGHT,BW*
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 88/12/01  *
C            - CHECK THE TRACE HEADER FOR THE ANGLE, THEN USE THE CARD *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 89/01/09  *
C            - CORRECTED RAMP CALCULATION AND CHANGED NAME TO PIESTKT   *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 89/01/11  *
C            - CHECKED VALIDITY OF MSTRT,MEND,MINC & SELECT THE WEIGHT *
C            - AND BEAMWIDTH FROM NEAREST ANGLE CARD                   *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 89/01/15  *
C            - Corrected ramp default                                  *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 89/02/07  *
C            - REPLACE FFT ROUTINES W/LOOPING, MIXED RADIX FFT'S       *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 89/02/10  *
C            - ADD CHECK FOR VREF EQUAL ZERO                           *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/02/15  *
C       - CORRECTED SIZE OF M4 (2*MXSAM*MXTRA+1)TO(2*MXSAM*(MXTRA+1))  *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/02/16  *
C       - REMOVED A MOVE OF DATA INTO A BEFORE THE CCUINT CALLED       *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/06/15  *
C       - double no. input samples allowable                           *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/06/15  *
C       - replace xmatrx subroutine with getvel subroutine - read a    *
C       - velocity tape rather than build an mxc-file-based matrix     *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 89/09/06  *
C       - Move code to sun for distribution/maintenance                *
C  REVISED BY:  MARY ANN THORNTON   V: 2.1    REVISION DATE: 92/04/07  *
C       - Call openpr with full program name for OS 6.1                *
C       - Correct rvtap subroutine to give a message when the velocity
C       - has less traces or samples than the seismic data
C  REVISED BY:  MARY ANN THORNTON   V: 2.2    REVISION DATE: 92/05/18  *
C       - remove f8x syntax and add saver routine to subroutine  
C       - Code now works on 32 bit machine
C  REVISED BY:  MARY ANN THORNTON   V: 2.3    REVISION DATE: 93/05/25  *
C       - Add hp logical unit, increase line header size         
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>
      PARAMETER (MXTRA=1024, MXSAM=2051, LHEAD=6000)
      PARAMETER (MXTOT=MXTRA*MXSAM)
      PARAMETER (LCRD=25,LPRT=26,LLIST=27)
      PARAMETER (MXXXX=MXSAM+ITRWRD,MXVEL=5000,MXANG=200)
      PARAMETER (M1=MXTRA*2,M2=MXTRA*4,M3=MXSAM*2,M4=2*MXSAM*(MXTRA+1))
C
      DIMENSION IHEAD(LHEAD),PARM(6),WPARM(11,2),PARM0(5)
      DIMENSION IZ(M1),ZZ(M2),TABL1(MXSAM),TABL2(M3)
      DIMENSION RXX(MXXXX),DATA(MXSAM),A(MXTOT),SCAL(MXSAM)
      DIMENSION B(MXTOT),WRK(M4),VEL(MXSAM,MXTRA)
      DIMENSION ANGLE(MXANG),BMW(MXANG),WATE(MXANG)
C
      INTEGER OFFSET
      INTEGER*2 IRX(LNTRHD),ITHD(LNTRHD,MXTRA)
C
      LOGICAL VERBOS
      CHARACTER*1 CARD(80),PARR(66)
      CHARACTER*4 NAME
      CHARACTER*4 VERSION
      CHARACTER*7 PPNAME
      CHARACTER*4 GIASC
      CHARACTER*128 NTAP,NVTAP,OTAP,INPUT
C
      EQUIVALENCE (CARD(1),NAME)
      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),DATA(1))
      DATA VERSION/' 2.3'/
      DATA PPNAME/'PIESTKT'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2'P','O','W','E','R',' ','S','T','A','C','K',' ','A','N','D',' ',
     3'P','I','E',' ','F','I','L','T','E','R',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     5          ' ',' ',' ',' ',' ',' ',' ',' ',' '/
C
C     (LTRM) TERMINAL = 0 EXCEPT WHEN USING PIPES; THEN TERMINAL = 2
C
      ICODE = 0
      LTRM = LER
      R1   = 0
      R2   = 0
      R3   = 0
      R4   = 0
      IERR  =  0
      CALL cmdlin(NTAP,NVTAP,OTAP,INPUT,IPIPI,IPIPO,LTRM,VERBOS)
      IF(NVTAP .EQ. ' ')then
         write(ltrm,*) 'You must supply a velocity tape name'
         Write(ltrm,*) ' JOB TERMINATED'
         stop 50
      endif
      IF(IPIPI.EQ.0) THEN
C        LU1 IS A INPUT DATASET
         CALL LBOPEN(LU1,NTAP,'r')
      ELSE
C        WE KNOW LU1 IS A PIPE
         LU1=0
         LTRM=2
      ENDIF
      CALL LBOPEN(LU3,NVTAP, 'r')
      IF(IPIPO.EQ.0) THEN
C        LU2 IS A OUTPUT DATASET
         CALL LBOPEN(LU2,OTAP,'w')
      ELSE
C        WE KNOW LU2 IS A PIPE
         LU2=1
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     MREC   = NO. OF RECORDS TO PROCESS                              C
C     IPAD   = 0 = NO EXTRA PADDING; = >0 = PADDED TO NEXT POWER OF 2 C
C              DATA WILL BE PADDED TO NEXT POWER OF 2 IF IT IS AN EXACT
C              POWER OF TWO TO START WITH
C     WAVMXI = INNER CIRCLE ZEROED FROM LONGEST WAVELENGTH UP TO THIS ONE
C     WAVMNI = INNER CIRCLE RAMPED FROM HERE TO WAVMXI
C     WAVMXO = OUTER CIRCLE ZEROED FROM HERE TO THE SHORTEST WAVELENGTH
C     WAVMNO = OUTER CIRCLE RAMPED FROM HERE TO WAVMXO
C     RAMP   = A RAMP FACTOR FOR THE WEDGE
C     DX     = TRACE SPACING
C     DZ     = DEPTH SAMPLE SPACING
C     BW     = BEAM WIDTH
C     VMIN,VMAX,VREF=MINIMUM,MAXIMUM,REFERENCE VELOCITIES USED WITH THE
C     BW TO CALCULATE THE SIZE OF THE WEDGE FOR THE PIE FILTER
C     BW IS RECORD VARIABLE AND READ IN IN DO-500-LOOP WITH ANGLE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(LPRT,38)NTAP,OTAP
   38 FORMAT(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)
      JERR = 0
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(LPRT,*)' ERROR OPENING EXTERNAL CARD FILE'
            STOP 50
         ENDIF
      ELSE
         N=ICOPEN('-piestkt.crd',LCRD)
            IF(N.EQ.0)THEN
               WRITE(LPRT,*)'  YOU MUST SUPPLY INPUT PARAMETERS'
               STOP 50
            ENDIF
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     READ CARDS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
    4 CONTINUE
      IREAD=1
      READ(LCRD,5,ERR=3000)CARD
    5 FORMAT(80A1)
      IF(NAME.NE.'PIES')GO TO 4
      READ(LCRD,200)ITYPE,MSTRT,MEND,MINC,IPAD,IGMIX,IPOW
  200 FORMAT(7I10)
      IF(IPOW.EQ.0)IPOW=1
      WRITE(LPRT,10)
   10 FORMAT (/////, 27X, 'PROGRAM PARAMETERS',//)
      WRITE(LPRT,11)IPOW
   11 FORMAT(
     *' DATA WILL BE RAISED TO THE POWER OF    ', 10X,'=', I10)
    9 CONTINUE
      IREAD=2
      READ(LCRD,5,ERR=3000)CARD
      IF(NAME.NE.'GSCL')GO TO 9
      READ(LCRD,210)ALPHA,XMULT,EXPNT
  210 FORMAT(3F10.0)
      IF(XMULT.EQ.0.)XMULT = 1.0
      WRITE(LPRT,20)ALPHA,XMULT,EXPNT
   20 FORMAT(' SUMMED OUTPUT SCALED USING THESE PARAMETERS:',//,
     *' TIME EXPONENT                          ', 10X,'=', F10.3, //,
     *' CONSTANT MULTIPLIER                    ', 10X,'=', F10.3, //,
     *' EXPONENT FOR POWER OF 10 MULTIPLIER    ', 10X,'=', F10.3,/)
   19 CONTINUE
      IREAD=3
      READ(LCRD,5,ERR=3000)CARD
      IF(NAME.NE.'FILT')GO TO 19
      READ(LCRD,220)DX,DZ,F1,F2,F3,F4,RAMP
  220 FORMAT(7F10.0)
      WRITE(LPRT,25)DX,DZ
   25 FORMAT(
     *' DELTA-X                                ', 10X,'=', F10.3, //,
     *' DELTA-Z                                ', 10X,'=', F10.3, /)

   50 CONTINUE
      IF(IGMIX.NE.0)THEN
         WRITE(LPRT,*)'2-TRACE GMIX APPLIED TO SUMMED OUTPUT RECORD'
      ENDIF
C
C     RTAPE4 RETURNS NO. OF BYTES IN CRAY FORMAT WORDS IN JCOF
C     RTAPE4 RETURNS NO. OF BYTES IN IEEE FORMAT WORDS IN JEOF
      JEOF = 0
CCCC  CALL RTAPE(LU1,IHEAD,JEOF)
      CALL RTAPE4(LU1,IHEAD,JCOF,JEOF)
      IF(JEOF.EQ.0)GO TO 1000
      LBYTE4 = JEOF + 4
      CALL SAVER(IHEAD, 'NumTrc', LTR, LINHED)
      CALL SAVER(IHEAD, 'NumRec', NREC, LINHED)
      CALL SAVER(IHEAD, 'SmpInt', ISI, LINHED)
      CALL SAVER(IHEAD, 'NumSmp', KSAMP, LINHED)
      CALL SAVER(IHEAD, 'Format', IFORM, LINHED)
      NBYTE4 = 4 + 256 + KSAMP*4
      IF(LTR.GT.MXTRA)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. TRACES ALLOWED IS ',MXTRA
         STOP 100
      ENDIF
      IF(KSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)' ERROR*****MAXIMUM NO. SAMPLES ALLOWED IS ',MXSAM
         STOP 100
      ENDIF
      IF(DX.LE.0.0)THEN
         CALL SAVER(IHEAD, 'GrpInt', GIASC, LINHED)
         READ(GIASC,23,IOSTAT=IERR)DX
   23    FORMAT(F8.0)
         IF(IERR .NE. 0) THEN
           WRITE(LPRT,*)'BAD READ ON GROUP INTERVAL FROM LINEHEADER'
           STOP 999
         ELSE
           WRITE(LPRT,*)'GROUP INTERVAL READ FROM LINEHEADER ', DX
         ENDIF
         IF(DX.LE.0.0)THEN
            WRITE(LPRT,*)'  GROUP INTERVAL IN HEADER LE ZERO'
            WRITE(LPRT,*)'  YOU MUST ENTER DX FOR TRACE SPACING'
            STOP 100
         ELSE
            WRITE(LPRT,*)' GROUP INTERVAL USED FOR TRACE SPACING',DX
         ENDIF
      ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   CALL RVTAP
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL RVTAP(LPRT,LU3,DX,DZ,ltr,ksamp,VEL,MXSAM,MXTRA,RXX,IRX,
     1DATA,VMIN,VMAX,IERR,LINHED)
      if(ierr .ne. 0)then
         if(ierr.eq.75)stop 75
         if(ierr.eq.100)stop 100
      endif
      V0 = VMIN
      V02 = V0/2.

      WRITE(LPRT,24)VMIN,VMAX
   24 FORMAT(
     *       ' MINIMUM VELOCITY                   ', 10X,'=', F10.3, //,
     *       ' MAXIMUM VELOCITY                   ', 10X,'=', F10.3,/)
      IF(ITYPE.NE.0)THEN
         CALL PWROF2(KSAMP,KPOW)
         KSAM2 = 2**KPOW
         IF(KSAM2.GT.MXSAM)THEN
         WRITE(LPRT,*)' MAX. SAMPLES EXCEEDED AT NEXT POWER OF 2'
            STOP 100
         ENDIF
         IF((KSAM2.EQ.KSAMP) .OR. (IPAD.GT.0))THEN
           KPOW=KPOW+1
           KSAM2=2**KPOW
           IF(KSAM2.GT.MXSAM)THEN
              WRITE(LPRT,*)' MAX. SAMPLES EXCEEDED AT EXTRA ZERO-PAD'
              STOP 100
           ENDIF
         ENDIF
         PI     = 4.0*ATAN(1.0)
         TWOPI  = 2. * PI
         WAVMXI = V02/F1
         WAVMNI = V02/F2
         WAVMXO = V02/F3
         WAVMNO = V02/F4
         RADIAN = PI/180.
         DEGREE = 180./PI
         CALL PWROF2(LTR,LPOW)
         LTR2 = 2**LPOW
         X    = FLOAT(LTR2)*DX
         DKX = TWOPI/X
         R1  = TWOPI/WAVMXI
         R2  = TWOPI/WAVMNI
         R3  = TWOPI/WAVMXO
         R4  = TWOPI/WAVMNO
         Z    = FLOAT(KSAM2)*DZ
         DKZ  = TWOPI/Z
      IF(RAMP.LE.0.)THEN
         RAMP = TWOPI*F4/V02
      ELSE
         RAMP = TWOPI/RAMP
      ENDIF
         IF(VERBOS)WRITE(LPRT,137)R1,R2,R3,R4,RAMP,DKX,DKZ,X,Z
  137 FORMAT(
     *' INNER CIRCLE RADIUS     (1)            ', 10X,'=', F10.3, //,
     *' INNER CIRCLE RADIUS     (2)            ', 10X,'=', F10.3, //,
     *' OUTER CIRCLE RADIUS     (1)            ', 10X,'=', F10.3, //,
     *' OUTER CIRCLE RADIUS     (2)            ', 10X,'=', F10.3, //,
     *' RAMP FOR THE FILTER                    ', 10X,'=', F10.3, //,
     *' DELTA KX                               ', 10X,'=', F10.7, //,
     *' DELTA KZ                               ', 10X,'=', F10.7, //,
     *' SIZE IN THE X DIRECTION                ', 10X,'=', F10.3, //,
     *' SIZE IN THE Z DIRECTION                ', 10X,'=', F10.3,/)
         PARM(1) = DKX
         PARM(2) = DKZ
         PARM(3) = R1
         PARM(4) = R2
         PARM(5) = R3
         PARM(6) = R4
         PARM0(1)= DKX
         PARM0(2)= DKZ
         PARM0(5)= RAMP
      ELSE
         LTR2  = LTR
         KSAM2 = KSAMP
      ENDIF
      KZMIN = 1
      KZMAX = KSAM2/2
      IF(MSTRT.LE.0 .OR. MSTRT.GT.NREC)MSTRT=1
      IF( MINC.LE.0 .OR.  MINC.GT.NREC)MINC =1
      IF( MEND.LE.0 .OR.  MEND.GT.NREC)MEND =NREC
      MREC = (MEND-(MSTRT-1)+(MINC-1))/MINC
      IF(MREC.LE.   0)MREC=NREC
      IF(MREC.GT.NREC)MREC=NREC
C     IF SUMMING ONLY, DON'T NEED THE EXTRA POWER-OF-2 SPACE
C
      LEN=6
      CALL HLHPRT(IHEAD,JCOF,PPNAME,LEN,LPRT)
      CALL SAVEW(IHEAD, 'NumRec', 1, LINHED)
      CALL WRTAPE(LU2,IHEAD,JCOF)
      WRITE(LPRT,36)  MREC,IPAD
   36 FORMAT(
     *' NUMBER OF RECORDS TO PROCESS           ', 10X,'=', I10  , //,
     *' NUMBER OF POWERS OF 2 TO PAD TO        ', 10X,'=', I10)
C
      IPARM = 6
      IF((ITYPE.EQ.1) .OR. (ITYPE.EQ.3))THEN
         IPARM = 4
      ENDIF
      IW=22
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  START PROCESSING DATASET                                           C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
  241 FORMAT(' IREC = ',I4,' ANGLE = ',F7.2,' BEAMWIDTH = ',F7.2,
     1' WEIGHT = ',F7.2)
  251 FORMAT(' IREC = ',I4,' WEIGHT = ',F7.2)
      CALL VCLR(A,1,MXSAM*MXTRA)
   95 CONTINUE
      IREAD=5
      READ(LCRD,5,ERR=3000)CARD
      IF(NAME.NE.'ANGL')GO TO 95
CC    LREC = NO. OF TRACES TO SKIP BEFORE THE MSTRT RECORD
CC    LBYTE4= NO. BYTES IN LINE HEADER
CC    NBYTE4= NO. BYTES IN TRACE
CC    CALL SEEKT TO POSITION TAPE TO THE MSTRT RECORD
CC    THEN SET LREC TO BE THE NUMBER OF TRACES TO SKIP ACCORDING TO MINC
      LREC = 0
      IF(MSTRT.GT.1)THEN
         LREC = (MSTRT-1)*LTR
         OFFSET = LBYTE4 + LREC*NBYTE4
         CALL SEEKT(LU1,OFFSET)
      ENDIF
      IF(MINC.GT.1)THEN
         LREC = (MINC-1)*LTR
      ELSE
         LREC = 0
      ENDIF
C     READ ALL THE ANGLE CARDS FOR THE CHOSEN RECORDS READ BELOW...
      M=0
      IF(ITYPE.NE.0)THEN
  239    M=M+1
         READ(LCRD,240,END=245)IREC,ANGLE(M),BMW(M),WATE(M)
         WRITE(LPRT,241) IREC,ANGLE(M),BMW(M),WATE(M)
         GO TO 239
  240    FORMAT(I10,3F10.0)
      ENDIF
  245 CONTINUE
      MTOT = M - 1
      IF(VERBOS)WRITE(LPRT,*)' MTOT=',MTOT
      DO 500 MR=MSTRT,MEND,MINC
         IF(VERBOS)WRITE(LPRT,*) '  PROCESSING RECORD ',MR
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C            STRETCH/SHRINK THE DATA AND MOVE INTO ARRAY A           C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
         CALL VCLR(A,1,MXSAM*MXTRA)
         INIT = 1
         LA=1
         TABL1(1) = 0.0
         TABL2(1) = 0.0
         DO 250 K=2,KSAMP
            TABL1(K) = DZ*(K-1)
  250    CONTINUE
         DO 310 L= 1,LTR
            JEOF=0
            CALL RTAPE(LU1,RXX,JEOF)
            IF(JEOF.EQ.0)GO TO 1500
            IF(VERBOS .AND. L.EQ.1)THEN
               CALL SAVER(IRX, 'RecNum', JREC, TRCHED) 
               CALL SAVER(IRX, 'TrcNum', JTRC, TRCHED) 
               CALL SAVER(IRX, 'DstSgn', JANG, TRCHED)
               WRITE(LPRT,*)' RECORD,TRACE,ANGLE ',JREC,JTRC,JANG
            ENDIF
            CALL VMOV(RXX,1,ITHD(1,L),1,ITRWRD)
            DO 300 K=2,KSAMP
               RATIO = VEL(K-1,L)/V0*DZ
               TABL2(K) = TABL2(K-1) + RATIO
  300       CONTINUE
            CALL CCUINT(TABL1,DATA,KSAMP,TABL2,A(LA),KSAMP,IZ,ZZ,INIT)
            INIT=0
            LA=LA+KSAM2
  310    CONTINUE
C        UPDATE OFFSET TO INCLUDE THE TRACES JUST READ
         OFFSET = OFFSET + (LTR*NBYTE4)
         IF(LTR2.LE.LTR)GO TO 330
         KBYT=KSAM2*SZSMPD
         DO 320 L=LTR+1,LTR2
            CALL VCLR(A(la),1,KSAM2)
            LA=LA+KSAM2
  320    CONTINUE
  330    CONTINUE
         IF(ITYPE.NE.0) THEN
C           PICK THE RIGHT BW,ANGLE,WEIGHT HERE BY MATCHING
C           THE HEADER LOCATION WITH THE ANGLE CARDS
C           THE + 90. BELOW IS TO PUT INTO RON'S COORDINATES,(0 LIKE X)
            CALL SAVER(IRX, 'DstSgn', IANG, TRCHED)
            CALL SAVER(IRX, 'DstUsg', IVREF, TRCHED)
            ANG = IANG
            VREF= IVREF 
            IF(VREF.LE.0.0)THEN
               WRITE(LPRT,*)' VREF IN THE HEADER IS ZERO'
               WRITE(LPRT,*)' ***** JOB TERMINATED *****'
               STOP 100
            ENDIF
            DIFMAX=999.
            DO 490 M=1,MTOT
               DIF = ABS(ANG-ANGLE(M))
               IF(DIF.LT.DIFMAX)THEN
                  MNEAR = M
                  DIFMAX=DIF
               ENDIF
  490       CONTINUE
            BW    = ABS(BMW(MNEAR))
            SANG1 = - SIN(ANGLE(MNEAR)*RADIAN)
            WEIGHT= WATE(MNEAR)
            IF(VERBOS)WRITE(LPRT,*)'BW,ANG,WEIGHT,MNEAR,VREF'
            IF(VERBOS)WRITE(LPRT,*) BW,ANG,WEIGHT,MNEAR,VREF
            A1 = VMIN/VREF*SANG1
            A2 = VMAX/VREF*SANG1
            IF(A1 .GT.  1.) A1 =  90.
            IF(A1 .LT. -1.) A1 = -90.
C           IF(A1 .GT.  1.) A1 =   1.
C           IF(A1 .LT. -1.) A1 =  -1.
            IF(ABS(A1) .LE. 1.) A1 = ASIN(A1)*DEGREE
            IF(A2 .GT.  1.) A2 =  90.
            IF(A2 .LT. -1.) A2 = -90.
C           IF(A2 .GT.  1.) A2 =   1.
C           IF(A2 .LT. -1.) A2 =  -1.
            IF(ABS(A2) .LE. 1.) A2 = ASIN(A2)*DEGREE
            IF(A1 .LT. A2) THEN
               ANG1 = A1 + 90. - BW
               ANG2 = A2 + 90. + BW
            ELSE
               ANG1 = A2 + 90. - BW
               ANG2 = A1 + 90. + BW
            ENDIF
            IF(ANG1 .LT.   0.) ANG1 = 0.
            IF(ANG1 .GT. 180.) ANG1 = 180.
            IF(ANG2 .LT.   0.) ANG2 = 0.
            IF(ANG2 .GT. 180.) ANG2= 180.
            PARM0(3)=ANG1
            PARM0(4)=ANG2
            CALL WEDGEI(LTR2,PARM0,WPARM)
            IF(VERBOS)WRITE(LPRT,*)' A1,A2,ANG1,ANG2'
            IF(VERBOS)WRITE(LPRT,*)  A1,A2,ANG1,ANG2
            IF(VERBOS)WRITE(LPRT,*)' PARM0 ',(PARM0(KKK),KKK=1,5)
            IF(VERBOS)WRITE(LPRT,*)' WPARM,1 ',(WPARM(KK,1),KK=1,11)
            IF(VERBOS)WRITE(LPRT,*)' WPARM,2 ',(WPARM(KK,2),KK=1,11)
            IW = 11*2
         ENDIF
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C   CALL THE PIEFILTER AND POWER STACK ROUTINE INTO ARRAY B
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
         CALL XPIES(WEIGHT,A,B,PARM,KZMIN,KZMAX,KSAM2,LTR2,ITYPE,
     1     WPARM,IERR,MR,IPOW,MREC,WRK)
         IF(IERR.NE.0)GO TO 2000
         IF(LREC.NE.0)THEN
            OFFSET = OFFSET + (LREC*NBYTE4)
            CALL SEEKT(LU1,OFFSET)
         ENDIF
  500 CONTINUE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C            STRETCH/SHRINK THE DATA BACK AND PUT INTO ARRAY A
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      CALL VCLR(A,1,MXSAM*MXTRA)
      INIT=1
      LA = 1
      DO 520 L=1,LTR
         DO 510 K=2,KSAMP
            ITAB = TABL2(K-1)/DZ + 1.0
            IF(ITAB.GT.KSAMP)ITAB=KSAMP
            if(vel(itab,l).le.0.0)then
               stop
            endif
            RATIO = V0/VEL(ITAB,L) * DZ
            TABL2(K) = TABL2(K-1) + RATIO
  510    CONTINUE
         CALL CCUINT(TABL1,B(LA),KSAMP,TABL2,A(LA),KSAMP,IZ,ZZ,INIT)
         INIT=0
         LA=LA+KSAM2
  520 CONTINUE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C       BUILD TABLE TO SCALE DATA (GSCL) AND GMIX IN FGSMX ROUTINE      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      ACON=.5
      DT = FLOAT(ISI)/1000.
      AC = XMULT*DT**(-ALPHA)
      DO 535 K=1,KSAM2
         TMP = AC*((FLOAT(K)*DT)**ALPHA)
         SCAL(K)=TMP*(10.**EXPNT)
  535 CONTINUE
      IGSCL=1
      CALL FGSMX(A,LTR2,KSAM2,IGSCL,IGMIX,SCAL)
      IF(VERBOS)WRITE(LPRT,*) '  PROCESSING SUMMED RECORD '
      LA=1
      DO 600 L=1,LTR
         ITHD(106,L) = 1
         ITHD(107,L) = L
         CALL VMOV(ITHD(1,L),1,IRX,1,ITRWRD)
         CALL VMOV(A(LA),1,DATA,1,KSAMP)
         LA=LA+KSAM2
         CALL WRTAPE(LU2,RXX,JEOF)
         IF(JEOF.EQ.0)GO TO 1600
  600 CONTINUE
      WRITE(LPRT,*) ' JOB COMPLETE '
      ICODE = 0
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(LPRT,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER FROM TAPE')
      CALL LBCLOS(LU1)
      CALL LBCLOS(LU2)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(LPRT,1510)MR,L
 1510 FORMAT(2X,'TAPEIO ERROR ON RECORD',I5,' TRACE',I5)
      ICODE = 75
      GO TO 5000
 1600 CONTINUE
      WRITE(LPRT,1610)L
 1610 FORMAT(2X,'TAPEIO ERROR ON OUTPUT TRACE',I5)
      ICODE = 75
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                          ERRORS FROM FILTER SUBROUTINES              C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 2000 CONTINUE
      WRITE(LPRT,*)'  ERROR FROM XPIES = ',IERR
      ICODE = 100
      GO TO 5000
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                          READ CARD ERRORS                            C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 3000 CONTINUE
      WRITE(LPRT,*)'  ERROR READING INPUT CARDS ON READ ',IREAD
      ICODE=50
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 5000 CONTINUE
      CALL LBCLOS(LU1)
      CALL LBCLOS(LU2)
      IF(ICODE.EQ.50) STOP 50
      IF(ICODE.EQ.75) STOP 75
      IF(ICODE.EQ.100) STOP 100
      IF(ICODE.EQ.200) STOP 200
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      cmdlin  (NTAP,NVTAP,OTAP,INPUT,IPIPI,IPIPO,LTRM,VERBOS)          *
C  ARGUMENTS:                                                          *
C      NTAP    CHAR*128  ??IOU* -                                      *
C      OTAP    CHAR*128  ??IOU* -                                      *
C      INPUT   CHAR*128  ??IOU* -                                      *
C      IPIPI   INTEGER   ??IOU* -                                      *
C      IPIPO   INTEGER   ??IOU* -                                      *
C      LTRM    INTEGER   ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   MARY ANN THORNTON                  ORIGIN DATE: 88/11/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/11/29  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      ARGSTR          -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LTRM  ( OUTPUT SEQUENTIAL ) -                                   *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE cmdlin(NTAP,NVTAP,OTAP,INPUT,IPIPI,IPIPO,LTRM,VERBOS)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP,NVTAP,OTAP,INPUT
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      VERBOS=.FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LTRM,*)'COMMAND LINE ARGUMENTS-POWER STACK & PIE FILTER'
         WRITE(LTRM,*)' '
         WRITE(LTRM,*)' INPUT '
         WRITE(LTRM,*)'-N[ntap]  .. INPUT DATASET NAME'
         WRITE(LTRM,*)'-VT[otap] .. VELOCITY TAPE DATASET NAME'
         WRITE(LTRM,*)'-C[input] .. EXTERNAL CARD FILE'
         WRITE(LTRM,*)'-O[otap]  .. OUTPUT DATASET NAME'
         WRITE(LTRM,*)'-V        .. VERBOSE PRINTOUT'
         WRITE(LTRM,*)'USAGE:'
         WRITE(LTRM,*)'piestkt -N[] -O[] -VT[] -C[] -V'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP,' ',' ')
      CALL ARGSTR('-VT',NVTAP,' ',' ')
      CALL ARGSTR('-O',OTAP,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      VERBOS = (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
C     MAKE THE OTAP A PIPE
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       PWROF2                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  GIVEN A NUMBER(N) THIS ROUTINE RETURNS THE BASE TWO       *
C       EXPONENT(IPWR) WHICH WILL GIVE 2**(IPWR-1).GT.N.LE.2**I *PWR   *
C                                                                      *
C  ENTRY POINTS:                                                       *
C      PWROF2  (N,IPWR)                                                *
C  ARGUMENTS:                                                          *
C      N       INTEGER    I    - INPUT VALUE (INTEGER)                 *
C      IPWR    INTEGER    O    - OUTPUT VALUE RETURNED (INTEGER)       *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   BRUCE CROWL                        ORIGIN DATE: 84/06/18  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/11/29  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 87/05/08  *
C            - CONVERTED TO CRAY FORTRAN                               *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE PWROF2 (N,IPWR)
      IPWR = 0
      IF (N.LE.0) GO TO 200
100   CONTINUE
      IF (2**IPWR.GE.N) GO TO 200
      IPWR = IPWR+1
      IF (IPWR.LT.30) GO TO 100
200   CONTINUE
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       WEDGEI                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      WEDGEI  (NX,PARM0,PARM)                                         *
C  ARGUMENTS:                                                          *
C      NX      INTEGER  ??IOU*         -                               *
C      PARM0   REAL     ??IOU*  (5)    -                               *
C      PARM    REAL     ??IOU*  (11,2) -                               *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 88/11/29  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/11/29  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      FLOAT   REAL    -                                               *
C      SQRT    GENERIC -                                               *
C      TAN     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C********************************************************************C
C NAME: WEDGEI  INIT WEDGE FILTER PARAMETERS    REV 1.0     JUL 86   C
C********************************************************************C
C
C  PURPOSE:
C       CALCULATES THE WEDGE FILTER PARAMETER ARRAY, PARM, GIVEN
C       PARM0 = (DX,DY,A1,A2,R).
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JUL 86          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL WEDGEI (NX, PARM0, PARM)
C
C  PARAMETERS:
C       NX      INTEGER INPUT SCALAR
C               NUMBER OF X'S - COLUMNN DIMENSION OF INPUT MATRIX.
C
C       PARM0   REAL INPUT ARRAY OF LENGTH 5
C               PARM0(1) = DX = DELTA X
C               PARM0(2) = DY = DELTA Y
C               PARM0(3) = A1 = ANGLE FOR FIRST RAY (DEGREES)
C               PARM0(4) = A2 = ANGLE FOR SECOND RAY (DEGREES)
C               PARM0(5) = R  = RAMP WIDTH
C
C       PARM    REAL OUTPUT ARRAY OF DIMENSION 11 BY 2
C               PARM( 1,K) = CASE: 0 = HORIZONTAL RAY
C                                  1 = RAMP REGION IS BELOW RAY
C                                  2 = RAMP REGION IS ABOVE RAY
C                                  3 = VERTICAL RAY
C               PARM( 2,K) = INDEX OF FIRST X       (CASE 1,2,3)
C               PARM( 3,K) = INDEX OF LAST X        (CASE 1,2,3)
C               PARM( 4,K) = INDEX BIAS             (CASE 1,3)
C               PARM( 5,K) = DX  = DELTA X          (CASE 1,2,3)
C               PARM( 6,K) = DY  = DELTA Y          (CASE 1,2)
C                          = R   = RAMP WIDTH       (CASE 3)
C               PARM( 7,K) = DYR = 1.0 / DY         (CASE 1,2)
C                          = RR  = 1.0 / R          (CASE 3)
C               PARM( 8,K) = TANPHI = SLOPE         (CASE 1,2)
C               PARM( 9,K) = B1 = LOWER Y-INTERCEPT (CASE 1,2)
C               PARM(10,K) = B2 = UPPER Y-INTERCEPT (CASE 1,2)
C               PARM(11,K) = SCALE = - 1.0 / B1     (CASE 1)
C                                  = - 1.0 / B2     (CASE 2)
C               WHERE: K = 1 FOR FIRST RAY AND K = 2 FOR SECOND RAY.
C
C  DESCRIPTION:
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
      SUBROUTINE WEDGEI (NX, PARM0, PARM)
C
      INTEGER NX
      REAL    PARM0(5), PARM(11,2)
C
      DATA PI / 3.1415927 /
C
C---------------------------------------------------------------------
C
      DO 30 K = 1, 2
         DO 20 I = 1, 11
            PARM(I,K) = 0.0
   20    CONTINUE
   30 CONTINUE
C
      DX = PARM0(1)
      DY = PARM0(2)
      R  = PARM0(5)
C
      IF (DX .LE. 0.0) GO TO 90
      IF (DY .LE. 0.0) GO TO 90
      IF (R  .LE. 0.0) GO TO 90
C
      RAD = PI / 180.0
C
      DO 80 K = 1, 2
         ANG = PARM0(K+2)
         IF (ANG .LE. 0.0 .OR. ANG .GE. 180.0) GO TO 80
C
         KOFF = 4 * K + 4
C
         IF (ANG .EQ. 90.0) THEN
            ICASE = 3
         ELSE IF (ANG .LT. 90.0) THEN
            IF (K .EQ. 1) THEN
               ICASE = 1
            ELSE
               ICASE = 2
            ENDIF
         ELSE
            IF (K .EQ. 1) THEN
               ICASE = 2
            ELSE
               ICASE = 1
            ENDIF
         ENDIF
C
         PARM(1,K) = FLOAT( ICASE )
C
         GO TO (40, 50, 60), ICASE
C
   40    CONTINUE
         NXOVR2 = NX / 2
         IF (K .EQ. 1) THEN
            J1 = 2
            J2 = NXOVR2 + 1
            JB = 1
         ELSE
            J1 = NXOVR2 + 2
            J2 = NX
            JB = NX + 1
         ENDIF
C
         DYR    = 1.0 / DY
         PHI    = ANG * RAD
         TANPHI = TAN( PHI )
         SECPHI = SQRT( TANPHI * TANPHI + 1.0 )
         B1     = - R * SECPHI
         B2     = 0.0
         SCALE  = - 1.0 / B1
C
         PARM( 2,K) = FLOAT( J1 )
         PARM( 3,K) = FLOAT( J2 )
         PARM( 4,K) = FLOAT( JB )
         PARM( 5,K) = DX
         PARM( 6,K) = DY
         PARM( 7,K) = DYR
         PARM( 8,K) = TANPHI
         PARM( 9,K) = B1
         PARM(10,K) = B2
         PARM(11,K) = SCALE
         GO TO 80
C
   50    CONTINUE
         DYR    = 1.0 / DY
         PHI    = ANG * RAD
         TANPHI = TAN( PHI )
         SECPHI = SQRT( TANPHI * TANPHI + 1.0 )
         B1     = 0.0
         B2     = R * SECPHI
         SCALE  = - 1.0 / B2
C
         PARM( 2,K) = 1.0
         PARM( 3,K) = FLOAT( NX )
         PARM( 5,K) = DX
         PARM( 6,K) = DY
         PARM( 7,K) = DYR
         PARM( 8,K) = TANPHI
         PARM( 9,K) = B1
         PARM(10,K) = B2
         PARM(11,K) = SCALE
         GO TO 80
C
   60    CONTINUE
         NXOVR2 = NX / 2
         IF (K .EQ. 1) THEN
            J1 = 2
            J2 = NXOVR2 + 1
            JB = 1
         ELSE
            J1 = NXOVR2 + 2
            J2 = NX
            JB = NX + 1
         ENDIF
C
         RR = 1.0 / R
C
         PARM( 2,K) = FLOAT( J1 )
         PARM( 3,K) = FLOAT( J2 )
         PARM( 4,K) = FLOAT( JB )
         PARM( 5,K) = DX
         PARM( 6,K) = R
         PARM( 7,K) = RR
C
   80 CONTINUE
C
   90 CONTINUE
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       XPIES                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:       2D-FFT FORWARD, DISK OR PIE FILTER, 2D-FFT INVERSE   *
C           -     POWER STACK                                          *
C  ENTRY POINTS:                                                       *
C      XPIES  (WEIGHT,A,B,PARM,NWMIN,NFREQ,KSAM2,LTR,ITYP,WPARM,IERR,  *
C              MR,IPOW,MREC,WRK)                                       *
C  ARGUMENTS:                                                          *
C      WEIGHT  REAL     ??IOU*       -                                 *
C      A       REAL     ??IOU*  (*)  -                                 *
C      B       REAL     ??IOU*  (*)  -                                 *
C      PARM    REAL     ??IOU*  (6)  -                                 *
C      NWMIN   INTEGER  ??IOU*       -                                 *
C      NFREQ   INTEGER  ??IOU*       -                                 *
C      KSAM2   INTEGER  ??IOU*       -                                 *
C      LTR     INTEGER  ??IOU*       -                                 *
C      ITYP    INTEGER  ??IOU*       -                                 *
C      WPARM   REAL     ??IOU*  (22) -                                 *
C      IERR    INTEGER  ??IOU*       -                                 *
C      MR      INTEGER  ??IOU*       -                                 *
C      IPOW    INTEGER  ??IOU*       -                                 *
C      MREC    INTEGER  ??IOU*       -                                 *
C      WRK     REAL     ??IOU*  (*)  -                                 *
C       +------------------------------------------------------+       *
C       ]               DEVELOPMENT INFORMATION                ]       *
C       +------------------------------------------------------+       *
C  AUTHOR:   R.D. COLEMAN                       ORIGIN DATE: 87/05/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/11/29  *
C       +------------------------------------------------------+       *
C       ]                 EXTERNAL ENVIRONMENT                 ]       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      XRFFT2-                                                         *
C      XCFFT2-                                                         *
C      FPIE  -                                                         *
C  INTRINSIC FUNCTIONS CALLED:                                         *
C      SIGN    GENERIC -                                               *
C      ABS     GENERIC -                                               *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       ]             OTHER DOCUMENTATION DETAILS              ]       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  MARYANN THORNTON              REVISION DATE: 87/10/01  *
C            - ADDED CODE TO DO POWER STACK                            *
C       +------------------------------------------------------+       *
C       ]                 ANALYSIS INFORMATION                 ]       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 88/11/29 ==================   *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C     WEIGHT = A WEIGHT NEEDED FOR EACH RECORD WHEN DOING A SUM        *
C     A      = ARRAY CONTAINING THE INCOMING AND OUTGOING DATA         *
C     B      = ARRAY TO HOLD THE OUTPUT (SUM OF ALL INPUT RECORDS)     *
C     PARM   = 4 WORDS CONTAINING PARAMETERS FOR THE DISK-SHAPE FILTER *
C     NWMIN  = INDEX OF FIRST ELEMENT                                  *
C     NFREQ  = NUMBER OF ELEMENTS                                      *
C     KSAM2  = TIME SAMPLES/TRACE                                      *
C     LTR    = TRACES/RECORD                                           *
C     ITYP   = TYPE OF FILTER TO INVOKE                                *
C     WPARM  = 22 WORDS CONTAINING PARAMETERS FOR THE PIE FILTER       *
C     IERR   = ERROR FLAG                                              *
C     MR     = RECORD NO. (IF = 1, THEN CLEAR B ARRAY)                 *
C     IPOW   = POWER FOR THE POWER STACKING                            *
C     MREC   = IF MR .EQ. LAST RECORD, 2-D FFT THE SUMMED OUTPUT RECORD*
C     WRK    = SCRATCH VECTOR OF LENGTH MAX( 4*KSAM2+6, 7*LTR )        *
C  ARGUMENTS:  (WEIGHT, A, B, PARM, NWMIN, NFREQ, KSAM2, LTR, ITYP,    *
C               WPARM, IERR, MR, IPOW, MREC, WRK)                      *
C                           (1)   DKX                                  *
C                           (2)   DKY * ASPECT RATIO                   *
C                           (3)   R1 (RADIUS 1 IN KX'S                 *
C                           (4)   R2 (RADIUS 2 IN KX'S                 *
C                           (5)   R3 (RADIUS 3 IN KX'S                 *
C                           (6)   R4 (RADIUS 4 IN KX'S                 *
C              1 = ZERO INNER CIRCLE                                   *
C              2 = ZERO INNER AND OUTER                                *
C              3 = ZERO OUTER CIRCLE                                   *
C              4 = PIE FILTER                                          *
C              THESE ARE CALCULATED BY FORTRAN ROUTINE WEDGEI          *
C      FDSCI -                                                         *
C      FDSCO -                                                         *
C      FDISC -                                                         *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
C
      SUBROUTINE XPIES (WEIGHT, A, B, PARM, NWMIN, NFREQ, KSAM2, LTR,
     &                  ITYP, WPARM, IERR, MR, IPOW, MREC, WRK)
C
      REAL    A(*), PARM(6), WPARM(22), B(*), WEIGHT, WRK(*), RPOW
      INTEGER IERR, LTR, ITYP, MR, KSAM2, NFREQ, IDIR, NWMIN,
     &        MREC, IPOW
C
C-----------------------------------------------------------------------
C
      IDIR = 1
      CALL XRFFT2 (A, IDIR, NWMIN, NFREQ, KSAM2, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
      CALL XCFFT2 (A, IDIR, NFREQ, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     APPLY THE FILTER
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      IF (ITYP .NE. 0) CALL FPIE  (A, PARM, WPARM, LTR, NFREQ, IDUMMY)
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     DO THE INVERSE FFT
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      IDIR = -1
      CALL XCFFT2 (A, IDIR, NFREQ, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
      CALL XRFFT2 (A, IDIR, NWMIN, NFREQ, KSAM2, LTR, WRK, IERR)
      IF (IERR .NE. 0) GO TO 900
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     DO THE POWER STACK INTO B
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      do 700 k=1,ksam2
         la = k
         do 600 l=1,ltr
            wrk(k) = abs(a(la))**ipow * weight
            wrk(k) = sign(wrk(k),a(la))
            b(la)  = b(la) + wrk(k)
            la = la + ksam2
  600    continue
  700 continue
c
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     TAKE THE SQUARE ROOT NOW AND APPLY PROPER SIGN
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C
      IF (MR .EQ. MREC) THEN
         RPOW = IPOW
         RPOW = 1./RPOW
         do 800 k = 1,ksam2
            la = k
            do 750 l = 1,ltr
               wrk(k) = abs(b(la))**rpow
               b(la) = sign(wrk(k),b(la))
               la = la + ksam2
  750       continue
  800    continue
      ENDIF
C
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     EXIT ROUTINE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
  900 CONTINUE
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       FGSMX                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  APPLIES 'GSCL' AND 'GMIX' TO A RECORD                     *
C  ENTRY POINTS:                                                       *
C      FGSMX (B, LTR, KSAMP, IGSCL, IGMIX, SCAL)                       *
C  ARGUMENTS:                                                          *
C      B       REAL     ??IOU*  (KSAMP,LTR) -                          *
C      LTR     INTEGER  I               - NO. TRACES (COLUMNS)         *
C      KSAMP   INTEGER  I               - NO. SAMPLES (ROWS)           *
C      IGSCL   INTEGER  I               - 1 = APPLY GSCL               *
C      IGMIX   INTEGER  I               - 1 = APPLY GMIX (2-TRACE-MIX) *
C      SCAL    REAL     I       (KSAMP) - VECTOR OF SCAL FACTOR/SAMPLE *
C       +------------------------------------------------------+       *
C       ]               DEVELOPMENT INFORMATION                ]       *
C       +------------------------------------------------------+       *
C  AUTHOR:   R.D. COLEMAN, QTC                  ORIGIN DATE: 87/05/06  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/11/29  *
C       +------------------------------------------------------+       *
C       ]                 EXTERNAL ENVIRONMENT                 ]       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:  NONE                                              *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       ]             OTHER DOCUMENTATION DETAILS              ]       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       ]                 ANALYSIS INFORMATION                 ]       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 88/11/29 ==================   *
C      B       REAL     I       (KSPAC) - ONE SEISMIC RECORD           *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
C
      SUBROUTINE FGSMX (B, LTR, KSAMP, IGSCL, IGMIX, SCAL)
C
      INTEGER LTR, KSAMP, IGSCL, IGMIX, L, K
      REAL    B(KSAMP,LTR), SCAL(KSAMP)
C
C-----------------------------------------------------------------------
C
      IF (IGSCL .GT. 0 .AND. IGMIX .GT. 0) GO TO 300
      IF (IGSCL .GT. 0                   ) GO TO 100
      IF (IGMIX .GT. 0                   ) GO TO 200
      GO TO 900
C
C                   GSCL ONLY
C
  100 CONTINUE
      DO 120 L = 1, LTR
         DO 110 K = 1, KSAMP
            B(K,L) = SCAL(K) * B(K,L)
  110    CONTINUE
  120 CONTINUE
      GO TO 900
C
C                   GMIX ONLY
C
  200 CONTINUE
      DO 220 L = LTR, 2, -1
         DO 210 K = 1, KSAMP
            B(K,L) = 0.5 * (B(K,L) + B(K,L-1))
  210    CONTINUE
  220 CONTINUE
      GO TO 900
C
C                   GSCL AND GMIX
C
  300 CONTINUE
      DO 320 L = LTR, 2, -1
         DO 310 K = 1, KSAMP
            B(K,L) = 0.5 * SCAL(K) * (B(K,L) + B(K,L-1))
  310    CONTINUE
  320 CONTINUE
C
      DO 330 K = 1, KSAMP
         B(K,1) = SCAL(K) * B(K,1)
  330 CONTINUE
C
C   EXIT
C
  900 CONTINUE
      RETURN
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C***********************************************************************
C  ROUTINE:       RVTAP         
C  ROUTINE TYPE:  SUBROUTINE
C  PURPOSE:       READ A VELOCITY TAPE and return a matrix of velocities
C  LANGUAGE:      FORTRAN
C  AUTHOR:        M. A. Thornton   
C  ORIGIN DATE:   91/01/24
C***********************************************************************
C  CATEGORY:      GENERAL PURPOSE
C  ENTRY TYPE:    SINGLE_ENTRY
C  PARAMETERS:
C      lprt           LOGICAL UNIT NUMBER FOR PRINT OUTPUT
C      lu3            velocity Tape logical unit
C      dxd            delta-x of the data
C      dzd            delta-z of the data
C      v              matrix of velocities
C      mxsam          max. no. samples per trace
C      mxtra          max. no. traces per record
C      rxx            TRACE 
C      irx            Trace header
C      data           the trace data without the header
C      vmin           minimum velocity on tape
C      vmax           maxmum velocity on tape
C      ierr           error flag for sucessful completion of subroutine
C  KEYWORDS:
C  LOGICAL UNITS:
C  FORTRAN SUPPLIED ROUTINES:
C**************************************************  END SCAN INFO  ****
C  GENERAL DESCRIPTION:
C  DESCRIPTION OF KEY VARIABLES:
C  ERROR HANDLING:
C  SPECIAL CONSIDERATIONS:
C***********************************************************************
      SUBROUTINE RVTAP(LPRT,LU3,DXD,DZD,ld,kd,V,MXSAM,MXTRA,RXX,
     &IRX,DATA,vmin,vmax,ierr,LINHED)
      dimension ihead(1500), rxx(*), irx(*), data(*)
      dimension v(mxsam,mxtra)

C*******************************************************************
C     READ LINE HEADER -  tape must be open exterior to this routine
C*******************************************************************
      ierr = 0
      jeof = 0
      call rtape (lu3, ihead, jeof)
      if (jeof .eq. 0) then
         Write (lprt, *) ' ERROR READING LINE HEADER'
         ierr = 75
         return
      endif
      call saver(ihead, 'NumTrc', ltr, LINHED)
      call saver(ihead, 'NumRec', nrec, LINHED)
      call saver(ihead, 'NumSmp', ksamp, LINHED)
      call saver(ihead, 'Dx1000', idx, LINHED)
      call saver(ihead, 'Dz1000', idz, LINHED)
      call saver(ihead, 'MinVel', ivmin, LINHED)
      call saver(ihead, 'MaxVel', ivmax, LINHED)
      dxn   = idx / 1000.0       
C ! trace spacing
      dzn   = idz / 1000.0       
C ! depth spacing
      vmin  = ivmin              
      vmax  = ivmax              
C   check to see if velocity dataset matches the data to within 1/100%
      xd = abs(dxn-dxd)
      zd = abs(dzn-dzd)
      xp = .0001 * dxd
      zp = .0001 * dzd
      if(xd .gt. xp .or. zd .gt. zp .or. ltr.lt.ld .or. 
     &  ksamp.lt.kd) then
         write(lprt,*)' Velocity tape does not match the data'
         Write(lprt,10)ltr,ksamp,dxn,dzn,dxd,dzd
   10    format(' No. of traces : ',i10,/
     1          ' No. of samples: ',i10,/
     2          ' Trace spacing (velocity): ',f40.20,/
     3          ' Depth spacing (velocity): ',f40.20,/
     4          ' Trace spacing (data): ',f40.20,/
     5          ' Depth spacing (data): ',f40.20)
         ierr = 100
         return
      endif
C     read the tape
      do 110 L = 1,ltr
         jeof = 0
         call rtape (lu3, rxx, jeof)
         if (jeof .eq. 0) then
            write (lprt, *) ' ERROR READING TRACE', l
            ierr = 75
         endif
         if (irx(125) .eq. 30000) then
            write (lprt, *) 'DEAD TRACE ON VELOCITY TAPE, trace = ', l
            ierr = 75
            return
         endif
         do 105 k=1,ksamp
            v(k,l) = data(k)
            if(v(k,l) .le. 0.0)then
               write(lprt,*)' zero velocity found in trace no.',l
               ierr = 75
               return
            endif
  105    continue
  110 continue
C
C     if the min and max velocity are not set in lineheader, pick them out
C     of the data
      if(vmin .le. 0.0 .or. vmax .le. 0.0)then
         vmin = 100000.
         vmax = 0.0
         do 200 l=1,ltr
            do 200 k=1,ksamp
               if(v(k,l) .lt. vmin)vmin = v(k,l)
               if(v(k,l) .gt. vmax)vmax = v(k,l)
  200    continue
         write(lprt,*)' WARNING-Maximum velocity in line header is zero'
         write(lprt,201) vmin
         write(lprt,202) vmax
  201    format(' Minimum velocity on tape is ',f10.2)
  202    format(' Maximum velocity on tape is ',f10.2)
      endif
      call lbclos (lu3)
      return
      end
