C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      program PREPMOD           
C**********************************************************************C
C
C PREPMOD READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C
c     it outputs a flat file containing record number, shotnumber,
c     group index, signed shot-trace distances, shot position.
C**********************************************************************C
      parameter (maxs=2)
      dimension s(maxs)
      pointer   (pntrs,s)
c
      character*(128) file_geom,file_topo,file_water
      character*7 name
c
      integer argis
      integer stderr
      dimension cputim(30) , waltim(30)
      logical query
      logical rdtopo,rdwater,linv
      real    firstshot,firstoff,doff,dshot
      parameter (undefined=-999999.)   
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
#include <f77/pid.h>
      data     lugeom/11/,lutopo/12/,luwater/13/
      data     name /'PREPMOD'/
c
      stderr=ler
c____________________________________________________________________
c     get online help if necessary
c____________________________________________________________________
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help(ler)
           call exitfu(0)
      endif
      call vclr(cputim,1,30)
      call vclr(waltim,1,30)
c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     read program parameters from command line argument string
C**********************************************************************C
      call cmdlin(file_geom,file_topo,file_water,rdtopo,rdwater,
     1            nshot,ntrace,nsamp,dtmsec,
     2            firstshot,dshot,firstoff,doff,
     3            dsta,dz,zvo,zdatum,minrecind,maxrecind,
     4            lerr,ler,azim,undefined,linv)
C**********************************************************************C 
C     open seismic data tape.         
C**********************************************************************
c______________________________________________________________________
c     open output flat files.
c______________________________________________________________________
      if(file_geom .ne. ' ') then
         open(lugeom,file=file_geom,status='UNKNOWN',
     1        form='FORMATTED')
      else
         lugeom = LOT
      endif
c
      if(file_topo .ne. ' ') then
         open(lutopo,file=file_topo,status='UNKNOWN',
     1        form='FORMATTED')
      endif
      if(rdtopo) then
C__________________________________________________________________
c        read in control information from xsd format topography
c        file.
C__________________________________________________________________
         read(lutopo,200) 
     1                 recunit,dtopo,smpunit,
     2                 nrec1,ntrace1,nsamp1,
     3                 recoff,trcoff,smpoff,
     4                 nsegments,maxpicks
200      format(6x,f12.3,1x,f12.3,1x,f12.3,1x,i5,1x,i5,1x,i5,
     1          7x,f12.3,1x,f12.3,1x,f12.3,8x,i5,1x,i5)
C__________________________________________________________________
c        read in the picks the first time to determine the minimum
c        and maximum x values.
C__________________________________________________________________
201      format(10x,i5,6x,20x,10x,i5,9x,i5)
         read(lutopo,201) iseg,
     1                    icolor,
     2                    npicks
         xtopomin=+999999.
         xtopomax=-999999.
         do 90100 jtopo=1,npicks
          read(lutopo,102) recno,xtopo,ztopo
          xtopomin=min(xtopo,xtopomin)
          xtopomax=max(xtopo,xtopomax)
90100    continue
         mintopo=nint(xtopomin/dsta)+1
         maxtopo=nint(xtopomax/dsta)+1
102      format(f12.3,1x,f12.3,1x,f12.3)
         if ((mod(dsta,dtopo).ne.0.).and.(mod(dtopo,dsta).ne.0.)) then
            write(lerr,*) 'probable error in routine prepmod'
            write(lerr,*) 'program assumes topography increment ',dtopo,
     1             ' and station increment ',dsta,' can be multiples of'
     2           //' each other'
            write(lerr,*) 'if you dont like this, call bert duquet'
     1           //' at socon 422-3982 with visa card in hand!'
            call exit(666)
         endif
         if (mintopo.lt.minrecind) then
           write(lerr,*) 'ming too big'
           call exit(666)
         endif
         if (maxtopo.gt.maxrecind) then
           write(lerr,*) 'maxg too small'
           call exit(666)
         endif
C__________________________________________________________________
c        rewind and read past the first record again!
C__________________________________________________________________
         rewind lutopo
         read(lutopo,200) 
     1                 recunit,trcunit,smpunit,
     2                 nrec1,ntrace1,nsamp1,
     3                 recoff,trcoff,smpoff,
     4                 nsegments,maxpicks
      else
       mintopo=minrecind
       maxtopo=maxrecind
      endif

c
      if(file_water .ne. ' ') then
         open(luwater,file=file_water,status='UNKNOWN',
     1        form='FORMATTED')
      endif
      if(rdwater) then
C__________________________________________________________________
c        read in control information from xsd format topography
c        file.
C__________________________________________________________________
         read(luwater,200)
     1                 recunit,dwater,smpunit,
     2                 nrec1,ntrace1,nsamp1,
     3                 recoff,trcoff,smpoff,
     4                 nsegments,maxpicks
C__________________________________________________________________
c        read in the picks the first time to determine the minimum
c        and maximum x values.
C__________________________________________________________________
         read(luwater,201) iseg,
     1                    icolor,
     2                    npicks
         xwatermin=+999999.
         xwatermax=-999999.
         do 90101 jtopo=1,npicks
          read(luwater,102) recno,xwater,zwater
          xwatermin=min(xwater,xwatermin)
          xwatermax=max(xwater,xwatermax)
90101    continue
         minwater=nint(xwatermin/dsta)+1
         maxwater=nint(xwatermax/dsta)+1
         if ((mod(dsta,dwater).ne.0.).and.(mod(dwater,dsta).ne.0.)) then
            write(lerr,*) 'probable error in routine prepmod'
            write(lerr,*) 'program assumes water increment ',dwater,
     1             ' and station increment ',dsta,' can be multiples of'
     2           //' each other'
            write(lerr,*) 'if you dont like this, call bert duquet'
     1           //' at socon 422-3982 with visa card in hand!'
            call exit(666)
         endif
         if (minwater.lt.minrecind) then
           write(lerr,*) 'ming too big'
           call exit(666)
         endif
         if (maxwater.gt.maxrecind) then
           write(lerr,*) 'maxg too small'
           call exit(666)
         endif
C__________________________________________________________________
c        rewind and read past the first record again!
C__________________________________________________________________
         rewind luwater
         read(luwater,200)
     1                 recunit,trcunit,smpunit,
     2                 nrec1,ntrace1,nsamp1,
     3                 recoff,trcoff,smpoff,
     4                 nsegments,maxpicks
      else
       minwater=minrecind
       maxwater=maxrecind
      endif

c
      ioversion=3
      write(lugeom,'(4a12)') 'nsamp','dtmsec','ntrace','ioversion'
      write(lugeom,'(i12,f12.3,2i12)') nsamp,dtmsec,ntrace,ioversion
c
      write(LERR,*)
      write(LERR,*) ' Traces per Record        =  ', ntrace
      write(LERR,*) ' Records per Line         =  ', nshot
      write(LERR,*) ' samples per trace        =  ', nsamp
      write(LERR,*) ' sample increment         =  ', dtmsec   
      write(LERR,*) ' datum value              =  ', zdatum     
      write(LERR,*) ' xtopomin                 =  ', xtopomin
      write(LERR,*) ' xtopomax                 =  ', xtopomax
      write(LERR,*) ' mintopo                  =  ', mintopo
      write(LERR,*) ' maxtopo                  =  ', maxtopo
      write(LERR,*) ' xwatermin                =  ', xwatermin
      write(LERR,*) ' xwatermax                =  ', xwatermax
      write(LERR,*) ' minwater                 =  ', minwater
      write(LERR,*) ' maxwater                 =  ', maxwater

      maxg=maxrecind-minrecind+1
c________________________________________________________________________
c     calculate memory requirements
c________________________________________________________________________
      WRITE(lerr,'(///,80A1)') ('_',I=1,80)
      WRITE(lerr,'(A)')'STORAGE MAP OF MAJOR ARRAYS'
      WRITE(lerr,'(80A1)') ('_',I=1,80)
      WRITE(lerr,'(A20,3A10)')'VARIABLE NAME','BEGIN','END','LENGTH'
C
      l_FREE=1
      call mapmem('xs',l_xs,l_free,nshot,lerr) 
      call mapmem('ys',l_ys,l_free,nshot,lerr) 
      call mapmem('zs',l_zs,l_free,nshot,lerr) 
      call mapmem('soptnm',l_soptnm,l_free,nshot,lerr) 
      call mapmem('nlive',l_nlive,l_free,nshot,lerr) 
      call mapmem('xdistmin',l_xdistmin,l_free,nshot,lerr) 
      call mapmem('xdistmax',l_xdistmax,l_free,nshot,lerr) 
      call mapmem('zdistmin',l_zdistmin,l_free,nshot,lerr) 
      call mapmem('zdistmax',l_zdistmax,l_free,nshot,lerr) 
c
      call mapmem('recind',l_recind,       
     1             l_free,ntrace*nshot,lerr) 
      call mapmem('xr',l_xr,l_free,ntrace*nshot,lerr) 
      call mapmem('yr',l_yr,l_free,ntrace*nshot,lerr) 
      call mapmem('zr',l_zr,l_free,ntrace*nshot,lerr) 
      call mapmem('live',l_live,l_free,ntrace*nshot,lerr) 
c
      call mapmem('ztopo',l_ztopo,l_free,maxg,lerr) 
      call mapmem('xg',l_xg,l_free,maxg,lerr) 
      call mapmem('yg',l_yg,l_free,maxg,lerr) 
      call mapmem('zg',l_zg,l_free,maxg,lerr) 
      call mapmem('zw',l_zw,l_free,maxg,lerr) 
      call mapmem('lrecind',l_lrecind,l_free,maxg,lerr) 
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for PREPMOD: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(stderr,'(//,a)') 'allocate dynamic memory for PREPMOD: '
      write(stderr,*) 1.e-6*lens,' Mwords'
      write(stderr,*) 1.e-6*lens*szsmpd,' Mbytes'
c
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)'program PREPMOD aborted'
         close(lerr)
         call exitfu(101)
      endif
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
c
      call vclr(s,1,lens)
c
      call prepsub(firstshot,dshot,firstoff,doff,s(l_soptnm),
     1             s(l_xs),s(l_ys),s(l_zs),s(l_xr),s(l_yr),s(l_zr),
     2             s(l_recind),s(l_live),s(l_xg),s(l_yg),s(l_zg),
     3             s(l_zw),s(l_nlive),s(l_ztopo),
     4             s(l_lrecind),minrecind,maxrecind,s(l_xdistmin),
     5             s(l_xdistmax),s(l_zdistmin),s(l_zdistmax),
     6             dsta,zdatum,nshot,ntrace,lugeom,cputim,waltim,
     7             lutopo,luwater,rdtopo,rdwater,
     8             zvo,dz,azim,stderr,lerr,undefined,mintopo,maxtopo,
     9             minwater,maxwater,linv,dtopo,dwater)
c
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read headers',cputim(1),waltim(1),
     2         'process headers',cputim(2),waltim(2),
     3         'write flat file',cputim(3),waltim(3),
     4         'total',cputim(20),waltim(20)       

      write(lerr,*) 'normal completion of PREPMOD'
      write(stderr,*) 'normal completion of PREPMOD'
      close(luwater)
      close(lutopo)
      close(lerr)
      close(lugeom)
c
      call exitfu(0)
      end
c------------------------------
c  online help section
c------------------------------
      subroutine  help(ler)

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for PREPMOD: '
        write(LER,*)'preprocessing for modeling program kmod'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-O[file_geom]  -- output geometry flat file '
     1                             //'(stdout)'
        write(LER,*)'-T[file_topo]  -- input xsd format topography'
        write(LER,*)'                  output if file doesn''t exist'
        write(LER,*)'-W[file_water] -- input xsd format water bottom '
        write(LER,*)'                  output if file doesn''t exist'
        write(LER,*)'-nsamp     -- number of times samples to be'
     1                         //' modeled (1024)'
        write(LER,*)'-dtmsec    -- time sampling increment (4)'
        write(LER,*)'-dshot     -- distance between adjacent shot'
     1                         //' location in m or ft'
        write(LER,*)'-fshot     -- lateral location of first shot'
     1                         //' to be modeled in m or ft'
        write(LER,*)'-nshot     -- number of shots'
        write(LER,*)'-dsta      -- distance between adjacent station'
     1                         //' location in m or ft'
        write(LER,*)'-ftra      -- first trace position associated with'
     1                         //' the first shot in m or ft'
        write(LER,*)'-ntrace    -- number of traces for each shot'
        write(LER,*)'-zdatum    -- elevation value if file_topo'
     1                         //' doesn''t exist (0.)'
        write(LER,*)'-zvo       -- velocity worktape z origin (used for'
     1                         //' output xsd pick files (0.)'
        write(LER,*)'-dz        -- velocity worktape z increment (used '
     1                         //' for output xsd pick files (10.)'  
        write(LER,*)'-ming      -- minimum station index'
     1                         //' (-10000)'
        write(LER,*)'-maxg      -- maximum station index'
     1                         //' (+32667)'
        write(LER,*)
        write(LER,*)'usage:'
        write(LER,*)'       prepmod -O[] -T[] -W[] -zdatum[] -dz[] '
     1                              //'-zvo[]'
        write(ler,*)'               -nsamp -dtmsec -dshot[] -fshot[] '
     1                              //'-nshot[]'
        write(ler,*)'               -dsta[] -ftra[] -ntrace[] -ming[] '
     1                              //'-maxg[]'
        write(LER,*)' '

      return
      end

C***********************************************************************
      subroutine cmdlin(file_geom,file_topo,file_water,rdtopo,rdwater,
     1                  nshot,ntrace,nsamp,dtmsec,
     2                  firstshot,dshot,firstoff,doff,
     3                  dsta,dz,zvo,zdatum,minrecind,maxrecind,
     4                  lerr,ler,azim,undefined,linv)
c-----
c     get command arguments
c
c__________________________________________________________________
      character*(*)  file_geom,file_topo,file_water
      integer        argis
      logical        rdtopo,rdwater,linv
      real           firstshot,firstoff,dshot,doff
      real           dtmsec
      integer        nshot,ntrace,nsamp

      real           firsttra
      logical        lexist
      ierror=0

      call argstr('-O',file_geom,' ',' ') 
      call argstr('-T',file_topo,' ',' ') 
      call argstr('-W',file_water,' ',' ') 
      linv=(argis('-inv') .gt. 0)
      call argr4('-zvo',zvo,0.,0.)
      call argr4('-dsta',dsta,0.,0.)
      call argr4('-dz',dz,10.,10.)
      call argr4('-dshot',dshot,0.,0.)
      call argr4('-fshot',firstshot,undefined,undefined)
      call argr4('-ftra',firsttra,undefined,undefined)
      call argi4('-ming',minrecind,-10000,-10000)     
      call argi4('-maxg',maxrecind,+32667,+32667)  
      call argi4('-nshot',nshot,0,0)  
      call argi4('-ntrace',ntrace,0,0)  
      call argi4('-nsamp',nsamp,1024,1024)  
      call argr4('-dtmsec',dtmsec,4.,4.)
      call argr4('-zdatum',zdatum,0.,0.)

      doff=dsta
      firstoff=firsttra-firstshot

      inquire(file=file_topo,exist=lexist)
      if (lexist) then
         rdtopo	= .true.
      else
         rdtopo =.false. 
      endif

      inquire(file=file_water,exist=lexist)
      if (lexist) then
         rdwater = .true.
      else
         rdwater = .false. 
      endif
c
      azim=0.     
c
      if(dsta .eq. 0) then
        write(lerr,*) 'cmdlin error'         
        write(lerr,*) 'station/group increment must be explicitly'
        write(lerr,*) 'entered as a nonzero number!'
        ierror=ierror+1
      endif
c
      if (dshot .eq. 0) then
        write(lerr,*) 'cmdlin error'        
        write(lerr,*) 'shot increment must be explicitly'
        write(lerr,*) 'entered as a nonzero number!'
        ierror=ierror+1
      endif

      if (ntrace .eq. 0) then
        write(lerr,*) 'cmdlin error'        
        write(lerr,*) 'number of traces must be explicitly'
        write(lerr,*) 'entered as a nonzero number!'
        ierror=ierror+1
      endif

      if (nshot .eq. 0) then
        write(lerr,*) 'cmdlin error'        
        write(lerr,*) 'number of shots must be explicitly'
        write(lerr,*) 'entered as a nonzero number!'
        ierror=ierror+1
      endif

      if (firstshot .eq. undefined) then
        write(lerr,*) 'cmdlin error'        
        write(lerr,*) 'first shot position must be explicitly'
        write(lerr,*) 'entered!'
        ierror=ierror+1
      endif

      if (firsttra .eq. undefined) then
        write(lerr,*) 'cmdlin error'        
        write(lerr,*) 'first trace value must be explicitly'
        write(lerr,*) 'entered!'
        ierror=ierror+1
      endif

      if(ierror .gt. 0) then 
         write(lerr,*) 'routine PREPMOD aborted'
         close(lerr)
         call exitfu(666)
      endif
c
      return
      end
