C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c ptop.F   
c Read a pressure or pressure gradient dataset (or velocity...) and 
c extract the depth of the specified pressure or gradient. 
c The depth can be the first occurence
c (mode 1) or the deepest top found on the trace (mode 2). The output
c is a 3 column ascii file (X Y Z), where X and Y are any two trace 
c indices and Z is the depth to the first occurence of the pressure.
c
c Martin Albertin                            September 16, 1996
c
c************************************************************************
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr  (SZLNHD)
      real        amp  (SZLNHD)
      real        pvalue, dz

      integer     nsamp, ntrc, nrec, iform
      integer     luin1, luout, lbytes, nbytes
      integer     ifmt_Wrd1, l_Wrd1, ln_Wrd1, Wrd1
      integer     ifmt_Wrd2, l_Wrd2, ln_Wrd2, Wrd2


      character   ntap  * 255, ofil * 255
      character   name*7, version*4
      character   mnemonic1*6, mnemonic2*6
      logical     hlp, query, writeflag
      integer     argis, lhdz, md, sd
      data lbytes/ 0 /, nbytes/ 0 /, name/'PTOP'/, version/' 1.0'/ 

c read program parameters from command line card image file
      query = ( argis ( '-?' ) .gt. 0 )
      hlp = ( argis ( '-h' ) .gt. 0 )
      if ( query .or. hlp )then
            call help()
            stop
      endif

c open printout file
#include <f77/open.h>


c read command line arguments
      call cmdln(ntap,ofil,pvalue,dz,md,mnemonic1,mnemonic2)

      if(md .eq. -1) then
         write(LER,*)'You must specify a scan mode (-mode[]) '
         write(LER,*)'on the command line.  '
         write(LER,*)'JOB TERMINATED ABNORMALLY'
         stop
      endif

c open input and output files
      call getln(luin1 , ntap ,'r', 0)
      luout = 29
      open (unit=luout, file=ofil, status='unknown', iostat=ierr)

c read line header from seismic dataset
      call rtape(luin1, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)'No line header read from unit ',luin
         write(LER,*)'JOB TERMINATED ABNORMALLY'
         stop
      endif

c save values from line header
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'Dz1000', lhdz, LINHED)

      if(dz .eq. -1.0) then
         dz = lhdz/1000
      endif

      write(LER,*)' NumSmp = ', nsamp
      write(LER,*)' NumTrc = ', ntrc
      write(LER,*)' NumRec = ', nrec
      write(LER,*)' Dz = ', dz
  
c print line header into printer listing
      call hlhprt(itr, lbytes, name, 5, LERR)

c--------------------------------------------------
c     BEGIN PROCESSING
c--------------------------------------------------

c set up hooks to header mnemonics 
 
      call savelu(mnemonic1,ifmt_Wrd1,l_Wrd1,ln_Wrd1,TRACEHEADER)
      call savelu(mnemonic2,ifmt_Wrd2,l_Wrd2,ln_Wrd2,TRACEHEADER)

c     write (LER,*)'Header 1: ', mnemonic1,' Header 2: ',mnemonic2

c loop on records   
      do 1005  mm = 1, nrec

c loop on traces
      do 1010  nn = 1, ntrc
         nbytes = 0
         call rtape(luin1, itr, nbytes)
         if(nbytes .eq. 0) then
            write(LERR,*)'End of file on input:',luin1
            write(LERR,*)'  trace= ',nn
            go to 999
         endif

         call vmov ( itr(ITHWP1), 1, amp, 1, nsamp )

         call saver2 ( itr, ifmt_Wrd1, l_Wrd1, ln_Wrd1,
     :                 Wrd1 , TRACEHEADER )
         call saver2 ( itr, ifmt_Wrd2, l_Wrd2, ln_Wrd2,
     :                 Wrd2 , TRACEHEADER )
 
c loop on samples 
         sd = nsamp
         writeflag=0
         do 1015 kk = 1,nsamp
            if (pvalue .le. amp(kk)) then
               depth = dz * (kk-1)
               sd = kk+1
c              kk=nsamp+1
               writeflag=1
               goto 1016
            endif
 1015    continue

 1016    continue

         if (md .eq. 2) then
            writeflag=0
            do 1017 kk = sd,nsamp
               if (pvalue .gt. amp(kk)) then
                  depth = dz * (kk-1)
                  sd = kk+1
c                 kk=nsamp+1
                  writeflag=1
                  goto 1018
               endif
 1017       continue

 1018       continue

         endif

         if (writeflag) then
            write(luout,'(2(i10,2x),f12.0)') Wrd1,Wrd2,depth
         endif

 1010 continue
 1005 continue

c--------------------------------------------------
c     END PROCESSING
c--------------------------------------------------
 
  999 continue
 
c close data files
      call lbclos(luin1)
      close (luout)
      end
 
C***********************  SUBROUTINE  **********************************
      subroutine help()
 
c provide terse online help [detailed help goes in man page]
 
#include <f77/iounit.h>
 
c...5....0....5....0....5....0....5....0....5....0....5....0....5....0..
      write(LER,*)'                                                    '
      write(LER,*)' ================================================== '
      write(LER,*)'                                                    '
      write(LER,*)' Command Line Arguments for program: ptop           '
      write(LER,*)'                                                    '
      write(LER,*)' PTOP reads a pressure or pressure gradient dataset '
      write(LER,*)' (or velocity model for that matter...)             '
      write(LER,*)' and extracts the depth of the first occurence of a '
      write(LER,*)' specified pressure or gradient. The output is a 3  '
      write(LER,*)' column ascii file (X Y Z), where X and Y are any   '
      write(LER,*)' two trace indices and Z is the depth to the first  '
      write(LER,*)' occurence of the pressure.                         '
      write(LER,*)'                                                    '
      write(LER,*)'                                                    '
      write(LER,*)' -N[]   -- input data set                    (stdin)'
      write(LER,*)' -O[]   -- output ascii data set                    '
      write(LER,*)' -pval[]-- pressure value for depth extraction      '
      write(LER,*)' -dz[]  -- depth sample interval (default=Dz1000)   '
      write(LER,*)' -mode[]-- scan mode (1 = first occurence  )        '
      write(LER,*)'                     (2 = deepest top      )        '
      write(LER,*)' -hw1[] -- first header index mnemonic to output    '
      write(LER,*)' -hw2[] -- second header index mnemonic to output   '
      write(LER,*)'                                                    '
      write(LER,*)' Usage:                                             '
      write(LER,*)'  ptop -N[] -O[] -pval[] -dz[] -mode[] -hw1[] -hw2[]'
      write(LER,*)'                                                    '
      write(LER,*)' ==================================================='
      write(LER,*)'                                                    '
      return
      end
 
C***********************  SUBROUTINE  **********************************
      subroutine cmdln(ntap,ofil,pvalue,dz,md,mnemonic1,mnemonic2)
#include <f77/iounit.h>
 
      character  ntap*(*), ofil*(*)
      character  mnemonic1*6, mnemonic2*6
      integer    md
      real       pvalue, dz
 
 
      call argstr( '-hw1',mnemonic1, ' ', ' ' )
      call argstr( '-hw2',mnemonic2, ' ', ' ' )
      call argr4('-pval',pvalue,0.0,0.0)
      call argi4('-mode',md,-1,-1)
      call argr4('-dz',dz,-1.0,-1.0)
      call argstr ( '-N', ntap, ' ', ' ' )
      call argstr ( '-O', ofil, ' ', ' ' )
 
      return
      end
