c***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       RMSVEL                                               *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:       Output interval velocities from rms velocities and   *
C                 2-way travel times                                   *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   N.D.Whitmore, Jr.                  ORIGIN DATE:   /  /    *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 89/03/17  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGR4           -                                               *
C      ARGSTR          -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LPCK  ( output SEQUENTIAL ) -                                   *
C      LPRT  ( OUTPUT SEQUENTIAL ) -                                   *
C      LT    ( OUTPUT SEQUENTIAL ) -                                   *
C      LVEL  ( INPUT  SEQUENTIAL ) -                                   *
C      0     ( standard in for c routines  )                           *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 5) - no errors                                       *
C      =50   =  ( 5) - error on input cards                            *
C      =100  =  ( 5) - user error                                      *
C      =200  =  ( 5) - error opening printout                          *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  THIS ROUTINE READS 'picks' (from xsd/oper)    *
C       - and outputs a list of interval velocities                    *
C       - VELOCITY TAPE                                                *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/08/02  *
C       - Move to sun for maintenance and distribution from the sun    *
C       - Also changed code to open a printout as the other programs do*
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/09/02  *
C       - Add argument 'inc' showing the panel increment from velspec  *
C  REVISED BY:  MARY ANN THORNTON  V:2.2      REVISION DATE: 92/03/27  *
C       - Call openpr with full program name for OS 6.1                *
C  REVISED BY:  MARY ANN THORNTON  V:2.3      REVISION DATE: 92/04/15  *
C       - Allow the output cards to contain the 1st pick in, and then  *
C       - interpolate for the other picks from there (the first pick
C       - did not show up in the output when it was less than the 
C       - interpolation spacing in previous versions of this code)     
C  Recompiled with newest sun compiler   5/12/92
C  REVISED BY:  MARY ANN THORNTON  V:3.0      REVISION DATE: 93/06/11  *
C       - Change code to read ttol as a command line argument, and let
C       - the default be 240 (as it is set now).  
C       - add the logical unit for the HP, use the rdpicks routine to 
C       - read in the picks
C       - Include the offset in the calculation for the vrms           *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/hp.h>

#include "lpick.h"

      PARAMETER (LPRT=26, LPCK=27, LLIST=25, LVEL=28)
      real vrms(1024),time(1024),vint(1024),depth(1024)

      dimension npicks(1000), offset(3), units(3)
      dimension rec(1), trac(1), samp(1), icolor(1)
      character*20 name(1000)

      CHARACTER*1   PARR(66)
      CHARACTER*4  VERSION
      CHARACTER*6  PPNAME
      CHARACTER*128 PICKS, VEL
      INTEGER ARGIS
      LOGICAL HELP
      DATA VERSION/' 3.1'/
      DATA PPNAME/'RMSVEL'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ','C','O','N','V',
     2          'E','R','T',' ','R','M','S',' ','T','O',
     3          ' ','I','N','T','E','R','V','A','L',' ',
     4          'V','E','L','O','C','I','T','I','E','S',
     5          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     6          ' ',' ',' ',' ',' ',' '/


      LT = LER

      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)

9999  IF(HELP)THEN

        WRITE(LT,*)'Command Line Arguments'
        WRITE(LT,*)'   Convert RMS Velocities to Interval Velocities'
        WRITE(LT,*)' '
        WRITE(LT,*)' Input '
        WRITE(LT,*)'-vm[vmin]  : minimum velocity'
        WRITE(LT,*)'-dv[deltav]: deltav - velocity incremenT'
        WRITE(LT,*)'-dx[dxrec] : record spacing of original data set'
        WRITE(LT,*)'             given to program editt'
        WRITE(LT,*)'-rs[irs]   : starting record number'
        WRITE(LT,*)'             given to program editt'
        WRITE(LT,*)'             Default is the record increment'
        WRITE(LT,*)'-R0[rdel]  : record increment'
        WRITE(LT,*)'             given to program editt'
        WRITE(LT,*)'-dt[deltat]: sample interval in ms'
        WRITE(LT,*)'-ttol[ttol]: travel time tolerance in ms'
        WRITE(LT,*)'             Default is 240 ms'
        WRITE(LT,*)'-P[picks]  : card file containing xsd picks'
        WRITE(LT,*)'-M[vel]    : output velocity function file name'
        WRITE(LT,*)'-Z[zmax]   : maximum depth'
        WRITE(LT,*)'Usage:'
        WRITE(LT,*)
     &        'rmsvel -vm[] -dv[] -dx[] -rs[] -R0[] -dt[] -ttol[]',
     &              ' -P[] -M[] -Z[]'
        WRITE(LT,*)' '
        WRITE(LT,*)' '
        WRITE(LT,*)' Program xsd2vlmx is available as a replacement'
        WRITE(LT,*)' for program rmsvel. rmsvel was last updated in'
        WRITE(LT,*)' June 1993 and will not be updated again.'
        WRITE(LT,*)' See the manual page for program xsd2vlmx'
        STOP
      ENDIF

      CALL ARGR4('-vm',vmin,0.0,0.0)
      CALL ARGR4('-dv',deltav,0.0,0.0)
      CALL ARGR4('-dx',dxrec,0.0,0.0)
      CALL ARGI4('-inc',inc,0,0)
      CALL ARGI4('-rs',irs,0,0)
      CALL ARGI4('-R0',irinc,0,0)
      CALL ARGR4('-dt',deltat,0.0,0.0)
      CALL ARGR4('-ttol',ttol,240.0,240.0)
      CALL ARGSTR('-P',PICKS,' ',' ')
      CALL ARGSTR('-M',VEL,' ',' ')
      CALL ARGR4('-Z',zmax,0.0,0.0)

      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include<mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)
      WRITE(lprt,*)' '
      WRITE(lprt,*)' '
      WRITE(lprt,*)' Program xsd2vlmx is available as a replacement'
      WRITE(lprt,*)' for program rmsvel. rmsvel was last updated on'
      WRITE(lprt,*)' June 18, 1993, and will not be updated again.'
      WRITE(lprt,*)' See the manual page for program xsd2vlmx'
      WRITE(lprt,*)' '
      WRITE(lprt,*)' '

      if(ttol.le.0.0)ttol = 240.
c  
c     To allow rmsvel to run on old decks that contain the command
c     line flag (-inc) we will do the following:
c       1) if R0 is present, use it and ignore inc
c       2) if inc is there, set R0 = inc, rs = inc, ignore rs,
c             where R0 is the flag for irinc, rs is the flag for irs
c       3) if R0 and inc are both missing, abort job.

      if(irinc.gt.0) go to 33
      if(inc.gt.0)then
         irinc = inc
      endif
      if(irinc.le.0 .and. inc.le.0)then
        write(lprt,*)' You must enter the record increment that was',
     &  'given to program editt'
        write(lprt,*)' Job terminated'
        stop 100
      endif
   33 continue
      if(irs.le.0)then
         write(lprt,*)' The starting record was not entered. It will'
         write(lprt,*)' be set equal to the record increment. If '
         write(lprt,*)' this is wrong, the location of the velocity '
         write(lprt,*)' function printed on the MODEL card will also'
         write(lprt,*)' be wrong.'
         write(lt  ,*)' The starting record was not entered. It will'
         write(lt  ,*)' be set equal to the record increment. If '
         write(lt  ,*)' this is wrong, the location of the velocity '
         write(lt  ,*)' function printed on the MODEL card will also'
         write(lt  ,*)' be wrong.'
         irs = irinc
      endif
      IF(vmin.le.0.0)THEN
           write(lprt,*)'minimum velocity must be entered'
           write(lprt,*)'Job terminated'
           write(lt,*)'minimum velocity must be entered'
           write(lt,*)'Job terminated'
      endif
      if(deltav.le.0.0)then
           write(lprt,*)'deltav must be entered'
           write(lprt,*)'Job terminated'
           write(lt,*)'deltav must be entered'
           write(lt,*)'Job terminated'
      endif

      IF(dxrec.le.0.0)THEN
           write(lprt,*)'record spacing must be entered'
           write(lprt,*)'Job terminated'
           write(lt,*)'record spacing must be entered'
           write(lt,*)'Job terminated'
      endif
      if(deltat.le.0.0)then
           write(lprt,*)'deltat must be entered'
           write(lprt,*)'Job terminated'
           write(lt,*)'deltat must be entered'
           write(lt,*)'Job terminated'
      endif

      jerr = 0
      IF(PICKS.NE.' ')THEN
         OPEN(UNIT=LPCK,FILE=PICKS,STATUS='OLD',IOSTAT=jerr)
         if(jerr.ne.0)then
           write(lprt,*)' error opening file containing picks'
           write(lprt,*)' Job terminated'
           write(lt,*)' error opening file containing picks'
           write(lt,*)' Job terminated'
           stop 100
         endif
      ELSE
           write(lprt,*)'filename of picks must be entered'
           write(lprt,*)'Job terminated'
           write(lt,*)'filename of picks must be entered'
           write(lt,*)'Job terminated'
           stop 100
      ENDIF
      IF(VEL.NE.' ')THEN
         OPEN(UNIT=lvel,FILE=VEL)
      ELSE
         vel = 'temp.vel'
         OPEN(UNIT=lvel,FILE=vel)
         write(lprt,*)' output velocity filename is temp.vel'
         write(lt,*)' output velocity filename is temp.vel'
      ENDIF
      WRITE(LPRT,37)PICKS
   37 FORMAT(' INPUT PICKS DATASET = '/,A128)
      WRITE(LPRT,38)VEL
   38 FORMAT(' OUTPUT VELOCITY DATASET = '/,A128)
      WRITE(LPRT,10)
   10 FORMAT (//, 27X, 'PROGRAM PARAMETERS',//)
      WRITE(LPRT,11)vmin,deltav,dxrec,deltat,irinc,irs,zmax
   11 FORMAT(
     *' Minimum velocity                       ', 10X,'=',F12.4,/
     *' Delta-v (velocity increment)           ', 10X,'=',F12.4,/
     *' Delta-x (dx spacing-original data set) ', 10X,'=',F12.4,/
     *' Delta-t (sample interval)              ', 10X,'=',F12.4,/
     *' R0      (editt increment)              ', 10X,'=',I12  ,/
     *' rs      (editt starting record)        ', 10X,'=',I12  ,/
     *' Maximum depth                          ', 10X,'=',F12.4)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  READ THE X,T POINTS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      call rdpick(cardl,cardd,card,prec,ptrac,psamp,pcolor,name,
     &            npicks,units,offset,maxseg,maxpik,SZSMPD,nrec,
     &            ntrac,nsamp,lprt,lpck,jerr)
      if(jerr.eq.300)then
         write(lprt,*)' Errors in reading the xsd picks indicate'
         write(lprt,*)'   the picks may be in the old format.  You'
         write(lprt,*)'   should run:'
         write(lprt,*)' '
         write(lprt,*)'   xsd2xsd -Pold_picks_filename -POnew_picks',
     &                   '_filename'
         write(lprt,*)' '
         write(lprt,*)'   to convert the picks to the new format.'
         write(lprt,*)'   and then run rmsvel again.'
         write(lt,*)' Errors in reading the xsd picks indicate'
         write(lt,*)'   the picks may be in the old format.  You'
         write(lt,*)'   should run:'
         write(lt,*)' '
         write(lt,*)'   xsd2xsd -Pold_picks_filename -POnew_picks',
     &                   '_filename'
         write(lt,*)' '
         write(lt,*)'   to convert the picks to the new format.'
         write(lt,*)'   and then run rmsvel again.'
      endif
      if(jerr.ne.0)then
         write(lprt,*)' Job Terminated '
         stop 100
      endif

C     units(1),offset(1)=units & offset for the records (rec)
C     units(2),offset(2)=units & offset for the traces (trac)
C     units(3),offset(3)=units & offset for the samples (samp)
c     use m as an index into rec,trac,samp-arrays (one-dimensional-arrays)

      m = 1
      do 100 i = 1,maxseg
c        jrec will be calculated using the 1st point in the segment
         jrec = (rec(m)-offset(1))/units(1) * irinc + (irs - irinc)
         xrec=jrec*dxrec

         do 50 j=1,npicks(i)
            vrms(j)=(trac(m)-offset(2))/units(2) * deltav+vmin-deltav
            time(j)=(samp(m)-offset(3))/units(3) * deltat
            m = m + 1
   50    continue

         nalter = npicks(i)
         call vinter(lt, nalter, vrms, time, ttol, vint, depth, zmax)
         write(lvel,250)'MODEL',nalter-1,jrec,xrec
         write(lvel,262)
     &   'VELOCITIES      VINT               DEPTH      VRMS      TIME'
         write(lvel,260)(k-1,vint(k),depth(k),vrms(k),time(k),
     &                   k=2,nalter)
  100 continue

      write(lvel,261)'novel',maxseg,'    = no of functions'

      WRITE(LPRT,*) ' JOB COMPLETE'

  250 format(a5,5x,i10,20x,i10,10x,f10.3)
  260 FORMAT(i10,f10.0,10x,3f10.0)
  261 FORMAT(a5,i5,a21)
  262 FORMAT(a60)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                             END OF JOB                               C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      STOP 0
      END
      subroutine vinter(lt, n, vrms, time, ttol, vint, depth , zmax)

c     This routine computes a Dix estimate of Interval Velocities
c     and Depths from RMS Velocities and 2-Way Travel Times

c     n       = # of velocity layers            (input+output)
      integer n
c     vrms    = rms velocity                    (input)
      real    vrms(*)
c     time    = two way travel time in millsec. (input)
      real    time(*)
c     ttol    = travel time tolerance -millsec. (input)
      real    ttol
c     vint    = interval velocity               (output)
      real    vint(*)
c     depth   = depth of layer                  (output)
      real    depth(*)
c     vtmp    = rms velocity temp               (work)
      real    vtmp(1024)
c     ttmp    = 2-way travel time temp          (work)
      real    ttmp(1024)
c     zmax    = max model depth
      real    zmax

c     build expanded v , t table

c     first load vrms and time into temp arrays
      if(time(1).le.0.) then
       ttmp(1) = 0.0
       vtmp(1) = vrms(1)
       do 10 j = 2,n
       ttmp(j) = time(j)
   10  vtmp(j) = vrms(j)
      else
       ttmp(1) = 0.0
       vtmp(1) = vrms(1)
       do 20 j = 1,n
       vtmp(j+1) = vrms(j)
   20  ttmp(j+1) = time(j)
       n = n+1
      endif

c     now expand these temp arrays back into time and vrms
c     so that a travel time layer is no less than ttol
c     start ic at 1 and keep the lst pick
      ic = 1
      time(1) = ttmp(1)
      vrms(1) = vtmp(1)
      do 30 j1 = 2,n
       if(ttmp(j1).le.ttmp(j1-1) ) go to 30
       n2 = (ttmp(j1) - ttmp(j1-1))/ttol + 1.
       rn2 = n2
       do 31 j2 = 1,n2
       ic = ic+1
       time(ic) = ttmp(j1-1) + j2/rn2 * ( ttmp(j1) -ttmp(j1-1) )
       rat      = ( time(ic) - ttmp(j1-1) )/( ttmp(j1)-ttmp(j1-1) )
   31  vrms(ic) = rat*vtmp(j1) + (1.-rat)*vtmp(j1-1)
   30  continue

       n = ic

c     Compute Interval Velocities and Depths
c      (if vint decreases by 50% in a layer,  assume anomolous pick)
      vint(1)=vrms(1)
      depth(1)=vint(1)*time(1)/2000.
      if(n.gt.1) then

       do 100 i=2,n
        t2   = time(i)/1000.
        t1   = time(i-1)/1000.
        if(t2.lt.t1) write(lt,*) 'times not in ascending order'
        delt = t2 -t1
        arg  = ( vrms(i)**2 * t2 - vrms(i-1)**2 * t1 )/delt
        if(arg .lt. .25*vint(i-1)**2) then
c        anomolous pick ? -  use previous velocity
         vint(i)=vint(i-1)
        else
         vint(i)=sqrt(arg)
        endif
        depth(i)=depth(i-1)+vint(i)*delt/2.
  100  continue

      endif

c     pad tables to maximum depth
      if(depth(n).lt.zmax) then
       n=n+1
       depth(n) = zmax
       vint(n)  = vint(n-1)
       time(n)  = time(n-1) + 2000.*(zmax - depth(n-1))/vint(n)
       t2 = time(n)/1000.
       t1 = time(n-1)/1000.
       vrms(n)  = sqrt(  (time(n)          )/time(n) * vrms(n-1)**2
     &                   +(time(n)-time(n-1))/time(n) * vint(n  )**2 )
      endif

      return
      end
