C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c  program VLMXRMS: to convert tdfn cards to depth and interval velocity
c      pairs
c
c    output is formated VLMX for conversion to a velocity tape
c
c    J. Garing 11/89
c    updated to run on cray L. Young   1/90
c    updated for OS6.1 Mary Ann Thornton   V: 2.1                3/92
c    updated for new sun compiler, new libmbs V:2.2              5/92
c    updated for logical unit needed by HP    V:2.3 M.A. Thornton5/93
c    Mary Ann Thornton        V:2.4                 September 1, 1994
c         - Program was changed to write the times in milliseconds
c         - rather than seconds because vlmx expects the times
c         - to be in milliseconds when the -RMS flag is turned on.
c         - Also, changed the format to be f10.0 rather than f10.3
#include <f77/hp.h>
      parameter (lprt=26)
      real vint,depth,v(1000),t(1000),guts,tint,zmax,vmax,vrmax
      real vrmin
      integer iv(7),it(7),k,icard,ri,velnum,ri1,nfunc,vflag
      character * 128  ofil, vfil
      character*4 version
      data version/' 2.4'/
C
      luvel= 1
      luout= 2
C     get command line values
C     cmdlin picks up all the command line arguments
c     ltrm will print to the terminal
      ltrm = ler
      call cmdlin(ofil,vfil,ri1,vmax,ltrm)
       if(ofil .EQ. ' ') then
         write(lprt,*)'must input output filename '
         go to 9999
       endif
       if(ofil.ne.' ')then
        open(unit=luout,file=ofil,status='new')
       endif
       if(vmax .eq. 0.)then
        vmax = 99999.
       endif
       if(ri1 .eq. 0)then
        ri1 = 1
       endif
c
c determine the number of the first ri to set ri numbers to
csequential record number  seq #= ri# - 1st ri# + 1
c
      zmax=0
      vrmax=0
      vrmin=99999
      nfunc=0
c
c
c  User specified maximum velocity to believe
c  Any greater velocity than this will be re-set to this number
c  Definitely a brute force patch right now.  Time depth a following
c  pairs are not readjusted.
c
c
c  read in tdfn cards
c
C
C     open the tdfn velocity file and the output vlmx card file
c
       if(vfil.ne.' ')then
        open(unit=luvel,file=vfil,status='old')
       endif
5     ij=0
10    read(luvel,'(i1,4x,7(i4,i5),7x,i5)',end=9000)
     + icard,(it(j),iv(j),j=1,7),ri
      if ((icard.lt.1).or.(icard.gt.9)) goto 8900
      j=1
      do 20 j=1,7
       if (iv(j).ne.0) then
        v(j+ij)=iv(j)
        t(j+ij)=it(j)/1000.
       else
        ij=ij+j-1
        goto 100
       endif
20    continue
      ij=ij+7
      if (icard.lt.9) goto 10
c
100   nv=ij
      nfunc=nfunc+1
      if (t(1).eq.0) nv=nv-1
      ri=ri-ri1+1
      write(luout,195) nv,ri
195   format('MODEL',5x,i10,20x,i10)
      write(luout,196)
196   format('VELOCITIES',6x,'VINT',15x,'DEPTH',6x,'VRMS',5x,'TIME',
     +' CLIPFLAG')
200   depth=0
      velnum=1
      if (t(1).eq.0) goto 290
      vint=v(1)
      if (vint.gt.vmax) then
           vint=vmax
           vflag=1
      endif
      if (vint.gt.vrmax) vrmax=vint
      if (vint.lt.vrmin) vrmin=vint
      depth=vint*t(1)/2.
      if (depth.gt.zmax) zmax=depth
      write(luout,'(i10,f10.0,10x,2f10.0,f10.0,i5)')
     + velnum,vint,depth,v(1),t(1)*1000.,vflag
      vflag=0
      velnum=velnum+1
c
290   do 300 k=2,ij
         guts=(v(k)**2.)*t(k) - (v(k-1)**2.)*t(k-1)
         tint=t(k)-t(k-1)
         vint=sqrt(guts/tint)
         if (vint.gt.vmax) then
           vint=vmax
           vflag=1
         endif
         if (vint.gt.vrmax) vrmax=vint
         if (vint.lt.vrmin) vrmin=vint
         depth=vint*tint/2. + depth
         if (depth.gt.zmax) zmax=depth
         write(luout,'(i10,f10.0,10x,2f10.0,f10.0,i5)')
     +    velnum,vint,depth,v(k),t(k)*1000.,vflag
         vflag=0
         velnum=velnum+1
300   continue
320   goto  5
c
c end
c
8900  write(luout,8910)
8910  format(' *****strange tdfn card found*****')
9000  write(luout,9100) nfunc,zmax
9100  format('NUMBER OF FUNCTIONS= ',i5,' MAXIMUM DEPTH CALCULATED=',
     + f10.0)
      write(luout,9110) vrmin,vrmax
9110  format('MINIMUM INTERVAL VEL= ',f10.0,' MAXIMUM INTERVAL VEL= ',
     + f10.0)
9999  continue
      stop
      end
c
C  subroutine cmdlin
C
      subroutine cmdlin(ofil,vfil,nrst,vmax,ltrm)
      integer ARGIS
      logical help
      character*128 ofil,vfil
      help = (ARGIS( '-h' ).GT. 0) .or. (argis('-?') .GT. 0)
      if(help)then
        write(ltrm,*)'command line arguments-----rmsvlmx       '
        write(ltrm,*)' '
        write(ltrm,*)' input '
        write(ltrm,*)'-o(ofil)    . OUTPUT CARD FILENAME'
        write(ltrm,*)'-v(vfil)    . INPUT VELOCITY CARD FILENAME'
        write(ltrm,*)'-rs(nrst)   . STARTING R.I.'
        write(ltrm,*)'-vmax(vmax) . MAXIMUM INTERVAL VELOCITY'
        write(ltrm,*)'USAGE:'
        write(LTRM,*)'rmsvlmx -o() -v() -rs() -vmax()'
        stop
      endif
      call ARGSTR('-o',ofil ,' ',' ')
      call ARGSTR('-v',vfil,' ',' ')
      call ARGI4('-rs',nrst,0,0)
      call ARGR4('-vmax',vmax,0.,0.)
      return
      end
