C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SHOWRAY                                              *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:                                                            *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   DAN WHITMORE                       ORIGIN DATE: 92/01/28  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED:           *
C  MODIFIED: DAN WHITMORE                      DATE:  1/28/92          *
C  MODIFIED: Mary Ann Thornton   V: 2.0        DATE:  5/12/92          *
C       - Removed any wordsize reference and ifdefs so it would run on
C       - 32 bit machine
C  MODIFIED: N. D. Whitmore, Jr. V: 2.1        DATE:  8/18/92          *
C       - Renamed dtsnap to snap to correct the command line argument
C       - conflict with dt.
C  MODIFIED: N. D. Whitmore, Jr. V: 2.2        DATE:  10/26/92         *
C       - Corrected an error.                                        
C  MODIFIED: Mary Ann Thornton   V: 2.3        DATE:  07/08/93         *
C       - Included hp.h so the logical unit LTRM would not be 0 on HP
C       - increased line header buffer size
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

C     Memory Space Allocation

      parameter (llist = 27, lprt = 26, lcrd=25, ltmp= 28)
      parameter (nxmax=2000,nzmax=1500,len_trace =itrwrd+nzmax)
      parameter (nrmax=2000,ntmax=4000)
      parameter (nznx_max=nzmax*nxmax,nrnt_max=nrmax*ntmax)

c     header and traces arrays
      dimension ihead(SZLNHD)
      dimension trace(len_trace),rtrd(nzmax)
      integer*2 itrh(lntrhd)
      equivalence (trace(1),itrh(1)),(trace(ithwp1),rtrd(1))

      real veloc(1)
      real partx(1),partz(1),vdt(1)
      real xray(1),zray(1),theta(1)
      pointer (pveloc,veloc)
      pointer (ppartx,partx), (ppartz,partz), (pvdt,vdt)
      pointer (pxray,xray), (pzray,zray), (ptheta,theta)
      integer iheada(1)
      pointer (piheada,iheada)

      character*1 parr(66)
      character*2 pname
      character*4 version
      character*7 ppname

      character*128 otap,ntap
      equivalence (pname,ppname)

      logical verbos

      data version/' 2.3'/
      data ppname/'SHOWRAY'/
      data parr/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     2' ',' ',' ',' ',' ',' ',' ','S','H','O','W',' ','R','A','Y','S',
     3' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     3          ' ',' ',' ',' ',' ',' ',' ',' ',' ',
     4          ' ',' ',' ',' ',' ',' ',' ',' ',' '/

c     Get Command Line Arguments
      ltrm  = LER
      call cmdlin(ntap,otap,ipipi,ipipo,ltrm,verbos,
     &vref,angle,dxray,dt,nt,snap,nang,xsrc,zsrc,ismoo)

c     Open Input Dataset
      if(ipipi.eq.0) then
C        luin is an input dataset
         call lbopen(luin,ntap,'r')
      else
C        we know luin is a pipe
         luin = 0
         ltrm = 2
      endif

c     Open Output Dataset
      if(ipipo.eq.0)then
C        luout is an output dataset
         call lbopen(luout,otap,'w')
      else
C        we know luout is a pipe
         luout=1
      endif

C     Open printout
      call openpr(llist,lprt,ppname,jerr)
      if(jerr.ne.0)stop 200
#include <mbsdate.h>
      nlin=1
      call gamoco(parr,nlin,lprt)
      write(lprt,38)ntap,otap
   38 format(' INPUT DATASET = ',/,A128,/,' OUTPUT DATASET = '/,A128)

C     Open Input Tape, Get parameters
      lhbyt = 0
      call rtape(luin,ihead,lhbyt)
        if(lhbyt.le.0) then
           call lbclos(luin)
           call lbclos(luout)
           write(LER,*)'error in reading input line header'
           stop 73
        endif
      len=5

c     Update Historical Line Header
      call hlhprt(ihead,lhbyt,ppname,len,lprt)

c     Bring in Input Line Header Values
      call saver(ihead, 'NumSmp', num_smp, linhed)
      call saver(ihead, 'NumTrc', num_trc, linhed)
      call saver(ihead, 'SmpInt', smp_int, linhed)
      call saver(ihead, 'Format', iform, linhed)
      call saver(ihead, 'Dx1000', idx_1000, linhed)
      call saver(ihead, 'Dz1000', idz_1000, linhed)

      if(iform.ne.3)then
         write(lprt,*)'  INPUT TAPE MUST BE FORMAT 3'
         stop 100
      endif

c     
c     Process parameters
c

      dx = float(idx_1000)/1000.
      dz = float(idz_1000)/1000.
      nx = num_trc
      nz = num_smp
      num_rec = dt*float(nt)/snap
      if(xsrc.le.0.0) then
        nray = (nx*dx)/dxray - 1
      else
        nray = 2*nang+1
      endif

c 
c     allocate arrays 
c

c
      jerr = 0
      isize_veloc = num_smp*num_trc
      call galloc( pveloc, isize_veloc*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( ppartx, isize_veloc*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( ppartz, isize_veloc*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( pvdt, isize_veloc*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( pxray, nray*(nt+5)*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( pzray, nray*(nt+5)*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      call galloc( ptheta, nray*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif
c
      jerr = 0
      isize_iheada = itrwrd*num_trc
      call galloc( piheada, isize_iheada*iszbyt, jerr, 'ABORT' )
      if ( jerr .ne. 0 ) then
         write(LER,*)'galloc error: ', jerr
         stop
      endif



c        Read velocities from the input dataset
         do jtrc=1,num_trc
            jeof=0
            call rtape(luin,trace,jeof)
              if(jeof.le.0) then
                 call lbclos(luin)
                 call lbclos(luout)
                 write(LER,*)'error in reading input'
                 write(LER,*)'rec,trace=',jrec,jtrc
                 stop 74
              endif
            call vmov(itrh,1,iheada( 1+itrwrd*(jtrc-1) ),1,itrwrd)
            call vmov(rtrd,1,veloc( 1+num_smp*(jtrc-1) ),1,num_smp)
         enddo
      
 
c        Find maximum velocity
         call maxv(veloc,1,vmax,lc,num_smp*num_trc)

C     Build initial conditions for rays        

      if(xsrc.le.0.) then

         angle = angle *3.14159/180.
         p     = sin(angle)/vref
         prtol = 1.0+0.0*abs(sin(angle*3.14159/180.))
         do jray=1,nray
         zray(jray) = zsrc + 1.5*dz
         xray(jray) = dxray*jray
         ixnod = xray(jray)/dx+1.5
         aang = veloc(1+(ixnod-1)*nz)*p
         theta(jray) = asin(aang)
         enddo

      else

         p = 0.
         prtol = 0.0
         nray=2*nang+1
         dang = abs(angle)/nang
         angray = -abs(angle)-dang
         do jray=1,nray
         angray = angray+dang
cdan  need to set zray to zsrc for shots
         zray(jray) = zsrc +dz
         xray(jray) = xsrc
           if(angray.gt.179.0 .or. angray.lt.-179.0) then
           write(lprt,*) 'angle out of range'
           stop 100
           endif
         theta(jray) =  angray*3.14159/180.
         enddo

      endif

c
c     Trace Rays
c

      write(lprt,*)' beginning to trace rays '
      write(LER,*)' beginning to trace rays '
    
      init  = 0
      iflag = 0
      ntskip = 1
      call       rkrayx( nz   ,nx     ,nray ,nt   ,
     &                   nz   ,nx     ,nray ,nt   , ntskip ,
     &                   dz   ,dx           ,dt   ,
     &                   veloc,ismoo  ,
     &                   partz,partx  ,vdt  ,init ,
     &                   theta,
     &                   zray ,xray   ,p    ,prtol,      dz,dx )


C
C     Set Output Header Info
C
      call savew(ihead, 'NumSmp', num_smp, LINHED)
      call savew(ihead, 'NumTrc', num_trc, LINHED)
      call savew(ihead, 'NumRec', num_rec, LINHED)
      call savew(ihead, 'SmpInt', smp_int, LINHED)
      call savew(ihead, 'Format', iform, LINHED)
      call savew(ihead, 'Dx1000', idx_1000, LINHED)
      call savew(ihead, 'Dz1000', idz_1000, LINHED)
      call wrtape(luout,ihead,lhbyt)
 
C     Process Output Records

      call vmov(veloc,1,vdt,1,nz*nx)
      jump = snap/dt

      do 100 jrec=1,num_rec
      if(VERBOS)write(lprt,*) 'PROCESSING RECORD ',jrec

c        grid rays for this time block
         jbeg = (jrec-1)*jump + 1
         jend = (jrec  )*jump
         do jt = jbeg,jend
          do jray = 1,nray
           if(p.ge.0.0) jtbias = xray(jray)*p/dt+.5
           if(p.lt.0.0) jtbias = -(xray(nray)-xray(jray))*p/dt+1.5
           jtime = jt-jtbias
           if(jtime.ge.1) then
            izloc = zray(jray+(jtime-1)*nray)/dz + 1.5
            ixloc = xray(jray+(jtime-1)*nray)/dx + 1.5
            if(izloc.gt.1 .and. izloc.le.nz .and. ixloc.gt.1
     &      .and.ixloc.le.nx) vdt(izloc+(ixloc-1)*nz) = -vmax
           endif
          enddo
         enddo

c        write out gridded rays for this time block
         do jtrc=1,num_trc
            call vmov(iheada( 1+itrwrd*(jtrc-1) ),1,itrh,1,itrwrd)
            call vmov(vdt( 1+num_smp*(jtrc-1) ),1,rtrd,1,num_smp)
            call savew(itrh, 'RecNum', jrec, TRCHED)
            call savew(itrh, 'TrcNum', jtrc, TRCHED)
            call savew(itrh, 'StaCor',    0, TRCHED)
            call wrtape(luout,trace,jeof)
              if(jeof.le.0) then
                 call lbclos(luin)
                 call lbclos(luout)
                 write(LER,*)'error in writing output'
                 write(LER,*)'rec,trace=',jrec,jtrc
                 stop 75
              endif
         enddo

100   continue

C     Close Seismic Datasets

      call lbclos(luin)
      call lbclos(luout)
 
c     End Of Job

      stop
      end
C***********************************************************************
      subroutine cmdlin(ntap,otap,ipipi,ipipo,ltrm,verbos,
     &vref,angle,dxray,dt,nt,snap,nang,xsrc,zsrc,ismoo)
      integer argis
      logical help,verbos
      character*128 ntap,otap
      help  = (argis( '-h' ).gt.0) .OR. (argis( '-?').gt.0)
      if(help)then
      write(ltrm,*)'# SHOWRAY -  GENERATE RAY PLOTS '
      write(ltrm,*)'# '
      write(ltrm,*)'#-N[]      .. input velocity dataset '
      write(ltrm,*)'#-O[]      .. output ray plot dataset '
      write(ltrm,*)'#-xsrc[]   .. <= 0 generate plane waves (pw)'
      write(ltrm,*)'#             >  0 generate shot point (sp)' 
      write(ltrm,*)'#                  at x location xsrc' 
      write(ltrm,*)'#-zsrc[]   .. depth of source '
      write(ltrm,*)'#-dxray[]  .. pw only: dx between rays in pw'
      write(ltrm,*)'#-vref[]   .. pw only: reference velocity'
      write(ltrm,*)'#-ang[]    .. if pw: ang = beam angle'
      write(ltrm,*)'#             if sp: rays between -ang and +ang'
      write(ltrm,*)'#-dang[]   .. sp only: angle increment (def=1.)'
      write(ltrm,*)'#-tmax     .. max time (in ms)'
      write(ltrm,*)'#-snap[]   .. time display increment in ms'
      write(ltrm,*)'#             ( nrec = tmax/snap )'
      write(ltrm,*)'#-dt[]     .. dt(ms) inc between ray endpoints '
      write(ltrm,*)'#-ismoo[]  .. # times to smooth model'
      stop
      endif

      call argstr('-N',NTAP,' ',' ')
      call argstr('-O',OTAP,' ',' ')
      call argr4  ('-xsrc', xsrc, 0.0, 0.0)
      call argr4  ('-zsrc', zsrc, 0.0, 0.0)
      call argr4  ('-ang', angle, 0.0, 0.0)
      call argr4  ('-dang', dangle, 1.0, 1.0)
      call argr4  ('-vref', vref, 0.0, 0.0)
      call argr4  ('-dxray', dxray, 50.0, 50.0)
      call argr4  ('-dt', dt, 2.0, 2.0)
      call argr4  ('-tmax', tmax, 2000.0, 2000.0)
      call argr4  ('-snap', snap, 200.0, 200.0)
      call argi4 ('-ismoo',ismoo,0,0)
      if(xsrc.le.0.0 .and. vref.le.0.0) then
       write(ltrm,*) 'vref must be ge 0. for plane waves'
       stop 100
      endif
      nang = ifix(abs(angle/dangle))
      if(nang.lt.1) nang=1
      snap = snap/1000.
      tmax   = tmax/1000.
      dt     = dt/1000.
      nt     = tmax/dt
      verbos = (argis( '-V' ).GT.0)
c
c     set pipe flags (0=no pipe,1=pipe)
      ipipi=0
      ipipo=0
      if(ntap.eq.' ' ) ipipi=1
      if(otap.eq.' ' ) ipipo=1
c
      RETURN
      END
C
      subroutine rkrayx (nzmax, nxmax, nrmax, ntmax, nz, nx, nray, nt,
     &                   ntskip, dz, dx, dt, v, ismoo, vdsz, vdsx, vdt,
     &                   init, theta, zray, xray, pray, prtol,
     &                   zrjct,xrjct)                         
c
c     FIXED DT RAYTRACING IN HETEROGENEOUS MEDIA -- RUNGE-KUTTA
c     N. D. Whitmore

c     MAXIMUM DIMENSIONS:
c             maxtab = max # entries in cos/sin table   - declared
      integer maxtab
      parameter (maxtab = 240001)
c             nzmax  = max # nz                         - input
      integer nzmax
c             nxmax  = max # nx                         - input
      integer nxmax
c             ntmax  = max # nt                         - input
      integer ntmax
c             nrmax  = max # of rays                    - input
      integer nrmax

c     DIMENSIONS:
c             nx = max # of nodes in x direction        - input
      integer nx
c             nz = max # of nodes in z direction        - input
      integer nz
c             nray = # of rays to trace                 - input
      integer nray
c             nt = # time steps                         - input
      integer nt
c             ntskip = output time increment            - input
      integer ntskip

c     GRID SIZES:
c             dz = z grid spacing                       - input
      real    dz
c             dx = x grid spacing                       - input
      real    dx
c             dt = time increment                       - input
      real    dt

c     SPATIAL ARRAYS:
c             v    = interval velocity model            - input

      real    v(nzmax,nxmax)
c             ismoo = # of times to apply 9 pt smoother - input
c                    to input velocity model v
      integer ismoo
c             vdsx  = v*v * partial(d( 1/v )/dx) * dt   - computed
      real    vdsx(nzmax,nxmax)
c             vdsz  = v*v * partial(d( 1/v )/dz) * dt   - computed
      real    vdsz(nzmax,nxmax)
c             vdt  = (v * dt)                           - computed
      real    vdt(nzmax,nxmax)
c             init   = initialization flag              - input
c                    = 0 intialize vdsx, vdsz, vdt
c                    = 1 do not intialize vdsx, vdsz, vdt
      integer init

c     COMPUTED WAVEFRONT SLOWNESS:
c             theta = incident angle                    - input / output
      real    theta(nrmax)

c     COMPUTED WAVEFRONT RAY POSITIONS:
c             xray = wavefront x positions at each dt   - input / output
      real    xray(nrmax,ntmax)
c             zray = wavefront z positions at each dt   - input / output
              real zray(nrmax,ntmax)

c     CONSTANT ANGLE RAY PARAMETER AND TOLERANCE
c             pray  = ray parameter                     - input
      real    pray
c             prtol = ray parameter tolerance           - input
      real    prtol
c             zrjct = z spacing for purging rays        - input
      real    zrjct
c             xrjct = x spacing for purging rays        - input
      real    xrjct

c     LOCAL DECLARATIONS (assume that:  max # rays < 15000)
      real   wcos(15000), wsin(15000), work(15000)
      data wcos/15000*0./, wsin/15000*0./, work/15000*0./
      save wcos, wsin
c
      integer ierr
      real*8 cstab(maxtab+5)
      real xmax, xmin, dmy
      save cstab, first, xmax, xmin, dmy, ierr
      logical first

      data first / .true. /, dmy / 0. /, ierr / 0 /
      data pi / 3.141592653589793 /
c
c-----------------------------------------------------------------------
c
c     program outline:
c
c     0. smooth v and compute vdsz, vdsx, vdt (if init = 0)
c
c     1. initialize starting parameters
c        a. find starting node indices
c        b. table starting sin, cos
c
c     2. loop over time steps, at each time step
c      a. compute node indices of previous ray endpoints
c      b. gather vdt->work
c      c. compute dtheta, thetmp
c         dtheta = cos(theta(n-1))*vdsx - sin(theta(n-1))*vdsz
c      b. gather cos(thetmp)->wcos sin(thetmp)->wsin
c      d. compute temp wavefronts
c         XT(t(n)) = X(t(n-1)) + sin( thetmp )*Vdt
c         ZT(t(n)) = Z(t(n-1)) + cos( thetmp )*Vdt
c      e. compute temp node indices
c      f. compute Runge-Kutta update of theta
c      g. gather cos(theta)->wcos sin(theta)->wsin
c      h. update wavefront with an Euler recursion:
c         X(t(n)) = X(t(n-1)) + sin(theta(n))*Vdt
c         Z(t(n)) = Z(t(n-1)) + cos(theta(n))*Vdt
c     end time step loop
c
c-----------------------------------------------------------------------
c
c  if first entry to this routine, build cos/sin table
c
      if (first) then
         first = .false.
         xmax  =  3.0 * pi
         xmin  = -3.0 * pi
         call gcftlp (dmy, dmy, 0, maxtab, xmin, xmax, 1, cstab, ierr)
      endif

c     0. smooth v and compute vdsz, vdsx, vdt (if init = 0)

      if (init .eq. 0) then
         dtray = dt * ntskip
         if (ismoo .gt. 0) then
            do 110 jsmoo = 1, ismoo
               call smoothk (v, vdt, nz, nx, nzmax, nxmax)
  110       continue
         endif

c        interior dsz

         do 125 j2 = 1, nx
            do 120 j1 = 2, nz-1
               temp        = 1.0 / v(j1+1,j2) - 1.0 / v(j1-1,j2)
               vdsz(j1,j2) = 0.5 * v(j1,j2)**2 * temp / dz  * dtray
  120       continue
  125    continue

         if (ismoo .gt. 0) then
            do 130 jsmoo = 1, ismoo
               call zsmoo (vdsz, vdt, nz, nx, nzmax, nxmax)
  130       continue
         endif

c        interior dsx
         do 145 j2 = 2, nx-1
            do 140 j1 = 1, nz
               temp        = 1.0 / v(j1,j2+1) - 1.0 / v(j1,j2-1)
               vdsx(j1,j2) = 0.5 * v(j1,j2)**2 * temp / dx * dtray
  140       continue
  145    continue

         if (ismoo .gt. 0) then
            do 150 jsmoo = 1, ismoo
               call xsmoo (vdsx, vdt, nz, nx, nzmax, nxmax)
  150       continue
         endif

c        compute vdt
         do 165 j2 = 2, nx-1
            do 160 j1 = 1, nz-1
               vdt(j1,j2) = v(j1,j2) * dtray
  160       continue
  165    continue

c        pad vdt, vdsz, vdsx from nz to nzmax-1

c        do 175 j2 = 1, nx
c           do 170 j1 = nz, nzmax-1
c              vdt (j1,j2) = vdt(nz-1,j2)
c              vdsz(j1,j2) = 0.0
c              vdsx(j1,j2) = 0.0
c 170       continue
c 175    continue

c        set vdsx and vdsz and vdt on model edges

         do 180 j1 = 1, nzmax
            vdt(j1,1)   = 0.0
            vdt(j1,2)   = 0.0
            vdt(j1,3)   = 0.0
            vdt(j1,nx)  = 0.0
            vdt(j1,nx-1)  = 0.0
            vdt(j1,nx-2)  = 0.0
            vdsx(j1,1)  = 0.0
            vdsx(j1,nx) = 0.0
  180    continue

         do 190 j2 = 1, nx
            vdt(nzmax,j2)  = 0.0
            vdt(1,j2)      = 0.0
            vdsz(1,j2)     = 0.0
            vdsz(nz,j2)    = 0.0
  190    continue

c        reset init

         init = 1
      endif

c     1. initialize starting parameters
c     a. find starting node indices

      dtray  = dt * ntskip
      prdt   = pray / dtray
      dxover = 1.0 / dx
      dzover = 1.0 / dz


c     gather cos(theta)->wcos sin(theta)->wsin

      call ccftlp (cstab, theta, 1, wcos, wsin, 1, nray, 0, ierr)

c     2. loop over time steps
c
c     compute number of time steps

      nt1 = (nt + ntskip) / ntskip * ntskip

      jtkont = 0
      do 220 jt = 1+ntskip, nt1+ntskip, ntskip
         jtkont = jtkont + 1

         call crkray1 (nrmax, nzmax, nray, ntskip, jt, 
     &                 dxover, dzover, vdsx, vdsz, vdt, cstab, 
     &                 theta, wcos, wsin, work, xray, zray)

c        d. purge rays that are not within prtol of a Snell ray
c           (discard if sin(theta) is not close to pray*V)

         if (prtol .gt. 0.0) then
            if ((jtkont/8)*8 .eq. jtkont) then
               do 210 j = 1, nray
                  if (abs( wsin(j) - prdt * work(j) ) .gt. prtol ) then
                     xray(j,jt) = 0.51*xrjct
                     zray(j,jt) = 0.51*zrjct
                  endif
  210          continue
            endif
         endif

c     end time step loop
  220 continue

c     interpolate ntskip time steps

      if (ntskip .gt. 1) then
         do 330 jt = 1, nt1, ntskip
            do 320 jt1 = 1, ntskip-1
               beta  = float( jt1 ) / float( ntskip )
               alpha = 1.0 - beta
               do 310 j = 1, nray
                  xray(j,jt+jt1) = alpha * xray(j,jt) +
     &                             beta  * xray(j,jt+ntskip)
                  zray(j,jt+jt1) = alpha * zray(j,jt) +
     &                             beta  * zray(j,jt+ntskip)
  310          continue
  320       continue
  330    continue

      endif

c     end time interpolation

      return
      end
      subroutine xsmoo (a, b, nz, nx, nzmax, nxmax)

C     CALCULATES A 3 POINT HORIZONTAL SMOOTHING OF A MATRIX
C     INPUT  A  - MATRIX
C     OUTPUT A  - SMOOTHED MATRIX
C     WORKSPACE B

      integer nzmax, nxmax, nx, nz
      real a(nzmax,nxmax), b(nzmax,nxmax)

      real scale
      integer jx, jz

c-----------------------------------------------------------------------

      scale = 1.0 / 3.0

      do 120 jx = 2, nx-1
         do 110 jz = 2, nz-1
            b(jz,jx) = scale * ( a(jz,jx-1) + a(jz,jx) + a(jz,jx+1) )
  110    continue
  120 continue

      do 220 jx = 2, nx-1
         do 210 jz = 2, nz-1
            a(jz,jx) = b(jz,jx)
  210    continue
  220 continue

       return
       end
      subroutine smoothk (v, slow, nz, nx, nzmax, nxmax)

C     CALCULATES A 9 POINT RECIPROCAL SMOOTHING OF A VELOCITY MATRIX
C     INPUT  V  - VELOCITY MATRIX
C     OUTPUT V  - SMOOTHED VELOCITY MATRIX
C     WORKSPACE SLOW

      implicit none
      integer nzmax, nxmax, nz, nx
      real v(nzmax,nxmax), slow(nzmax,nxmax)

      real scale
      integer jx, jz
c
c-----------------------------------------------------------------------
c
      scale = 1.0 / 9.0

      do 20 jx = 2, nx-1
         do 10 jz = 2, nz-1
            slow(jz,jx) =
     &         scale *
     &         ( 1.0/v(jz-1,jx-1) + 1.0/v(jz,jx-1) + 1.0/v(jz+1,jx-1)
     &         + 1.0/v(jz-1,jx  ) + 1.0/v(jz,jx  ) + 1.0/v(jz+1,jx  )
     &         + 1.0/v(jz-1,jx+1) + 1.0/v(jz,jx+1) + 1.0/v(jz+1,jx+1)  )
   10    continue
   20 continue

      do 40 jx = 2, nx-1
         do 30 jz = 2, nz-1
            v(jz,jx) = 1.0 / slow(jz,jx)
   30    continue
   40 continue

       return
       end
      subroutine zsmoo (a, b, nz, nx, nzmax, nxmax)

C     CALCULATES A 3 POINT HORIZONTAL SMOOTHING OF A MATRIX
C     INPUT  A  - MATRIX
C     OUTPUT A  - SMOOTHED MATRIX
C     WORKSPACE B

      implicit none
      integer nzmax, nxmax, nx, nz
      real a(nzmax,nxmax), b(nzmax,nxmax)

      real scale
      integer jx, jz

c-----------------------------------------------------------------------

      scale = 1.0 / 3.0

      do 120 jx = 2, nx-1
         do 110 jz = 2, nz-1
            b(jz,jx) = scale * ( a(jz-1,jx) + a(jz,jx) + a(jz+1,jx) )
  110    continue
  120 continue

      do 220 jx = 2, nx-1
         do 210 jz = 2, nz-1
            a(jz,jx) = b(jz,jx)
  210    continue
  220 continue

       return
       end

