C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c - modified all loops which ran from 1 to nwlim to instead run from 2 to nwlim
c   to prevent division by zero problems, since w0=0
c   nwlim is the upper freq limit
c						- j.m. wade 10/13/98
c
c subroutine to downward continue a 2d  zero-offset wavefield using phase shift
c
	subroutine dwn2d(c_data,v,s,nkx,nw,nz,iz,kx2,nwlim,
     1			 nxfft2,dw,c_mult,depth,dip_option,iz0,
     2			 m_order,dip_cutoff,sincut,aper,izfilt)
c
c
	integer	nkx,nw,iz,iz0
	integer	iw,nz,ikx,nwlim
	integer	m_order,dip_option,izfilt
c
	real	omega,dw
	real	dip_cutoff,sincut,dip_least,dip_aper,aper
	real	depth(nz),kr_cut,kr_cut2,viz,viz1,vizviz
        real    sindip,varg,sarg,siz
c
	complex	c_data(nw,nkx),c_mult(nw,nkx)
	real	disc,dfmult
	real    v(nz),s(nz),kx2(nkx)
 
        viz = v(iz)
        vizviz = viz * viz
        if (iz .gt. 1) then
            viz1 = v(iz-1)
        else
            viz1 = 0
        endif
        siz = s(iz)

	do iw=2,nwlim

	   omega=(iw-1)*dw
           varg = vizviz /(omega*omega)
           sarg = siz * omega

	   if(omega .eq. 0.0)then

	     do ikx=1,nxfft2
	        c_mult(iw,ikx)=cmplx(0.,0)
	     end do

	   else

 	     if( (iz .eq. iz0) .or. (viz .ne. viz1) )then

c make the complex multipliers
c really only have to do 1/2 the kx spectrum then use symmetry

	       do ikx=1,nxfft2

                  disc = 1. - varg * kx2(ikx)

  		     if(disc .ge. 0.0)then
  		       c_mult(iw,ikx)= cexp (cmplx(0.,sarg*sqrt(disc)))
  		     end if

  		     if(disc.lt.0.0)then
  		       c_mult(iw,ikx)=cexp(cmplx(-sarg*sqrt(-disc),0.))
  		     end if

                  if (ikx .gt. 1 .and. ikx .lt. nxfft2) then
                     c_mult(iw,nkx+2-ikx)=c_mult(iw,ikx)
                  endif

	       end do

 	     end if

 	   end if

c End of first frequency loop 
c
	end do
c
c decide if we are dip filtering, and if we are, decide if it is time
c to take a bite and how to take the bite and take the bite.
c
        if(dip_option .eq. 1 )then
             if(iz .eq. 1)then

              do iw=2,nwlim
                 omega=(iw-1)*dw
                 kr_cut=(omega/viz*sincut)
                 kr_cut2 = kr_cut*kr_cut
	  
		 do ikx=1,nkx
                    dfmult=1./(1.+(kx2(ikx)/kr_cut2)**m_order)
                    c_data(iw,ikx)=c_data(iw,ikx)*dfmult
		 end do

              end do

             end if

             if(iz .ne. 1 .and. viz.ne.viz1)then

                do iw=2,nwlim
                  omega=(iw-1)*dw
                  kr_cut=(omega/viz*sincut)
                  kr_cut2 = kr_cut*kr_cut
	  
		  do ikx=1,nkx
                    dfmult=1./(1.+(kx2(ikx)/kr_cut2)**m_order)
                    c_data(iw,ikx)=c_data(iw,ikx)*dfmult
		  end do

                end do

             end if

	end if

c       if(dip_option .eq. 2 .and. mod(iz,izfilt) .eq. 0 )then - 1/17/00 - jmw

        if(dip_option .eq. 2) then
          if (mod(iz,izfilt) .eq. 0 )then

	      dip_aper=atan2(aper,depth(iz))

	      dip_least=min(dip_cutoff,dip_aper)
              sindip = sin(dip_least)

              do iw=2,nwlim
                 omega=(iw-1)*dw
                 kr_cut=(omega/viz*sindip)
                 kr_cut2 = kr_cut*kr_cut

		 do ikx=1,nkx
                    dfmult=1./(1.+(kx2(ikx)/kr_cut2)**m_order)
                    c_data(iw,ikx)=c_data(iw,ikx)*dfmult
		 end do

              end do

          end if
        end if

c Ok, apply the phase shift
c
        do ikx=1,nkx
           do iw=2,nwlim
              c_data(iw,ikx)=c_data(iw,ikx)*c_mult(iw,ikx)
           end do
        end do

c all done with this depth step
c
	return
	end
