C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
        Subroutine wxsdpicks(rec,trac,samp,icolor,segname,npts,
     1            units,offset, max_picks, max_segs,
     &            nrec,ntrac,nsamp,jseg,maxpik,LERR,lpout,jerr,
     1            tx, tz, pout)
c a subroutine to write an xsd pick file.
c Write the header record:
       Implicit none
       Integer max_picks, nrec, ntrac, nsamp, jerr, ii
       Integer lpout, LERR
       character   pout*128
       Real Units(3), Offset(3),  trac(max_picks),
     1      samp(max_picks), rec(max_picks)
       Real   tx(max_picks),  tz(max_picks)
       Integer i,j, jseg, maxpik, max_segs
       Integer icolor(max_segs), npts(max_segs)
       Character*20 segname(max_segs)

       Character uword*6, oword*7, cword*6
       data uword/'Units '/
       data cword/'Count '/
       data oword/'Offset '/


c -------find the maximum number of picks in any segment:
c      write(*,*) ' max_picks in wxsdpicks =',max_picks
c      write(*,*) ' max_segs               =',max_segs
c      write(*,*) 'writing to file number  =',lpout
c      write(*,*) 'writing to file named   =', pout
       maxpik = 0
       Do i = 1,jseg
         maxpik = max(maxpik, npts(i))
       Enddo

c  Code to allow for standard output if people want it:

       If (pout .ne. ' ') then
       Write(lpout,50) uword,
     1                 units, nrec,   ntrac, nsamp,
     1                 oword, Offset,
     1                 cword, jseg, maxpik
       else
       Write(   * ,50) uword,
     1                 units, nrec,   ntrac, nsamp,
     1                 oword, Offset,
     1                 cword, jseg, maxpik
       endif

 50    Format(a6,3(f12.6,1x),3(i5,1x),a7,3(f12.6,1x),a6,i5,1x,i5)

       ii = 0
       do i = 1,jseg
         if(pout .ne. ' ') then
         write(lpout,20) I, segname(I), icolor(i), npts(i)
         else
         write(*,20) I, segname(I), icolor(i), npts(i)
         endif
20    Format('Segment = ',I5,' Name ',A20,2X,'color = ',
     1        I5,' pout =',I6)
         Do j= 1, npts(i)
           ii = ii +1
         if(pout .ne. ' ') then
           write(lpout,'(F12.6,4F13.6)') rec(ii), trac(ii), samp(ii),
     1                                   tx (ii), tz  (ii)
         else
           write(*,'(F12.6,4F13.6)') rec(ii), trac(ii), samp(ii),
     1                                   tx (ii), tz  (ii)
         endif
         enddo
       enddo
       return
       end

