C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       TOPOMXC                                              *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE: Convert getrace depth point elevation header dump files    *
C           to MXC format.                                             *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   JOHN D. GARING                     ORIGIN DATE: 90/03/01  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 89/03/17  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      cmdlin          -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      lcrd  ( INPUT  SEQUENTIAL )-Trace header list file of elevations*
C      lprt  ( OUTPUT SEQUENTIAL )-Print out                           *
C      ltrm  ( OUTPUT SEQUENTIAL )-Terminal screen                     *
C      LELE  ( INPUT  SEQUENTIAL )-Input file                          *
C      lmxc  ( OUTPUT SEQUENTIAL )-Output file                         *
C      0     ( Standard-in for c routines  )                           *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 5) - no errors                                       *
C      =50   =  ( 5) - error on input cards                            *
C      =75   =  ( 5) - tapeio error                                    *
C      =100  =  ( 5) - user error                                      *
C      =200  =  ( 5) - error opening printout                          *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:                                                *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/01/10  *
C       - Code revised to execute on the Cray-2                        *
C  REVISED BY:  MARY ANN THORNTON             REVISION DATE: 91/08/27  *
C       - Move code to sun to be maintained/distributed from sun       *
C  REVISED BY:  MARY ANN THORNTON   V 2.1     REVISION DATE: 92/03/24  *
C       - Call openpr with ppname, to correct printout                 *
C  REVISED BY:  MARY ANN THORNTON   V 2.2     REVISION DATE: 93/06/10  *
C       - Corrected the format statments to show group interval rather
C       - than CDP interval, add logical unit for the HP
C***********************************************************************
#include <f77/hp.h>

      parameter (lcrd=25, lprt=26,llist=27,lmxc=62)
      real rrsfc,elev,depth(10000),topo,x(3000),dept2(3000),xi
      integer i,k,n
      character*4 version
      character*7 ppname
      character*128 input, model
      character*1 parr(66)
      data version/' 2.2'/
      data ppname/'topomxc'/
      DATA PARR/' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     1          ' ',' ',' ',' ',' ',' ',' ',' ',' ','C',
     2          'O','N','V','E','R','T',' ','F','R','O',
     3          'M',' ','T','O','P','O',' ','T','O',' ',
     4          'M','X','C',' ',' ',' ',' ',' ',' ',' ',
     5          ' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
     6          ' ',' ',' ',' ',' ',' '/
c
      ltrm = LER
      CALL cmdlin(input,model,rrsfc,giint,ltrm)
C     OPEN MODEL FILE(MXC) AND/OR CARD FILE
      CALL OPENPR(LLIST,lprt,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,lprt)
      IF(MODEL.NE.' ')THEN
         OPEN(UNIT=lmxc,FILE=model,STATUS='unknown',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(lprt,*)'  ERROR OPENING MODEL CARDS'
            STOP 50
         ENDIF
      ELSE
         WRITE(lprt,*)' MODEL CARDS NAME MUST BE SUPPLIED'
         STOP 100
      ENDIF
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=lcrd,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(lprt,*)'  ERROR OPENING EXTERNAL CARD FILE'
            STOP 50
         ENDIF
       ELSE
         N=ICOPEN('-topomxc.crd',lcrd)
      ENDIF
c   check group interval and regional reference surface
c
      IF(rrsfc.LE.0)THEN
         WRITE(lprt,*)'  Reference surface must be entered'
         STOP 50
      ENDIF
      IF(giint.LE.0)THEN
         WRITE(lprt,*)' GROUP interval must be entered'
         STOP 50
      ENDIF
      topo=0
      i=1
      write(lprt,10)giint, rrsfc
10    format('GROUP interval = ',f7.2,
     $       ' Model reference surface = ',f8.2)
c   read elevation from trace header file
50    read(lcrd,*,end=4000) elev
      if (elev.eq.0) then
         write(lprt,57) i
57       format(' stopping topo read because topo=0 at group ',i5)
         goto 4000
      endif
      topo = rrsfc-elev
      if (topo.lt.0.) then
         topo=0
         write(lprt,58) i
58       format(' found an elev above ref surf at group ',i5)
      endif
      depth(i)=topo
      i=i+1
      goto 50
c
4000  i=i-1
c
c  resample topography to a max of 250 points
c
      k=0
      n=0
      xi=i
c     iout=(xi/250.+.5)
      iout=1
      do 60 k=1,i,iout
      n=n+1
      x(n)=(k-1)*giint
      dept2(n)=depth(k)
60    continue
      xmax=(i-1)*giint
      if(x(n).lt.xmax) then
         n=n+1
         x(n)=xmax
         dept2(n)=depth(i)
      endif
      k=1
      write(lmxc,65) rrsfc,xmax
65    format(' topo values for reg ref surf= ',f5.0,' xmax= ',f10.2)
      do 80 k=1,n,4
        write(lmxc,75) (x(j),dept2(j),j=k,k+3)
75      format(4(f8.2,2x,f8.2,2x))
80    continue
      write(lmxc,85)
85    format(' -1.0')

      write(lprt,*)' Job Complete'
9000  stop
      end
      SUBROUTINE cmdlin(input,model,rrsfc,giint,ltrm)
      INTEGER ARGIS
      LOGICAL HELP
      CHARACTER*128  INPUT,MODEL
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
        WRITE(ltrm,*)'COMMAND LINE ARGUMENTS '
         WRITE(ltrm,*)' '
         WRITE(ltrm,*)' INPUT '
         WRITE(ltrm,*)'-C[input] .. EXTERNAL CARD FILE'
         WRITE(ltrm,*)'-M[model] .. MODEL CARDS (MXC FILE)'
         WRITE(ltrm,*)'-R[ref]   .. REFERENCE SURFACE'
         WRITE(ltrm,*)'-G[giint] .. GROUP INTERVAL'
         WRITE(ltrm,*)'USAGE:'
         WRITE(ltrm,*)'topomxc -C[] -M[] -R[] -G[]'
         STOP
      ENDIF
      CALL ARGSTR('-C',input,' ',' ')
      CALL ARGSTR('-M',model,' ',' ')
      CALL ARGR4 ('-R',rrsfc,0.0,0.0)
      CALL ARGR4 ('-G',giint,0.0,0.0)
      RETURN
      END
