C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C*********************************************************************
C name:         CUBEVZ VELOCITY MODEL GENERATION            DEC 92   *
C*********************************************************************
C
C  PURPOSE:
C       Create V(z) model suite by perturbation in vavg vs.time
C
C  USAGE:
C       vmodvavg -N[ntap] -O[otap] -C[card] [-V] [-h]
C
C       -N[ntap]
C             Specifies 'ntap' as the input SIS data set containing the
C             velocity function to be perturbed. 
C
C       -O[otap]
C             Specifies 'otap' as the output SIS data set containing the
C             velocity functions. 
C
C	-C[card]
C		Specifies 'card' as the input card file. Must be
C		specified.
C
C       -V
C               Causes the program to generate verbose print output.
C
C       -h
C               Causes the program to write help information to the
C               standard output and then halts.
C
C  FILES:
C
C       otap	output velocity perturbation model consisting of one
C		record with each trace corresponding to an interval
C		velocity versus depth function.  Each function will
C		be used later to create a prestack migrated stack in
C  		program cubevz.
C
C*********************************************************************
C     AUTHOR:  David Nelson
C     REVISED: David Nelson   Version 1.0       12/28/92
C              0. use vmod as a template to write this program
C              1. add option to input functions by average velocity
C              2. interpolate to perturbations in average velocity 
C                 instead of interval velocity
C              3. ensure input card depths/times come out at correct
C                 depth samples on velocity tape
C              4. use NL2L to interpolate interval velocity correctly
C                 instead of LINTERP which does not preserve travel time
C              5. remove function fairway specification option,
C                 only allow a central function as input
C              6. make line header buffer 6000 words
C     REVISED: David Nelson   Version 1.1       03/24/93
C              0. make ratio vary with time or depth instead of constant
C     REVISED: David Nelson   Version 1.2       04/01/93
C              0. read velocity input from usp dataset instead of cards
C              1. only support interval versus time on input
C              2. output interval versus time
C     REVISED: David Nelson   Version 1.3       07/26/93
C              0. add option to output lower, higher, or both velocity
C                 functions relative to the input velocity function.
C     REVISED: Mary Ann Thornton Version 1.4       10/10/93
C              Changed the do loop syntax for loop 200
C              it failed on the gp15 machine
C     REVISED: David Nelson   Version 1.5       04/20/94
C              0. fixed bug in computing time to depth conversion
C                 of the VMULT cards. This occurred when the maximum
C                 depth in the table was greater than the maximum
C                 depth computed from the input velocity trace.
C*   REVISED: David Nelson    Version 1.6          22 APR 94
C*            1. Fixed array index overrun bug in velblock in lpinv.c
C                  
C*********************************************************************
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/hp.h>

      PARAMETER (MXSAM=4096,MXTRA=256,LHEAD=SZLNHD)
      PARAMETER (LPRT=26,LCRD=25,LLIST=27)

      DIMENSION IHEAD(LHEAD)
      DIMENSION RXX(MXSAM+ITRWRD)

      INTEGER*2 IRX(LNTRHD)
      INTEGER NUMPERT,TDFLAG,LOWHI

      REAL DELTAV,MIDPERT
      REAL RATIO(MXSAM),VSCALE(MXSAM)
      REAL TIME(MXSAM),TIMDEP(MXSAM),DEPTH(MXSAM)
      REAL VAVG(MXSAM),VIN(MXSAM),VELT(MXSAM),VEL(MXSAM*MXTRA)

      LOGICAL VERBOS,nextiv
      CHARACTER*66 PARR
      CHARACTER*8 PPNAME
      CHARACTER*4 VERSION
      CHARACTER*128 NTAP,OTAP,INPUT

      EQUIVALENCE (RXX(1),IRX(1)),(RXX(ITHWP1),VIN(1))

      DATA VERSION/' 1.6'/
      DATA PPNAME/'VMODVAVG'/
      DATA PARR/' '/

      PARR(9:)='CREATE PERTURBATIONS IN AVERAGE VELOCITY VS. TIME'

      CALL cmdlin(NTAP,OTAP,INPUT,IPIPI,IPIPO,LER,VERBOS)

      IF(IPIPI.EQ.0) THEN
C        LUIN IS AN INPUT DATASET
         CALL LBOPEN(LUIN,NTAP,'r')
      ELSE
C        WE KNOW LUIN IS A PIPE
         LUIN = 0
      ENDIF

      IF(IPIPO.EQ.0) THEN
C        LUOUT IS AN OUTPUT DATASET
         CALL LBOPEN(LUOUT,OTAP,'w')
      ELSE
C        WE KNOW LUOUT IS A PIPE
         LUOUT = 1
      ENDIF

C     OPEN PRINTOUT
      JERR = 0
      CALL OPENPR(LLIST,LPRT,PPNAME,JERR)
      IF(JERR.NE.0)STOP 200
#include <mbsdate.h>
      NLIN=1
      CALL GAMOCO(PARR,NLIN,LPRT)

      IF(NTAP.NE.' ')WRITE(LPRT,901)NTAP
901   FORMAT(' INPUT  VELOCITY FUNCTION DATASET = '/,A128)
      IF(OTAP.NE.' ')WRITE(LPRT,900)OTAP
900   FORMAT(' OUTPUT VELOCITY FUNCTION DATASET = '/,A128)

C     OPEN CARD FILE
      JERR = 0
      IF(INPUT.NE.' ')THEN
         OPEN(UNIT=LCRD,FILE=INPUT,STATUS='OLD',IOSTAT=JERR)
         IF(JERR.NE.0)THEN
            WRITE(LPRT,*)' ERROR OPENING INPUT CARD FILE'
            STOP 50
         ENDIF
      ELSE
         N=ICOPEN('-vmod.crd',LCRD)
            IF(N.EQ.0)THEN
               WRITE(LPRT,*)'  YOU MUST SUPPLY INPUT PARAMETERS'
               STOP 50
            ENDIF
      ENDIF

C     READ INPUT CARDS
      CALL READCARD(LCRD,LPRT,NUMPERT,DELTAV,TDFLAG,LOWHI,
     +              TIMDEP,VSCALE,NTIME)

      IF (MOD(NUMPERT,2).EQ.0)THEN
         NUMPERT=NUMPERT+1
         WRITE(LPRT,*)' THE NUMBER OF PERTURBATIONS WAS INCREMENTED'
         WRITE(LPRT,*)' TO MAKE IT AN ODD NUMBER WHICH ALLOWS FOR'
         WRITE(LPRT,*)' SYMMETRY ABOUT THE MIDDLE FUNCTION'
      ENDIF

      if (LOWHI .eq. 0) LOWHI=3

      NTR=NUMPERT
      if (LOWHI .ne. 3) NTR=NUMPERT/2+1

C     OPEN INPUT VELOCITY FUNCTION DATASET AND READ ITS TRACE
      CALL RTAPE(LUIN,IHEAD,IERR)
      call saver(IHEAD,'NumSmp',NSAMP,linhed)
      call saver(IHEAD,'SmpInt',ISI,linhed)

      IF(NSAMP.GT.MXSAM)THEN
         WRITE(LPRT,*)NSAMP," INPUT SAMPLES IS GREATER THAN ",MXSAM
         STOP 100
      ENDIF

      CALL RTAPE(LUIN,RXX,IERR)

C     SET UP OUTPUT LINE HEADER
c     idt=DELTAZ*1000.
      numrec=1
      call savew(IHEAD,'NumRec',numrec,linhed)
      call savew(IHEAD,'SmpInt',ISI,linhed)
      call savew(IHEAD,'NumTrc',NTR,linhed)
c     call savew(IHEAD,'Dz1000',idt,linhed)

C     HLH WILL PRINT LINEHEADER AND UPDATE THE HISTORICAL PORTION
      LEN=8
      NBYTES=393*ISZBYT
      JCOF = NBYTES
      CALL HLHPRT(IHEAD,JCOF,PPNAME,LEN,LPRT)

C     WRITE PARAMETERS TO USER REPORT
      WRITE(LPRT,271)NUMPERT,NSAMP,DELTAV
271   FORMAT(//,7X, 'INPUT PARAMETERS AFTER DEFAULTS:',
     +       //,'NUMBER OF VELOCITY FUNCTIONS..............',4X,I5,
     +       /,'NUMBER OF SAMPLES.........................',1X,I8,
     +       /,'DELTA VELOCITY (MAXIMUM BLOCKING ERROR)...',1X,F8.2)


C     CONVERT INTERVAL TO AVERAGE VELOCITY 
      CALL TINT2TLP(VIN,NSAMP,VAVG,1.0)

C     interpolate unfilled values in input perturbation scalar array
      CALL INFILL(VSCALE,TIMDEP,NTIME)

      IF (TDFLAG .EQ. 2) THEN
        WRITE(LPRT,*)' VMULT ARRAY WAS INPUT IN DEPTH'
C       convert vmult depth array to time if input is in depth
        DO IT=1,NSAMP
          DEPTH(IT)=0.0005*VAVG(IT)*(IT-1)*ISI
        ENDDO
        DO ID=1,NTIME
          if (TIMDEP(ID) .GE. DEPTH(NSAMP)) then
            TIME(ID)=2000.0*TIMDEP(ID)/VAVG(NSAMP)
          else
            DO IT=1,NSAMP
              IF (DEPTH(IT) .GT. TIMDEP(ID)) THEN
                TIME(ID)=(IT-2)*ISI*(DEPTH(IT)-TIMDEP(ID))/
     +                   (DEPTH(IT)-DEPTH(IT-1)) +
     +                   (IT-1)*ISI*(TIMDEP(ID)-DEPTH(IT-1))/
     +                   (DEPTH(IT)-DEPTH(IT-1))
                GOTO 444
              ENDIF
            ENDDO
          endif
444       CONTINUE
        ENDDO
      ELSE
        WRITE(LPRT,*)' VMULT ARRAY WAS INPUT IN TIME'
C       copy time/depth array to time array, it already is time
        CALL VMOV(TIMDEP,1,TIME,1,NTIME)
      ENDIF

C     interpolate perturbation scalar array to every vint sample
      CALL VSMUL(TIME,1,.001,TIME,1,NTIME)
      CALL LINTERP(VSCALE,TIME,NTIME,RATIO,ISI*0.001,NSAMP)

C     print out the time,vavg,vmult table
      IF(VERBOS) THEN
         write(LPRT,*)" "
         write(LPRT,*)" AFTER CONVERSION TO AVERAGE VELOCITY VS. TIME"
         WRITE(LPRT,*)"   TIME        VAVG     VMULT"
         do IT=1,NSAMP
            write(LPRT,'(F7.0,F12.0,F10.3)')
     +                  FLOAT((IT-1)*ISI),VAVG(IT),RATIO(IT)
         enddo
      ENDIF

C     PERTURBATE FUNCTIONS IN AVERAGE VELOCITY

      IV=1 
      MIDPERT=NUMPERT/2+1

      DO IP=1,NUMPERT
        nextiv=.false.
C       COMPUTE PERTURBATION FACTOR
        IF((LOWHI.eq.1 .or. LOWHI.eq.3) .and. IP.LT.MIDPERT)THEN
          PFACT=-1.*(MIDPERT-IP)/(MIDPERT-1)
          nextiv=.true.
        ELSE IF (IP.EQ.MIDPERT) THEN
          PFACT=0.
          nextiv=.true.
        ELSE IF ((LOWHI.eq.2 .or. LOWHI.eq.3) .and. IP.GT.MIDPERT) THEN
          PFACT=(IP-MIDPERT)/(NUMPERT-MIDPERT)
          nextiv=.true.
        ENDIF                     
        if (nextiv) then
C         COMPUTE PERTURBATED VAVG FUNCTION
          DO II=1,NSAMP
            VELT(II)=(1.+((RATIO(II)-1.)*PFACT))*VAVG(II)
          ENDDO
C         CONVERT AVERAGE TO INTERVAL VELOCITY
          CALL TLP2TINT(VELT,NSAMP,VEL(IV),1.0)
C         BLOCK INTO CONSTANT VELOCITY LAYERS
          IF(DELTAV.GT.0.) CALL VELBLOCK(VEL(IV),NSAMP,DELTAV)
          IV=IV+NSAMP
        endif
      ENDDO
 
C     STUFF MIN/MAX VELOCITY INTO LINE HEADER
      minv=99999.
      maxv=-99999.
      j=NTR*NSAMP
      DO I=1,J
        IF (VEL(I).LT.MINV) THEN
          MINV=VEL(I)
        ELSEIF (VEL(I).GT.MAXV) THEN
          MAXV=VEL(I)
        ENDIF
      ENDDO
      iminv=MINV
      call savew(IHEAD,'MinVel',iminv,linhed)
      imaxv=MAXV
      call savew(IHEAD,'MaxVel',imaxv,linhed)

C     OUTPUT VELOCITY FUNCTION PERTURBATION DATASET
      CALL WRTAPE(LUOUT,IHEAD,JCOF)
      LA=1
      IRX(106)=1
      JEOF = (ITRWRD+NSAMP)*ISZBYT
      DO L= 1,NTR
        IRX(107)=L
        CALL VMOV(VEL(LA),1,VIN,1,NSAMP)
        CALL WRTAPE(LUOUT,RXX,JEOF)
        LA=LA+NSAMP
      ENDDO

      WRITE(LPRT,*) ' JOB COMPLETE'
      CALL LBCLOS(LUOUT)
      STOP
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR HANDLING                               C
C                       LINE HEADER ERRORS                             C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1000 CONTINUE
      WRITE(6,1010)
 1010 FORMAT(2X,'ERROR READING LINE HEADER')
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         TAPEIO ERRORS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 1500 CONTINUE
      WRITE(6,1510)MR,L
 1510 FORMAT(2X,'TAPEIO ERROR PROCESSING OUTPUT RECORD',I5,' TRACE',I5)
      CALL LBCLOS(LUOUT)
      STOP 75
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C                         ERROR READING CARDS
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
3000  CONTINUE
      WRITE(6,3011)
3011  FORMAT(2X,'ERROR READING PARAMETER CARD')
      CALL LBCLOS(LUOUT)
      STOP 75
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       cmdlin                                                *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      cmdlin  (NTAP,OTAP,NS,PIPI,IPIPO,LER,VERBOS)                    *
C  ARGUMENTS:                                                          *
C      NTAP    CHAR*128  ??IOU* -                                      *
C      OTAP    CHAR*128  ??IOU* -                                      *
C      NS      INTEGER   ??IOU* -                                      *
C      IPIPI   INTEGER   ??IOU* -                                      *
C      IPIPO   INTEGER   ??IOU* -                                      *
C      LER     INTEGER   ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 88/03/16  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 88/03/16  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      ARGSTR          -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 1) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE cmdlin(NTAP,OTAP,INPUT,IPIPI,IPIPO,LER,VERBOS)
      INTEGER ARGIS
      LOGICAL HELP,VERBOS
      CHARACTER*128 NTAP,OTAP,INPUT
C     SET DEFAULTS TO NO PIPES
      IPIPI=0
      IPIPO=0
      VERBOS=.FALSE.
      HELP  = (ARGIS( '-h' ).GT.0) .OR. (ARGIS( '-?').GT.0)
      IF(HELP)THEN
         WRITE(LER,*)'COMMAND LINE ARGUMENTS--VELOCITY PERTURBATIONS'
         WRITE(LER,*)' '
         WRITE(LER,*)' INPUT '
         WRITE(LER,*)'-N[ntap]     . INPUT DATASET NAME OF VELOCITY '
         WRITE(LER,*)'             . FUNCTION IN VINT VS. TIME'
         WRITE(LER,*)'-O[otap]     . OUTPUT DATASET NAME OF VELOCITY '
         WRITE(LER,*)'             . FUNCTION PERTURBATION DATASET'
         WRITE(LER,*)'-C[card]     . INPUT PARAMETER CARD FILE' 
         WRITE(LER,*)'-V           . VERBOSE PRINTOUT'
         WRITE(LER,*)' '
         WRITE(LER,*)'USAGE:'
         WRITE(LER,*)'vmod -N[] -O[] -C[]'
         STOP
      ENDIF
      CALL ARGSTR('-N',NTAP ,' ',' ')
      CALL ARGSTR('-O',OTAP ,' ',' ')
      CALL ARGSTR('-C',INPUT,' ',' ')
      VERBOS = (ARGIS( '-V' ).GT.0)
C     MAKE THE NTAP A PIPE
      IF(NTAP.EQ.' ' ) IPIPI=1
C     MAKE THE OTAP A PIPE
      IF(OTAP.EQ.' ' ) IPIPO=1
      RETURN
      END

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

      SUBROUTINE READCARD(LCRD,IPRT,NUMPERT,DELTAV,TDFLAG,LOWHI,
     +                    TIMDEP,VSCALE,NTIME)

      PARAMETER(MXSAM=4096)

      INTEGER LCRD,IPRT
      INTEGER NUMPERT,NTIME,TDFLAG,LOWHI
      REAL DELTAV
      REAL TIMDEP(1),VSCALE(1)

      CHARACTER*1 CARD(80)
      CHARACTER*4 NAME
      EQUIVALENCE (CARD(1),NAME)

CMAT  DO 200 J=1,999
      DO  J=1,999
         READ(LCRD,'(80A1)',ERR=3000,END=999)CARD
                            
         IF(NAME.EQ.'VEL ')THEN
           READ(LCRD,300,ERR=3000,END=999)NUMPERT,DELTAV,TDFLAG,LOWHI
  300      FORMAT(10X,I10,F10.0,2I10)
 
         ELSE IF(NAME.EQ.'VMUL')THEN
           DO I=1,MXSAM               
              inum = i
              READ(LCRD,305,ERR=709,END=708)
     +             NAME,TIMDEP(I),VSCALE(I)
  305         FORMAT(A4,6X,BN,2F10.0)
              IF(NAME.NE.'    '.AND.NAME.NE.'VMUL')GOTO 709
              IF(I.GT.1.AND.TIMDEP(I).LT.TIMDEP(I-1))THEN
                WRITE(IPRT,343)
343             FORMAT(/,'** ERROR TIMES/DEPTHS MUST INCREASE')
              ENDIF
           ENDDO
 
709        CONTINUE
           BACKSPACE(LCRD)
         ENDIF

708     CONTINUE
      enddo
      GOTO 999
 
3000  CONTINUE
      WRITE(IPRT,*)'ERROR READING INPUT CARDS'
999   CONTINUE
      NTIME = inum-1
      RETURN
      END

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C#   +    1    +    2    +    3    +    4    +    5    +    6    +    7
CVEL MODEL   # FUNCTS    DELTAV       T/D    HI/LOW
C                  41       100         2         3
CVMULT      TIME/DPTH     VMULT
CVMULT             40       1.1
CVMULT            120
CVMULT            440       1.2
