C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      	subroutine xwmig (indata, outdata, tsin, tcos, 
     :      v, chop, xs, zs, xg, zg, xmin, dx, zmin, dz, dt,
     :      nq, nt, nx, nz, delay, oper, xint )
c       
c       xwmig: crosswell migration of one data trace 
c       
c       credits: C. Liner (utulsa) 5/92, 11/92 
c       
	implicit none
c
c       ******** begin subroutine arguments ******
c       
c       nq = number of points in trig tables on range 0->2pi
c       nt = time samples per input trace 
c       nx = traces in outdata
c       nz = depth levels in outdata 
c       
	integer nq, nt, nx, nz
c       
c       indata    = input data trace 
c       outdata   = migrated image 
c       tsin,tcos = trig tables (see subroutine `table')
c       
	real indata(nt), outdata(nz,nx), tsin(nq), tcos(nq)
c       
c       v     = constant migration velocity
c       chop  = smallest absolute amplitude to process (for speed)
c       xs,zs = x- and z-coordinate of source for this trace
c       xg,zg = x- and z-coordinate of receiver for this trace
c       xmin  = minimum x-coordinate (left) in migrated image
c       dx    = trace spacing in migrated image
c       zmin  = minimum z-coordinate (top) in migrated image
c       dz    = depth increment in migrated image
c       dt    = time sample rate of input data
c       delay = delay beyond first arrival to begin processing
c       oper  = flag for single/double signed operator
c               1 = up/downgoing waves are both processed +1
c               2 = upwaves->(+1) downwaves->(-1)
c
        real v, chop, xs, zs, xg, zg , om1, oc, op1, xd
        real xmin, dx, zmin, dz, dt, delay  
        integer oper
c
c       ******** end subroutine arguments ******
c       

c
c       ******** local variables ******
c        
c       x,z   = coordinates in rotated system 
c       x1,z1 = coordinates in unrotated system 
c       t     = reflection time 
c       tmin  = direct arrival time 
c       odx   = 1/dx to avoid divide on inner loop 
c       odz   = 1/dz to avoid divide on inner loop 
c       xsphx = xs + hx to avoid an add on inner loop 
c       zsphz = zs + hz to avoid an add on inner loop 
c        
        real x, z, x1, z1, t, tmin, odx, odz, xsphx, zsphz
c        
c       hx        = horizontal half-offset between source and reciever 
c       hz        = vertical half-offset between source and reciever 
c       h         = half-distance between source and receiver
c       tmpx,tmpz = temporary variables
c        
        real hx, hz, h, tmpx, tmpz
c        
c       a     = ellise invariant distance
c       b     = distance from ellipse center to either focus 
c       xc,zc = x- and z-coord of center point between source and rec 
c        
	real a, b, xc, zc, xint
c        
c       itmin       = time sample of tmin+delay
c       it,iz,ix,iq = integer counter for t,z,x,q
c       nqby2       = int( nq/2 )
c        
        integer it, itmin, iz, ix, iq, ixold, izold, nqby2

c        
c       comments done to here 
c        
	hx = (xg - xs)/2.
	hz = (zg - zs)/2.
	xc = xs + hx
	zc = zs + hz
	h  = sqrt(hx*hx + hz*hz)
	tmpx = hx / h
	tmpz = hz / h

c       ... some operations that can be done ahead of time
c       ... to speed up inner loop
        odx  = 1./dx
        odz  = 1./dz
        xsphx = xs + hx
        zsphz = zs + hz

        tmin = 2*h/v + delay
        itmin = tmin/dt + 2

c	... loop over t
	do 200 it = itmin, nt

c         ... time associated with this time sample
	  t = (it - 1)*dt

c         ... a = total travel path: src->refl->rec.
c         ... [and the invariant distance for the elliptical
c         ...  impulse response]
	  a = v*t/2.

c         ... skip this sample if
c         ... the amp is too small to worry about, amp < chop.
	  if (abs(indata(it)) .le. chop) goto 200
c         ... b = half-width of ellipse along axis through foci
	  b = sqrt(a*a - h*h)

c         ... special case iq=1
c         ... see main q-loop for comments
          iq = 1 
          x  = a * tcos(iq) + xsphx
	  z  = b * tsin(iq) + zsphz
	  x1 = (x - xc)*tmpx - (z - zc)*tmpz + xc
	  z1 = (x - xc)*tmpz + (z - zc)*tmpx + zc 
          ix = (x1 - xmin)*odx + 1
          iz = (z1 - zmin)*odz + 1

	  if (ix .ge. 1 .and. ix .le. nx) then
	    if (iz .ge. 1 .and. iz .le. nz ) then
	      outdata(iz,ix) = outdata(iz,ix) + indata(it) 
	    endif
	  endif

c         ... remember this coordinate in the output (image) space
          ixold = ix 
          izold = iz 

c         ... loop over arc length along migration ellipse
          nqby2 = nq/2
	  do 100 iq = 2, nq - 2

c           ... NOTE: q loop has 20 floating point ops (no div) 
c           ...       and 6 if-checks in 3 if-calls. 

c           ... calc (x,z) in coordinate system with origin at center
c           ... of migration ellipse, and x-axis tilted through
c           ... source/receiver
            x  = a * tcos(iq) + xsphx
	    z  = b * tsin(iq) + zsphz

c           ... rotate to horizontal x-axis and translate 
c           ... to arbitrary origin
	    x1 = (x - xc)*tmpx - (z - zc)*tmpz + xc
	    z1 = (x - xc)*tmpz + (z - zc)*tmpx + zc 

c           ... find indices of this output point
            ix = (x1 - xmin)*odx + 1
            iz = (z1 - zmin)*odz + 1

c           ... check that we have moved to a new output point
c	    if (ix .ne. ixold .or. iz .ne. izold) then

c             ... check that point is beyond x-limits of output
	      if (ix .gt. 1 .and. ix .lt. nx) then

c               ... check that point is beyond z-limits of output
	        if (iz .gt. 1 .and. iz .lt. nz ) then

c                 ... add data amplitude into migrated image
                  if (oper .eq. 2 .and. iq .gt. nqby2) then

                    om1 = outdata(iz-1,ix)
                    op1 = outdata(iz+1,ix)
                    xd  = indata(it)
	            outdata(iz-1,ix) = om1 + xint * xd
	            outdata(iz+1,ix) = op1 + xint * xd
                    om1 = outdata(iz,ix-1)
                    oc  = outdata(iz,ix  )
                    op1 = outdata(iz,ix+1)
	            outdata(iz,ix-1) = om1 + xint * xd
	            outdata( iz,ix ) = oc  +        xd
	            outdata(iz,ix+1) = op1 + xint * xd
                  else
	            outdata(iz,ix) = outdata(iz,ix) + indata(it) 
                  endif

	        elseif (iz .eq. 1 .or. iz .eq. nz) then
c                 ... add data amplitude into migrated image
                  if (oper .eq. 2 .and. iq .gt. nqby2) then

	            outdata(iz,ix) = outdata(iz,ix) - indata(it) 
                  else
	            outdata(iz,ix) = outdata(iz,ix) + indata(it) 
                  endif

	        endif

	      elseif (ix .eq. 1 .or. ix .eq. nx) then

c               ... check that point is beyond z-limits of output
	        if (iz .gt. 1 .and. iz .lt. nz ) then

c                 ... add data amplitude into migrated image
                  if (oper .eq. 2 .and. iq .gt. nqby2) then

                    om1 = outdata(iz-1,ix)
                    oc  = outdata(iz,  ix)
                    op1 = outdata(iz+1,ix)
                    xd  = indata(it)
	            outdata(iz-1,ix) = om1 + xint * xd
	            outdata( iz,ix ) = oc  +        xd
	            outdata(iz+1,ix) = op1 + xint * xd
                  else
	            outdata(iz,ix) = outdata(iz,ix) + indata(it) 
                  endif

	        elseif (iz .eq. 1 .or. iz .eq. nz) then
c                 ... add data amplitude into migrated image
                  if (oper .eq. 2 .and. iq .gt. nqby2) then

	            outdata(iz,ix) = outdata(iz,ix) - indata(it) 
                  else
	            outdata(iz,ix) = outdata(iz,ix) + indata(it) 
                  endif

	        endif

	      endif
c	    endif

	    ixold = ix
	    izold = iz

 100    continue

 200    continue

	return
	end	





      	subroutine trigtable (tsin, tcos, nq)
	implicit none
	integer nq
	real tsin(nq), tcos(nq)

        integer iq
	real dq, q

	dq = 2.*3.1415926 / (nq - 1)

	do 100 iq = 1, nq
            q = ( iq - 1 ) * dq
            tsin(iq) = sin(q)
	    tcos(iq) = cos(q)
 100    continue

	return
	end	


