C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c***********************************************************************
c NAME: ZKGCMDLN
c PURPOSE: GET COMMAND LINE ARGUMENTS
c***********************************************************************
c
c  HISTORY:       MAR 95          REV 1.0         J. Cooperstein, CETech
c
c***********************************************************************
      subroutine zkgcmdln( dt, dz, tmax, zmax, mbytes, outfil, datsfx
     &                   , datpth, verbos, debug)
c***********************************************************************
c
      implicit none
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
c
c output parameters:
c
      integer   debug           ! debug output flag
      real      dt              ! Sampling interval (milliseconds)
      real      dz              ! delta z
      integer   mbytes          ! MBytes for scratch (default=32)
      real      tmax            ! maximum t (msecs)
      real      zmax            ! maximum z
      logical   verbos          ! verbose output flag
      character outfil*(*)      ! output data dictionary
      character datpth*(*)      ! output data file path
      character datsfx*(*)      ! output data file suffix
c
c local variables:
c
      character flags*64        ! input flags
c
c***********************************************************************
c
c===  get command line arguments
c
      call argr4( 'dz='   , dz    ,    0.0,    0.0 )
      call argr4( 'dtms=' , dt    ,    0.0,    0.0 )
      call argr4( 'zmax=' , zmax  ,    0.0,    0.0 )
      call argr4( 'tmax=' , tmax  ,    0.0,    0.0 )
c
      if ( ((dz .gt. 0.0) .and. (dt .gt. 0.0)) .or.
     &   ((dz .eq. 0.0) .and. (dt .eq. 0.0)) ) then
         write( LER, * )' ***** ERROR: dz OR dtms may be specified,'
     &                , ' but not both *****'
         call exitfu(1)
      endif
c
#ifdef CRAY
      call argi4( 'M='    , mbytes,     64,     64 )
#else
      call argi4( 'M='    , mbytes,     32,     32 )
#endif
c
      call argi4( '-D'    , debug ,     1 ,     0  )
      call argstr('flags' , flags ,    ' ',    ' ' )
      verbos = ( index( flags, 'V' ) .gt. 0 ) .or. ( debug .gt. 0 )
c
      call argstr( 'out='         , outfil, ' '    , ' '    )
      call argstr( 'data_path='   , datpth, './'   , './'   )
      call argstr( 'data_suffix=' , datsfx, '.usp' , '.usp' )
c***********************************************************************
      return
      end
c***********************************************************************
