C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************
c
c aps_usp  reads data from aps files (or sps files), both point and
c          relation, and stuffs it into usp line headers and trace
c          headers.  Works for single- or multi-component data.
c          Replaces function of pr3d?
c
c**********************************************************************
c
c USP system includes
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

#ifdef SUNSYSTEM
      implicit   none
#endif

      character name*100
c
c    USP dataset dimensions, variables
c
      integer numsmp, numtrc, numrec, ns, irs
      integer recind
      integer ifmt_CrwNam, l_CrwNam, ln_CrwNam
      integer ifmt_PrcNam, l_PrcNam, ln_PrcNam
      integer ifmt_JobNum, l_JobNum, ln_JobNum
      integer ifmt_UnitFl, l_UnitFl, ln_UnitFl
      integer ifmt_NumCmp, l_NumCmp, ln_NumCmp
      integer ifmt_MCTrSp, l_MCTrSp, ln_MCTrSp
      integer ifmt_MCLE(16), l_MCLE(16), ln_MCLE(16)

*      integer ifmt_SGRDat, l_SGRDat, ln_SGRDat, sgrdat
      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer ifmt_LinInd, l_LinInd, ln_LinInd, linind
      integer ifmt_SrComp, l_SrComp, ln_SrComp
      integer ifmt_RcComp, l_RcComp, ln_RcComp
      integer ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC, srptxc
      integer ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC, srptyc
      integer ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC, rcptxc
      integer ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC, rcptyc
      integer ifmt_SrXAzm, l_SrXAzm, ln_SrXAzm, srxazm
      integer ifmt_SrYRot, l_SrYRot, ln_SrYRot
      integer ifmt_SrZRot, l_SrZRot, ln_SrZRot
      integer ifmt_RcXAzm, l_RcXAzm, ln_RcXAzm, rcxazm
      integer ifmt_RcYRot, l_RcYRot, ln_RcYRot
      integer ifmt_RcZRot, l_RcZRot, ln_RcZRot
      integer ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm
      integer ifmt_RecInd, l_RecInd, ln_RecInd
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn, dstsgn

      real dt
c
c    Space for a line header
c
      integer lheader(SZLNHD)
      integer lhedlength, trlength, trdataoff
      integer itrace
c
c    Function subroutines
c
      integer argis, nblen, usprtrace, uspwtrace, uspclose
c      integer uspseek
      character   getname * 100

      integer ierr, iabort
c
      integer jerr
c
c    Data trace (plus header)
c
      real        trace
      pointer     (ptrace, trace(2))
c
c    uspio argument declarations
c
      character*100 mode, clparam, wclparam, infile, outfile
      integer   ierror, maxfile, maxcomp
      integer   pt
      integer   dptw
      integer   ikpsock
      integer   seekalot, seekstat
      integer   cinp
      integer   incon, outcon

*     aps_usp declarations 

      character*1    dumx, dum1, H
      character*6    fldtap, mcmnem
      character*8    jobnum, srcortn, rcvortn
      character*10   gpcontr
      character*14   rclnm, rlinam
      character*15   dum15
      character*16   srlnm, slinam
      character*21   dum21
      character*27   mclist
      character*48   crwnam
      character*80   card
      character*255  srcaps, rcvaps, relaps

      integer        lusrc, lurel, lurcv
      integer        istart, icmp, numcmp, hnum, h4num, hnrec
      integer        index, unitfl, numch, nreclen
      integer        date, fldrecno, fldreci
      integer        sn_rel, srcindx, sn_src, srcind
      integer        chfrom, chto, chindx
      integer        rcvfrom, rcvto, rcvindx, rn_rcv, rn_rel
      integer        sc_usp, sc_rel, sc_src, isazmth
      integer        rc_usp, rc_rel, rc_rcv, irazmth
      integer        mcle(16), mcrcvr(4)
      integer        str_int

      logical        verbos, all, slflag, spflag
      logical        srcend, rcvend, relend

      real           srate, reclen
      real           xsrc, ysrc, slazmth, sazmth
      real           xrcv, yrcv, rlazmth, razmth

      data           all,    srxazm, rcxazm, mcle,  H/
     &               .FALSE., 900  ,  900  , 16*0, 'H'/
**********************************************************************
      name = getname()
c*********************************************************************
c
c    Self-doc
c
c*********************************************************************

      if ( argis ( '-?' ) .gt. 0 .or. 
     &     argis ( '-h' ) .gt. 0 .or.
     1     argis ( '-help' ) .gt. 0  ) then
 
          write(LER,14) name(1:nblen(name))
 14       format('***************************************************'//
     1            a80,/
     2    ' stuffs info from aps files into usp headers.'//
     3    ' Usage: aps_usp -Saps_src_file -Raps_rcvr_file'/
     4    '                -Xaps_reln_file -MCL[] -ALL -V'/
     5    '                -sl OR -sp'/
     6    '                -Nseismic_indata -Oseis_outdata' )
          write(LER,14) ' '
          write(LER,14) ' -MCL has the default 11,12,21,22'
          write(LER,14) ' -sp means find shot #s in SoPtNm (default)'
          write(LER,14) ' -sl means find shot #s in SrcLoc'
          stop       
      endif

#include <f77/open.h>

*********************************************************************
*     get command line arguments

      call cmdln(srcaps, rcvaps, relaps, all, mclist,
     &           slflag, spflag, verbos)

*     open, check aps input files
 80   format(1a80)
      lusrc = 0
      if ( srcaps .ne. ' ' ) then
         call alloclun(lusrc)
         open (lusrc, file=srcaps(1:nblen(srcaps)),status='old',err=910)
         if (verbos) write(LER ,82)  srcaps
         write(LERR,82)  srcaps
 82      format(/' Source aps input: ',a80)
         rewind(lusrc)
         read (lusrc, 80) card
         if (card(33:38) .ne. 'APS001') then
            write (LER, 84) card(33:38)
            write (LERR,84) card(33:38)
 84         format(' APS source format version number: ',a6/
     &             ' is not APS001.')
            stop
         endif
      endif

      lurcv = 0
      if ( rcvaps .ne. ' ' ) then
         call alloclun(lurcv)
         open (lurcv,file=rcvaps(1:nblen(rcvaps)),status='old',err=920)
         if (verbos) write(LER ,86)  rcvaps
         write(LERR,86)  rcvaps
 86      format(/' Receiver aps input: ',a80)
         rewind(lurcv)
         read (lurcv, 80) card
         if (card(33:38) .ne. 'APS001') then
            write (LER, 88) card(33:38)
            write (LERR,88) card(33:38)
 88         format(' APS receiver format version number: ',a6/
     &             ' is not APS001.')
            stop
         endif
      endif

      lurel = 0
      if ( relaps .ne. ' ' ) then
         call alloclun(lurel)
         open (lurel,file=relaps(1:nblen(relaps)),status='old',err=930)
         if (verbos) write(LER ,45)  relaps
         write(LERR,45)  relaps
 45      format(/' Relation aps input: ',a80)
         rewind(lurel)
         read (lurel, 80) card
         if (card(33:38) .ne. 'APS001') then
            write (LER, 47) card(33:38)
            write (LERR,47) card(33:38)
 47         format(' APS relation format version number: ',a6/
     &             ' is not APS001.')
            stop
         endif
      endif      

      if ( srcaps .eq. ' ' .or. rcvaps .eq. ' ' .or.
     &     relaps .eq. ' '                          ) then
         write(LER,14) name(1:nblen(name))
         stop
      endif

*********************************************************************
c
c    uspioinit initializes the "uspinfo" structure used by the uspio
c    library. To allocate enough space, uspioinit needs to know the
c    maximum number ofseismic files and the maximum number of components
c    to allow for. For scalar I/O, maxcomp is 1.
c

      maxfile = 2
      maxcomp = 1
      call uspioinit(name, maxfile, maxcomp)
      write(LERR,*) 'uspio initialized'

c**********************************************************************
c
c    uspsinput: "USP Scalar Input"
c
c**********************************************************************
c
c    Description of INPUT arguments to uspsinput
c
c**********************************************************************
c
c mode (read / write mode):
c 'r'   open an already existing file for reading only
c 'rw'  open an already existing file for reading and writing
c 'ra'  open an already existing file for reading, writing, and
c       appending. Output will start at the end of the file
c       (although nothing will prevent you from seeking back to the
c       beginning and overwriting the original traces if you wish!).
c

      mode = 'r'

c
c clparam ("Input file name command line parameter"): this string
c is appended to '-N' and looked for on the command line to find
c an input file name for this input. If clparam is whitespace,
c then uspinput will look for '-N' (as is usual practice for scalar
c USP programs that only need a single input). If instead clparam
c were, say, '1', then uspinput would look for '-N1' on the command
c line.
c
c If an input file name is specified, then uspinput will attempt
c to open that file for input.
c
c If no input file name is specified on the command line, the place
c uspinput next looks depends on whether the program is running
c under IKP or not. If not in IKP, the only possible fallback is to
c standard input. If in IKP, the fallback is to the "IKP single input"
c socket number specified by the argument "ikpsock" (this is quite
c likely 0, meaning standard input, but doesn't have to be).
c
c If you specify the same "clparam" for different inputs, uspinput
c will check the command line for repeated occurrences of the same
c argument. (For example, "-N file1 -N file2 -N file3".) Note this is
c very different from the behavior for "wclparam" (see below).
c

      clparam = ' '

c
c wclparam ("Windowing command line parameter"): This string is appended
c to '-ns', '-ne', '-rs', '-re', '-wi', and '-pt' and the result looked
c for on the command line to determine how to "window" the data. If
c wclparam is entirely whitespace you'll get the usual USP defaults.
c
c '-ns' and '-ne' are the standard start-trace, end-trace in a gather
c parameters; '-rs' and '-re' are the standard start-gather, end-gather
c in a line parameters.
c
c '-pt', if present, specifies that traces outside the window should
c be passed through; '-wi', if present, specifies that traces outside
c the window should be discarded.
c
c If you specify the same wclparam for multiple input files, uspinput
c will only look for the associated windowing parameters on the command
c line ONCE. After that it will re-use whatever values it found before.
c (The idea is that if you specify one '-rs', say, you'll want it to
c apply to ALL the associated '-N' input files, no matter how many
c there happen to have been.)
c

      wclparam = ' '

c
c dptw ("default pass through or window"): In the absence of anything
c to the contrary on the command line, 0 means DON'T pass through
c unused data, 1 means DO pass it through unchanged.
c '-wi(wclparam suffix)' on the command line overrides, and means
c to truncate anyway. '-pt(wclparam suffix)' overrides, and means
c to pass through anyway. If dptw is -1, that means don't even LOOK
c on the command line for any windowing parameters; the user program
c wants to handle ALL windowing / pass-through etc details for this
c file for itself.
c

      dptw = 0

c
c ikpsock is the ikp socket number to look for a single input on.
c Usually ikpsock will be 0, meaning standard input. (You are asked
c to specify ikpsock because you might want to have multiple inputs
c in ikpsock; at most one of those could be from standard input.)
c

      ikpsock = 0

c
c seekalot guides uspinput in deciding how to buffer the data.
c A value of 0 means "this program will mostly plod through the data
c reading in order (alternated perhaps with passes through the data
c writing in order)". A value of 1 means "this program will jump around
c within a gather a lot, but not often between different gathers". If
c the program is going to furiously alternate reading and writing
c nearby traces (for example, read a trace, write it back out, read
c the next trace, write it back out, etc) that also counts as 1.
c If the program will jump at random all over the data, even between
c different gathers and lines, then seekalot should be 2.
c

      seekalot = 0

      ierror = 0

      call uspsinput(mode, clparam, wclparam, 
     1      dptw, ikpsock, seekalot, seekstat,
     1      numsmp, numtrc, numrec, dt, ns, irs, pt,
     1      lheader, lhedlength, trlength, trdataoff, infile,
     1      incon, ierror)

c**********************************************************************
c
c    Description of OUTPUT arguments of uspsinput
c
c**********************************************************************
c
c numsmp, numtrc, numrec, dt specify the dimensions of the dataset:
c
c  numsmp = number of samples in a trace (NumSmp),
c  numtrc = number of traces in a gather (NumTrc)
c  numrec = number of gathers in a line  (NumRec)
c
c  dt = sampling rate, in FLOATING-POINT SECONDS.
c       (uspinput / uspouput handle the conversion between
c       the sample rate stored as an integer in the usp line header
c       keyword 'SmpInt', and the floating-point number that most
c       programs that actually USE the sample rate as a physically
c       meaningful unit demand.)
c

c
c ns and irs return the trace number and gather number, respectively,
c of the first trace the user program sees. (These are not from any
c header; they are simply counted from the beginning of the file,
c starting with 1, 2, 3, etc.) Your program may need this information
c to modify values from the line header specifying things like initial
c trace offsets, etc. (They may no longer be what you expect after
c windowing.)
c
c
c pt tells your program whether the output will be windowed (0) or
c passed through (1). The user program may need to know this for
c modifying values in an outgoing line header. (The standard
c USP dimensional line-header keywords "NumTrc" and "NumRec" will
c automatically be set appropriately by "uspoutput".)
c
c
c lheader is the line header for this input.
c
c
c lhedlength is the length in bytes of this line header.
c
c
c trlength is the length in full words (floats) of a single trace,
c including the trace header. You'll need to allocate
c trlength * SZSMPD bytes to store a trace.
c
      iabort = 1
      call galloc (ptrace, trlength * SZSMPD,
     1                    ierr, iabort)
c
c trdataoff is the offset in full words (floats) from the start of
c the trace to the start of the trace data. (In other words, it's
c the trace header length.)
c
c For now this will always be ITRWRD, but if you write your code
c to use trdataoff then it will not have to be changed if we switch
c to variable-length trace headers later on, which is quite likely.
c
c
c incon is the "connection number", the number you'll have to use
c to refer to this connection later on. (It's like a sisio logical
c unit number, but not the same. It starts at 1 for the first
c connection, and counts up.)
c
c
c ierror will be incremented once for each error that was found.
c Unless ierror is zero this input cannot be used, and attempting
c to do so will result in an error.
c
**********************************************************************

*     get aps header info
      hnrec = 1
 100  read (lurel, 80) card
      hnrec = hnrec + 1
         if(card(1:1) .ne. H) then
            backspace lurel
            hnrec = hnrec -1
            go to 1000
         endif
         hnum = str_int(card, 2, 4)

         if (hnum .eq. 2) then
*           H01 Description of survey area 
*           H02 Date of survey             
            date = -1.0
            if(card(33:40) .ne. '        ' .and.
     &          card(33:35) .ne. 'N/A'           ) 
     &          date = str_int(card, 33, 40)
           write(LER,*) card(1:32), date

         elseif (hnum .eq. 4) then
*           H021Post-plot date of issue  
*           H022Tape/disk identifier      
*           H03 Client 
*           H04 Geophysical gpcontr 

            if(card(33:42) .ne. '          ' .and. 
     &         card(33:35) .ne. 'N/A'             ) 
     &         gpcontr = card(33:42)
              write(LER,*) card(1:32), gpcontr

         elseif (hnum .eq. 20) then
*           H05 Positioning contractor 
*           H06 Pos. proc. contractor 
*           H07 Field computer system(s) 
*           H08 Coordinate location  
*           H09 Offset from coord. location
*           H12 Geodetic datum,-spheroid  
*           H14 Geodetic datum parameters 
*           H17 Vertical Datum description
*           H18 Projection type           
*           H19 Projection zone     
*           H20 Description of grid units  
            unitfl = 1
            if (index(card(33:80),'F') .ne. 0 .or.
     &         index(card(33:80),'f') .ne. 0      ) then
*              FOOT or FEET or foot or feet appears
               unitfl = 0
            endif
           write(LER,*) card(1:32), unitfl

         elseif (hnum .eq. 30) then
*           H201Factor to metre             0.30480061
*           H220Long. of central meridian  
*           H231Grid origin               
*           H232Grid coord. at origin 
*           H241Scale factor    
*           H242Lat., Long.- scale factor  
*           H30 Project code and description
            if(card(33:40) .ne. '        ' .and. 
     &         card(33:35) .ne. 'N/A'           ) 
     &         jobnum = card(33:40)
              write(LER,*) card(1:32), jobnum

         elseif (hnum .eq. 400) then
*           H31 Line number format 
*           H400Type,Model,Polarity  

            rc_rcv = 0
 400        read (lurel, 80) card
            hnrec = hnrec + 1
               if (card(1:1) .ne. H) then
                  backspace lurel
                  hnrec = hnrec - 1
                  go to 1000
               endif
               h4num = str_int(card, 2, 4)
*               if(h4num .gt. 599) then
*                  backspace lurel
*                  hnrec = hnrec - 1
*                  go to 599
*               endif

               rc_rcv = rc_rcv + 1
               if (h4num .eq. 401 + (rc_rcv-1)*20) then
*                 H401Crew name, Comment  
                  if(card(33:38) .ne. '      ' .and. 
     &               card(33:35) .ne. 'N/A'         ) 
     &               crwnam = card(33:80)
                    write(LER,*) card(1:32), crwnam

               elseif (h4num .eq. 402 + (rc_rcv-1)*20) then
*                 H402Sample rate, Record Len. 
                  call str_rl2(card, 33, 80, srate, reclen)
                  nreclen = reclen
                 write(LER,*) card(1:32), srate, nreclen

               elseif (hnum .eq. 403 + (rc_rcv-1)*20) then
*                 H403Number of channels         
                  numch = str_int(card, 33, 80)
                 write(LER,*) card(1:32), numch

               elseif (hnum .eq. 409 + (rc_rcv-1)*20) then
*                 H404Tape type, format, density  
*                 H405Filter_alias Hz,Db pnt,slope
*                 H406Filter_notch Hz,-3Db points 
*                 H407Filter_low Hz, Db pnt slope
*                 H408Time delay FTB-SOD app Y/N  
*                 H409Multi component recording   
                  mcrcvr(rc_rcv) = str_int(card,33,33)
                 write(LER,*) card(1:35), mcrcvr(rc_rcv)

*                 H410Aux. channel 1 contents     
*                 H411Aux. channel 2 contents
*                 H412Aux. channel 3 contents
*                 H413Aux. channel 4 contents    
               endif
            go to 400
 
 600        continue
*           H600Type,Model,Polarity            
*           H601Damp coeff,natural freq.
*           H602Nunits, len(X),width(Y)     
*           H603Unit spacing X,Y 
*           NB: possibly more H6__ receiever cards
*           H700Type,Model,Polarity            
*           H701Size,vert. stk fold     
*           H702Nunits, len(X),width(Y)  
*           703Unit spacing X,Y            
*           H711Nom. shot depth,charge len.
*           H712Nom. soil,drill method  
*           H713Weathering thickness 
*           NB: possibly more H7__ source cards
*           H990R,S,X file quality control 
*           H991Coord. status final/prov 

         endif
      go to 100

*     get line header offsets
*     args:       mnemonic, type,      offset,   count,    buffer
 1000 write(LERR,*) '# of header records: ', hnrec
*      write(LER,*) '# of header records: ', hnrec
      call savelu('CrwNam',ifmt_CrwNam,l_CrwNam,ln_CrwNam,LINEHEADER)
      call savelu('PrcNam',ifmt_PrcNam,l_PrcNam,ln_PrcNam,LINEHEADER)
      call savelu('JobNum',ifmt_JobNum,l_JobNum,ln_JobNum,LINEHEADER)
      call savelu('UnitFl',ifmt_UnitFl,l_UnitFl,ln_UnitFl,LINEHEADER)
      call savelu('MCTrSp',ifmt_MCTrSp,l_MCTrSp,ln_MCTrSp,LINEHEADER)
      call savelu('NumCmp',ifmt_NumCmp,l_NumCmp,ln_NumCmp,LINEHEADER)

*     write line header
      if (all) then
         call savew2(lheader,ifmt_CrwNam,l_CrwNam, ln_CrwNam,
     1               crwnam(1:6) , LINEHEADER)
         call savew2(lheader,ifmt_PrcNam,l_PrcNam, ln_PrcNam,
     1               gpcontr(1:10) , LINEHEADER)
         call savew2(lheader,ifmt_JobNum,l_JobNum, ln_JobNum,
     1               jobnum , LINEHEADER)
         call savew2(lheader,ifmt_UnitFl,l_UnitFl, ln_UnitFl,
     1               unitfl , LINEHEADER)
      endif

*        for now (4/9/95), assume that components are arranged as 
*        single-component GATHERS
         call savew2(lheader,ifmt_MCTrSp,l_MCTrSp, ln_MCTrSp,
     1                2, LINEHEADER)

      icmp = 0
1100  icmp = icmp + 1
         if(icmp .gt. 16) go to 1120
         istart = 3*(icmp-1) + 1
         if (mclist(istart:istart+1) .eq. '  ') then
            if (icmp .eq. 1) then
               write (LER,*) ' Specify -MCL correctly!'
               stop
            else
               go to 1120
            endif
         else
            mcle(icmp) = str_int(mclist, istart, istart+1)
            mcmnem(1:5) = 'MCLE0'
            if (icmp .le. 9) then
               write(mcmnem(6:6),'(i1)') icmp
            else
               write(mcmnem(5:6),'(i2)') icmp
            endif
            call savelu(mcmnem,ifmt_MCLE(icmp),l_MCLE(icmp),
     &                  ln_MCLE(icmp),LINEHEADER)
            call savew2(lheader, ifmt_MCLE(icmp), l_MCLE(icmp),
     &                  ln_MCLE(icmp), mcle(icmp), LINEHEADER)
         endif
      go to 1100

 1120 numcmp = icmp -1
      call savew2(lheader,ifmt_NumCmp,l_NumCmp, ln_NumCmp,
     1            numcmp , LINEHEADER)

*     check

*         call saver2(lheader,ifmt_CrwNam,l_CrwNam, ln_CrwNam,
*     1               crwnam , LINEHEADER)
*         call saver2(lheader,ifmt_PrcNam,l_PrcNam, ln_PrcNam,
*     1               gpcontr , LINEHEADER)
*         call saver2(lheader,ifmt_JobNum,l_JobNum, ln_JobNum,
*     1               jobnum , LINEHEADER)
*         call saver2(lheader,ifmt_UnitFl,l_UnitFl, ln_UnitFl,
*     1               unitfl , LINEHEADER)
*         call saver2(lheader,ifmt_NumCmp,l_NumCmp, ln_NumCmp,
*     1            numcmp , LINEHEADER)

*      write(LERR,*) 'CrwNam ', crwnam(1:6)
*      write(LERR,*) 'PrcNam ', gpcontr
*      write(LERR,*) 'JobNum ', jobnum
*      write(LERR,*) 'UnitFl ', unitfl
*      write(LERR,*) 'NumCmp ', numcmp
*      write(LER,*) 'MCList ', (mcle(icmp), icmp = 1, numcmp)
c**********************************************************************
c
c uspsoutput creates a file from scratch (or overwrites a file of
c that name that is already there), and writes the line header.
c
c
c**********************************************************************
c
c    Description of INPUT arguments to uspsoutput
c
c**********************************************************************
c
c
c mode (read / write mode):
c 'w'   create a new file for writing only
c 'rw'  create a new file for reading and writing
c 'ra'  create a new file for reading and writing and appending,
c       meaning that you don't have to specify the final file
c       size up front. After you're done the line header will
c       automatically be updated to reflect the final size.
c       You DO have to write out an integral number of gathers.
c
      mode = 'w'
c
c clparam ("Output file name command line parameter"): this string
c is appended to '-O' and looked for on the command line to find
c an output file name for this output. If clparam is whitespace,
c then uspoutput will look for '-O' as is usual practice for scalar
c USP programs that only need a single output.
c
c If no output file name is specified on the command line, the place
c uspoutput next looks depends on whether the program is running
c under IKP or not. If not in IKP, the only possible fallback is to
c standard output. If in IKP, the fallback is to the "IKP single output"
c socket number specified by the argument "ikpsock" (this is quite
c likely 1, meaning standard output, but doesn't have to be).
c
c If you specify the same "clparam" for different outputs, uspoutput
c will check the command line for repeated occurrences of the same
c argument. (For example, "-O file1 -O file2 -O file3".)
c
      clparam = ' '
c
c cinp gives the "corresponding input". (The "corresponding input"
c must have the same trace length and NumSmp.)
c
c If there is a corresponding input the data sample rate
c dt and the data dimensions NumTrc and NumRec will be found from
c there instead of from the uspoutput command line; the
c appropriate values will be RETURNED.
c
c Whether or not to do pass-through depends on the setting for
c the corresponding input.
c
c If there is no corresponding input set cinp to 0.
c
      cinp = incon
c
c ikpsock is the ikp socket number to look for a single output on.
c If this is not grounded, then all the output will be looked for
c here instead of in multiple sockets. Usually ikpsock will be 1,
c meaning standard output.
c
      ikpsock = 1
c
c seekalot is just as for uspinput.
c
      seekalot = 0
c
c numsmp, numtrc, numrec, dt are as for uspsinput.
c However, if there is a "corresponding input", then
c numsmp, numtrc, numrec, and dt will be set (output), not read;
c the dimensional information will be determined from the
c corresponding input.
c
c If you're appending, there's no reason not to set numrec
c to zero.
c
c
c lheader is the line header. You can either provide a header yourself
c or ask that uspoutput create one for you. In either case, the lheader
c you provide should be allocated big enough to contain a USP line
c header.
c
c Normally you will pass through a line header from a dataset you
c already read, as we do here.
c
c
c lhedlength is the length in bytes of the line header. If 0, then
c you are asking for uspoutput to create a header for you from
c scratch.
c
c Normally you will use the value for a line header you read from
c somewhere, as we do here.
c
c
c trlength is the length in full words (floats) of a single trace,
c including the trace header. Until variable length headers are
c introduced, just use trlength = ITRWRD + numsmp.
c
c If there is a "corresponding input", trlength must match the trace
c length for the corresponding input.
c

      call uspsoutput (mode, clparam, cinp, ikpsock, seekalot, seekstat,
     1   numsmp, numtrc, numrec, dt, lheader, lhedlength, trlength,
     1   outfile, outcon, ierror)
c**********************************************************************
c
c    Description of OUTPUT arguments of uspsoutput
c
c**********************************************************************
c
c seekstat is just as for uspsinput.
c
c
c If there is a corresponding input, then numtrc, numrec, and dt
c will be returned.
c
c
c outcon is the "connection number", the number you'll have to use
c to refer to this connection later.
c
c
c ierror will be incremented once for each error that was found.
c Unless ierror is zero this output cannot be used, and
c attempting to do so will result in an error.
c

**********************************************************************
*  get trace header offsets
*     args:       mnemonic, type,      offset,   count,    buffer
*      call savelu('SGRDat',ifmt_SGRDat,l_SGRDat,ln_SGRDat,TRACEHEADER)
      call savelu('SrComp',ifmt_SrComp,l_SrComp,ln_SrComp,TRACEHEADER)
      call savelu('RcComp',ifmt_RcComp,l_RcComp,ln_RcComp,TRACEHEADER)

      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

      call savelu('SrXAzm',ifmt_SrXAzm,l_SrXAzm,ln_SrXAzm,TRACEHEADER)
      call savelu('SrYRot',ifmt_SrYRot,l_SrYRot,ln_SrYRot,TRACEHEADER)
      call savelu('SrZRot',ifmt_SrZRot,l_SrZRot,ln_SrZRot,TRACEHEADER)
      call savelu('RcXAzm',ifmt_RcXAzm,l_RcXAzm,ln_RcXAzm,TRACEHEADER)
      call savelu('RcYRot',ifmt_RcYRot,l_RcYRot,ln_RcYRot,TRACEHEADER)
      call savelu('RcZRot',ifmt_RcZRot,l_RcZRot,ln_RcZRot,TRACEHEADER)

      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)

***********************************************************************
*     prepare to read src, rcv tapes
      rewind (lusrc)
      call skip (lusrc, hnrec)
      rewind (lurcv)
      call skip (lurcv, hnrec)

**********************************************************************
      icmp = 0
*     do for every trace
 3000 do 3099 itrace = 1, numrec * numtrc
*        assume that the different components are assembled in 
*        consecutive shot-gather records
         if (mod(itrace,numtrc) .eq. 1) then
            icmp = icmp + 1
            if(icmp .gt. numcmp) icmp = 1
            write(LERR,*) 'Starting shot gather', itrace/numtrc + 1
         endif

c     Arguments to usprtrace and uspwtrace:
c
c**********************************************************************
c
c     The first argument is the integer connection number that you
c     got back from either uspinput or uspoutput.
c
c     The second argument is the trace array for it to read from or
c     write to.
c
c     The third argument is the DIMENSIONED length of the trace.
c     If the trace it reads is too long to fit, you will get an error
c     message instead of a memory overrun and possibly a core dump.
c     In this example, since we allocated the trace to be just long
c     enough, the length is just trlength.
c
c     The return value is:
c
c     0: everything OK
c    -1: something very bad
c     1: you just went off the end of the data
c

         if (usprtrace(incon, trace, trlength) .ne. 0) then
            write (LER , *) 'Could not read trace ', itrace
            go to 3099
         endif

*        get parms for this data
         if (spflag) then
            call saver2(trace,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                  srcind , TRACEHEADER)
         elseif (slflag) then                        
            call saver2(trace,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                  srcind , TRACEHEADER)
         endif
         call saver2(trace,ifmt_RecInd,l_RecInd, ln_RecInd,
     1               recind , TRACEHEADER)
         call saver2(trace,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1               dstsgn , TRACEHEADER)

*        assuming that the different components are assembled in 
*        consecutive shot-gather records (MCTrSp=2):
         rc_usp = mod(mcle(icmp),10)
         sc_usp = (mcle(icmp)-rc_usp)/10
*         write(LERR,*) icmp, 'MCLE(',mcle(icmp),')',sc_usp, rc_usp
         if (mod(itrace,numtrc) .eq. 1) then
            write(LERR,3005) itrace/numtrc, srcind, icmp
            write(LER,3005) itrace/numtrc + 1, srcind, mcle(icmp)
 3005       format(' Starting shot gather', i5, '; at shot point', i5,
     &             '; component ',i2)
         endif

***********************************************************************
*        get relations
*        start of relation loop

         relend = .FALSE.
*        rewind once only, if nec
 2000    if (relend) then
            rewind (lurel)
            call skip (lurel, hnrec)
         endif

         read (lurel, 2005,end=2030) dumx,fldtap,fldrecno,fldreci,dum1,
     &                                srlnm, sn_rel, srcindx,
     &                                chfrom, chto, chindx,
     &                                rclnm, rcvfrom, rcvto, rcvindx,
     &                                sc_rel, rc_rel
 2005       format(a1, a6, i4, i1, a1,
     &              a16, i8, i1, 
     &              2i4, i1, 
     &              i16, 2i8, i1, 
     &              2i3)
*|     |   |||               |       ||   |   ||               |       |
*     aps format :
*     col  1    : type X               (a1)
*     col  2-7  : field tape no.       (a6)
*     col  8-11 : field record no.     (i4)
*     col 12    : field record incr.   (i1)
*     col 13    : rcvr instrument code (a1)
*     col 14-29 : shot line name        (a16)
*     col 30-37 : shot point no.        (i8)
*     col 38    : shot point index      (i1)
*     col 39-42 : from rcvr channel     (i4)
*     col 43-46 : to rcvr channel       (i4)
*     col 47    : rcvr channel incr     (i1)
*     col 48-63 : rcvr line name        (a16)
*     col 64--71: from rcvr             (i8)
*     col 72-79 : to rcvr               (i8)
*     col 80    : rcvr index            (i1)
*     col 81-83 : src component index   (i3)
*     col 84-86 : rcv component index   (i3)

      write (LERR, 2005) dumx,fldtap,fldrecno,fldreci,dum1,
     &                                srlnm, sn_rel, srcindx,
     &                                chfrom, chto, chindx,
     &                                rclnm, rcvfrom, rcvto, rcvindx,
     &                                sc_rel, rc_rel

*           does this relation contain this source-point?
*      write(LERR,*) srcind, sn_rel
            if(sn_rel .ne. srcind) go to 2000

*           does this relation contain this source-component?
*      write(LERR,*) sc_usp, sc_rel
            if(sc_rel .ne. sc_usp) go to 2000

*           on this source-line?
*! eliminate line test for practice dataset!
*           if (srlnm .ne. srcind) go to 2000

*           does this relation contain this receiver?
            if(recind .gt. rcvto .or.
     &         recind .lt. rcvfrom   ) go to 2000

*           does this relation contain this receiver-component?
            if(rc_rel .ne. rc_usp) go to 2000

*           nominal end of relation loop
              if (verbos) then
                 write(LERR,*)' Relation found with src point ',sn_rel, 
     &                        ' , and rcvr points incldg ', recind
              endif
              go to 2090

 2030      if (relend) then
              write(LERR,2035) relaps
              write(LER,2035) relaps
 2035         format(' Relation for this src, rcvr NOT found in ', a80) 
           else
              relend = .TRUE.
              rewind (lurel)
              call skip (lurel, hnrec) 
              write(LERR,*) ' Checking back through ',relaps,' again...'
              go to 2000
           endif

*           now get source point record
 2090      if (verbos) then
               write (LERR,2095) sn_rel, sc_rel, srlnm, 
     &                           rc_rel,rclnm,
     &                           chfrom, chto, chindx,
     &                           rcvfrom, rcvto, rcvindx
 2095          format(' Now looking for aps shot point', i5,
     &                ' (component',i2,') on shot line', a16/
     &            ' with receivers (component',i2,') on rcvr line', a16/
     &            13x,', on channels ',i5,' to ',i5,' (stride',i5,')'/
     &            13x,', numbrd from ',i5,' to ',i5,' (index',i5,')')
               write (LERR,*) srcend, rcvend
            endif

            srcend = .FALSE.
*           rewind once only, if nec
 2200       if (srcend) then
               rewind (lusrc)
               call skip (lusrc, hnrec)
            endif

*           start of source loop 
            read(lusrc, 2215, end=2230) dum1, slinam, sn_src, dum21,
     &                                  xsrc, ysrc, dum15,
     &                                  sc_src, srcortn, slazmth
 2215          format(a1, a16, i8, a21, 
     &                f9.1, f10.1, a15, 
     &                i2, a8, f10.1  )
*     aps format has:
*     col  1    : type S or R          | dum1
*     col  2-17 : line name             (a16)
*     col 18-25 : point number          (i8)
*     col 26    : point index (1-9)    |  NB: should be used as comp?
*     col 27-28 : point code           |
*     col 29-32 : static correction    | 
*     col 33-36 : point depth          | dum21
*     col 37-40 : seismic datum        |
*     col 41-42 : uphole time          |
*     col 43-46 : water depth          |
*     col 47-55 : x-coordinate (map easting) (f9.1)
*     col 56-65 : y-coordinate (map northing)(f10.1)
*     col 66-71 : surface elevation    |
*     col 72-74 : day                  | dum15
*     col 75-80 : time                 |
*     col 81-82 : component index       (i2)
*     col 83-90 : component azimuth (or Z) (a8)
*     col 91-100: line azimuth          (f10.1)

*               if (dum1 .ne. 'S') go to 2200

*              check if this is the src/comp we want, otherwise loop
               if (sn_src .ne. sn_rel) go to 2200
               if (sc_src .ne. sc_usp) go to 2200
*           nominal end of source loop

*            write(LERR, 2215) dum1, slinam, sn_src, dum21,
*     &                        xsrc, ysrc, dum15,
*     &                        sc_src, srcortn, slazmth

*          with src #'s matching, check src line #'s & components
*          (should really check for same srcindx as well!
*! eliminate line test for practice dataset!
*           if(slinam .ne. srlnm) go to 2200
            if (verbos) then
               write(LERR,*) ' Source point   ', sn_rel, 
     &                       ' (component ', sc_rel,
     &                       ') found on source line   ', slinam
            endif
            go to 2400

*          if we reached EOF
 2230      if (srcend) then
              write(LERR,2235) sn_rel,srcaps
              write(LER,2235) sn_rel,srcaps
 2235         format(' Source point ', i5, ' NOT found in ', a80) 
           else
              srcend = .TRUE.
              rewind (lusrc)
              call skip (lusrc, hnrec) 
              write(LERR,*) ' Checking back through ',srcaps,' again...'
              go to 2200
           endif

*          now get all receiver point records

 2400      do 2499 rn_rel = rcvfrom, rcvto
*             start receiver search loop

              rcvend = .FALSE.
*             rewind once only, if nec
              if (rcvend) then
                  rewind (lurcv)
                  call skip (lurcv, hnrec)
               endif

 2410         read(lurcv, 2215, end=2430) dum1, rlinam, rn_rcv, dum21,
     &                                    xrcv, yrcv, dum15,
     &                                    rc_rcv, rcvortn, rlazmth
*              if (dum1 .ne. 'R') go to 2410

*             check if this is the rcvr/comp we want, otherwise loop
              if (rn_rcv .ne. recind) go to 2410
              if (rc_rcv .ne. rc_usp) go to 2410
*           nominal end of receiver search loop

*            write(LERR, 2215) dum1, rlinam, rn_rcv, dum21,
*     &                        xrcv, yrcv, dum15,
*     &                        rc_rcv, rcvortn, rlazmth

*           with rcvr #'s matching, check rcvr line #'s
*          (should really check for same rcvrindx as well!
*! eliminate line test for practice dataset!
*            if (rlinam .eq. rclnm) then
            if (verbos) then
               write(LERR,*) ' Receiver point ', rn_rcv, 
     &                       ' (component ', rc_rel,
     &                       ') found on receiver line ',rlinam
            endif
            go to 2450

*           if we reached EOF
 2430       if (rcvend) then
               write(LERR,2435) recind, rcvaps
               write(LER,2435) recind, rcvaps
 2435          format(' Receiver point ', i5, ' NOT found in ', a80)
            else
               rcvend = .TRUE.
               rewind (lurcv)
               call skip (lurcv,hnrec)
               write(LERR,*)' Checking back through ',rcvaps,' again...'
               go to 2410
            endif
***********************************************************************
*           now, with a trace, and related sources and rcvrs in hand:

 2450     continue

             if (all) then
*                call savew2(trace,ifmt_SGRDat,l_SGRDat, ln_SGRDat,
*     1                      date , TRACEHEADER)
                linind = str_int(rclnm, 1, 14)
                call savew2(trace,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                      linind, TRACEHEADER)
             endif

             call savew2(trace,ifmt_SrComp,l_SrComp, ln_SrComp,
     1                   sc_rel , TRACEHEADER)
             call savew2(trace,ifmt_RcComp,l_RcComp, ln_RcComp,
     1                   rc_rel , TRACEHEADER)

             srptxc = xsrc
             call savew2(trace,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                   srptxc , TRACEHEADER)
             srptyc = ysrc
             call savew2(trace,ifmt_SrPtYc,l_SrPtYc, ln_SrPtYc,
     1                   srptyc , TRACEHEADER)
             rcptxc = xrcv
             call savew2(trace,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                   rcptxc , TRACEHEADER)
             rcptyc = yrcv
             call savew2(trace,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                   rcptyc , TRACEHEADER)

             if (sc_src .eq. 1) then
                call str_rl(srcortn, 1, 8, sazmth)
                isazmth = sazmth*10.
                call savew2(trace,ifmt_SrXAzm,l_SrXAzm, ln_SrXAzm,
     1                      isazmth, TRACEHEADER)
             elseif (sc_src .eq. 2) then
                call str_rl(srcortn, 1, 8, sazmth)
                isazmth = sazmth*10.0
*               Note: what is stored is the azimuth of the x-axis of the
*                     implied right-handed coordinate system (z down),
*                     corresponding to this y-axis.
                call savew2(trace,ifmt_SrXAzm,l_SrXAzm, ln_SrXAzm,
     1                      isazmth - 900, TRACEHEADER)
             elseif (sc_src .eq. 3) then
                call savew2(trace,ifmt_SrXAzm,l_SrXAzm, ln_SrXAzm,
     1                       0        , TRACEHEADER)
            endif
            call savew2(trace,ifmt_SrYRot,l_SrYRot, ln_SrYRot,
     1                       0        , TRACEHEADER)
            call savew2(trace,ifmt_SrZRot,l_SrZRot, ln_SrZRot,
     1                       0        , TRACEHEADER)

             if (rc_rcv .eq. 1) then
                call str_rl(rcvortn, 1, 8, razmth)
                irazmth = razmth*10.
                call savew2(trace,ifmt_RcXAzm,l_RcXAzm, ln_RcXAzm,
     1                      irazmth , TRACEHEADER)
             elseif (rc_rcv .eq. 2) then
                call str_rl(rcvortn, 1, 8, razmth)
                irazmth = razmth*10.
                call savew2(trace,ifmt_RcXAzm,l_RcXAzm, ln_RcXAzm,
     1                      irazmth - 900, TRACEHEADER)
             elseif (rc_rcv .eq. 3) then
                call savew2(trace,ifmt_RcXAzm,l_RcXAzm, ln_RcXAzm,
     1                       0        , TRACEHEADER)
            endif
            call savew2(trace,ifmt_RcYRot,l_RcYRot, ln_RcYRot,
     1                       0        , TRACEHEADER)
            call savew2(trace,ifmt_RcZRot,l_RcZRot, ln_RcZRot,
     1                       0        , TRACEHEADER)

*           write trace header
            if (uspwtrace(outcon, trace, trlength) .ne. 0) then
                write (LER , *) 'Could not write trace ', itrace
            endif

c    usprtrace and uspwtrace will print an error message if you
c    try to read or write outside the legal bounds of the data, with
c    one exception: if you increment ONCE off the end of the data
c    (while either reading or writing), they will give a nonzero
c    error code but will NOT print any message nor abort the program.
c
c    Thus if you don't want to keep track of how many traces there
c    are, you can just "keep going until you get a nonzero return
c    code", and that will work. (Keep in mind that if you allow
c    appending, then you can write anywhere! If it's off the current
c    end of the data, you'll just make the data that much bigger.
c    If you try to read beyond what's there, though, that will
c    always be an error.)
c

            if (verbos) then
               if (spflag) then
                  write(LERR,*) 'SpPtNm', srcind
               elseif (slflag) then 
                  write(LERR,*) 'SrcLoc', srcind                       
               endif

               write(LERR,*) 'LinInd', linind

               write(LERR,*) 'SrComp', sc_rel
               write(LERR,*) 'SrPtXC', srptxc
               write(LERR,*) 'SrPtYC', srptyc
               write(LERR,*) 'SrXAzm', srxazm
               write(LERR,*) 'RcComp', rc_rel
               write(LERR,*) 'RcPtXC', rcptxc
               write(LERR,*) 'RcPtYC', rcptyc
               write(LERR,*) 'RcXAzm', rcxazm
            endif

            backspace (lusrc)

 2499    enddo
*        end of receiver point record loop
         backspace (lurcv)
*         backspace (lurel)
 3099 continue
*     end of trace loop

 4000 continue

c
c    Finally, make SURE to call uspclose to close your connections
c    before exiting. Some of your data may end up missing if you forget
c    to do this.
c

      if (uspclose(incon)) then
          write (LER , *) 'Trouble closing input.'
      endif

      if (uspclose(outcon)) then
          write (LER , *) 'Trouble closing output.'
      endif

      write( LERR, * ) ' '
      write( LER, * ) ' '
      write( LERR, * ) ' Normal Termination'
      write( LER, * ) ' Normal Termination'
      write( LER, * ) ' '

      stop     

***********************************************************************
*     tape errors

 910  write(LER,915) srcaps
      write(LERR,915) srcaps
 915  format(/' APS_USP: Error opening aps source file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop
 
 920  write(LER,925) rcvaps
      write(LERR,925) rcvaps
 925  format(/' APS_USP: Error opening aps receiver file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop
 
 930  write(LER,935) relaps
      write(LERR,935) relaps
 935  format(/' APS_USP: Error opening aps relation file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop
 
      end

*****************************************************************
*****************************************************************
*****************************************************************
*****************************************************************
      subroutine skip (lu, nskip)
*     skips records

 100  do 109 i=1,nskip
         read(lu,*)
 109  enddo

      return
      end
