C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln (srctap, rcvtap, reltap, all, mclist,
     &                  slflag, spflag, verbos)

c     srctap-  C*255    aps (sps) source filename
c     rcvtap-  C*255    aps (sps) receiver filename
c     reltap-  C*255    aps (sps) relation filename
c     (NOTE:   sesimic i/o (-N and -O) are handled by uspio

*     mclist  C*27      sequence for source-receiver pairs

c     verbos  L         verbose output or not
c     all     L         override existing headers, or not
c     slflag  L         flag => shot location indices are in SrcLoc
c     spflag  L         flag => shot location indices are in SoPtNm
*                       NOTE: default is slflag = .false.;
*                                        spflag = .true.
*                             If both are set .true. or .false.,
*                             then default is restored

      integer        argis

      character      srctap*(*), rcvtap*(*), reltap*(*)
      character*27   mclist
            
      logical     verbos, all, slflag, spflag

#include <f77/open.h>

      call argstr( '-S', srctap, ' ', ' ' )
      call argstr( '-R', rcvtap, ' ', ' ' )
      call argstr( '-X', reltap, ' ', ' ' )

      all = (argis(-ALL) .gt. 0)
      call argstr( '-MCL', mclist, '11,12,21,22', '33' )

      slflag = .false.
      spflag = .true.
      slflag = (argis('-sl') .gt.0)
      spflag = (argis('-sp') .gt.0)
      if (slflag .eq. .true. .and. spflag .eq. .true.) then
         slflag = .false.
      elseif (slflag .eq. .false. .and. spflag .eq. .false.) then
         spflag = .true.
      endif
      if(slflag .eq. .true.) 
     1  write(LERR,*) ' Source location indices in SrcLoc.'
      if(spflag .eq. .true.) 
     1  write(LERR,*) ' Source location indices in SoPtNm.'

      verbos  = (argis('-V') .gt. 0 .or. argis('-v') .gt. 0)

      return
      end
