C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine str_rl (string, Nbegin, Nend, float)

*     converts digits Nbegin to Nend of string to a signed float

#include <f77/iounit.h>

      character string*(*)
      character ok*11
      integer  i, jndex, Nbegin, Nend, Nstart, Nstop, Nstm1
      logical gotnum
      real    float
      parameter (ok = '0123456789.')

*      write(LER,*) Nbegin, Nend, string(Nbegin:Nend)
*     find a number in here somewhere
      gotnum = .false.
      Nstart = Nbegin
      Nstop  = Nend
      ndecml = 0
      do i = Nbegin, Nend
         jndex = index(ok,string(i:i))
         if (jndex .eq. 0) then
*           this character is not ok
            if (gotnum) then
*              we already have found a number, so we quit 
               Nstop = i-1
               go to 100
            else
*              We have not yet found a number, but maybe the next one...
               Nstart = i + 1
            endif
         else
            gotnum = .true.
         endif
*        check that there is at most one decimal point
         jndex = index('.',string(i:i))
         if(jndex .eq. 1) ndecml = ndecml + 1
         if (ndecml .gt. 1) then
            Nstop = i-1
            go to 100
         endif
      enddo

 100  if (.not. gotnum .or. ndecml .gt. 1) then
*        error if string is not a number
         write(6,15) string(Nstart:Nstop)
 15      format(' Not a number:',a48)
         return
      endif

      read (string(Nstart:Nstop),*) float
      Nstm1 = Nstart-1
      if (Nstm1 .ne. 0 .and.
     &    string(Nstm1:Nstm1) .eq. '-') float = - float

*      write(LER,*) Nstart, Nstop, string(Nstart:Nstop), float

      return
      end


